// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

let lazy = {};

ChromeUtils.defineLazyGetter(lazy, "decoder", () => new TextDecoder());
ChromeUtils.defineLazyGetter(lazy, "encoder", () => new TextEncoder());

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = lazy.encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = lazy.decoder.decode(source);
      this.pos += size;
      return value;
    }

    readBytes() {
      const size = this.readInt32();
      const bytes = new Uint8Array(this.dataView.buffer, this.pos, size);
      this.pos += size;
      return bytes
    }

    writeBytes(value) {
      this.writeUint32(value.length);
      value.forEach((elt) => {
        this.writeUint8(elt);
      })
    }
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            if (result.data) {
                throw new UniFFIInternalError(FfiConverterString.lift(result.data));
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }

    /**
     * Computes the size of the value.
     *
     * @param {*} _value
     * @return {number}
     */
    static computeSize(_value) {
        throw new UniFFIInternalError("computeSize() should be declared in the derived class");
    }

    /**
     * Reads the type from a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @returns {any}
     */
    static read(_dataStream) {
        throw new UniFFIInternalError("read() should be declared in the derived class");
    }

    /**
     * Writes the type to a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @param {any} _value
     */
    static write(_dataStream, _value) {
        throw new UniFFIInternalError("write() should be declared in the derived class");
    }

}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 256) {
            throw new UniFFITypeError(`${value} exceeds the U8 bounds`);
        }
    }
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const utf8Arr = new Uint8Array(buf);
        return lazy.decoder.decode(utf8Arr);
    }
    static lower(value) {
        return lazy.encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        return 4 + lazy.encoder.encode(value).length
    }
}

/**
 * CustomTypesDemo
 */
export class CustomTypesDemo {
    constructor({ url, handle } = { url: undefined, handle: undefined }) {
        try {
            FfiConverterTypeUrl.checkType(url)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("url");
            }
            throw e;
        }
        try {
            FfiConverterTypeHandle.checkType(handle)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("handle");
            }
            throw e;
        }
        /**
         * @type {Url}
         */
        this.url = url;
        /**
         * @type {Handle}
         */
        this.handle = handle;
    }

    equals(other) {
        return (
            this.url == other.url &&
            this.handle == other.handle
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeCustomTypesDemo extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new CustomTypesDemo({
            url: FfiConverterTypeUrl.read(dataStream),
            handle: FfiConverterTypeHandle.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeUrl.write(dataStream, value.url);
        FfiConverterTypeHandle.write(dataStream, value.handle);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeUrl.computeSize(value.url);
        totalSize += FfiConverterTypeHandle.computeSize(value.handle);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof CustomTypesDemo)) {
            throw new UniFFITypeError(`Expected 'CustomTypesDemo', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeUrl.checkType(value.url);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".url");
            }
            throw e;
        }
        try {
            FfiConverterTypeHandle.checkType(value.handle);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".handle");
            }
            throw e;
        }
    }
}


/**
 * ExplicitValuedEnum
 */
export const ExplicitValuedEnum = {
    /**
     * FIRST
     */
    FIRST:1,
    /**
     * SECOND
     */
    SECOND:2,
    /**
     * FOURTH
     */
    FOURTH:4,
    /**
     * TENTH
     */
    TENTH:10,
    /**
     * ELEVENTH
     */
    ELEVENTH:11,
    /**
     * THIRTEENTH
     */
    THIRTEENTH:13,
};

Object.freeze(ExplicitValuedEnum);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeExplicitValuedEnum extends FfiConverterArrayBuffer {
    static #validValues = Object.values(ExplicitValuedEnum);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return ExplicitValuedEnum.FIRST
            case 2:
                return ExplicitValuedEnum.SECOND
            case 3:
                return ExplicitValuedEnum.FOURTH
            case 4:
                return ExplicitValuedEnum.TENTH
            case 5:
                return ExplicitValuedEnum.ELEVENTH
            case 6:
                return ExplicitValuedEnum.THIRTEENTH
            default:
                throw new UniFFITypeError("Unknown ExplicitValuedEnum variant");
        }
    }

    static write(dataStream, value) {
        if (value === ExplicitValuedEnum.FIRST) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === ExplicitValuedEnum.SECOND) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === ExplicitValuedEnum.FOURTH) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === ExplicitValuedEnum.TENTH) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === ExplicitValuedEnum.ELEVENTH) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === ExplicitValuedEnum.THIRTEENTH) {
            dataStream.writeInt32(6);
            return;
        }
        throw new UniFFITypeError("Unknown ExplicitValuedEnum variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for ExplicitValuedEnum`);
      }
    }
}



/**
 * GappedEnum
 */
export const GappedEnum = {
    /**
     * ONE
     */
    ONE:10,
    /**
     * TWO
     */
    TWO:11,
    /**
     * THREE
     */
    THREE:14,
};

Object.freeze(GappedEnum);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGappedEnum extends FfiConverterArrayBuffer {
    static #validValues = Object.values(GappedEnum);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return GappedEnum.ONE
            case 2:
                return GappedEnum.TWO
            case 3:
                return GappedEnum.THREE
            default:
                throw new UniFFITypeError("Unknown GappedEnum variant");
        }
    }

    static write(dataStream, value) {
        if (value === GappedEnum.ONE) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === GappedEnum.TWO) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === GappedEnum.THREE) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown GappedEnum variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for GappedEnum`);
      }
    }
}



/**
 * SequentialEnum
 */
export const SequentialEnum = {
    /**
     * FIRST
     */
    FIRST:0,
    /**
     * SECOND
     */
    SECOND:1,
    /**
     * FOURTH
     */
    FOURTH:2,
    /**
     * TENTH
     */
    TENTH:3,
    /**
     * ELEVENTH
     */
    ELEVENTH:4,
    /**
     * THIRTEENTH
     */
    THIRTEENTH:5,
};

Object.freeze(SequentialEnum);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSequentialEnum extends FfiConverterArrayBuffer {
    static #validValues = Object.values(SequentialEnum);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return SequentialEnum.FIRST
            case 2:
                return SequentialEnum.SECOND
            case 3:
                return SequentialEnum.FOURTH
            case 4:
                return SequentialEnum.TENTH
            case 5:
                return SequentialEnum.ELEVENTH
            case 6:
                return SequentialEnum.THIRTEENTH
            default:
                throw new UniFFITypeError("Unknown SequentialEnum variant");
        }
    }

    static write(dataStream, value) {
        if (value === SequentialEnum.FIRST) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === SequentialEnum.SECOND) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === SequentialEnum.FOURTH) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === SequentialEnum.TENTH) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === SequentialEnum.ELEVENTH) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === SequentialEnum.THIRTEENTH) {
            dataStream.writeInt32(6);
            return;
        }
        throw new UniFFITypeError("Unknown SequentialEnum variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for SequentialEnum`);
      }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeCustomTypesDemo extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeCustomTypesDemo.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeCustomTypesDemo.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeCustomTypesDemo.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeCustomTypesDemo.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterMapStringU8 extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = new Map();
        for (let i = 0; i < len; i++) {
            const key = FfiConverterString.read(dataStream);
            const value = FfiConverterU8.read(dataStream);
            map.set(key, value);
        }

        return map;
    }

    static write(dataStream, map) {
        dataStream.writeInt32(map.size);
        for (const [key, value] of map) {
            FfiConverterString.write(dataStream, key);
            FfiConverterU8.write(dataStream, value);
        }
    }

    static computeSize(map) {
        // The size of the length
        let size = 4;
        for (const [key, value] of map) {
            size += FfiConverterString.computeSize(key);
            size += FfiConverterU8.computeSize(value);
        }
        return size;
    }

    static checkType(map) {
        for (const [key, value] of map) {
            try {
                FfiConverterString.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterU8.checkType(value);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeHandle extends FfiConverter {
    static lift(buf) {
        return FfiConverterI64.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterI64.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterI64.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterI64.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterI64.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeUrl extends FfiConverter {
    static lift(buf) {
        return FfiConverterString.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterString.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterString.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.





/**
 * echoExplicitValue
 * @returns {ExplicitValuedEnum}
 */
export function echoExplicitValue(value) {

        const liftResult = (result) => FfiConverterTypeExplicitValuedEnum.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeExplicitValuedEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                114, // custom_types:uniffi_uniffi_custom_types_fn_func_echo_explicit_value
                FfiConverterTypeExplicitValuedEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * echoGappedValue
 * @returns {GappedEnum}
 */
export function echoGappedValue(value) {

        const liftResult = (result) => FfiConverterTypeGappedEnum.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeGappedEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                115, // custom_types:uniffi_uniffi_custom_types_fn_func_echo_gapped_value
                FfiConverterTypeGappedEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * echoSequentialValue
 * @returns {SequentialEnum}
 */
export function echoSequentialValue(value) {

        const liftResult = (result) => FfiConverterTypeSequentialEnum.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeSequentialEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                116, // custom_types:uniffi_uniffi_custom_types_fn_func_echo_sequential_value
                FfiConverterTypeSequentialEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getCustomTypesDemo
 * @returns {CustomTypesDemo}
 */
export function getCustomTypesDemo(demo) {

        const liftResult = (result) => FfiConverterTypeCustomTypesDemo.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterOptionalTypeCustomTypesDemo.checkType(demo)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("demo");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                117, // custom_types:uniffi_uniffi_custom_types_fn_func_get_custom_types_demo
                FfiConverterOptionalTypeCustomTypesDemo.lower(demo),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getExplicitDiscriminant
 * @returns {number}
 */
export function getExplicitDiscriminant(value) {

        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeExplicitValuedEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                118, // custom_types:uniffi_uniffi_custom_types_fn_func_get_explicit_discriminant
                FfiConverterTypeExplicitValuedEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getExplicitEnumValues
 * @returns {object}
 */
export function getExplicitEnumValues() {

        const liftResult = (result) => FfiConverterMapStringU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                119, // custom_types:uniffi_uniffi_custom_types_fn_func_get_explicit_enum_values
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getGappedDiscriminant
 * @returns {number}
 */
export function getGappedDiscriminant(value) {

        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeGappedEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                120, // custom_types:uniffi_uniffi_custom_types_fn_func_get_gapped_discriminant
                FfiConverterTypeGappedEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getGappedEnumValues
 * @returns {object}
 */
export function getGappedEnumValues() {

        const liftResult = (result) => FfiConverterMapStringU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                121, // custom_types:uniffi_uniffi_custom_types_fn_func_get_gapped_enum_values
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * getSequentialDiscriminant
 * @returns {number}
 */
export function getSequentialDiscriminant(value) {

        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeSequentialEnum.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                122, // custom_types:uniffi_uniffi_custom_types_fn_func_get_sequential_discriminant
                FfiConverterTypeSequentialEnum.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}
