// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

let lazy = {};

ChromeUtils.defineLazyGetter(lazy, "decoder", () => new TextDecoder());
ChromeUtils.defineLazyGetter(lazy, "encoder", () => new TextEncoder());

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = lazy.encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = lazy.decoder.decode(source);
      this.pos += size;
      return value;
    }

    readBytes() {
      const size = this.readInt32();
      const bytes = new Uint8Array(this.dataView.buffer, this.pos, size);
      this.pos += size;
      return bytes
    }

    writeBytes(value) {
      this.writeUint32(value.length);
      value.forEach((elt) => {
        this.writeUint8(elt);
      })
    }

    // Reads a SuggestStore pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerSuggestStore() {
        const pointerId = 6; // suggest:SuggestStore
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a SuggestStore pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerSuggestStore(value) {
        const pointerId = 6; // suggest:SuggestStore
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a SuggestStoreBuilder pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerSuggestStoreBuilder() {
        const pointerId = 7; // suggest:SuggestStoreBuilder
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a SuggestStoreBuilder pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerSuggestStoreBuilder(value) {
        const pointerId = 7; // suggest:SuggestStoreBuilder
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            if (result.data) {
                throw new UniFFIInternalError(FfiConverterString.lift(result.data));
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }

    /**
     * Computes the size of the value.
     *
     * @param {*} _value
     * @return {number}
     */
    static computeSize(_value) {
        throw new UniFFIInternalError("computeSize() should be declared in the derived class");
    }

    /**
     * Reads the type from a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @returns {any}
     */
    static read(_dataStream) {
        throw new UniFFIInternalError("read() should be declared in the derived class");
    }

    /**
     * Writes the type to a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @param {any} _value
     */
    static write(_dataStream, _value) {
        throw new UniFFIInternalError("write() should be declared in the derived class");
    }

}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 256) {
            throw new UniFFITypeError(`${value} exceeds the U8 bounds`);
        }
    }
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -2147483648 || value > 2147483647) {
            throw new UniFFITypeError(`${value} exceeds the I32 bounds`);
        }
    }
    static computeSize(_value) {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt32(value)
    }
    static read(dataStream) {
        return dataStream.readInt32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
        if (value < 0) {
            throw new UniFFITypeError(`${value} exceeds the U64 bounds`);
        }
    }
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF64 extends FfiConverter {
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBool extends FfiConverter {
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const utf8Arr = new Uint8Array(buf);
        return lazy.decoder.decode(utf8Arr);
    }
    static lower(value) {
        return lazy.encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        return 4 + lazy.encoder.encode(value).length
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBytes extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return dataStream.readBytes()
    }

    static write(dataStream, value) {
        dataStream.writeBytes(value)
    }

    static computeSize(value) {
        // The size of the length + 1 byte / item
        return 4 + value.length
    }

    static checkType(value) {
        if (!value instanceof Uint8Array) {
            throw new UniFFITypeError(`${value} is not an Uint8Array`);
        }
    }
}

/**
 * The store is the entry point to the Suggest component. It incrementally
 * downloads suggestions from the Remote Settings service, stores them in a
 * local database, and returns them in response to user queries.
 *
 * Your application should create a single store, and manage it as a singleton.
 * The store is thread-safe, and supports concurrent queries and ingests. We
 * expect that your application will call [`SuggestStore::query()`] to show
 * suggestions as the user types into the address bar, and periodically call
 * [`SuggestStore::ingest()`] in the background to update the database with
 * new suggestions from Remote Settings.
 *
 * For responsiveness, we recommend always calling `query()` on a worker
 * thread. When the user types new input into the address bar, call
 * [`SuggestStore::interrupt()`] on the main thread to cancel the query
 * for the old input, and unblock the worker thread for the new query.
 *
 * The store keeps track of the state needed to support incremental ingestion,
 * but doesn't schedule the ingestion work itself, or decide how many
 * suggestions to ingest at once. This is for two reasons:
 *
 * 1. The primitives for scheduling background work vary between platforms, and
 * aren't available to the lower-level Rust layer. You might use an idle
 * timer on Desktop, `WorkManager` on Android, or `BGTaskScheduler` on iOS.
 * 2. Ingestion constraints can change, depending on the platform and the needs
 * of your application. A mobile device on a metered connection might want
 * to request a small subset of the Suggest data and download the rest
 * later, while a desktop on a fast link might download the entire dataset
 * on the first launch.
 */
export class SuggestStore {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * Creates a Suggest store.
     * @returns {SuggestStore}
     */
    static init(path,remoteSettingsService) {
        const liftResult = (result) => FfiConverterTypeSuggestStore.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            try {
                FfiConverterTypeRemoteSettingsService.checkType(remoteSettingsService)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("remoteSettingsService");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                54, // suggest:uniffi_suggest_fn_constructor_suggeststore_new
                FfiConverterString.lower(path),
                FfiConverterTypeRemoteSettingsService.lower(remoteSettingsService),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    /**
     * Return whether any suggestions have been dismissed.
     * @returns {Boolean}
     */
    anyDismissedSuggestions() {
        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                38, // suggest:uniffi_suggest_fn_method_suggeststore_any_dismissed_suggestions
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Removes all content from the database.
     */
    clear() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                39, // suggest:uniffi_suggest_fn_method_suggeststore_clear
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Clear dismissed suggestions
     */
    clearDismissedSuggestions() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                40, // suggest:uniffi_suggest_fn_method_suggeststore_clear_dismissed_suggestions
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Dismiss a suggestion by its dismissal key.
     *
     * Dismissed suggestions cannot be fetched again.
     *
     * Prefer [SuggestStore::dismiss_by_suggestion] if you have a
     * `crate::Suggestion`. This method is intended for cases where a
     * suggestion originates outside this component.
     */
    dismissByKey(key) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(key)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("key");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                41, // suggest:uniffi_suggest_fn_method_suggeststore_dismiss_by_key
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterString.lower(key),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Dismiss a suggestion.
     *
     * Dismissed suggestions cannot be fetched again.
     */
    dismissBySuggestion(suggestion) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestion.checkType(suggestion)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("suggestion");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                42, // suggest:uniffi_suggest_fn_method_suggeststore_dismiss_by_suggestion
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestion.lower(suggestion),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Deprecated, use [SuggestStore::dismiss_by_suggestion] or
     * [SuggestStore::dismiss_by_key] instead.
     *
     * Dismiss a suggestion
     *
     * Dismissed suggestions will not be returned again
     */
    dismissSuggestion(suggestionUrl) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(suggestionUrl)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("suggestionUrl");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                43, // suggest:uniffi_suggest_fn_method_suggeststore_dismiss_suggestion
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterString.lower(suggestionUrl),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Fetches a geoname's names stored in the database.
     *
     * See `fetch_geoname_alternates` in `geoname.rs` for documentation.
     * @returns {GeonameAlternates}
     */
    fetchGeonameAlternates(geoname) {
        const liftResult = (result) => FfiConverterTypeGeonameAlternates.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeGeoname.checkType(geoname)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("geoname");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                44, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_geoname_alternates
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeGeoname.lower(geoname),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Fetches geonames stored in the database. A geoname represents a
     * geographic place.
     *
     * See `fetch_geonames` in `geoname.rs` for documentation.
     * @returns {Array.<GeonameMatch>}
     */
    fetchGeonames(query,matchNamePrefix,filter) {
        const liftResult = (result) => FfiConverterSequenceTypeGeonameMatch.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(query)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("query");
                }
                throw e;
            }
            try {
                FfiConverterBool.checkType(matchNamePrefix)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("matchNamePrefix");
                }
                throw e;
            }
            try {
                FfiConverterOptionalSequenceTypeGeoname.checkType(filter)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("filter");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                45, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_geonames
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterString.lower(query),
                FfiConverterBool.lower(matchNamePrefix),
                FfiConverterOptionalSequenceTypeGeoname.lower(filter),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Returns global Suggest configuration data.
     * @returns {SuggestGlobalConfig}
     */
    fetchGlobalConfig() {
        const liftResult = (result) => FfiConverterTypeSuggestGlobalConfig.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                46, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_global_config
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Returns per-provider Suggest configuration data.
     * @returns {?SuggestProviderConfig}
     */
    fetchProviderConfig(provider) {
        const liftResult = (result) => FfiConverterOptionalTypeSuggestProviderConfig.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestionProvider.checkType(provider)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("provider");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                47, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_provider_config
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestionProvider.lower(provider),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Ingests new suggestions from Remote Settings.
     * @returns {SuggestIngestionMetrics}
     */
    ingest(constraints) {
        const liftResult = (result) => FfiConverterTypeSuggestIngestionMetrics.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestIngestionConstraints.checkType(constraints)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("constraints");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                48, // suggest:uniffi_suggest_fn_method_suggeststore_ingest
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestIngestionConstraints.lower(constraints),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Interrupts any ongoing queries.
     *
     * This should be called when the user types new input into the address
     * bar, to ensure that they see fresh suggestions as they type. This
     * method does not interrupt any ongoing ingests.
     */
    interrupt(kind = null) {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterOptionalTypeInterruptKind.checkType(kind)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("kind");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                49, // suggest:uniffi_suggest_fn_method_suggeststore_interrupt
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterOptionalTypeInterruptKind.lower(kind),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * Return whether a suggestion has been dismissed given its dismissal key.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a suggestion has been dismissed.
     * This method is intended for cases where a dismissal key originates
     * outside this component.
     * @returns {Boolean}
     */
    isDismissedByKey(key) {
        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(key)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("key");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                50, // suggest:uniffi_suggest_fn_method_suggeststore_is_dismissed_by_key
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterString.lower(key),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Return whether a suggestion has been dismissed.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a `Suggestion` has been
     * dismissed, but this method can be used to do so.
     * @returns {Boolean}
     */
    isDismissedBySuggestion(suggestion) {
        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestion.checkType(suggestion)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("suggestion");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                51, // suggest:uniffi_suggest_fn_method_suggeststore_is_dismissed_by_suggestion
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestion.lower(suggestion),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Queries the database for suggestions.
     * @returns {Array.<Suggestion>}
     */
    query(query) {
        const liftResult = (result) => FfiConverterSequenceTypeSuggestion.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestionQuery.checkType(query)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("query");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                52, // suggest:uniffi_suggest_fn_method_suggeststore_query
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestionQuery.lower(query),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Queries the database for suggestions.
     * @returns {QueryWithMetricsResult}
     */
    queryWithMetrics(query) {
        const liftResult = (result) => FfiConverterTypeQueryWithMetricsResult.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestionQuery.checkType(query)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("query");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                53, // suggest:uniffi_suggest_fn_method_suggeststore_query_with_metrics
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestionQuery.lower(query),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new SuggestStore(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'SuggestStore' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerSuggestStore());
    }

    static write(dataStream, value) {
        dataStream.writePointerSuggestStore(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Builder for [SuggestStore]
 *
 * Using a builder is preferred to calling the constructor directly since it's harder to confuse
 * the data_path and cache_path strings.
 */
export class SuggestStoreBuilder {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {SuggestStoreBuilder}
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                62, // suggest:uniffi_suggest_fn_constructor_suggeststorebuilder_new
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    /**
     * build
     * @returns {SuggestStore}
     */
    build() {
        const liftResult = (result) => FfiConverterTypeSuggestStore.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                55, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_build
                FfiConverterTypeSuggestStoreBuilder.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * Deprecated: this is no longer used by the suggest component.
     * @returns {SuggestStoreBuilder}
     */
    cachePath(path) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                56, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_cache_path
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(path),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * dataPath
     * @returns {SuggestStoreBuilder}
     */
    dataPath(path) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                57, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_data_path
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(path),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * Add an sqlite3 extension to load
     *
     * library_name should be the name of the library without any extension, for example `libmozsqlite3`.
     * entrypoint should be the entry point, for example `sqlite3_fts5_init`.  If `null` (the default)
     * entry point will be used (see https://sqlite.org/loadext.html for details).
     * @returns {SuggestStoreBuilder}
     */
    loadExtension(library,entryPoint) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(library)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("library");
                }
                throw e;
            }
            try {
                FfiConverterOptionalstring.checkType(entryPoint)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("entryPoint");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                58, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_load_extension
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(library),
                FfiConverterOptionalstring.lower(entryPoint),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * remoteSettingsBucketName
     * @returns {SuggestStoreBuilder}
     */
    remoteSettingsBucketName(bucketName) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(bucketName)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("bucketName");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                59, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_bucket_name
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(bucketName),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * remoteSettingsServer
     * @returns {SuggestStoreBuilder}
     */
    remoteSettingsServer(server) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeRemoteSettingsServer.checkType(server)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("server");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                60, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_server
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterTypeRemoteSettingsServer.lower(server),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * remoteSettingsService
     * @returns {SuggestStoreBuilder}
     */
    remoteSettingsService(rsService) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeRemoteSettingsService.checkType(rsService)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("rsService");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                61, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_service
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterTypeRemoteSettingsService.lower(rsService),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestStoreBuilder extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new SuggestStoreBuilder(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'SuggestStoreBuilder' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerSuggestStoreBuilder());
    }

    static write(dataStream, value) {
        dataStream.writePointerSuggestStoreBuilder(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * A set of names for a single entity.
 */
export class AlternateNames {
    constructor({ primary, localized, abbreviation } = { primary: undefined, localized: undefined, abbreviation: undefined }) {
        try {
            FfiConverterString.checkType(primary)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("primary");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(localized)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("localized");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(abbreviation)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("abbreviation");
            }
            throw e;
        }
        /**
         * The entity's primary name. For a `Geoname`, this is `Geoname::name`.
         * @type {string}
         */
        this.primary = primary;
        /**
         * The entity's name in the language that was ingested according to the
         * locale in the remote settings context. If none exists and this
         * `AlternateNames` is for a `Geoname`, then this will be its primary name.
         * @type {?string}
         */
        this.localized = localized;
        /**
         * The entity's abbreviation, if any.
         * @type {?string}
         */
        this.abbreviation = abbreviation;
    }

    equals(other) {
        return (
            this.primary == other.primary &&
            this.localized == other.localized &&
            this.abbreviation == other.abbreviation
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeAlternateNames extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new AlternateNames({
            primary: FfiConverterString.read(dataStream),
            localized: FfiConverterOptionalstring.read(dataStream),
            abbreviation: FfiConverterOptionalstring.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.primary);
        FfiConverterOptionalstring.write(dataStream, value.localized);
        FfiConverterOptionalstring.write(dataStream, value.abbreviation);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.primary);
        totalSize += FfiConverterOptionalstring.computeSize(value.localized);
        totalSize += FfiConverterOptionalstring.computeSize(value.abbreviation);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof AlternateNames)) {
            throw new UniFFITypeError(`Expected 'AlternateNames', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.primary);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".primary");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(value.localized);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".localized");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(value.abbreviation);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".abbreviation");
            }
            throw e;
        }
    }
}

/**
 * Additional data about how an FTS match was made
 */
export class FtsMatchInfo {
    constructor({ prefix, stemming } = { prefix: undefined, stemming: undefined }) {
        try {
            FfiConverterBool.checkType(prefix)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("prefix");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(stemming)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("stemming");
            }
            throw e;
        }
        /**
         * Was this a prefix match (`water b` matched against `water bottle`)
         * @type {Boolean}
         */
        this.prefix = prefix;
        /**
         * Did the match require stemming? (`run shoes` matched against `running shoes`)
         * @type {Boolean}
         */
        this.stemming = stemming;
    }

    equals(other) {
        return (
            this.prefix == other.prefix &&
            this.stemming == other.stemming
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeFtsMatchInfo extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new FtsMatchInfo({
            prefix: FfiConverterBool.read(dataStream),
            stemming: FfiConverterBool.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterBool.write(dataStream, value.prefix);
        FfiConverterBool.write(dataStream, value.stemming);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterBool.computeSize(value.prefix);
        totalSize += FfiConverterBool.computeSize(value.stemming);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof FtsMatchInfo)) {
            throw new UniFFITypeError(`Expected 'FtsMatchInfo', found '${typeof value}'`);
        }
        try {
            FfiConverterBool.checkType(value.prefix);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".prefix");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.stemming);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".stemming");
            }
            throw e;
        }
    }
}

/**
 * A single geographic place.
 *
 * This corresponds to a single row in the main "geoname" table described in
 * the GeoNames documentation [1]. We exclude fields we don't need.
 *
 * [1]: https://download.geonames.org/export/dump/readme.txt
 */
export class Geoname {
    constructor({ geonameId, geonameType, name, countryCode, featureClass, featureCode, adminDivisionCodes, population, latitude, longitude } = { geonameId: undefined, geonameType: undefined, name: undefined, countryCode: undefined, featureClass: undefined, featureCode: undefined, adminDivisionCodes: undefined, population: undefined, latitude: undefined, longitude: undefined }) {
        try {
            FfiConverterI64.checkType(geonameId)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("geonameId");
            }
            throw e;
        }
        try {
            FfiConverterTypeGeonameType.checkType(geonameType)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("geonameType");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(name)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("name");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(countryCode)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("countryCode");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(featureClass)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("featureClass");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(featureCode)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("featureCode");
            }
            throw e;
        }
        try {
            FfiConverterMapU8String.checkType(adminDivisionCodes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("adminDivisionCodes");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(population)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("population");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(latitude)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("latitude");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(longitude)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("longitude");
            }
            throw e;
        }
        /**
         * The `geonameid` straight from the geoname table.
         * @type {number}
         */
        this.geonameId = geonameId;
        /**
         * The geoname type. This is derived from `feature_class` and
         * `feature_code` as a more convenient representation of the type.
         * @type {GeonameType}
         */
        this.geonameType = geonameType;
        /**
         * The place's primary name.
         * @type {string}
         */
        this.name = name;
        /**
         * ISO-3166 two-letter uppercase country code, e.g., "US".
         * @type {string}
         */
        this.countryCode = countryCode;
        /**
         * Primary geoname category. Examples:
         *
         * "PCLI" - Independent political entity: country
         * "A" - Administrative division: state, province, borough, district, etc.
         * "P" - Populated place: city, village, etc.
         * @type {string}
         */
        this.featureClass = featureClass;
        /**
         * Secondary geoname category, depends on `feature_class`. Examples:
         *
         * "ADM1" - Administrative division 1
         * "PPL" - Populated place like a city
         * @type {string}
         */
        this.featureCode = featureCode;
        /**
         * Administrative divisions. This maps admin division levels (1-based) to
         * their corresponding codes. For example, Liverpool has two admin
         * divisions: "ENG" at level 1 and "H8" at level 2. They would be
         * represented in this map with entries `(1, "ENG")` and `(2, "H8")`.
         * @type {object}
         */
        this.adminDivisionCodes = adminDivisionCodes;
        /**
         * Population size.
         * @type {number}
         */
        this.population = population;
        /**
         * Latitude in decimal degrees (as a string).
         * @type {string}
         */
        this.latitude = latitude;
        /**
         * Longitude in decimal degrees (as a string).
         * @type {string}
         */
        this.longitude = longitude;
    }

    equals(other) {
        return (
            this.geonameId == other.geonameId &&
            this.geonameType == other.geonameType &&
            this.name == other.name &&
            this.countryCode == other.countryCode &&
            this.featureClass == other.featureClass &&
            this.featureCode == other.featureCode &&
            this.adminDivisionCodes == other.adminDivisionCodes &&
            this.population == other.population &&
            this.latitude == other.latitude &&
            this.longitude == other.longitude
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGeoname extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new Geoname({
            geonameId: FfiConverterI64.read(dataStream),
            geonameType: FfiConverterTypeGeonameType.read(dataStream),
            name: FfiConverterString.read(dataStream),
            countryCode: FfiConverterString.read(dataStream),
            featureClass: FfiConverterString.read(dataStream),
            featureCode: FfiConverterString.read(dataStream),
            adminDivisionCodes: FfiConverterMapU8String.read(dataStream),
            population: FfiConverterU64.read(dataStream),
            latitude: FfiConverterString.read(dataStream),
            longitude: FfiConverterString.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterI64.write(dataStream, value.geonameId);
        FfiConverterTypeGeonameType.write(dataStream, value.geonameType);
        FfiConverterString.write(dataStream, value.name);
        FfiConverterString.write(dataStream, value.countryCode);
        FfiConverterString.write(dataStream, value.featureClass);
        FfiConverterString.write(dataStream, value.featureCode);
        FfiConverterMapU8String.write(dataStream, value.adminDivisionCodes);
        FfiConverterU64.write(dataStream, value.population);
        FfiConverterString.write(dataStream, value.latitude);
        FfiConverterString.write(dataStream, value.longitude);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI64.computeSize(value.geonameId);
        totalSize += FfiConverterTypeGeonameType.computeSize(value.geonameType);
        totalSize += FfiConverterString.computeSize(value.name);
        totalSize += FfiConverterString.computeSize(value.countryCode);
        totalSize += FfiConverterString.computeSize(value.featureClass);
        totalSize += FfiConverterString.computeSize(value.featureCode);
        totalSize += FfiConverterMapU8String.computeSize(value.adminDivisionCodes);
        totalSize += FfiConverterU64.computeSize(value.population);
        totalSize += FfiConverterString.computeSize(value.latitude);
        totalSize += FfiConverterString.computeSize(value.longitude);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof Geoname)) {
            throw new UniFFITypeError(`Expected 'Geoname', found '${typeof value}'`);
        }
        try {
            FfiConverterI64.checkType(value.geonameId);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".geonameId");
            }
            throw e;
        }
        try {
            FfiConverterTypeGeonameType.checkType(value.geonameType);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".geonameType");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.name);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".name");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.countryCode);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".countryCode");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.featureClass);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".featureClass");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.featureCode);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".featureCode");
            }
            throw e;
        }
        try {
            FfiConverterMapU8String.checkType(value.adminDivisionCodes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".adminDivisionCodes");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.population);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".population");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.latitude);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".latitude");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.longitude);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".longitude");
            }
            throw e;
        }
    }
}

/**
 * Alternate names for a geoname and its country and admin divisions.
 */
export class GeonameAlternates {
    constructor({ geoname, country, adminDivisions } = { geoname: undefined, country: undefined, adminDivisions: undefined }) {
        try {
            FfiConverterTypeAlternateNames.checkType(geoname)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("geoname");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAlternateNames.checkType(country)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("country");
            }
            throw e;
        }
        try {
            FfiConverterMapU8TypeAlternateNames.checkType(adminDivisions)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("adminDivisions");
            }
            throw e;
        }
        /**
         * Names for the geoname itself.
         * @type {AlternateNames}
         */
        this.geoname = geoname;
        /**
         * Names for the geoname's country. This will be `Some` as long as the
         * country is also in the ingested data, which should typically be true.
         * @type {?AlternateNames}
         */
        this.country = country;
        /**
         * Names for the geoname's admin divisions. This is parallel to
         * `Geoname::admin_division_codes`. If there are no names in the ingested
         * data for an admin division, then it will be absent from this map.
         * @type {object}
         */
        this.adminDivisions = adminDivisions;
    }

    equals(other) {
        return (
            this.geoname.equals(other.geoname) &&
            this.country == other.country &&
            this.adminDivisions == other.adminDivisions
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGeonameAlternates extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new GeonameAlternates({
            geoname: FfiConverterTypeAlternateNames.read(dataStream),
            country: FfiConverterOptionalTypeAlternateNames.read(dataStream),
            adminDivisions: FfiConverterMapU8TypeAlternateNames.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeAlternateNames.write(dataStream, value.geoname);
        FfiConverterOptionalTypeAlternateNames.write(dataStream, value.country);
        FfiConverterMapU8TypeAlternateNames.write(dataStream, value.adminDivisions);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeAlternateNames.computeSize(value.geoname);
        totalSize += FfiConverterOptionalTypeAlternateNames.computeSize(value.country);
        totalSize += FfiConverterMapU8TypeAlternateNames.computeSize(value.adminDivisions);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof GeonameAlternates)) {
            throw new UniFFITypeError(`Expected 'GeonameAlternates', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeAlternateNames.checkType(value.geoname);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".geoname");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAlternateNames.checkType(value.country);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".country");
            }
            throw e;
        }
        try {
            FfiConverterMapU8TypeAlternateNames.checkType(value.adminDivisions);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".adminDivisions");
            }
            throw e;
        }
    }
}

/**
 * A fetched geoname with info on how it was matched.
 */
export class GeonameMatch {
    constructor({ geoname, matchType, prefix } = { geoname: undefined, matchType: undefined, prefix: undefined }) {
        try {
            FfiConverterTypeGeoname.checkType(geoname)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("geoname");
            }
            throw e;
        }
        try {
            FfiConverterTypeGeonameMatchType.checkType(matchType)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("matchType");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(prefix)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("prefix");
            }
            throw e;
        }
        /**
         * The geoname that was matched.
         * @type {Geoname}
         */
        this.geoname = geoname;
        /**
         * The type of name that was matched.
         * @type {GeonameMatchType}
         */
        this.matchType = matchType;
        /**
         * Whether the name was matched by prefix.
         * @type {Boolean}
         */
        this.prefix = prefix;
    }

    equals(other) {
        return (
            this.geoname.equals(other.geoname) &&
            this.matchType == other.matchType &&
            this.prefix == other.prefix
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGeonameMatch extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new GeonameMatch({
            geoname: FfiConverterTypeGeoname.read(dataStream),
            matchType: FfiConverterTypeGeonameMatchType.read(dataStream),
            prefix: FfiConverterBool.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeGeoname.write(dataStream, value.geoname);
        FfiConverterTypeGeonameMatchType.write(dataStream, value.matchType);
        FfiConverterBool.write(dataStream, value.prefix);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeGeoname.computeSize(value.geoname);
        totalSize += FfiConverterTypeGeonameMatchType.computeSize(value.matchType);
        totalSize += FfiConverterBool.computeSize(value.prefix);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof GeonameMatch)) {
            throw new UniFFITypeError(`Expected 'GeonameMatch', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeGeoname.checkType(value.geoname);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".geoname");
            }
            throw e;
        }
        try {
            FfiConverterTypeGeonameMatchType.checkType(value.matchType);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".matchType");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.prefix);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".prefix");
            }
            throw e;
        }
    }
}

/**
 * Single sample for a Glean labeled_timing_distribution
 */
export class LabeledTimingSample {
    constructor({ label, value } = { label: undefined, value: undefined }) {
        try {
            FfiConverterString.checkType(label)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("label");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("value");
            }
            throw e;
        }
        /**
         * @type {string}
         */
        this.label = label;
        /**
         * Time in microseconds
         * @type {number}
         */
        this.value = value;
    }

    equals(other) {
        return (
            this.label == other.label &&
            this.value == other.value
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeLabeledTimingSample extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new LabeledTimingSample({
            label: FfiConverterString.read(dataStream),
            value: FfiConverterU64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.label);
        FfiConverterU64.write(dataStream, value.value);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.label);
        totalSize += FfiConverterU64.computeSize(value.value);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof LabeledTimingSample)) {
            throw new UniFFITypeError(`Expected 'LabeledTimingSample', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.label);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".label");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.value);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".value");
            }
            throw e;
        }
    }
}

/**
 * QueryWithMetricsResult
 */
export class QueryWithMetricsResult {
    constructor({ suggestions, queryTimes } = { suggestions: undefined, queryTimes: undefined }) {
        try {
            FfiConverterSequenceTypeSuggestion.checkType(suggestions)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("suggestions");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(queryTimes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("queryTimes");
            }
            throw e;
        }
        /**
         * @type {Array.<Suggestion>}
         */
        this.suggestions = suggestions;
        /**
         * Samples for the `suggest.query_time` metric
         * @type {Array.<LabeledTimingSample>}
         */
        this.queryTimes = queryTimes;
    }

    equals(other) {
        return (
            this.suggestions == other.suggestions &&
            this.queryTimes == other.queryTimes
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeQueryWithMetricsResult extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new QueryWithMetricsResult({
            suggestions: FfiConverterSequenceTypeSuggestion.read(dataStream),
            queryTimes: FfiConverterSequenceTypeLabeledTimingSample.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterSequenceTypeSuggestion.write(dataStream, value.suggestions);
        FfiConverterSequenceTypeLabeledTimingSample.write(dataStream, value.queryTimes);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterSequenceTypeSuggestion.computeSize(value.suggestions);
        totalSize += FfiConverterSequenceTypeLabeledTimingSample.computeSize(value.queryTimes);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof QueryWithMetricsResult)) {
            throw new UniFFITypeError(`Expected 'QueryWithMetricsResult', found '${typeof value}'`);
        }
        try {
            FfiConverterSequenceTypeSuggestion.checkType(value.suggestions);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".suggestions");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(value.queryTimes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".queryTimes");
            }
            throw e;
        }
    }
}

/**
 * Global Suggest configuration data.
 */
export class SuggestGlobalConfig {
    constructor({ showLessFrequentlyCap } = { showLessFrequentlyCap: undefined }) {
        try {
            FfiConverterI32.checkType(showLessFrequentlyCap)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("showLessFrequentlyCap");
            }
            throw e;
        }
        /**
         * @type {number}
         */
        this.showLessFrequentlyCap = showLessFrequentlyCap;
    }

    equals(other) {
        return (
            this.showLessFrequentlyCap == other.showLessFrequentlyCap
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestGlobalConfig extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestGlobalConfig({
            showLessFrequentlyCap: FfiConverterI32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterI32.write(dataStream, value.showLessFrequentlyCap);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI32.computeSize(value.showLessFrequentlyCap);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestGlobalConfig)) {
            throw new UniFFITypeError(`Expected 'SuggestGlobalConfig', found '${typeof value}'`);
        }
        try {
            FfiConverterI32.checkType(value.showLessFrequentlyCap);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".showLessFrequentlyCap");
            }
            throw e;
        }
    }
}

/**
 * Constraints limit which suggestions to ingest from Remote Settings.
 */
export class SuggestIngestionConstraints {
    constructor({ providers = null, providerConstraints = null, emptyOnly = false } = { providers: undefined, providerConstraints: undefined, emptyOnly: undefined }) {
        try {
            FfiConverterOptionalSequenceTypeSuggestionProvider.checkType(providers)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeSuggestionProviderConstraints.checkType(providerConstraints)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("providerConstraints");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(emptyOnly)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("emptyOnly");
            }
            throw e;
        }
        /**
         * @type {?Array.<SuggestionProvider>}
         */
        this.providers = providers;
        /**
         * @type {?SuggestionProviderConstraints}
         */
        this.providerConstraints = providerConstraints;
        /**
         * Only run ingestion if the table `suggestions` is empty
         *
         * @type {Boolean}
         */
        this.emptyOnly = emptyOnly;
    }

    equals(other) {
        return (
            this.providers == other.providers &&
            this.providerConstraints == other.providerConstraints &&
            this.emptyOnly == other.emptyOnly
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestIngestionConstraints extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestIngestionConstraints({
            providers: FfiConverterOptionalSequenceTypeSuggestionProvider.read(dataStream),
            providerConstraints: FfiConverterOptionalTypeSuggestionProviderConstraints.read(dataStream),
            emptyOnly: FfiConverterBool.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterOptionalSequenceTypeSuggestionProvider.write(dataStream, value.providers);
        FfiConverterOptionalTypeSuggestionProviderConstraints.write(dataStream, value.providerConstraints);
        FfiConverterBool.write(dataStream, value.emptyOnly);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterOptionalSequenceTypeSuggestionProvider.computeSize(value.providers);
        totalSize += FfiConverterOptionalTypeSuggestionProviderConstraints.computeSize(value.providerConstraints);
        totalSize += FfiConverterBool.computeSize(value.emptyOnly);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestIngestionConstraints)) {
            throw new UniFFITypeError(`Expected 'SuggestIngestionConstraints', found '${typeof value}'`);
        }
        try {
            FfiConverterOptionalSequenceTypeSuggestionProvider.checkType(value.providers);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeSuggestionProviderConstraints.checkType(value.providerConstraints);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".providerConstraints");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.emptyOnly);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".emptyOnly");
            }
            throw e;
        }
    }
}

/**
 * Ingestion metrics
 *
 * These are recorded during [crate::Store::ingest] and returned to the consumer to record.
 */
export class SuggestIngestionMetrics {
    constructor({ ingestionTimes, downloadTimes } = { ingestionTimes: undefined, downloadTimes: undefined }) {
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(ingestionTimes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("ingestionTimes");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(downloadTimes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("downloadTimes");
            }
            throw e;
        }
        /**
         * Samples for the `suggest.ingestion_time` metric
         * @type {Array.<LabeledTimingSample>}
         */
        this.ingestionTimes = ingestionTimes;
        /**
         * Samples for the `suggest.ingestion_download_time` metric
         * @type {Array.<LabeledTimingSample>}
         */
        this.downloadTimes = downloadTimes;
    }

    equals(other) {
        return (
            this.ingestionTimes == other.ingestionTimes &&
            this.downloadTimes == other.downloadTimes
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestIngestionMetrics extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestIngestionMetrics({
            ingestionTimes: FfiConverterSequenceTypeLabeledTimingSample.read(dataStream),
            downloadTimes: FfiConverterSequenceTypeLabeledTimingSample.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterSequenceTypeLabeledTimingSample.write(dataStream, value.ingestionTimes);
        FfiConverterSequenceTypeLabeledTimingSample.write(dataStream, value.downloadTimes);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterSequenceTypeLabeledTimingSample.computeSize(value.ingestionTimes);
        totalSize += FfiConverterSequenceTypeLabeledTimingSample.computeSize(value.downloadTimes);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestIngestionMetrics)) {
            throw new UniFFITypeError(`Expected 'SuggestIngestionMetrics', found '${typeof value}'`);
        }
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(value.ingestionTimes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".ingestionTimes");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeLabeledTimingSample.checkType(value.downloadTimes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".downloadTimes");
            }
            throw e;
        }
    }
}

/**
 * Some providers manage multiple suggestion subtypes. Queries, ingests, and
 * other operations on those providers must be constrained to a desired subtype.
 */
export class SuggestionProviderConstraints {
    constructor({ dynamicSuggestionTypes = null, ampAlternativeMatching = null } = { dynamicSuggestionTypes: undefined, ampAlternativeMatching: undefined }) {
        try {
            FfiConverterOptionalSequencestring.checkType(dynamicSuggestionTypes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("dynamicSuggestionTypes");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAmpMatchingStrategy.checkType(ampAlternativeMatching)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("ampAlternativeMatching");
            }
            throw e;
        }
        /**
         * Which dynamic suggestions should we fetch or ingest? Corresponds to the
         * `suggestion_type` value in dynamic suggestions remote settings records.
         * @type {?Array.<string>}
         */
        this.dynamicSuggestionTypes = dynamicSuggestionTypes;
        /**
         * Which strategy should we use for the AMP queries?
         * Use None for the default strategy.
         * @type {?AmpMatchingStrategy}
         */
        this.ampAlternativeMatching = ampAlternativeMatching;
    }

    equals(other) {
        return (
            this.dynamicSuggestionTypes == other.dynamicSuggestionTypes &&
            this.ampAlternativeMatching == other.ampAlternativeMatching
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestionProviderConstraints extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestionProviderConstraints({
            dynamicSuggestionTypes: FfiConverterOptionalSequencestring.read(dataStream),
            ampAlternativeMatching: FfiConverterOptionalTypeAmpMatchingStrategy.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterOptionalSequencestring.write(dataStream, value.dynamicSuggestionTypes);
        FfiConverterOptionalTypeAmpMatchingStrategy.write(dataStream, value.ampAlternativeMatching);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterOptionalSequencestring.computeSize(value.dynamicSuggestionTypes);
        totalSize += FfiConverterOptionalTypeAmpMatchingStrategy.computeSize(value.ampAlternativeMatching);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestionProviderConstraints)) {
            throw new UniFFITypeError(`Expected 'SuggestionProviderConstraints', found '${typeof value}'`);
        }
        try {
            FfiConverterOptionalSequencestring.checkType(value.dynamicSuggestionTypes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".dynamicSuggestionTypes");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAmpMatchingStrategy.checkType(value.ampAlternativeMatching);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".ampAlternativeMatching");
            }
            throw e;
        }
    }
}

/**
 * A query for suggestions to show in the address bar.
 */
export class SuggestionQuery {
    constructor({ keyword, providers, providerConstraints = null, limit = null } = { keyword: undefined, providers: undefined, providerConstraints: undefined, limit: undefined }) {
        try {
            FfiConverterString.checkType(keyword)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("keyword");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeSuggestionProvider.checkType(providers)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeSuggestionProviderConstraints.checkType(providerConstraints)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("providerConstraints");
            }
            throw e;
        }
        try {
            FfiConverterOptionali32.checkType(limit)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("limit");
            }
            throw e;
        }
        /**
         * @type {string}
         */
        this.keyword = keyword;
        /**
         * @type {Array.<SuggestionProvider>}
         */
        this.providers = providers;
        /**
         * @type {?SuggestionProviderConstraints}
         */
        this.providerConstraints = providerConstraints;
        /**
         * @type {?number}
         */
        this.limit = limit;
    }

    equals(other) {
        return (
            this.keyword == other.keyword &&
            this.providers == other.providers &&
            this.providerConstraints == other.providerConstraints &&
            this.limit == other.limit
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestionQuery extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestionQuery({
            keyword: FfiConverterString.read(dataStream),
            providers: FfiConverterSequenceTypeSuggestionProvider.read(dataStream),
            providerConstraints: FfiConverterOptionalTypeSuggestionProviderConstraints.read(dataStream),
            limit: FfiConverterOptionali32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.keyword);
        FfiConverterSequenceTypeSuggestionProvider.write(dataStream, value.providers);
        FfiConverterOptionalTypeSuggestionProviderConstraints.write(dataStream, value.providerConstraints);
        FfiConverterOptionali32.write(dataStream, value.limit);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.keyword);
        totalSize += FfiConverterSequenceTypeSuggestionProvider.computeSize(value.providers);
        totalSize += FfiConverterOptionalTypeSuggestionProviderConstraints.computeSize(value.providerConstraints);
        totalSize += FfiConverterOptionali32.computeSize(value.limit);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestionQuery)) {
            throw new UniFFITypeError(`Expected 'SuggestionQuery', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.keyword);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".keyword");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeSuggestionProvider.checkType(value.providers);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeSuggestionProviderConstraints.checkType(value.providerConstraints);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".providerConstraints");
            }
            throw e;
        }
        try {
            FfiConverterOptionali32.checkType(value.limit);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".limit");
            }
            throw e;
        }
    }
}


/**
 * AmpMatchingStrategy
 */
export const AmpMatchingStrategy = {
    /**
     * Disable keywords added via keyword expansion.
     * This eliminates keywords that for terms related to the "real" keywords, for example
     * misspellings like "underarmor" instead of "under armor"'.
     */
    NO_KEYWORD_EXPANSION:1,
    /**
     * Use FTS matching against the full keywords, joined together.
     */
    FTS_AGAINST_FULL_KEYWORDS:2,
    /**
     * Use FTS matching against the title field
     */
    FTS_AGAINST_TITLE:3,
};

Object.freeze(AmpMatchingStrategy);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeAmpMatchingStrategy extends FfiConverterArrayBuffer {
    static #validValues = Object.values(AmpMatchingStrategy);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return AmpMatchingStrategy.NO_KEYWORD_EXPANSION
            case 2:
                return AmpMatchingStrategy.FTS_AGAINST_FULL_KEYWORDS
            case 3:
                return AmpMatchingStrategy.FTS_AGAINST_TITLE
            default:
                throw new UniFFITypeError("Unknown AmpMatchingStrategy variant");
        }
    }

    static write(dataStream, value) {
        if (value === AmpMatchingStrategy.NO_KEYWORD_EXPANSION) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === AmpMatchingStrategy.FTS_AGAINST_FULL_KEYWORDS) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === AmpMatchingStrategy.FTS_AGAINST_TITLE) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown AmpMatchingStrategy variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for AmpMatchingStrategy`);
      }
    }
}



/**
 * GeonameMatchType
 */
export const GeonameMatchType = {
    /**
     * ABBREVIATION
     */
    ABBREVIATION:0,
    /**
     * AIRPORT_CODE
     */
    AIRPORT_CODE:1,
    /**
     * This includes any names that aren't abbreviations or airport codes.
     */
    NAME:2,
};

Object.freeze(GeonameMatchType);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGeonameMatchType extends FfiConverterArrayBuffer {
    static #validValues = Object.values(GeonameMatchType);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return GeonameMatchType.ABBREVIATION
            case 2:
                return GeonameMatchType.AIRPORT_CODE
            case 3:
                return GeonameMatchType.NAME
            default:
                throw new UniFFITypeError("Unknown GeonameMatchType variant");
        }
    }

    static write(dataStream, value) {
        if (value === GeonameMatchType.ABBREVIATION) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === GeonameMatchType.AIRPORT_CODE) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === GeonameMatchType.NAME) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown GeonameMatchType variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for GeonameMatchType`);
      }
    }
}



/**
 * The type of a geoname.
 */
export class GeonameType {}
/**
 * Country
 */
GeonameType.Country = class extends GeonameType{
    constructor(
        ) {
            super();
        }
}
/**
 * A state, province, prefecture, district, borough, etc.
 */
GeonameType.AdminDivision = class extends GeonameType{
    constructor(
        level
        ) {
            super();
            this.level = level;
        }
}
/**
 * AdminDivisionOther
 */
GeonameType.AdminDivisionOther = class extends GeonameType{
    constructor(
        ) {
            super();
        }
}
/**
 * A city, town, village, populated place, etc.
 */
GeonameType.City = class extends GeonameType{
    constructor(
        ) {
            super();
        }
}
/**
 * Other
 */
GeonameType.Other = class extends GeonameType{
    constructor(
        ) {
            super();
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeGeonameType extends FfiConverterArrayBuffer {
    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return new GeonameType.Country(
                    );
            case 2:
                return new GeonameType.AdminDivision(
                    FfiConverterU8.read(dataStream)
                    );
            case 3:
                return new GeonameType.AdminDivisionOther(
                    );
            case 4:
                return new GeonameType.City(
                    );
            case 5:
                return new GeonameType.Other(
                    );
            default:
                throw new UniFFITypeError("Unknown GeonameType variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof GeonameType.Country) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof GeonameType.AdminDivision) {
            dataStream.writeInt32(2);
            FfiConverterU8.write(dataStream, value.level);
            return;
        }
        if (value instanceof GeonameType.AdminDivisionOther) {
            dataStream.writeInt32(3);
            return;
        }
        if (value instanceof GeonameType.City) {
            dataStream.writeInt32(4);
            return;
        }
        if (value instanceof GeonameType.Other) {
            dataStream.writeInt32(5);
            return;
        }
        throw new UniFFITypeError("Unknown GeonameType variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof GeonameType.Country) {
            return totalSize;
        }
        if (value instanceof GeonameType.AdminDivision) {
            totalSize += FfiConverterU8.computeSize(value.level);
            return totalSize;
        }
        if (value instanceof GeonameType.AdminDivisionOther) {
            return totalSize;
        }
        if (value instanceof GeonameType.City) {
            return totalSize;
        }
        if (value instanceof GeonameType.Other) {
            return totalSize;
        }
        throw new UniFFITypeError("Unknown GeonameType variant");
    }

    static checkType(value) {
      if (value === undefined || value === null || !(value instanceof GeonameType)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of GeonameType`);
      }
    }
}



/**
 * What should be interrupted when [SuggestStore::interrupt] is called?
 */
export const InterruptKind = {
    /**
     * Interrupt read operations like [SuggestStore::query]
     */
    READ:0,
    /**
     * Interrupt write operations.  This mostly means [SuggestStore::ingest], but
     * other operations may also be interrupted.
     */
    WRITE:1,
    /**
     * Interrupt both read and write operations,
     */
    READ_WRITE:2,
};

Object.freeze(InterruptKind);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeInterruptKind extends FfiConverterArrayBuffer {
    static #validValues = Object.values(InterruptKind);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return InterruptKind.READ
            case 2:
                return InterruptKind.WRITE
            case 3:
                return InterruptKind.READ_WRITE
            default:
                throw new UniFFITypeError("Unknown InterruptKind variant");
        }
    }

    static write(dataStream, value) {
        if (value === InterruptKind.READ) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === InterruptKind.WRITE) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === InterruptKind.READ_WRITE) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown InterruptKind variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for InterruptKind`);
      }
    }
}





/**
 * The error type for all Suggest component operations. These errors are
 * exposed to your application, which should handle them as needed.
 */
export class SuggestApiError extends Error {}


/**
 * Network
 */
export class Network extends SuggestApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `Network: ${super.toString()}`
    }
}

/**
 * The server requested a backoff after too many requests
 */
export class Backoff extends SuggestApiError {

    constructor(
        seconds,
        ...params
    ) {
        const message = `seconds: ${ seconds }`;
        super(message, ...params);
        this.seconds = seconds;
    }
    toString() {
        return `Backoff: ${super.toString()}`
    }
}

/**
 * An operation was interrupted by calling `SuggestStore.interrupt()`
 */
export class Interrupted extends SuggestApiError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `Interrupted: ${super.toString()}`
    }
}

/**
 * Other
 */
export class Other extends SuggestApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `Other: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new Network(
                    FfiConverterString.read(dataStream)
                    );
            case 2:
                return new Backoff(
                    FfiConverterU64.read(dataStream)
                    );
            case 3:
                return new Interrupted(
                    );
            case 4:
                return new Other(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown SuggestApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Network) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof Backoff) {
            totalSize += FfiConverterU64.computeSize(value.seconds);
            return totalSize;
        }
        if (value instanceof Interrupted) {
            return totalSize;
        }
        if (value instanceof Other) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown SuggestApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof Network) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof Backoff) {
            dataStream.writeInt32(2);
            FfiConverterU64.write(dataStream, value.seconds);
            return;
        }
        if (value instanceof Interrupted) {
            dataStream.writeInt32(3);
            return;
        }
        if (value instanceof Other) {
            dataStream.writeInt32(4);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        throw new UniFFITypeError("Unknown SuggestApiError variant");
    }

    static errorClass = SuggestApiError;
}


/**
 * Per-provider configuration data.
 */
export class SuggestProviderConfig {}
/**
 * Weather
 */
SuggestProviderConfig.Weather = class extends SuggestProviderConfig{
    constructor(
        score,
        minKeywordLength
        ) {
            super();
            this.score = score;
            this.minKeywordLength = minKeywordLength;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestProviderConfig extends FfiConverterArrayBuffer {
    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return new SuggestProviderConfig.Weather(
                    FfiConverterF64.read(dataStream),
                    FfiConverterI32.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown SuggestProviderConfig variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof SuggestProviderConfig.Weather) {
            dataStream.writeInt32(1);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterI32.write(dataStream, value.minKeywordLength);
            return;
        }
        throw new UniFFITypeError("Unknown SuggestProviderConfig variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof SuggestProviderConfig.Weather) {
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterI32.computeSize(value.minKeywordLength);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown SuggestProviderConfig variant");
    }

    static checkType(value) {
      if (value === undefined || value === null || !(value instanceof SuggestProviderConfig)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of SuggestProviderConfig`);
      }
    }
}



/**
 * A suggestion from the database to show in the address bar.
 */
export class Suggestion {}
/**
 * Amp
 */
Suggestion.Amp = class extends Suggestion{
    constructor(
        title,
        url,
        rawUrl,
        icon,
        iconMimetype,
        fullKeyword,
        blockId,
        advertiser,
        iabCategory,
        impressionUrl,
        clickUrl,
        rawClickUrl,
        score,
        ftsMatchInfo
        ) {
            super();
            this.title = title;
            this.url = url;
            this.rawUrl = rawUrl;
            this.icon = icon;
            this.iconMimetype = iconMimetype;
            this.fullKeyword = fullKeyword;
            this.blockId = blockId;
            this.advertiser = advertiser;
            this.iabCategory = iabCategory;
            this.impressionUrl = impressionUrl;
            this.clickUrl = clickUrl;
            this.rawClickUrl = rawClickUrl;
            this.score = score;
            this.ftsMatchInfo = ftsMatchInfo;
        }
}
/**
 * Pocket
 */
Suggestion.Pocket = class extends Suggestion{
    constructor(
        title,
        url,
        score,
        isTopPick
        ) {
            super();
            this.title = title;
            this.url = url;
            this.score = score;
            this.isTopPick = isTopPick;
        }
}
/**
 * Wikipedia
 */
Suggestion.Wikipedia = class extends Suggestion{
    constructor(
        title,
        url,
        icon,
        iconMimetype,
        fullKeyword
        ) {
            super();
            this.title = title;
            this.url = url;
            this.icon = icon;
            this.iconMimetype = iconMimetype;
            this.fullKeyword = fullKeyword;
        }
}
/**
 * Amo
 */
Suggestion.Amo = class extends Suggestion{
    constructor(
        title,
        url,
        iconUrl,
        description,
        rating,
        numberOfRatings,
        guid,
        score
        ) {
            super();
            this.title = title;
            this.url = url;
            this.iconUrl = iconUrl;
            this.description = description;
            this.rating = rating;
            this.numberOfRatings = numberOfRatings;
            this.guid = guid;
            this.score = score;
        }
}
/**
 * Yelp
 */
Suggestion.Yelp = class extends Suggestion{
    constructor(
        url,
        title,
        icon,
        iconMimetype,
        score,
        hasLocationSign,
        subjectExactMatch,
        subjectType,
        locationParam
        ) {
            super();
            this.url = url;
            this.title = title;
            this.icon = icon;
            this.iconMimetype = iconMimetype;
            this.score = score;
            this.hasLocationSign = hasLocationSign;
            this.subjectExactMatch = subjectExactMatch;
            this.subjectType = subjectType;
            this.locationParam = locationParam;
        }
}
/**
 * Mdn
 */
Suggestion.Mdn = class extends Suggestion{
    constructor(
        title,
        url,
        description,
        score
        ) {
            super();
            this.title = title;
            this.url = url;
            this.description = description;
            this.score = score;
        }
}
/**
 * Weather
 */
Suggestion.Weather = class extends Suggestion{
    constructor(
        city,
        score
        ) {
            super();
            this.city = city;
            this.score = score;
        }
}
/**
 * Fakespot
 */
Suggestion.Fakespot = class extends Suggestion{
    constructor(
        fakespotGrade,
        productId,
        rating,
        title,
        totalReviews,
        url,
        icon,
        iconMimetype,
        score,
        matchInfo
        ) {
            super();
            this.fakespotGrade = fakespotGrade;
            this.productId = productId;
            this.rating = rating;
            this.title = title;
            this.totalReviews = totalReviews;
            this.url = url;
            this.icon = icon;
            this.iconMimetype = iconMimetype;
            this.score = score;
            this.matchInfo = matchInfo;
        }
}
/**
 * Dynamic
 */
Suggestion.Dynamic = class extends Suggestion{
    constructor(
        suggestionType,
        data,
        dismissalKey,
        score
        ) {
            super();
            this.suggestionType = suggestionType;
            this.data = data;
            this.dismissalKey = dismissalKey;
            this.score = score;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestion extends FfiConverterArrayBuffer {
    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return new Suggestion.Amp(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalbytes.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterI64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterOptionalTypeFtsMatchInfo.read(dataStream)
                    );
            case 2:
                return new Suggestion.Pocket(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterBool.read(dataStream)
                    );
            case 3:
                return new Suggestion.Wikipedia(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalbytes.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            case 4:
                return new Suggestion.Amo(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterI64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 5:
                return new Suggestion.Yelp(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalbytes.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterBool.read(dataStream),
                    FfiConverterBool.read(dataStream),
                    FfiConverterTypeYelpSubjectType.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            case 6:
                return new Suggestion.Mdn(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 7:
                return new Suggestion.Weather(
                    FfiConverterOptionalTypeGeoname.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 8:
                return new Suggestion.Fakespot(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterI64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalbytes.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterOptionalTypeFtsMatchInfo.read(dataStream)
                    );
            case 9:
                return new Suggestion.Dynamic(
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalTypeJsonValue.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown Suggestion variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof Suggestion.Amp) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.rawUrl);
            FfiConverterOptionalbytes.write(dataStream, value.icon);
            FfiConverterOptionalstring.write(dataStream, value.iconMimetype);
            FfiConverterString.write(dataStream, value.fullKeyword);
            FfiConverterI64.write(dataStream, value.blockId);
            FfiConverterString.write(dataStream, value.advertiser);
            FfiConverterString.write(dataStream, value.iabCategory);
            FfiConverterString.write(dataStream, value.impressionUrl);
            FfiConverterString.write(dataStream, value.clickUrl);
            FfiConverterString.write(dataStream, value.rawClickUrl);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterOptionalTypeFtsMatchInfo.write(dataStream, value.ftsMatchInfo);
            return;
        }
        if (value instanceof Suggestion.Pocket) {
            dataStream.writeInt32(2);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterBool.write(dataStream, value.isTopPick);
            return;
        }
        if (value instanceof Suggestion.Wikipedia) {
            dataStream.writeInt32(3);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterOptionalbytes.write(dataStream, value.icon);
            FfiConverterOptionalstring.write(dataStream, value.iconMimetype);
            FfiConverterString.write(dataStream, value.fullKeyword);
            return;
        }
        if (value instanceof Suggestion.Amo) {
            dataStream.writeInt32(4);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.iconUrl);
            FfiConverterString.write(dataStream, value.description);
            FfiConverterOptionalstring.write(dataStream, value.rating);
            FfiConverterI64.write(dataStream, value.numberOfRatings);
            FfiConverterString.write(dataStream, value.guid);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Yelp) {
            dataStream.writeInt32(5);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterOptionalbytes.write(dataStream, value.icon);
            FfiConverterOptionalstring.write(dataStream, value.iconMimetype);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterBool.write(dataStream, value.hasLocationSign);
            FfiConverterBool.write(dataStream, value.subjectExactMatch);
            FfiConverterTypeYelpSubjectType.write(dataStream, value.subjectType);
            FfiConverterString.write(dataStream, value.locationParam);
            return;
        }
        if (value instanceof Suggestion.Mdn) {
            dataStream.writeInt32(6);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.description);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Weather) {
            dataStream.writeInt32(7);
            FfiConverterOptionalTypeGeoname.write(dataStream, value.city);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Fakespot) {
            dataStream.writeInt32(8);
            FfiConverterString.write(dataStream, value.fakespotGrade);
            FfiConverterString.write(dataStream, value.productId);
            FfiConverterF64.write(dataStream, value.rating);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterI64.write(dataStream, value.totalReviews);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterOptionalbytes.write(dataStream, value.icon);
            FfiConverterOptionalstring.write(dataStream, value.iconMimetype);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterOptionalTypeFtsMatchInfo.write(dataStream, value.matchInfo);
            return;
        }
        if (value instanceof Suggestion.Dynamic) {
            dataStream.writeInt32(9);
            FfiConverterString.write(dataStream, value.suggestionType);
            FfiConverterOptionalTypeJsonValue.write(dataStream, value.data);
            FfiConverterOptionalstring.write(dataStream, value.dismissalKey);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        throw new UniFFITypeError("Unknown Suggestion variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Suggestion.Amp) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.rawUrl);
            totalSize += FfiConverterOptionalbytes.computeSize(value.icon);
            totalSize += FfiConverterOptionalstring.computeSize(value.iconMimetype);
            totalSize += FfiConverterString.computeSize(value.fullKeyword);
            totalSize += FfiConverterI64.computeSize(value.blockId);
            totalSize += FfiConverterString.computeSize(value.advertiser);
            totalSize += FfiConverterString.computeSize(value.iabCategory);
            totalSize += FfiConverterString.computeSize(value.impressionUrl);
            totalSize += FfiConverterString.computeSize(value.clickUrl);
            totalSize += FfiConverterString.computeSize(value.rawClickUrl);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterOptionalTypeFtsMatchInfo.computeSize(value.ftsMatchInfo);
            return totalSize;
        }
        if (value instanceof Suggestion.Pocket) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterBool.computeSize(value.isTopPick);
            return totalSize;
        }
        if (value instanceof Suggestion.Wikipedia) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterOptionalbytes.computeSize(value.icon);
            totalSize += FfiConverterOptionalstring.computeSize(value.iconMimetype);
            totalSize += FfiConverterString.computeSize(value.fullKeyword);
            return totalSize;
        }
        if (value instanceof Suggestion.Amo) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.iconUrl);
            totalSize += FfiConverterString.computeSize(value.description);
            totalSize += FfiConverterOptionalstring.computeSize(value.rating);
            totalSize += FfiConverterI64.computeSize(value.numberOfRatings);
            totalSize += FfiConverterString.computeSize(value.guid);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Yelp) {
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterOptionalbytes.computeSize(value.icon);
            totalSize += FfiConverterOptionalstring.computeSize(value.iconMimetype);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterBool.computeSize(value.hasLocationSign);
            totalSize += FfiConverterBool.computeSize(value.subjectExactMatch);
            totalSize += FfiConverterTypeYelpSubjectType.computeSize(value.subjectType);
            totalSize += FfiConverterString.computeSize(value.locationParam);
            return totalSize;
        }
        if (value instanceof Suggestion.Mdn) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.description);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Weather) {
            totalSize += FfiConverterOptionalTypeGeoname.computeSize(value.city);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Fakespot) {
            totalSize += FfiConverterString.computeSize(value.fakespotGrade);
            totalSize += FfiConverterString.computeSize(value.productId);
            totalSize += FfiConverterF64.computeSize(value.rating);
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterI64.computeSize(value.totalReviews);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterOptionalbytes.computeSize(value.icon);
            totalSize += FfiConverterOptionalstring.computeSize(value.iconMimetype);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterOptionalTypeFtsMatchInfo.computeSize(value.matchInfo);
            return totalSize;
        }
        if (value instanceof Suggestion.Dynamic) {
            totalSize += FfiConverterString.computeSize(value.suggestionType);
            totalSize += FfiConverterOptionalTypeJsonValue.computeSize(value.data);
            totalSize += FfiConverterOptionalstring.computeSize(value.dismissalKey);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown Suggestion variant");
    }

    static checkType(value) {
      if (value === undefined || value === null || !(value instanceof Suggestion)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of Suggestion`);
      }
    }
}



/**
 * A provider is a source of search suggestions.
 */
export const SuggestionProvider = {
    /**
     * AMP
     */
    AMP:1,
    /**
     * WIKIPEDIA
     */
    WIKIPEDIA:2,
    /**
     * AMO
     */
    AMO:3,
    /**
     * POCKET
     */
    POCKET:4,
    /**
     * YELP
     */
    YELP:5,
    /**
     * MDN
     */
    MDN:6,
    /**
     * WEATHER
     */
    WEATHER:7,
    /**
     * FAKESPOT
     */
    FAKESPOT:8,
    /**
     * DYNAMIC
     */
    DYNAMIC:9,
};

Object.freeze(SuggestionProvider);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestionProvider extends FfiConverterArrayBuffer {
    static #validValues = Object.values(SuggestionProvider);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return SuggestionProvider.AMP
            case 2:
                return SuggestionProvider.WIKIPEDIA
            case 3:
                return SuggestionProvider.AMO
            case 4:
                return SuggestionProvider.POCKET
            case 5:
                return SuggestionProvider.YELP
            case 6:
                return SuggestionProvider.MDN
            case 7:
                return SuggestionProvider.WEATHER
            case 8:
                return SuggestionProvider.FAKESPOT
            case 9:
                return SuggestionProvider.DYNAMIC
            default:
                throw new UniFFITypeError("Unknown SuggestionProvider variant");
        }
    }

    static write(dataStream, value) {
        if (value === SuggestionProvider.AMP) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === SuggestionProvider.WIKIPEDIA) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === SuggestionProvider.AMO) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === SuggestionProvider.POCKET) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === SuggestionProvider.YELP) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === SuggestionProvider.MDN) {
            dataStream.writeInt32(6);
            return;
        }
        if (value === SuggestionProvider.WEATHER) {
            dataStream.writeInt32(7);
            return;
        }
        if (value === SuggestionProvider.FAKESPOT) {
            dataStream.writeInt32(8);
            return;
        }
        if (value === SuggestionProvider.DYNAMIC) {
            dataStream.writeInt32(9);
            return;
        }
        throw new UniFFITypeError("Unknown SuggestionProvider variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for SuggestionProvider`);
      }
    }
}



/**
 * Subject type for Yelp suggestion.
 */
export const YelpSubjectType = {
    /**
     * SERVICE
     */
    SERVICE:0,
    /**
     * BUSINESS
     */
    BUSINESS:1,
};

Object.freeze(YelpSubjectType);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeYelpSubjectType extends FfiConverterArrayBuffer {
    static #validValues = Object.values(YelpSubjectType);

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match Python bindings
        switch (dataStream.readInt32()) {
            case 1:
                return YelpSubjectType.SERVICE
            case 2:
                return YelpSubjectType.BUSINESS
            default:
                throw new UniFFITypeError("Unknown YelpSubjectType variant");
        }
    }

    static write(dataStream, value) {
        if (value === YelpSubjectType.SERVICE) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === YelpSubjectType.BUSINESS) {
            dataStream.writeInt32(2);
            return;
        }
        throw new UniFFITypeError("Unknown YelpSubjectType variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for YelpSubjectType`);
      }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionali32 extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterI32.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterI32.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterI32.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterI32.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalbytes extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterBytes.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterBytes.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterBytes.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterBytes.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeAlternateNames extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeAlternateNames.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeAlternateNames.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeAlternateNames.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeAlternateNames.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeFtsMatchInfo extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeFtsMatchInfo.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeFtsMatchInfo.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeFtsMatchInfo.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeFtsMatchInfo.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeGeoname extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeGeoname.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeGeoname.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeGeoname.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeGeoname.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeSuggestionProviderConstraints extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeSuggestionProviderConstraints.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeSuggestionProviderConstraints.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeSuggestionProviderConstraints.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeSuggestionProviderConstraints.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeAmpMatchingStrategy extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeAmpMatchingStrategy.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeAmpMatchingStrategy.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeAmpMatchingStrategy.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeAmpMatchingStrategy.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeInterruptKind extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeInterruptKind.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeInterruptKind.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeInterruptKind.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeInterruptKind.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeSuggestProviderConfig extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeSuggestProviderConfig.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeSuggestProviderConfig.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeSuggestProviderConfig.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeSuggestProviderConfig.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalSequencestring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterSequencestring.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterSequencestring.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterSequencestring.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterSequencestring.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalSequenceTypeGeoname extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterSequenceTypeGeoname.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterSequenceTypeGeoname.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterSequenceTypeGeoname.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterSequenceTypeGeoname.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalSequenceTypeSuggestionProvider extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterSequenceTypeSuggestionProvider.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterSequenceTypeSuggestionProvider.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterSequenceTypeSuggestionProvider.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterSequenceTypeSuggestionProvider.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeJsonValue extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeJsonValue.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeJsonValue.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeJsonValue.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeJsonValue.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterString.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeGeoname extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeGeoname.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeGeoname.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeGeoname.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeGeoname.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeGeonameMatch extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeGeonameMatch.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeGeonameMatch.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeGeonameMatch.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeGeonameMatch.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeLabeledTimingSample extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeLabeledTimingSample.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeLabeledTimingSample.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeLabeledTimingSample.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeLabeledTimingSample.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeSuggestion extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeSuggestion.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeSuggestion.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeSuggestion.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeSuggestion.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeSuggestionProvider extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeSuggestionProvider.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeSuggestionProvider.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeSuggestionProvider.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeSuggestionProvider.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterMapU8String extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = new Map();
        for (let i = 0; i < len; i++) {
            const key = FfiConverterU8.read(dataStream);
            const value = FfiConverterString.read(dataStream);
            map.set(key, value);
        }

        return map;
    }

    static write(dataStream, map) {
        dataStream.writeInt32(map.size);
        for (const [key, value] of map) {
            FfiConverterU8.write(dataStream, key);
            FfiConverterString.write(dataStream, value);
        }
    }

    static computeSize(map) {
        // The size of the length
        let size = 4;
        for (const [key, value] of map) {
            size += FfiConverterU8.computeSize(key);
            size += FfiConverterString.computeSize(value);
        }
        return size;
    }

    static checkType(map) {
        for (const [key, value] of map) {
            try {
                FfiConverterU8.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterString.checkType(value);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterMapU8TypeAlternateNames extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = new Map();
        for (let i = 0; i < len; i++) {
            const key = FfiConverterU8.read(dataStream);
            const value = FfiConverterTypeAlternateNames.read(dataStream);
            map.set(key, value);
        }

        return map;
    }

    static write(dataStream, map) {
        dataStream.writeInt32(map.size);
        for (const [key, value] of map) {
            FfiConverterU8.write(dataStream, key);
            FfiConverterTypeAlternateNames.write(dataStream, value);
        }
    }

    static computeSize(map) {
        // The size of the length
        let size = 4;
        for (const [key, value] of map) {
            size += FfiConverterU8.computeSize(key);
            size += FfiConverterTypeAlternateNames.computeSize(value);
        }
        return size;
    }

    static checkType(map) {
        for (const [key, value] of map) {
            try {
                FfiConverterU8.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterTypeAlternateNames.checkType(value);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeJsonValue extends FfiConverter {
    static lift(buf) {
        return FfiConverterString.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterString.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterString.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.

import {
  FfiConverterTypeRemoteSettingsService,
  RemoteSettingsService,
} from "moz-src:///toolkit/components/uniffi-bindgen-gecko-js/components/generated/RustRemoteSettings.sys.mjs";

// Export the FFIConverter object to make external types work.
export { FfiConverterTypeRemoteSettingsService, RemoteSettingsService };import {
  FfiConverterTypeRemoteSettingsServer,
  RemoteSettingsServer,
} from "moz-src:///toolkit/components/uniffi-bindgen-gecko-js/components/generated/RustRemoteSettings.sys.mjs";

// Export the FFIConverter object to make external types work.
export { FfiConverterTypeRemoteSettingsServer, RemoteSettingsServer };



/**
 * Determines whether a "raw" sponsored suggestion URL is equivalent to a
 * "cooked" URL. The two URLs are equivalent if they are identical except for
 * their replaced template parameters, which can be different.
 * @returns {Boolean}
 */
export function rawSuggestionUrlMatches(rawUrl,cookedUrl) {

        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(rawUrl)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("rawUrl");
                }
                throw e;
            }
            try {
                FfiConverterString.checkType(cookedUrl)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("cookedUrl");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                37, // suggest:uniffi_suggest_fn_func_raw_suggestion_url_matches
                FfiConverterString.lower(rawUrl),
                FfiConverterString.lower(cookedUrl),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
}
