---
layout: page
title: Contributing
permalink: /contributing/
---

We encourage you to participate in this open source project. We love pull requests, bug reports, ideas, (security) code reviews or any kind of positive contribution.

Thank you for taking the time to contribute to one of Mozilla's Android projects!

Before contributing, please review our [Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/).

## Docs

* [Contributing to Mozilla Mobile's Android projects](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/shared/android/CONTRIBUTING.md)
* [Contributing code to Mozilla's Android projects](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/shared/android/CONTRIBUTING_code.md)

### Project

* [Hosting Android code in the Android Components repository]({{ site.baseurl }}/contributing/hosting-android-code-in-repository)

### Development

* [Design Axioms]({{ site.baseurl }}/contributing/design-axioms)
* [Architecture and Overview]({{ site.baseurl }}/contributing/architecture)
* [Code coverage]({{ site.baseurl }}/contributing/code-coverage)
* [Working on unreleased component code in an app]({{ site.baseurl }}/contributing/testing-components_inside_app)

### Process

* [Release checklist]({{ site.baseurl }}/contributing/release-checklist)
* [Versioning and release process]({{ site.baseurl }}/contributing/versioning)
* [Deprecating components and code]({{ site.baseurl }}/contributing/deprecating)
* [Merge day process]({{ site.baseurl }}/contributing/merge-day)
* [Updating the tracking protection lists process]({{ site.baseurl }}/contributing/update-tracking-protection-list)
* [Updating to a newer Application Services]({{ site.baseurl }}/contributing/app-services-upgrades)

### Accepted RFCs

* [0001 - Introducing a lightweight RFC process]({{ site.baseurl }}/rfc/0001-rfc-process)
* [0002 - Moving search state to BrowserState and introducing a SearchMiddleware]({{ site.baseurl }}/rfc/0002-search-state-in-browser-store)
* [0003 - Adding a `concept-base` component]({{ site.baseurl }}/rfc/0003-concept-base-component)
* [0004 - Introducing a Top Sites Feature]({{ site.baseurl }}/rfc/0004-top-sites-feature)
* [0005 - Migrate feature-sitepermissions to be compatible with the new GeckoView permission API]({{ site.baseurl }}/rfc/0005-migrate-sitepermission-ac-store-geckoview-store)
* [0006 - Determining the set of default search engines]({{ site.baseurl }}/rfc/0006-search-defaults)
* [0007 - Synchronizing the branching and versioning of Android Components with the Mozilla release trains]({{ site.baseurl }}/rfc/0007-synchronized-releases)
* [0008 - Adding tab partitions (groups) to BrowserState]({{ site.baseurl }}/rfc/0008-tab-groups)
* [0012 - Introduce a Store for UI components]({{ site.baseurl }}/rfc/0012-introduce-ui-store)

### Presentations

* [GeckoView and Android components (June 2018)](https://onlinexperiences.com/Launch/Event.htm?ShowKey=44908&DisplayItem=E271804) **[Mozilla internal only]**
