/*
 *	Generic socket definitions
 *
 *	Authors:	Alan Cox, <iialan@iifeak.swan.ac.uk>
 */
 
extern int gs_create(struct socket *, int);
extern int gs_dup(struct socket *, struct socket *);
extern int gs_release(struct socket *, struct socket *);
extern int gs_bind(struct socket *, struct sockaddr *, int);
extern int gs_connect(struct socket *, struct sockaddr *, int, int);
extern int gs_socketpair(struct socket *, struct socket *);
extern int gs_accept(struct socket *, struct socket *, int);
extern int gs_getname(struct socket *, struct sockaddr *, int *, int);
extern int gs_select(struct socket *, int sel_type, select_table *);
extern int gs_ioctl(struct socket *, unsigned int, unsigned long);
extern int gs_listen(struct socket *, int);
extern int gs_sendmsg(struct socket *, struct msghdr *, int, int, int);
extern int gs_recvmsg(struct socket *, struct msghdr *, int, int, int, int *);
extern int gs_shutdown(struct socket *, int);
extern int gs_setsockopt(struct socket *, int, int, char *, int);
extern int gs_getsockopt(struct socket *, int, int, char *, int *);
extern int gs_fcntl(struct socket *, unsigned int, unsigned long);

extern struct protocol proto_generic;
