/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * MODULE NAME: 	stage2.c
 *
 * SCCSINFO:		@(#)stage2.c	1.6 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Robert Jakobsson, ????.
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *   File containing the  module CUTOFF2 which opens index- and flagfile
 *   and calls Traverse. After that it links entries with reached flags
 *   reset using LinkEntries.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "xconfig.h"
#include "cutoff.h"
#include "dbserver.h"		/* to get IT_SYSTEM_MOLECULE_LABEL */
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_stage2.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"
#include "f_flag.h"
#include "f_pointers.h"
#include "f_traverse.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* cutoffmain.c */
extern off_t global_idxlen;
extern int global_indexfd;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define LASTINLINK -3

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static void LinkEntries P_(( void ));

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int stage2()
 *
 * Modifications:
 *      <list mods with name and date>
 */
int stage2()
{
  (void)printf("stage2: starting\n");
  /* call function traverse with system system label */
  if ((Traverse()) == FAIL)
    fatal_error(FATAL_GEN, "stage2", "Traverse failed");

  /* call function LinkEntries which link entries with reached flag reset */
  LinkEntries();
  (void)printf("stage2: completed\n");
  return SUCCESS;
}

/*  */
/**********************************************************************
 * Function: static void LinkEntries()
 *
 * links entries with reached flag reset
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void LinkEntries()
{
  LABEL prev_label, cur_label;
#ifdef REPORTNUMBER
  int count = REPORTNUMBER;
#endif
  long processed = 0;
  long linked = 0;

  prev_label = (LASTINLINK);

  for (cur_label = IT_SYSTEM_MOLECULE_LABEL;
       cur_label<ConvToLabel(global_idxlen);
       cur_label += sizeof(INDEX)) {

#ifdef REPORTNUMBER
    if (count++ >= REPORTNUMBER) {
      (void)printf("Processed: %ld, Linked: %ld\n", processed, linked);
      count = 0;
    }
#endif
    processed++;
    if (!is_flag_set(cur_label, CO_REACHED)) {
      if (ChangeFilNo(cur_label,LASTINLINK) == FAIL)
	fatal_error(FATAL_GEN, "LinkEntries", "ChangeFilNo failed");

      if (prev_label != (LASTINLINK)) {
	/*
	 * The free index entry linking is implemented in a questionable
	 * manner, since the filenumber field of an index entry cannot
	 * keep a long. How is this list used?
	 */
	if (ChangeFilNo(prev_label, -((int)cur_label)) == FAIL)
	  fatal_error(FATAL_GEN, "LinkEntries", "ChangeFilNo failed");
      }
      linked++;
      prev_label = cur_label;
    }
  }
  (void)printf("Total Processed: %ld, Linked: %ld\n", processed, linked);
}
