.\" 
.\" Linkoping Intelligent Communication of Knowledge System (LINCKS)
.\"      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
.\"       Department of Computer and Information Sciences
.\"		University of Linkoping, Sweden
.\"		    581 83 Linkoping, Sweden
.\"		       lincks@ida.liu.se
.\"
.\" These collective LINCKS programs are free software; you can 
.\" redistribute them and/or modify them under the terms of the GNU
.\" General Public License as published by the Free Software Foundation,
.\" version 2 of the License.
.\"
.\" These programs are distributed in the hope that they will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the programs; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" xlincks man page
.\" author: David Partain
.\" version:  @(#)xlincks.l	1.7 5/27/94
.\"
.TH xlincks l "5/27/94" IISLAB "LINCKS System"
.SH NAME
xlincks - An X-windows based user interface to LINCKS databases.
.SH SYNOPSIS
.B xlincks
[
-D
] 
[
-N
]
[
-S
]
[
-q
]
[
-C
]
[
-c
]
[
-u username -p password 
]
[
some X options
]
[
database-dir
]
.SH DESCRIPTION
\fIxlincks\fR is used to access, manipulate, and store information in
LINCKS databases.
.SH OPTIONS
.TP
.B -D
Use all window buttons, including so-called `development buttons'.  This
includes two extra buttons which allow you to get a graphical image of
the reference structure and to see the binding table for the composite
object.  If you don't know what these are, you don't need to use -D.
.TP
.B -N
Use no buttons.  This is for users who know their way around the
keyboard commands within \fIxlincks\fR and don't wish to have their
windows cluttered with buttons.  This options overrides the former
if both are given.
.TP
.B -S
Suppress.  This option suppresses certain informational messages, in
particular some parallel editing notifications (since the window is
shaded anyway).
.TP
.B -q
Quiet mode.  Shuts off the copyright and version printouts at log in.
.TP
.B -C
Chaining mode.  Chains windows together.  When a new window is popped
up, it is put below and to the left (generally) of the window from which
it was expanded.
.TP
.B -c
Use color when doing parallel notification and difference operations
instead of the background shading.
.TP
.B -u username -p password
Both username and password must be given when using this option,
which try to log you into the database server directly.
.TP
.B some X options
This is a bit complicated.  Only those X options which require no
arguments (-rv, etc.) are acceptable.
.TP
.B database-dir
The path to the database in which you are going to log in.  You must
have this argument unless you have the environment variable LINCKSDBDIR
set.  In that case, you only need it if you wish to override the
environment setting.
.SH IMPORTANT NOTE
This manual page is not intended to be complete user documentation.  The
LINCKS release contains a document called `The xlincks User's Manual'
which fills this role.  The manual page is intended to give very basic
information and as a reminder of information found in the user's
manual.
.SH PREREQUISITES
You need a terminal that can run \fIX windows\fR, and you need to know
how to do basic \fIX windows\fR things, e.g. changing window sizes, and
moving windows.
.SH STARTING XLINCKS
.LP
Start \fIxlincks\fR with the appropriate command line arguments and on
a database that you have access to.  You will be prompted for your
LINCKS login and password.  You must have a valid login for the
particular LINCKS database you want to use.
.LP
\fIxlincks\fR will create a series of windows.  For each one, use the
mouse to place it where you want it, then click the left button.  (In
these directions, if the mouse button is not otherwise specified, use
the left button).  One of the windows should be the \fIxlincks\fR
command menu.
.SH BASIC INTERACTION WITH XLINCKS
Much of the information in a database is organized hierarchically.
When you start up \fIxlincks\fR you should get one or more windows
which are your entry points into the database.  To see more of the
database, you ``expand'' (see "HOW TO EXPAND" below) some item in a
window, thereby using it as the root of a new window.
.SH ON-LINE HELP
There are two kinds of on-line help: the help text associated with a
particular button, and on-line documentation.
.TP
.B Button help text
Click on the button about which you wish to know more using the the
right mouse button.
.TP
.B On-line documentation
When you log in, you should get a window called `Help!'.  All of the
on-line documentation is organized under this window.  You can `expand'
the appropriate items to see the documentation.  Additionally, there is
a button in the command menu called `Help Window ...'.  This will bring
up the Help! window if you click on it.
.SH CONVENTIONS 
.LP
<<xxx>> usually means "xxx" is a placeholder.  A placeholder indicates
that the GPD calls for something of type `xxx' to be in this place.
Editing the placeholder will then create something of type `xxx' in the
database.
.LP
A box (frame) around an item often means that it's something that
can be expanded.  This is, however, simply a convention used by some
GPD's.
.SH ANSWERS TO A FEW COMMON QUESTIONS
.LP
How do I expand an item?
.in +5
To expand something using the default GPD, you have the following
choices:

Click with the left mouse button on the thing you want to expand while
at the same time holding the `Control' button.  This will open a new
window.  The key command `meta-l meta-e' has the same effect.

Click with the right mouse button on the thing you want to expand
while at the same time holding the `Control' button.  This will expand
the item and reuse the window.  The key command `meta-l meta-E' has the
same effect.
.in -5
.LP
How do I expand something using a different GPD?
.in +5
To expand something using a GPD other than the default, click on the
`Expand ...' command menu button, which will bring up a menu of GPD's.
Then, first click on the item you wish to expand and then click (in the
menu) on the GPD you wish to use.

For example, if you wish to see something in `node' view (the entire
database object), click on the item you want to see, bring up the menu,
and click on the menu item `node'.
.in -5
.LP
How can I create a new item?
.in +5
This is done with the command `meta-l meta-i'.  This will create a
sibling of the current item if it is a plural item or the nearest closer
plural if it is not.  See `The xlincks User's Manual' for more
information.
.in -5
.LP
How can I remove an item?
.in +5
On the item you wish to remove, type `meta-l meta-r'.
.in -5
.LP
How can I put in a link item?
.in +5
First, click on the item to which you wish to have a link (the source),
then click on the item after which you wish to put the link (the
destination), then click on the command menu `Add Link' button.
.in -5
.LP
How to tell what can be expanded?
.in +5
It's controlled by the GPD (which you can look at using the window
button `GPD').
.in -5
.LP
How can I go back to the window from which this one was expanded?
.in +5
When a window is created, it includes a `stack' of windows which have
preceded it in the chain of expansion.  You can go back to the previous
window by `popping' one window off of this stack.  This is done by:

The key command `meta-l meta-p' will go back to the previous window but
put it into a new one.

The key command `meta-l meta-P' will go back to the previous window and
put it into the same window.  Holding down the `Control' key and
clicking anywhere in the window with the right mouse button has the same
effect.
.in -5
.LP
How can I export the window as text to an external file?
.in +5
Click on the window button `Export ..', which will bring up a menu of
choices.  You can set the name of the external file, choose whether to
export it as LaTeX (which tries to maintain some of the internal
structure in the database object) or straight text, and you can set some
parameters for LaTeX exports.  Then click on `Execute' in the menu.
.in -5
.LP
How can I see old versions of a object?
.in +5
If you wish to see the history of the composite object represented in
the window, click on the `History ..' button in the window.  You can
then browse through the history of the object by clicking on the circles
in the graph.

If you, instead, wish to see the history of one component of a composite
object (one item in the window), click on the item and then on the `Item
History ...' button in the command menu.  You can browse in the same
way.
.in -5
.SH SECURITY
Virtually non-existent.  There has been very little work done on
security, as this is neither our research interest nor of any importance
in our working environment.  Passwords, however, are encrypted in the
password file.

.SH EDITING WITHIN THE DATABASE
The editing style of \fIxlincks\fR is based upon the \fIemacs\fR
editor.  Emacs-like commands available inside LINCKS are:

control-a:	Go to beginning of the line.

control-b:	Go backward one character.

control-d:	Delete character under cursor.

control-e:	Go to end of line.

control-f:	Go forward one character.

control-h:	Delete previous character.

control-j:	Split the paragraph into two (when possible).

control-k:	Delete to the end of the line.

control-l:	Refresh the window.

control-m:	Insert a newline.

control-n:	Go to the next line.

control-o:	Insert a newline but remain on same line.

control-p:	Go to the previous line.

control-r:	Search backward for subsequent keystrokes.

control-s:	Search forward.

control-t:	Transpose this character with predecessor.

control-v:	Go forward one `page'.

control-x control-s:	 Save window.

control-x control-c:	 Close window.

meta-b:		Go backward one word.

meta-f:		Go forward one word.

meta-j:		Join this paragraph with the next.

meta-k:		Kill to the end of the paragraph.

meta-q:		Reform the paragraph.

meta-v:		Go back one `page'.

meta-d:		Delete next word.

meta-h:		Delete previous word.

meta-<:		Go to the beginning of the window.

meta->:		Go to the end of the window.

meta-[:		Go backward a paragraph.

meta-]:		Go forward a paragraph.

meta-l meta-b:	promote this version of the view.

meta-l meta-c:	close all windows.

meta-l meta-d:	difference between the previous and current compositions.

meta-l meta-e:	expand this item in a new window.

meta-l meta-E:	expand this item in the same window.

meta-l meta-p:	pop back to previous window in a new window.

meta-l meta-P:	pop back to previous window in the same window.

meta-l meta-g:	show the GPD used to build this view.

meta-l meta-h:	show the composite temporal history.

meta-l meta-i:	insert a new plural item after.

meta-l meta-I:	insert a new plural item before.

meta-l meta-l:	export the window.

meta-l meta-o:	show the item temporal history for current item.

meta-l meta-q:	logout.

meta-l meta-r:	delete this plural item.

meta-l meta-s:	store all changes in all windows.

meta-l meta-u:	refetch the latest version of this view.

meta-l meta-w:	close auxiliary windows.

.SH XLINCKS Widget Hierarchy
.nf

xlincks
	ExportLatex 	  exportLatex
	LatexStyle 	  latexStyle
	LatexDeep 	  latexDeep
	LatexFontSize 	  latexFontSize
	LatexPlaceHolders latexPlaceHolders
	LatexEscape       latexEscape

	UseColors	  useColors

	PixelPen 		pixelPen
	PixelChange 		pixelChange
	PixelDelete 		pixelDelete
	PixelInsert 		pixelInsert
	PixelInvisible 		pixelInvisible

	PixmapPen 		pixmapPen
	PixmapPenWidth		pixmapPenWidth
	PixmapPenHeight 	pixmapPenHeight
	PixmapBound 		pixmapBound
	PixmapBoundWidth 	pixmapBoundWidth
	PixmapBoundHeight 	pixmapBoundHeight
	PixmapChange 		pixmapChange
	PixmapChangeWidth 	pixmapChangeWidth
	PixmapChangeHeight 	pixmapChangeHeight
	PixmapDelete 		pixmapDelete
	PixmapDeleteWidth 	pixmapDeleteWidth
	PixmapDeleteHeight 	pixmapDeleteHeight
	PixmapInsert 		pixmapInsert
	PixmapInsertWidth 	pixmapInsertWidth
	PixmapInsertHeight 	pixmapInsertHeight
	PixmapInvisible		pixmapInvisible
	PixmapInvisibleWidth 	pixmapInvisibleWidth
	PixmapInvisibleHeight 	pixmapInvisibleHeight

	Box  commandmenu
		Command  Expand ...
		Command  Cut & Paste ...
		Command  Item History ...
		Command  User Root ...
		Command  Help Window ...
		Command  Add Link
		Command  DBDump
		Command  Store All
		Command  Close All
		Command  Logout
		Command  CloseAuxWins
		Command  Compare

	WMShell  gpdmenu
		Viewport  scroll
			Core  clip
			List  list

	ApplicationShell  some random name here
		Form  windowform
			Form  buttons
				Command  StoreWindow
				Command  CloseWindow
				Command  RefetchWindow
				Command  PromoteVersion
				Command  ExportWindow
				Command  DupWindow
				Command  ShowGPD
				Command  ShowHistory
				Command  DumpRefStr
				Command  ShowBT
			XlView  scroller
				Core  clip
				Layout  contents
					XlText  ...
					XlText  ...
					XlText  some number of text widgets

	WMShell  some random name here
		Paned  refpane
			Box  box
				Command  close
				Command  dump
			Viewport  scroll
				Core  clip
				Composite  contents
					Label  templatetitle
					Graph  template
					Label  targettitle
					Graph  target
				Scrollbar  horizontal
				Scrollbar  vertical
			Grip  grip
		TransientShell  fileinput
			Form  inputform
				Dialog  inputdialog
					Label  label
					Text  value
					Command  Execute
					Command  Cancel

	WMShell  some random name here
		Paned  historypane
			Box  box
				Command  close
				Command  dump
			Viewport  scroll
				Core  clip
				Graph  history
			Grip  grip
		TransientShell  fileinput
			Form  inputform
				Dialog  inputdialog
					Label  label
					Text  value
					Command  Execute
					Command  Cancel
	ApplicationShell  export
		Form  exportform
			Label  title
			Label  label
			Command  type
			Label  latex
			Label  stylelabel
			Command  style
			Label  fontlabel
			Command  font
			Label  structlabel
			Command  struct
			Label  esclabel
			Command  escape
			Label  phlabel
			Command  placeholder
			Dialog  output
				Label  label
				Text  value
			Label  status
			Command  doit
			Command  close

.SH FILES
.LP
DBDIR/.lincksrc		Database Configuration File."
.SH ENVIRONMENT
.TP
.B \fILINCKSDBDIR\fR
specifies the default LINCKS database directory.
.SH SEE ALSO
cutoff(1), dbdump(1), dbroot(1), dbs(1), dbstat(1), lincks(1),
monitor(l), netserv(l), t2lincks(1)
.SH DIAGNOSTICS
.LP
If the machine beeps at you, you've tried to do something that can't be
done.  Look at the trace output for more information.
.LP
Periodically, an informational window will pop up.  We hope that the
messages are self-explanatory.
.LP
The trace output in the window where you started \fIxlincks\fR is
sometimes cryptic, but this is because it is not really intended for the
user.  While you could simply send it to /dev/null, we recommend that
you keep it available should you for some reason not understand some
behavior that could be clarified by looking at the output.
.SH BUGS
Please report all bugs to lincks-bugs@ida.liu.se.  We will do our best
to answer queries promptly.  Patches will be release periodically to
fix known problems.  Please include a description of how you can
reproduce the bug and the output of either `dbx xlincks core' or `gdb
xlincks core' if possible.
.SH COPYRIGHT
Copyright (C) 1993, 1994 Lin Padgham, Ralph Ronnquist
.LP
The collective LINCKS programs are free software; you can redistribute 
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation, version 2.
.LP
The collective LINCKS programs are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along
with the LINCKS system; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recently released version of the LINCKS system is always 
available for anonymous ftp from ftp.ida.liu.se (130.236.30.131) in
the directory pub/lincks.
