/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	misc.c
 *
 * SCCSINFO:		@(#)misc.c	1.11 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Ralph & David 1993-05-27
 *
 * DESCRIPTION:
 *
 *	Various library functions that we wanted to have ourselves for
 *		some reason.
 * 
 * MODIFICATIONS:
 *	<list mods with name and date>
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_misc.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#ifndef HAVE_FLOCK /* also defined in includes/config.h */
#define read_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_RDLCK, off, where, len)
#define readw_lock( fd, off, where, len) \
  LockReg( fd, F_SETLKW, F_RDLCK, off, where, len)
#define write_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_WRLCK, off, where, len)  
#define writew_lock( fd, off, where, len) \
  LockReg( fd, F_SETLKW, F_WRLCK, off, where, len)  
#define un_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_UNLCK, off, where, len)
#endif /* n HAVE_FLOCK */


/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: char *strdup( STRDUP_CONST char *input );
 * 
 * mallocs and copies the input and returns a pointer to the copy.  this
 * is just a little safer since it checks for null input.
 * 
 * Modifications:
 *      <list mods with name and date>
 */
char *strdup(input)
STRDUP_CONST char *input;
{
  char *output = NULL;

  if (input == NULL)
    return NULL;

  if ((output = malloc((ALLOC_T)strlen(input) + 1)) == NULL)
    return NULL;

  return strcpy(output,input);
}
/*  */
/**********************************************************************
 * Function: RETSIGTYPE (*Signal( int signo, RETSIGTYPE (*func) ())) ();
 * 
 * Implements a reliable signal based on either on either sigaction
 * or signal (on suns!).
 * 
 * Modifications:
 *      <list mods with name and date>
 */
RETSIGTYPE (*Signal(signo, func)) ()
int signo;
RETSIGTYPE (*func)();
{
  return(SignalR( signo, func, 1));
}

/*  */
/**********************************************************************
 * Function: RETSIGTYPE (*SignalR( int signo, RETSIGTYPE (*func) ()), int restart) ();
 * 
 * Implements a reliable signal based on either on either sigaction
 * or signal (on suns!).
 * 
 * Modifications:
 *      <list mods with name and date>
 */
RETSIGTYPE (*SignalR( signo, func, restart)) ()
int signo;
RETSIGTYPE (*func)();
int restart;
{
#ifdef HAVE_SIGACTION
  struct sigaction act;
  struct sigaction old_act;

  act.sa_handler = func;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if ( signo == SIGALRM ) {
#ifdef SA_INTERRUPT
    /* interrupt system call for alarm under sun os */
    act.sa_flags |= SA_INTERRUPT;
#endif /* SA_INTERRUPT */
  }
  else {
    if (restart)
#ifdef SA_RESTART
      act.sa_flags |= SA_RESTART;
#else
      act.sa_flags = 0;
#endif /* SA_RESTART */
    else
#ifdef SA_INTERRUPT
      /* interrupt system call for alarm under sun os */
      act.sa_flags |= SA_INTERRUPT;
#else
      act.sa_flags = 0;
#endif /* SA_INTERRUPT */
  }
  if (sigaction(signo, &act, &old_act) < 0)
    return(SIG_ERR);
  else
    return(old_act.sa_handler);
#else
  return (signal(signo,func));
#endif  /* n HAVE_SIGACTION */
}

/*  */
#ifndef HAVE_FLOCK
/**********************************************************************
 * Function: int LockReg( ... )
 *
 * Unlocks/Locks (type) a region (where : offset + len ) of a file (fd) 
 * used by the macros/function below. Also available on Sun
 *
 * 1993-07-29 Martin Sjolin.
 *            Created.
 *
 */
int LockReg( fd, cmd, type, offset, where, len )
int fd, cmd, type, where;
off_t offset, len;
{
  struct flock lock;

  lock.l_type   = type;		/* F_RDLCK, F_WRLCK or F_UNLCK */
  lock.l_start  = offset;	/* byte offset relative to where */
  lock.l_whence = where;	/* SEEK_SET, SEEK_CUR, SEEK_END */
  lock.l_len    = len;		/* length of lock, 0 => to EOF */
#ifdef DEBUG
  lock.l_pid    = getpid();
#endif
  return( fcntl( fd, cmd, &lock) );
}
#endif /* n HAVE_FLOCK */

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: int readlockit(int fd, off_t pos, off_t size)
 *
 * Modifications:
 *      <list mods with name and date>
 */
int readlockit(fd, pos, size)
  int fd;
  off_t pos;
  off_t size;
{
#ifndef NO_LOCKS
#ifdef HAVE_FLOCK
  if (flock(fd, LOCK_SH) < 0)
#else
  if( readw_lock( fd, pos, L_SET, size) == -1)
#endif /* n HAVE_FLOCK  */
    return -1;
#endif	/* n NO_LOCKS */
  return 1;
}

/*  */
/**********************************************************************
 * Function: int writelockit(int fd)
 *
 * Modifications:
 *      <list mods with name and date>
 */
int writelockit(fd)
  int fd;
{
#ifndef NO_LOCKS
#ifdef HAVE_FLOCK
  if (flock(fd, LOCK_EX) < 0)
#else
  /* lock from  current end to whatever */
  if( writew_lock( fd, 0L, L_XTND, 0L) == -1)
#endif /* HAVE_FLOCK */
    return -1;
#endif	/* n NO_LOCKS */
  return 1;
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: void unlockit(int fd, off_t pos, off_t size)
 *
 * Modifications:
 *      <list mods with name and date>
 */
void unlockit(fd, pos, size)
  int fd;
  off_t pos;
  off_t size;
{
#ifdef NO_LOCKS
  return;
#endif	/* n NO_LOCKS */

#ifdef HAVE_FLOCK
    (void)flock(fd, LOCK_UN);
#else
    (void)un_lock( fd, pos, L_SET, size);
#endif /* HAVE_FLOCK */
}
