/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	links.c
 *
 * SCCSINFO:		@(#)links.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???, 10 May, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains the global functions FreeLinks, AddLink,
 *	and DelLink.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "dbserver.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_links.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void FreeLinks(LINKGROUP *lg)
 *
 * Disposes of the entire link structure rooted in lg.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void FreeLinks(lg)
  LINKGROUP *lg;
{
  LINKGROUP *p;
  LINKS *fp, *fpx;
  LINKITEM *ip, *ipx;

  for (p = lg; p != (LINKGROUP *) NULL; p = lg) {
    lg = p->nextgroup;
    free(p->name);
    for (fp = p->links; fp != (LINKS *) NULL; fp = fpx) {
      fpx = fp->nextlinks;
      free(fp->tag);
      for (ip = fp->linkitem; ip != (LINKITEM *) NULL; ip = ipx) {
	ipx = ip->nextitem;
	free((FREEPTR *)ip);
      }
      free((FREEPTR *)fp);
    }
    free((FREEPTR *)p);
  }
}


/*  */
/**********************************************************************
 * Function: LINKGROUP *DelLink(FIVE PARAMETERS)
 * Parameters:
 *	LINKGROUP *linkroot
 *	char *name
 *	char *tag
 *	LABEL vs
 *	LABEL label
 *
 * Deletes a link from the link structure root
 * Modifications:
 *      <list mods with name and date>
 */
LINKGROUP *DelLink(linkroot, name, tag, vs, label)
  LINKGROUP *linkroot;
  char *name;
  char *tag;
  LABEL vs;
  LABEL label;
{
  LINKGROUP *lg, *lgp;
  LINKS *lf, *lfp;
  LINKITEM *li, *lip;

  lg = lgp = (LINKGROUP *) NULL;
  lf = lfp = (LINKS *) NULL;
  li = lip = (LINKITEM *) NULL;

  for (lg = linkroot; lg != (LINKGROUP *) NULL; lg = lg->nextgroup) {
    if (strcmp(lg->name, name) == 0)
      break;
    lgp = lg;
  }

  if (lg != (LINKGROUP *) NULL) {
    for (lf = lg->links; lf != (LINKS *) NULL; lf = lf->nextlinks) {
      if (strcmp(lf->tag, tag) == 0)
	break;
      lfp = lf;
    }
  }
  if (lf != (LINKS *) NULL) {
    for (li = lf->linkitem; li != (LINKITEM *) NULL; li = li->nextitem) {
      if ((li->vs == vs) && (li->label != label))
	break;
      lip = lip;
    }
  }
  if (li == (LINKITEM *) NULL)
    return (linkroot);

  if (lip == (LINKITEM *) NULL)
    lf->linkitem = li->nextitem;
  else
    lip->nextitem = li->nextitem;
  free((FREEPTR *)li);

  if (lf->linkitem == (LINKITEM *) NULL) {
    if (lfp == (LINKS *) NULL)
      lg->links = lf->nextlinks;
    else
      lfp->nextlinks = lf->nextlinks;
    free(lf->tag);
    free((FREEPTR *)lf);
  }
  if (lg->links == (LINKS *) NULL) {
    if (lgp == (LINKGROUP *) NULL)
      linkroot = lg->nextgroup;
    else
      lgp->nextgroup = lg->nextgroup;
    free(lg->name);
    free((FREEPTR *)lg);
  }
  return (linkroot);
}


/*  */
/**********************************************************************
 * Function: LINKGROUP *AddLink(FIVE PARAMETERS)
 * Parameters:
 *	LINKGROUP *linkroot
 *	char *name
 *	char *tag
 *	LABEL vs
 *	LABEL label
 *
 * Adds a link to the link structure linkroot.
 *
 * Modifications:
 *      <list mods with name and date>
 */
LINKGROUP *AddLink(linkroot, name, tag, vs, label)
  LINKGROUP *linkroot;
  char *name;
  char *tag;
  LABEL vs;
  LABEL label;
{
  LINKGROUP *lg = (LINKGROUP *) NULL;
  LINKS *lf = (LINKS *) NULL;
  LINKITEM *li = (LINKITEM *) NULL;

  for (lg = linkroot; lg != (LINKGROUP *) NULL; lg = lg->nextgroup) {
    if (strcmp(lg->name, name) == 0)
      break;
  }

  if (lg != (LINKGROUP *) NULL) {
    for (lf = lg->links; lf != (LINKS *) NULL; lf = lf->nextlinks) {
      if (strcmp(lf->tag, tag) == 0)
	break;
    }
  }
  if (lf != (LINKS *) NULL) {
    for (li = lf->linkitem; li != (LINKITEM *) NULL; li = li->nextitem) {
      if ((li->vs == vs) && (li->label != label))
	break;
    }
  }
  if (li != (LINKITEM *) NULL)
    return (linkroot);

  li = (LINKITEM *) malloc(sizeof(LINKITEM));
  li->vs = vs;
  li->label = label;
  li->nextitem = (LINKITEM *) NULL;

  if (lf == (LINKS *) NULL) {
    lf = (LINKS *) malloc(sizeof(LINKS));
    lf->tag = (char *)malloc((ALLOC_T)strlen(tag) + 1);
    (void)strcpy(lf->tag, tag);
    lf->nextlinks = (LINKS *) NULL;
  } else {
    li->nextitem = lf->linkitem;
  }
  lf->linkitem = li;

  if (lg == (LINKGROUP *) NULL) {
    lg = (LINKGROUP *) malloc(sizeof(LINKGROUP));
    lg->name = (char *)malloc((ALLOC_T)strlen(name) + 1);
    (void)strcpy(lg->name, name);
    lg->nextgroup = linkroot;
  } else {
    lf->nextlinks = lg->links;
  }
  lg->links = lf;
  return (lg);
}
