/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   MODULE:	autostart.c
 *
 *   SCCSINFO:	@(#)autostart.c	1.11 6/6/94
 *
 *   AUTHOR:	Ralph R|nnquist, long time ago.
 *
 *   DESCRIPTION:
 *	Low-level liblincks routine to establish a conenction between
 *	a workspace (application) and database server.
 *
 *   MODIFIED:
 *      1994-04-30 Martin Sj|lin. Using the tcp.c module for connecting etc
 *	< add modifications here with name and date >
 *
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 * int LL_FindMonitorHost(char *host,int *sock);
 */

/**********************************************************************
 * INCLUDES
 **********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <sys/socket.h>
#ifdef  HAVE_USLEEP			/* included in config.h ifndef */
#include <sys/time.h>
#endif /* n HAVE_USLEEP */
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <rpc/types.h>			/* broken include files */
#include <rpc/xdr.h>

#include "lincks.h"
#include "xconfig.h"

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif /* n __STDC__ */

/**********************************************************************
 * EXTERNALLY-AVAILABLE DATA FOUND IN THIS MODULE:
 **********************************************************************/
/* none */

/**********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 **********************************************************************/
#include "f_linckshandler.h"
#include "f_logws.h"
#include "f_rpc.h"
#include "f_tcp.h"

/**********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 **********************************************************************/
extern int LL_uid;
extern char *sys_errlist[];
extern int sys_nerr;
extern int errno;

/**********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 **********************************************************************/
static void local_error P_((char *format, ...));

/**********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 **********************************************************************/
#define LOG_ERRSTRING	sys_errlist[(errno >= sys_nerr) ? 0 : errno]
#define LOG_MESS(b)	LogMess(LL_uid,"%s, %s",b,LOG_ERRSTRING)
#define LOGIN_ERR \
"Couldn't connect to server. Server not running or server host not reachable."

/**********************************************************************
 * INTERNAL (STATIC) DATA:
 **********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: static void local_error(char *format, ...)
 *
 * error routine used for tcp_server ...
 *
 * Modifications:
 *      <list mods with name and date>
 */
#ifdef __STDC__
static void local_error(char *format, ...)
#else
static void local_error(va_alist)
  va_dcl
#endif /* n __STDC__ */
{
  va_list ap;
#ifndef __STDC__
  char *format;
  va_start(ap);
  format = va_arg(ap, char *);
#else
  va_start(ap,format);
#endif
  LogMess(LL_uid, format, ap);
  va_end(ap);
}

/*  */
/************************************************************************
 * Function: int LL_FindMonitorHost(char *host, int *sock)
 *
 * Establishes socket connection to a monitor for the present database.
 *
 * Modifications:
 *	<list mods here with name and date>
 *
 */
int LL_FindMonitorHost(host, sock)
  char *host;
  int *sock;
{ 
  struct hostent *hp;
  static struct linger lingertime = { 1, 60 }; /* 60 second linger time */
  static int opt = 1;
  static t_u32bits addr = 0;

  /* Use HOST from run-time configuration.  */
  (void)strcpy(host, HOST);

  if (tcp_lookup(host, &addr, &hp) != SUCCESS) {
    LOG_MESS(LOGIN_ERR);
    return FAIL;
  }

  /* Tickle the monitor process to check its existence.  */
  if (hp) 
   if (tickle_rpc(host, ((u_long)MONITORPROGNO),((u_long)TCPIPNO))!=SUCCESS) {
      (void)fprintf(stderr,"\nNo monitor for %s on %s!\n",DBDIR,HOST);
      return FAIL;
    }

  /* Create a socket for communication and export socket handle.  */
  if ((*sock = tcp_connect(local_error, host, TCPIPNO)) < 0)
    return FAIL;

  /* 
   * just in the case the server closes the connection really fast,
   * enable linger with a 60 second options on timeout.
   */
  if (setsockopt(*sock, SOL_SOCKET, SO_LINGER, 
		 (char *)&lingertime, sizeof(lingertime))< 0) {
    LOG_MESS("workspace: Set SO_LINGER failed");
    return FAIL;
  }
  /*
   * Set socket options to avoid transfer delays. This forces every
   * transfer packet to be available as soon as it comes rather than
   * having the network to wait 100ms for additional bytes.
   */
  if (setsockopt(*sock, IPPROTO_TCP, TCP_NODELAY,
		 (char *)&opt, sizeof(opt)) < 0) {
    LOG_MESS("workspace: Warning - TCP_NODELAY not supported.\n");
  }

  if (InitSignals(*sock) == FAIL) {
    LOG_MESS("InitSignals failed");
  }
  return SUCCESS;
}
