/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:		ltextsrc.h
 *
 * SCCSINFO:		@(#)ltextsrc.h	1.4 6/6/94
 *
 * ORIGINAL AUTHOR(S):	
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	Header file for XlTextSrc Widget
 */
#ifndef _XlTextSrc_h
#define _XlTextSrc_h

#include <X11/Xaw/TextSrc.h>

/****************************************************************
 * Lincks Text Source widget
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/*
 * Resource Definitions.
 */

#define XtCDataCompression "DataCompression"
#define XtCPieceSize "PieceSize"

#define XtNdataCompression "dataCompression"
#define XtNpieceSize "pieceSize"

/* Class record constants */

extern WidgetClass XltextSrcObjectClass;

typedef struct _XlTextSrcClassRec *XlTextSrcObjectClass;
typedef struct _XlTextSrcRec      *XlTextSrcObject;

#if 0
/* we don't seem to use any of these public routines any longer */
/************************************************************
 * Public routines 
 ************************************************************/

/*	Function Name: XawAsciiSourceFreeString
 *	Description: Frees the string returned by a get values call
 *                   on the string when the source is of type string.
 *	Arguments: w - the XlTextSrc object.
 *	Returns: none.
 */

void XlTextSourceFreeString(/* w */);
/*
Widget w;
*/

/*	Function Name: XlTextSave
 *	Description: Saves all the pieces into a file or string as required.
 *	Arguments: w - the asciiSrc Object.
 *	Returns: TRUE if the save was successful.
 */

XtBoolean XlTextSave(/* w */);
/*
Widget w;
*/

/*	Function Name: XlTextSaveAsObject
 *	Description: Save the current buffer as a NODE object
 *	Arguments: w - the XlTextSrc object.
 *                 name - name of the file to save this file into.
 *	Returns: True if the save was sucessful.
 */

XtBoolean XlTextSaveAsObject(/* w, name */);
/*
Widget w;
String name;
*/

/*	Function Name: XlTextSourceChanged
 *	Description: Returns true if the source has changed since last saved.
 *	Arguments: w - the XlText Source object.
 *	Returns: a Boolean (see description).
 */

XtBoolean XlTextSourceChanged(/* w */);
/*
Widget w;
*/
#endif

typedef struct _XlTextSrcClassRec*	XlTextSrcWidgetClass;
typedef struct _XlTextSrcRec*		XlTextSrcWidget;

/* declare the class constant */

extern WidgetClass XltextsrcWidgetClass;

#endif /* _Template_h */
