/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextjustify.c
 *
 * SCCSINFO:		@(#)ltextjustify.c	1.4 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with text fill and
 *	justify.
 *
 **********************************************************************/
#include "config.h"	/* includes system dependent includes */

/**********************************************************************
 * FUNCTIONS DEFINED IN THIS FILE:
 * static void AutoFill(TextWidget ctx)
 * static XawTextPosition StripOutOldCRs(THREE PARAMETERS)
 * static void InsertNewCRs(TextWidget ctx, XawTextPosition from, to)
 * static void FormRegion(TextWidget ctx,XawTextPosition from, to)
 * static void FormParagraph(FOUR PARAMETERS)
 */

/*  */
/**********************************************************************
 * Function: static void AutoFill(TextWidget ctx)
 * 
 * Breaks the line at the previous word boundry when called 
 * inside InsertChar.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void AutoFill(ctx)
  TextWidget ctx;
{
  int width, height, x, line_num, max_width;
  XawTextPosition ret_pos;
  XawTextBlock text;

  if ( !((ctx->text.auto_fill) && (Mult == 1)) )
    return;

  for ( line_num = 0; line_num < Lines ; line_num++)
    if ( Info[line_num].position >= Point )
      break;
  line_num--;			/* backup a line. */

  max_width = Max(0, (int)(ctx->core.width - HMargins(ctx)));

  x = (int) LeftMargin;
  FindPos(Sink,Info[line_num].position, x, max_width,
	  TRUE, &ret_pos, &width, &height);
  
  if ( ret_pos >= Point )
    return;
  
  text.ptr = "\n";
  text.length = 1;
  text.firstPos = 0;
  text.format = FMT8BIT;

  (void)_XawTextReplace((TextWidget)ctx, ret_pos - 1, ret_pos, &text);
}


/*  */
/**********************************************************************
 * Function: static XawTextPosition StripOutOldCRs(THREE PARAMETERS)
 * Parameters:
 *	TextWidget ctx		- the text widget
 *	XawTextPosition from	- starting point
 *	XawTextPosition to 	- the ending point
 * 
 * Strips out the old carrige returns.
 *
 * Returns: the new ending location (we may add some caracters).
 *
 * Modifications:
 *      <list mods with name and date>
 */
static XawTextPosition StripOutOldCRs(ctx, from, to)
  TextWidget ctx;
  XawTextPosition from, to;
{
  XawTextPosition startPos, endPos, eop_begin, eop_end, temp;
  Widget src = Source;
  XawTextBlock text;
  char *buf;

  text.ptr= "  ";
  text.firstPos = 0;
  text.format = FMT8BIT;
   
/*
 * Strip out CR's. 
 */

  eop_begin = eop_end = startPos = endPos = from;
  while (TRUE) {
    endPos=SrcScan(src, startPos, XawstEOL, XawsdRight, 1, FALSE);

    temp=SrcScan(src, endPos, XawstWhiteSpace, XawsdLeft, 1, FALSE);
    temp=SrcScan(src, temp, XawstWhiteSpace, XawsdRight, 1, FALSE);

    if (temp > startPos) endPos = temp;
    if (endPos >= to) break;

    if (endPos >= eop_begin) {
      startPos = eop_end;
      eop_begin = SrcScan(src, startPos, XawstParagraph, XawsdRight, 1, FALSE);
      eop_end = SrcScan(src, startPos, XawstParagraph, XawsdRight, 1, TRUE);
    } else {
      XawTextPosition periodPos, next_word;
      int i, len;

      periodPos= SrcScan(src, endPos, XawstPositions, XawsdLeft, 1, TRUE);
      next_word = SrcScan(src, endPos, XawstWhiteSpace, XawsdRight, 1, FALSE);

      len = next_word - periodPos;

      text.length = 1;
      buf = _XawTextGetText((TextWidget)ctx, periodPos, next_word);

      if ( (periodPos < endPos) && (buf[0] == '.') ) text.length++;

      /*
       * Remove all extra spaces. 
       */

      for (i = 1 ; i < len; i++) 
	  if ( !isspace(buf[i]) || ((periodPos + i) >= to) ) break;
      
      XtFree((char *)buf);

      to -= (i - text.length - 1);
      startPos = SrcScan(src, periodPos, XawstPositions, XawsdRight, i, TRUE);
      (void)_XawTextReplace((TextWidget)ctx, endPos, startPos, &text);
      startPos -= i - text.length;
    }
  }
  return(to);
}


/*  */
/**********************************************************************
 * Function: static void InsertNewCRs(TextWidget ctx, XawTextPosition from, to)
 * 
 *	Inserts the new Carrige Returns.
 *	Arguments: ctx - the text widget.
 *                 from, to - the ends of the region.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertNewCRs(ctx, from, to)
  TextWidget ctx;
  XawTextPosition from, to;
{
  XawTextPosition startPos, endPos, space, eol;
  XawTextBlock text;
  int i, width, height, len;
  char * buf;

  text.ptr = "\n";
  text.length = 1;
  text.firstPos = 0;
  text.format = FMT8BIT;

  startPos = from;
  while (TRUE) {
    FindPos(Sink, startPos, LeftMargin, (int)(ctx->core.width - HMargins(ctx)), 
	    TRUE, &eol, &width, &height);
    if (eol >= to) break;

    eol = SrcScan(Source, eol, XawstPositions, XawsdLeft, 1, TRUE);
    space = SrcScan(Source, eol, XawstWhiteSpace, XawsdRight, 1,TRUE);
    
    startPos = endPos = eol;
    if (eol == space) return;

    len = (int) (space - eol);
    buf = _XawTextGetText((TextWidget)ctx, eol, space);
    for ( i = 0 ; i < len ; i++)
      if (!isspace(buf[i])) break;

    to -= (i - 1);
    endPos = SrcScan(Source, endPos, XawstPositions, XawsdRight, i, TRUE);
    XtFree((char *)buf);
    
    (void)_XawTextReplace((TextWidget)ctx, startPos, endPos, &text);
    startPos = SrcScan(Source,startPos,XawstPositions,XawsdRight,1,TRUE);
  }
}  


/*  */
/**********************************************************************
 * Function: static void FormRegion(TextWidget ctx,XawTextPosition from, to)
 * 
 *	Description: Forms up the region specified.
 *	Arguments: ctx - the text widget.
 *                 from, to - the ends of the region.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void FormRegion(ctx, from, to)
  TextWidget ctx;
  XawTextPosition from, to;
{
  if (from >= to) return;

  to = StripOutOldCRs(ctx, from, to);
  InsertNewCRs(ctx, from, to);
  _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void FormParagraph(FOUR PARAMETERS)
 * Parameters:
 *	Widget w		- the text widget
 *	XEvent *event		- the X event
 *	String * params		- not used
 *	Cardinal *num_params	- not used
 * 
 * Reforms up the current paragraph.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void FormParagraph(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String * params;
  Cardinal * num_params;
{
  TextWidget ctx = (TextWidget) w;
  XawTextPosition from, to;

  StartAction(ctx, event);

  from =  SrcScan(Source, Point, XawstParagraph, XawsdLeft, 1, FALSE);
  to  =  SrcScan(Source, from, XawstParagraph, XawsdRight, 1, FALSE);

  FormRegion(ctx, from, to);

  EndAction(ctx);
}
