/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	layoutP.h
 *
 * SCCSINFO:		@(#)layoutP.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Nilgun & Michael, 1990-09-11
 *
 * MODIFICATIONS:
 *	< list mods with name and date >
 *
 * DESCRIPTION:
 *
 * Lincks XlLayout Widget
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#ifndef _XlLayoutP_h
#define _XlLayoutP_h

#include <X11/Xaw/FormP.h>
#include <X11/ConstrainP.h>

#include "layout.h"

typedef struct {
    int empty;			/* put in here methods */
} XlLayoutClassPart;

typedef struct _XlLayoutClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    XlLayoutClassPart   layout_class;
} XlLayoutClassRec;

extern XlLayoutClassRec XllayoutClassRec;

#define XtRLayoutResource "XlLayoutResource"

typedef struct _XlLayoutPart {
    /* resources */
    XlLayoutType type;  	/* One of vertical, optimal or horizontal */

    /* private state follows */

    struct { /* Goal column details */
      int x;	/* The goal pixel column for up/down movement */
      int flag; /* Whether to bother setting goal column */
    } goal_column;

    struct { /* Focussing details */
      Widget widget;	/* Child widget that has focus. */
      int y;		/* Expected focussing row */
    } focus;

    struct { /* Incremental search details */
      char *text;	/* Current text to search. */
      char *old_text;	/* Last text to search. */
      int flag;		/* -1/0/1 for backward/no/forward in progress */
      int wrap;		/* Whether to wrap around at next search */
      int match;	/* Length of last match. */
    } search;

} XlLayoutPart;

typedef struct _XlLayoutRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    XlLayoutPart	layout;
} XlLayoutRec;

typedef struct _XlLayoutConstraintsPart {
  int empty;
} XlLayoutConstraintsPart;

typedef struct _XlLayoutConstraintsRec {
  FormConstraintsPart	    form;
  XlLayoutConstraintsPart  layout_form;
} XlLayoutConstraintsRec, *XlLayoutConstraints;

#endif /* _XlLayoutP_h */
