/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         dbcodes.h
 *
 * SCCSINFO:            @(#)dbcodes.h	1.3 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ????
 *
 * MODIFICATIONS:
 *      1993-08-26 Martin Sjlin. Added definition of RCOOB
 *            for information sent after OOB. This information should
 *            be silently discarded in lowcom.c:LL_ReceiveStatus.
 *      1994-01-06 Martin Sjlin. Added definition of DISCONNECT_CODE
 *            and RECONNECT_CODE as preparation for disconnected WS.
 *      < add modifications with name and date >
 *
 * DESCRIPTION:
 *  This file contains the communication codes exchanged between
 *  the dbms programs
 */

#ifndef DBCODES_H
#define DBCODES_H

/* Status codes from data base */
#define RCNYI     1   /* Unimplemented command. */
#define RCOK      2   /* Positive acknwoledge. */
#define RCLOGO    3   /* Close connection. */
#define RCBAD     4   /* Bad operation. */
#define RCUUP     5   /* Unable to unpack packet. */
#define RCERROR   6   /* Error # and error string follows. */
#define RCMOL     7   /* Here comes a molecule. */
#define RCBUFFER  8   /* Buffer molecule (not sent). */
#define RCMESSAGE 9   /* Here comes a pen message. */
#define RCOOB     10  /* Before this was a OOB */

/* Command codes to data base */
#define ALIVE_CODE	1
#define LOGO_CODE	2
#define EDIT_CODE	3
#define STORE_CODE	4
#define RETRIEVE_CODE	5
#define RELEASE_CODE	6
#define QUERY_CODE	7
#define MESSAGE_CODE	8
#define DISCONNECT_CODE 9
#define RECONNECT_CODE  10
#define MAX_DB_CODE    (RECONNECT_CODE)  /* Must be last <>_CODE! */
/*
 * The ALIVE_CODE is used for a workspace to "tickle" the database to
 * see that it is responding.
 * The LOGO_CODE is sent by the workspace at logout.
 * The EDIT_CODE is sent by the workspace to indicate that a new version
 * is created for an object.
 * The STORE_CODE is used when a node is stored.
 * The RETRIEVE_CODE is used when a workspace wants to retrieve a node.
 * The RELEASE_CODE is sent by the RELEASEOBJ function, to indicate to
 * the database that the workspace has released its memory previously
 * allocated for an object.
 * The QUERY_CODE is reserved for future query language processing at
 * the database side.
 * The MESSAGE_CODE is used when a workspace wants to get a pen message
 * (subsequent to an OOB signal).
 * The DISCONNECT_CODE is sent before disconnecting a WS, to enable storing
 * interface table on a file/DB.
 * The RECONNECT_CODE is sent when reconnecting a WS, to signal a read
 * in of a interface table from file/DB.
 */

/* Socket definitions */
#define SPECBYTE 0xA5		/* Attention code from LINSRV */
#define TIME_OUT_LIMIT 36000	/* # of seconds before time out */


#define OOB_MESSAGE_CODE 0x1		/* pen message */
#define PEN_RESOLVE	 0		/* Resolve version node async. */
#define PEN_CHECK	 1		/* Node being edited by other user */
#define PEN_POLL	 2		/* User began editing in parallel */

/* Molecule Type Constants */
#define UNKNOWN_TYPE	0
#define OTHER		1
#define VSH		2
#define VS		3
#define VSE		4
#define VSS		5
/*
 * UNKNOWN_TYPE marks a node whose type is "unknown". This is used at
 * retrieve requests from sysfuns.
 * OTHER marks  that a node is a version node ("user's data").
 * VSH marks hidden history node (no PEN).
 * VS marks history node (PEN).
 * VSE marks history node at pre-edit.
 * VSS marks history node a final store.
 */

#endif	/* DBCODES_H */
