/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	monhandler.c
 *
 * SCCSINFO:		@(#)monhandler.c	1.9 6/6/94
 *
 * ORIGINAL AUTHOR(S):  ???, 3 Mar, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 * This file contains the signal catcher Handler
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <sys/wait.h>
#ifdef  HAVE_USLEEP			/* included in config.h ifndef */
#include <sys/time.h>
#endif /* n HAVE_USLEEP */
#ifdef HAVE_GETDTABLESIZE		/* included in config.h ifndef */
#include <sys/resource.h>
#endif /* HAVE_GETDTABLESIZE */

#include "lincks.h"
#include "monitor.h"
#include "libshared.h"
#include "xconfig.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_monhandler.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_misc.h"
#include "f_monerrors.h"

/* libc */
#if defined(sun) || defined(__sun__)
extern time_t time P_((time_t *tloc));
#endif
/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern int errno;		/* errno.h */
extern UID uidcom;		/* monitormain.c */
extern int debug;		/* monitormain.c */
extern pid_t childpid;		/* monitormain.c */
extern int currentmolfd;	/* monitormain.c */
extern int currentdatafd;	/* monitormain.c */
extern int indexfd;		/* monitormain.c */
extern char host[];		/* monitormain.c */
extern char lockfile[];		/* monitormain.c */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: RETSIGTYPE Handler(int sig, int code, struct sigcontext *scp)
 * 
 * Takes care of system signals and performs appropriate
 * actions on them
 *
 * Modifications:
 *      <list mods with name and date>
 */
RETSIGTYPE Handler(sig)
  int sig;
{
    int savederrno = errno;
    static time_t deathtime = 0;
    int status = 0;
    char netservfn[MAXPATHLEN];

    /* Create path to Net server */
    (void)sprintf(netservfn, "%s/%s", BINARIES, NETSERVER);

    switch (sig) {
      case SIGALRM:		/* alarm clock */
        if ( unlink(lockfile) < 0)
	  Error(0, "Handler: Failed to unlink lockfile %s", lockfile);
	errno = 0;
	Error(0, "System halted.");
	exit(0);
	break;

      case SIGCHLD:		/* child status has changed */
#ifdef HAVE_WAITPID
        if (waitpid(0,&status, WNOHANG))
#else
        if (wait3(&status, WNOHANG, (struct rusage *)NULL))
#endif
        {
	    char ex[16], sig[32];

#if defined(WIFEXITED) && defined(WEXITSTATUS)
	    if ( WIFEXITED(status))
	      (void)sprintf(ex,", exit status %d",WEXITSTATUS(status));
	    else
	      ex[0] = '\0';
#else
	    (void)sprintf(ex, ", exit status %d", status);
#endif /* n WIFEXITED */
#if defined(WIFSIGNALED) && defined(WTERMSIG)
	    if( WIFSIGNALED(status) )
	      (void) sprintf(sig, ", signal %d", WTERMSIG(status));
	    else
	      sig[0] = '\0';
#else
	    (void)strcpy( sig, ", cannot determine signal");
#endif /* n WIFSIGNALED */

	    errno = 0;
            Error(0, "netserv died%s%s%s", ex, sig,
#if defined(WIFSIGNALED) && defined(WCOREDUMP)
                   (WIFSIGNALED(status) && WCOREDUMP(status))
                   ? " - core dumped." :
                   "."
#else
		  status != 0 ? ", cannot determine if core dumped." : "."
#endif /* n WIFSIGNALED */
	          );

	    /* Check if there is any use in starting a new server */ 
            if (time((time_t *)NULL) - deathtime < CHILDMINTIME) {
		Error(ER_SYSERR, "Handler: could not restart netserv");
	    } else {
	      deathtime = time((time_t *)NULL);

	      /* Start Net Server process */
	      if ((childpid = fork()) == 0) {
		(void)Signal(SIGHUP, SIG_DFL);
		(void)close(indexfd);
		(void)close(currentdatafd);
		(void)close(currentmolfd);

		/* Start net server */
		Error(0, "netserv restarting...");
		if (debug) {
		  if((execl(netservfn, NETSERVER, "-d", 
			    "-h", host, DBDIR, (char *)NULL)) == -1) {
		    Error(ER_INIT, "Handler: could not start %s", netservfn);
		  }
		} else {
		  if ((execl(netservfn, NETSERVER, "-h", host, 
			     DBDIR, (char *)NULL)) == -1) {
		    Error(ER_INIT, "Handler: could not start %s", netservfn);
		  }
		}
	      exit(1);
	      } /* fork() == 0 */
	    } /* time - deathtime */
	  }
#ifndef HAVE_RELIABLE_SIGNALS
	if (Signal(SIGCHLD, Handler) == BADSIG) 
	  Error(ER_INIT, "Handler: could not register signal SIGCHLD.");
#endif
	break;


      case SIGUSR1:
	/* Check first if child is dead */
#ifdef HAVE_WAITPID
        if (waitpid(0, &status, WNOHANG) != 0) {
#else
        if (wait3(&status, WNOHANG,(struct rusage *)NULL) != 0) {
#endif
	  /* Set new death time */
	  deathtime = time((time_t *)NULL);

	  /* Start Net Server process */
	  if ((childpid = fork()) == 0) {
	    (void)Signal(SIGHUP, SIG_DFL);
	    (void)close(indexfd);
	    (void)close(currentdatafd);
	    (void)close(currentmolfd);

	    /* Start net server */
	    Error(0, "netserv restarting...");
	    if (debug) {
	      if((execl(netservfn, NETSERVER, "-d", 
			"-h", host, DBDIR, (char *)NULL)) == -1) {
		Error(ER_INIT, "Handler: could not start %s", netservfn);
	      }
	    } else {
	      if ((execl(netservfn, NETSERVER, "-h", host, 
			 DBDIR, (char *)NULL)) == -1) {
		Error(ER_INIT, "Handler: could not start %s", netservfn);
	      }
	    }
	    exit(1);
	  } /* fork() == 0 */
	}
#ifndef HAVE_RELIABLE_SIGNALS
	if (Signal(SIGUSR1, Handler) == BADSIG) 
	  Error(ER_INIT, "Handler: could not register signal SIGCHLD.");
#endif /* HAVE_RELIABLE_SIGNALS */
	break;

#ifdef SIGXFSZ
      case SIGXFSZ:		/* file size limit exceeded */
	Error(ER_SYSERR, "Index file is too large.");

	/* DAVID: and we just continue ... */
#endif /* SIGXFSZ */

      /* Remove any file locks before exiting */
#ifdef SIGLOST
      case SIGLOST:
#endif
      case SIGTERM:
      case SIGHUP:
      case SIGQUIT:
        Error( ER_INIT,
	      "Handler: caught signal %d cleaning up lock file.",
	      sig);

	if ( unlink( lockfile ) < 0 ) 
	  Error(ER_INIT, "Handler: could not remove %s", lockfile);

	/* Kill children and parent .. */
	(void)Signal(SIGCHLD, SIG_IGN);
	(void)Signal(SIGHUP, SIG_IGN);

	/* and kill all of them in the process group */
        (void)kill(0, SIGHUP);

	/* Wait for it netserver to die */
        (void)wait((WAIT_T *)NULL);

#if 0   /* unclear about this - the netserver should wait ? */
#ifdef HAVE_WAITPID
        while (waitpid(0, &status, WNOHANG) > 0) ;
#else
        while (wait3(&status, WNOHANG,(struct rusage *)NULL) > 0) ;
#endif
#endif
	/* Commit suicide */
	exit(2);
	break;

      } /* switch */
    errno = savederrno;
}

