/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	dbsqueue.c
 *
 * SCCSINFO:		@(#)dbsqueue.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  PEN pum group, 1992-05-18
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 * This file contains the definition of the functions which
 * manipulate the DBSQueue structure.
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_dbsqueue.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void Enqueue(DBSQueue *dbsqueuep, pid_t pid, void *infop)
 * 
 * Inserts a pointer at the end of the DBS queue
 * Uses Error
 *
 * Modifications:
 *      <list mods with name and date>
 */
void Enqueue(dbsqueuep, pid, infop)
    DBSQueue *dbsqueuep;
    pid_t pid;
    void *infop;
{
    DBSQueue *newp;

    while (dbsqueuep->nextp != NULL) 
        dbsqueuep = dbsqueuep->nextp;	

    if ((newp = (DBSQueue *) malloc(sizeof(DBSQueue))) == NULL) {
	Error(ER_MALLOC, "Enqueue:");
        return;
    }
    newp->pid = pid;
    newp->infop = infop;
    newp->nextp = dbsqueuep->nextp;
    dbsqueuep->nextp = newp;
}

/*  */
/**********************************************************************
 * Function: void *Dequeue(DBSQueue *dbsqueuep, pid_t pid)
 * 
 * Removes and returns the front pointer in the queue
 * which is associated with the process identity
 *
 * Modifications:
 *      <list mods with name and date>
 */
void *Dequeue(dbsqueuep, pid)
    DBSQueue *dbsqueuep;
    pid_t pid;
{
    DBSQueue *oldp;
    void *infop;
    
    while (dbsqueuep->nextp != NULL) {
        if (dbsqueuep->nextp->pid == pid) {
	    infop = dbsqueuep->nextp->infop;
	    oldp = dbsqueuep->nextp;
	    /* remove oldp from queue */
	    dbsqueuep->nextp = dbsqueuep->nextp->nextp; 
	    free((FREEPTR *)oldp); /* free oldp */
	    return(infop);
	};
	dbsqueuep = dbsqueuep->nextp;
    };
    return(NULL);
}

/*  */
/**********************************************************************
 * Function: void MakeEmpty(DBSQueue *dbsqueuep, pid_t pid)
 * 
 * Makes the queue empty for the process identity
 *
 * Modifications:
 *      <list mods with name and date>
 */
void MakeEmpty(dbsqueuep, pid)
    DBSQueue *dbsqueuep;
    pid_t pid;
{
    DBSQueue *oldp;

    while (dbsqueuep->nextp != NULL) {
        if (dbsqueuep->nextp->pid == pid) {
	    oldp = dbsqueuep->nextp;
	    /* remove oldp from queue */
	    dbsqueuep->nextp = dbsqueuep->nextp->nextp; 
	    free((FREEPTR *)oldp);
	}
	else
	    dbsqueuep = dbsqueuep->nextp;
    };
}
