/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	gobble.c
 *
 * SCCSINFO:		@(#)gobble.c	1.9 6/6/94
 *
 * ORIGINAL AUTHOR(S):  ???, 15 April, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This is a debugging module. It contains the function gobble.
 *      This module is currently not used at all.
 */
#ifndef lint
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "dbserver.h"
#include "libshared.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_gobble.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_dbserfs.h"
#include "f_molfile.h"
#include "f_dbrdmol.h"
#include "f_dbserrors.h"
#include "f_dbserv.h"
#include "f_makelinks.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern IT_ENTRY *InterfaceTable;/* dbserv.c */
extern int ITblsize;		/* dbserv.c */
extern MOLECULE the_molecule;  

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
static MOLECULE *workspace;

/*  */
/**********************************************************************
 * Function: void Gobble()
 *
 * Modifications:
 *      <list mods with name and date>
 */
void Gobble()
{
  long ll;				/* need for scanf of labels */
  WS_LABEL index = IT_SYSTEM_MOLECULE_POSITION;
  LABEL label, vsl, lbl;
  A_ENTRY *access;
  register int ch;
  char name[MAXNAMELEN], tag[MAXNAMELEN];
  MOLECULE *molp;
  PACKEDBUFF *atrbuff, *imagebuff;


attention:
  ch = getchar();

  switch (ch) {
  case 'g':
    break;

  case 'm':
    (void)printf("Enter label or index to read: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL) {
      index = label;
      label = TranslateIndexToLabel(index);
    } else
      index = TranslateLabelToIndex(label);

    /* Get molecule access data */
    if ((access = MolAccess(label, ACCESS)) == NULL) {
      return;
    }
    if (ReadMolecule(access) != SUCCESS) {
      Error(ER_READ, "Gobble: read failed");
    } else {
      molp = &the_molecule;
      (void)printf("Molecule: %ld\n", (long)label);
      (void)printf("BLINKS::\n");
      PrintLinks(molp->blinks);
      (void)printf("FLINKS::\n");
      PrintLinks(molp->flinks);

      (void)printf("ATTR::\n");
      if (molp->attributes)
	(void)printf("%02x %02x %02x %02x\n",
		     *(molp->attributes->buff),
		     *(molp->attributes->buff + 1),
		     *(molp->attributes->buff + 2),
		     *(molp->attributes->buff + 3));
      else
	(void)printf("NULL\n");

      (void)printf("IMAGE::\n");
      if (molp->image)
	(void)printf("%02x %02x %02x %02x\n",
		     *(molp->image->buff),
		     *(molp->image->buff + 1),
		     *(molp->image->buff + 2),
		     *(molp->image->buff + 3));
      else
	(void)printf("NULL\n");
    }
    break;

  case 'w':
    (void)printf("Enter label or index to write: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL) {
      index = label;
      label = TranslateIndexToLabel(index);
    } else
      index = TranslateLabelToIndex(label);

    (void)printf("Molecule: %ld\n", (long) label);
    /* this is seriously brain dead */
    /* if ((workspace = ReadMolecule(label)) == NULL)
	{
	  Error(ER_READ, "Gobble: read failed");
	  break;
	}*/
    if (MakeLinksIndices(workspace->flinks) < 0) {
      Error(ER_IT_NO_SPACE, "Gobble: Could not translate links to indices");
      break;
    }
    (void)printf("Enter <group name> <tag> <vs label> <link label> (or q to quit):\n");
    while (1) {
      (void)scanf("%s", name);
      if (*name == 'q')
	break;
      (void)scanf("%s", tag);
      (void)scanf("%ld", &ll); vsl = ll;
      (void)scanf("%ld", &ll); lbl = ll;
      if ((vsl = TranslateLabelToIndex(vsl)) == IT_NO_SPACE) {
	Error(ER_IT_NO_SPACE, "Gobble: no more interface table space");
	goto attention;
      }
      if ((lbl = TranslateLabelToIndex(lbl)) == IT_NO_SPACE) {
	Error(ER_IT_NO_SPACE, "Gobble: no more interface table space");
	goto attention;
      }
      if ((workspace->flinks = AddLink(workspace->flinks, name, tag, vsl, lbl)) == NULL) {
	Error(ER_READ, "Gobble: could not add link");
	goto attention;
      }
    }

    (void)printf("Enter attributes field or just <CR> to keep old\n");
    atrbuff = (PACKEDBUFF *) malloc(sizeof(PACKEDBUFF));
    atrbuff->buff = (char *)malloc((ALLOC_T)256);
    (void)getchar();
    (void)gets(atrbuff->buff);
    if (strlen(atrbuff->buff)) {
      (void)strcat(atrbuff->buff, "\n");
      atrbuff->size = strlen(atrbuff->buff) + 1;
      workspace->attributes = atrbuff;
    }
    (void)printf("Enter image field or just <CR> to keep old\n");
    imagebuff = (PACKEDBUFF *) malloc(sizeof(PACKEDBUFF));
    imagebuff->buff = (char *)malloc((ALLOC_T)256);
    (void)gets(imagebuff->buff);
    if (strlen(imagebuff->buff)) {
      (void)strcat(imagebuff->buff, "\n");
      imagebuff->size = strlen(imagebuff->buff) + 1;
      workspace->image = imagebuff;
    }
    goto gobble;
    break;

  case 'd':
    (void)printf("Enter label or index: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL)
      index = label;
    else
      index = TranslateLabelToIndex(label);

    (void)Release(index);
    break;

  case 'r':
    (void)printf("Enter label or index: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL)
      index = label;
    else
      index = TranslateLabelToIndex(label);

    (void)Retrieve(index);
    break;

  case 's':
    (void)printf("Enter label or index: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL)
      index = label;
    else
      index = TranslateLabelToIndex(label);

    (void)Store(index, workspace, 1);
    break;

  case 'l':
    (void)printf("Enter label or index to look for: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL)
      index = label;
    else
      index = TranslateLabelToIndex(label);
    break;

  case 'i':
    (void)printf("Enter label or index: ");
    (void)scanf("%ld", &ll); label = ll;
    (void)printf("OK\n");
    if (label < IT_SYSTEM_MOLECULE_LABEL)
      index = label;
    else
      index = TranslateLabelToIndex(label);

    (void)printf(" Old InterfaceTable[%ld].label = %ld |.checknumber = %ld\n",
		 (long)index, (long)InterfaceTable[index].label,
		 (long)InterfaceTable[index].checknumber);
    (void)printf("Enter new label and checknumber: ");
    (void)scanf("%ld %d", &ll, &InterfaceTable[index].checknumber);
    InterfaceTable[index].label = ll;
    (void)printf("OK\n");
    break;

  case 't':
    (void)printf("        0       1       2       3       4       5       6       7       8       9");
    for (index = 0; index < ITblsize; ++index) {
      if ((index % 10) == 0)
	(void)printf("\n%3ld: ", (long)index);
      if (InterfaceTable[index].label == 0)
	(void)printf(" - ");
      else
	(void)printf("%3ld", (long)InterfaceTable[index].label);
      switch (InterfaceTable[index].checknumber) {
      case IT_DELETED:
	(void)printf("  - |");
	break;
      case IT_NOT_SENT:
	(void)printf(" Rel|");
	break;
      default:
	(void)printf(" %3ld|", (long)InterfaceTable[index].checknumber);
	break;
      }
    }
    (void)printf("||\n");
    break;

  case 'x':
  case 'q':
    return;
    break;

  case 'h':
  case '?':
    (void)printf("Commands are:\n");
    (void)printf(" h ?               Type this.\n");
    (void)printf(" x q               Nice exit.\n");
    (void)printf(" g                 Enter debugger.\n");
    (void)printf(" d <label/index>   RELEASE.\n");
    (void)printf(" r <label/index>   RETRIEVE.\n");
    (void)printf(" s <label/index>   STORE.\n");
    (void)printf(" m <label/index>   Print molecule.\n");
    (void)printf(" w <label/index>   Edit molecule.\n");
    (void)printf(" l <label/index>   Find label or index.\n");
    (void)printf(" i <label/index>   Change Interface Table entry.\n");
    (void)printf(" t                 Dump the Interface Table.\n");
    break;

  default:
  gobble:
    (void)printf("     InterfaceTable[%ld].label = %ld |.checknumber = %ld\n",
		 (long)index, (long)InterfaceTable[index].label,
		 (long) InterfaceTable[index].checknumber);
    (void)printf("Gobble: ");
    break;
  }
  goto attention;
}

/*  */
/**********************************************************************
 * Function: void PrintLinks(LINKGROUP *group)
 *
 * Modifications:
 *      <list mods with name and date>
 */
void PrintLinks(group)
  LINKGROUP *group;
{
  LINKS *links;
  LINKITEM *item;

  while (group) {
    (void)printf("%s\n", group->name == NULL ? "" : group->name);
    links = group->links;
    while (links) {
      (void)printf("  %s(", links->tag == NULL ? "" : links->tag);
      item = links->linkitem;
      while (item) {
	(void)printf("%ld:%ld", (long)item->vs, (long) item->label);
	item = item->nextitem;
	if (item)
	  (void)printf(" ");
      }
      (void)printf(")\n");
      links = links->nextlinks;
    }
    group = group->nextgroup;
  }
  return;
}

#endif
