/* 
 *	$Id: osdep.h,v 2.1.0.1 1995/04/11 14:46:40 mummert Exp mummert $
 *
 *	osdep.h
 *	=======
 *
 *	System dependencies for the MultiSound AD/DA-driver 
 *	for Linux and generic SysV386.
 *
 *	Author: Markus Mummert <mum@mmk.e-technik.tu-muenchen.de>
 *	Fragments of text/code picked from Hannu Savolainen's VoxWare.
 *	Points of interest: ->FIXME:
 *
 */

#ifndef _OSDEP_H_
#define _OSDEP_H_

/*
 * General Info on interfacing to OS other than System V386/R3.2
 * =============================================================
 *
 * (Hannu: Sorry, I haven't changed msnd.c to completely using your
 *	   os.h macros. However, it should now be very easy to do so,
 *	   without modifying general stucture of the code. -- Markus)
 *
 * This is what msnd.c offers ....
 * --------------------------
 */
extern void msndinit();		/* initialization of HW during boot */
extern void msndintr();		/* interrupt service routine */
extern void msndopen( /* dev_t dev, int flags */);
extern void msndclose();	
extern void msndread();
extern void msndwrite();
extern void msndioctl( /* dev_t dev, int cmd, char *argp */);

/* And of course: There are all these globals in Space.c 
 *		  describing current driver state and initialization.
 */

/*
 * This is what msnd.c requires ....
 * ----------------------------
 */
#if 0 /* NEVER - stuff just shown for info */
 *  extern void bcopy(char *from, char *to, int bytes);	/* block copy	*/
 *  extern m_OUTB(char *port, unsigned char byte); 	/* byte to port */
 *  extern char m_INB(char *port);			/* read port	*/
 *  m_DELAY(int *tics);		/* macro to wait for HW-latencies	*/
 *  extern int printf();	/* kernel printf(),not libc.a printf() */
 *  m_DISABLE_INTR(flags);	/* should only mask our own interrupt	*/
 *  m_RESTORE_INTR(flags);	/* restore interrupts as saved above	*/
 *  m_SLEEP			/* macro to call sleep  (only one loc.)	*/
 *  m_WAKEUP			/* macro to call wakeup	(only one loc.)	*/
 *  m_PROCESS_ABORTING;		/* returns != 0 if raised by signal	*/
 *  extern caddr_t sptalloc(int size_in_clicks,int pg_p,int is_0,int wait_fg);
 *  extern void sptfree(caddr_t adress, int size_in_clicks, int is_1);
 *  extern int copyout(char *from, char *to, int count);
 *  extern int copyin(char *from, char *to, int count);
 *  #define btoc(x)	...  	/* only in sptalloc()/sptfree() calls	*/
 *  #define phystokv(paddr) ...	/* translate phys. to kernel virt. adr.	*/
 *  #define NULL	0	/* this looks quite portable ...	*/
 *  #define FREAD	...	
 *  #define FWRITE	...	
 *  #define HZ	...		/* ticks of clock/sec used by m_DELAY()	*/
 *  #define PG_P ...	 	/* bits used only in sptalloc() call 	*/
 *  #define PG_RW ...
 *  #define	EIO	...	* I/O error				*/
 *  #define	ENXIO	...	* No such device or address		*/
 *  #define	EAGAIN	...	/* No more processes			*/
 *  #define	EFAULT	...	/* Bad address				*/
 *  #define	EBUSY	...	/* device busy				*/
 *  #define	ENODEV	...	/* No such device			*/
 *  #define	EINVAL	...	/* Invalid argument			*/
 *  #define	ENOSPC	...	/* No space left on device		*/
 *  #define	EINTR	...	/* got interrupted by signal		*/
 *  #define	ENOMEM	...	/* No kernel mem			*/
 *  typedef struct user_t {
 *  	int u_error, u_count, u_offset;
 *  	char *u_base; 
 *  }
 *  typedef char*	caddr_t;	/* kernel virtual adress-type	*/
 *  typedef unsigned long paddr_t;	/* only needed in phystokv()	*/
 *  typedef short	dev_t;		/* used in driver entry point	*/
#endif /* NEVER */


#ifdef linux
/*
 *
 * LINUX OS-DEPENDENCIES
 * =====================
 *
 */

/*
 * Constants, types & Co.
 * ----------------------
 */
#include <linux/param.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/dma.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/malloc.h>
#include <linux/string.h>
#include <linux/soundcard.h>

/*
 * Does Linux have the following bitmasks/constants?
 * Never mind, just redefine them.
 */
#undef FREAD
#define FREAD	0x01
#undef FWRITE
#define FWRITE	0x02
#undef NULL
#define NULL	0 

/*
 * simplified SysV386 info struct for data-exchange between
 * calling process and driver
 */
typedef struct user_t {
	int u_error, u_count, u_offset;
	char *u_base; 
} user_t;
extern user_t u;			/* someone actually has to	*/
					/* define us as a static var	*/
/*
 * on SysV386 physical and kernel virtual adresses
 * differ, on Linux they don't, says Hannu. 
 */
typedef unsigned long	paddr_t;	/* only needed in phystokv()	*/

/*
 * Hardware Settings and driver state we define in Space.c
 * but maybe want to override from kiflinux.c's sound_setup
 * or to access from somewhere
 */
extern int
    m_MSNDiobase,
    m_MSNDseg,
    m_MSNDint,
    m_driver_state
;

/*
 * Translations of SysV386 kernel support calls
 * --------------------------------------------
 */
#define printf 		printk		/* Kernel printf() */
#define bcopy(s, d, c)	memcpy(d, s, c)
#define btoc(x)		(x)		/* byte/click-conversion unused	*/
#define phystokv(paddr)	(paddr)		/* phys.adress = kernel virtual */
#define m_INB		inb_p		/* WARNING! m_OUTB def flipped	*/
#define m_OUTB(a, d) 	outb_p((d),(a))	/*   compared to VoxWare-OUTB	*/
					/*   and to Linux outb()	*/

/*
 * Some back and forth translations to at least hint an
 * integration step towards VoxWare. The nasty thing about copyin/copyout
 * is that it returns an error code, whereas memcpy doesn't.
 */
#define KERNEL_MALLOC(nbytes)		kmalloc((nbytes), GFP_KERNEL)
#define KERNEL_FREE(addr)		kfree(addr)
#define sptalloc(nbytes, d1, d2, d3)	KERNEL_MALLOC(nbytes)	
#define sptfree(addr, d1, d2) 		KERNEL_FREE(addr)	
#define COPY_FROM_USER(d, s, o, c) 	memcpy_fromfs((d), &((s)[o]), (c))
#define COPY_TO_USER(d, o, s, c)	memcpy_tofs(&((d)[o]), (s), (c))

#ifdef _IN_SOURCE_MSND_C_
static int copyin(char *s, char *d, int c) {
	COPY_FROM_USER(d, s, 0, c);
	return 0;
}
static int copyout(char *s, char *d, int c) {
	COPY_TO_USER(d, 0, s, c);
	return 0;
}
#endif  /* _IN_SOURCE_MSND_C_ */

/*
 * The following definitions define some wait queue handling stuff
 * in VoxWare. Wait and see ...
 */
#define WK_NONE		0x00		/* process wakeup reasons ...	*/
#define WK_WAKEUP	0x01
#define WK_TIMEOUT	0x02
#define WK_SIGNAL	0x04
#define WK_SLEEP	0x08

struct snd_wait {
	  int mode; int aborting;
};

#define DEFINE_WAIT_QUEUE(name, flag) static struct wait_queue *name = NULL; \
	static volatile struct snd_wait flag = {0}
#define RESET_WAIT_QUEUE(q, f) {f.aborting = 0;f.mode = WK_NONE;}
#define PROCESS_ABORTING(q, f) (/*f.aborting | */(current->signal & \
	~current->blocked))
#define TIMED_OUT(q, f) (f.mode & WK_TIMEOUT)
#define DO_SLEEP(q, f, time_limit)	\
	{ unsigned long tl;\
	  if (time_limit) tl = current->timeout = jiffies + (time_limit); \
	     else tl = 0xffffffff; \
	  f.mode = WK_SLEEP;interruptible_sleep_on(&q); \
	  if (!(f.mode & WK_WAKEUP)) \
	   { \
	     if (current->signal & ~current->blocked) \
	        f.aborting = 1; \
	     else \
	        if (jiffies >= tl) f.mode |= WK_TIMEOUT; \
	   } \
	  f.mode &= ~WK_SLEEP; \
	}
#define WAKE_UP(q, f)	{f.mode = WK_WAKEUP;wake_up(&q);}

/*
 * ... ok guys, looks like we can translate the sleep(), wakeup() and
 * delay() calls from SysV386 into a bunch of wait queue commands.
 * Remember in msnd.c we have only one sleep()/wakeup() combination:
 * the waker beeing always the interrupt service routine, the sleeper
 * the read, write, close routines sleeping on bankbuffers to be
 * served. So this combination operates on one and only one queue.
 * That's why the argument x remains unused in the macro defs.
 *
 * We translate delay(tics) into a sleep request on a second wait queue
 * with appropriate timeout. Noone but the timeout event will awake
 * us from sleeping. As argument we pass tics = HZ*sleep_time_in_seconds.
 *
 * FIXME: We want to have 2 sec timeout handling some time ...
 */

#ifdef _IN_SOURCE_MSND_C_
DEFINE_WAIT_QUEUE(msnd_interrupt_q, miq_flag);
DEFINE_WAIT_QUEUE(delay_q, dq_flag);
#endif /* _IN_SOURCE_MSND_C */

#define NOTIMEOUT	0
#define m_SLEEP 	{ \
			    RESET_WAIT_QUEUE(msnd_interrupt_q, miq_flag); \
			    DO_SLEEP(msnd_interrupt_q, miq_flag, NOTIMEOUT); \
			} 
#define m_WAKEUP		WAKE_UP(msnd_interrupt_q, miq_flag)
#define m_PROCESS_ABORTING	PROCESS_ABORTING(msnd_interrupt_q, miq_flag)

			/* this definitly does the `job' .... */
#define m_DELAY(tics)	{ RESET_WAIT_QUEUE(delay_q, dq_flag); \
			DO_SLEEP(delay_q, dq_flag, (tics)) }
 
/*
 * Interrupt handling
 * ------------------
 *
 * VoxWare's linux/os.h wants an SA_INTERRUPT-handler so SND_SA_INTERRUPT
 * is required. Otherwise the IRQ number is not passed the handler
 * (at least in older Kernel versions).
 *
 * So we just define it  (See kiflinux.c: SA_INTERRUPT) although we don't
 * evaluate the arguments passed to msndintr() at the moment. We might
 * account for your other 10 Tahitis/MultiSounds/Montereys/soundcards later.
 *
 * Also SA_INTERRUPT means, that we get a fast call and postprocessing
 * to msndintr(). To determine if we need that look at this: max. data
 * flow is 176KBytes/sec (CD-Quality-Sampling). The two shared mem banks
 * between multisound-DSP and host have 16KBytes each yielding an interrupt
 * rate of coarsly 10Hz. Also we can buffer up to 1/10Hz = 100ms of sound
 * until we have get our interrupt served, otherwise the MultiSound DSP
 * starves waiting for a bank. Because we can buffer the banks into/from
 * the driver's bankbuffer set (wich is just a memcopy of 16KBytes < 1ms)
 * in time, we have time do lots of other stuff on any priority level.
 * Note that this is different from just copying in/out between user process
 * and MultiSound memory bank, since the syncer has a lot more time
 * to stow away / bring the data to / from disk.
 *
 * Summarizing: 10Hz interrupt rate, 100ms maximum allowed service delay
 *		and maybe 1ms service time.
 *
 */
#define SND_SA_INTERRUPT

/*
 * The following is currently like VoxWare DISABLE_INTR/RESTORE_INTR.
 * We would be happy happier though if we could limit disabling to our own
 * interrupt vector. Since we are not in a hurry (100ms) we could allow
 * other driver interrupts to interrupts us, we might earn some credit
 * for being polite.
 */
#define m_DISABLE_INTR(flags) __asm__ __volatile__("pushfl ; popl %0 ; cli":"=r" (flags));
#define m_RESTORE_INTR(flags) __asm__ __volatile__("pushl %0 ; popfl": :"r" (flags));



#else /* meaning ndef linux */
/*
 *
 * GENERIC SYSV386 DEPENDENCIES
 * ============================
 *
 */


#ifdef SCO					/* try these for SCO...	*/
#include <sys/types.h>				/* (taken from VoxWare)	*/
#include <sys/errno.h>
#include <sys/signal.h>
#include <sys/fcntl.h>
#include <sys/tty.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/inode.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/fs/s5dir.h>
#include <sys/file.h>
#include <sys/immu.h>
#include <sys/region.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/sysmacros.h>
#include <sys/dma.h>
#include <sys/wait.h>

#else
#include <sys/types.h>				/* your include-file	*/
#include <sys/param.h>				/* names and contents	*/
#include <sys/dir.h>				/* may be different... 	*/
#include <sys/signal.h>
#include <sys/immu.h>
#include <sys/region.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/errno.h>
#include <sys/sysmacros.h>
#include <sys/file.h>
#endif

#ifdef _IN_SOURCE_MSND_C_
static int g_sleep_ret;
#endif /* _IN_SOURCE_MSND_C */

extern caddr_t sptalloc();
extern int (*m_spldev)();	/* priority level for critical driver	*/
			 	/* sections, must match ipl in sdevice	*/
#define m_DISABLE_INTR(flags)	flags = m_spldev()
#define m_RESTORE_INTR(flags)	splx(flags)
#define m_SLEEP			g_sleep_ret = \
				    sleep(&m_driver_state, (PCATCH|(PZERO+1)))
#define m_WAKEUP		wakeup(&m_driver_state)
#define m_DELAY(tics)		delay(tics)
#define m_INB	inb
#define m_OUTB	outb
#define m_PROCESS_ABORTING	(((u.u_procp)->p_sig) || g_sleep_ret)

#endif /* meaning ndef linux */
/*
 *
 * (still) COMMON FOR ALL SYSTEMS
 * ==============================
 *
 */
 						/* FIXME: not working	*/
#define CHECK_MSND_SEG_UNUSED	0		/* on Linux,check SysV,	*/
						/* used to work on dos	*/
						/* looks like we'd have	*/
						/* demandpaging jump in	*/

#define WORD			short           /* 16bit 		*/
#define BYTE			char          	/* 8bit 		*/
#define UBYTE			unsigned char 
#undef FULL
#define FULL			-1		/* two buffer states	*/
#undef EMPTY
#define EMPTY			0

						/* maximum number banks */
#define MAXBANKS		64		/* allowed to be backed	*/
						/* internally in driver	*/
						/* ->1MByte (enough!)	*/

#ifndef BUFFSIZE_IN_BYTES			/* allocated portions	*/
#define BUFFSIZE_IN_BYTES	0x0800		/* from kernel mem, has	*/
#endif				/*2048*/	/* to be true divisor	*/
						/* of BANKSIZE_IN...	*/

						/* size of 1 of the 2 	*/
#define BANKSIZE_IN_BYTES	0x4000      	/* contigous shared	*/
/*  ... DO NOT CHANGE */			/* RAM areas (banks)	*/
						/* of MultiSound-HW     */
						/* (16KByte)		*/

#define BUFFS_PER_BANK		(BANKSIZE_IN_BYTES/BUFFSIZE_IN_BYTES)
/*  ... DO NOT CHANGE */

						/* limits to number 	*/
#define MAXBUFFS    (MAXBANKS*BUFFS_PER_BANK)	/* of buffers		*/
#define MINBUFFS    (3*BUFFS_PER_BANK)		/* min -> 48KByte	*/
/*  ... DO NOT CHANGE */

#if (BUFFS_PER_BANK*BUFFSIZE_IN_BYTES) != (BANKSIZE_IN_BYTES)
#include "*** ERROR: BUFFSIZE_IN_BYTE doesn't fit in BANKSIZE_IN_BYTES ***"
#endif


#endif /* _OSDEP_H_ */
/*
 *	EOT
 *	===
 */

