/*
 *	$Id: Space.c,v 2.1.0.1 1995/04/11 14:46:40 mummert Exp mummert $
 *
 *	Space.c
 *	=======
 *
 *	kernel build-time configuration settings
 *	for MultiSound device driver
 *
 *      Copyright (c) 1994-1995 by Markus Mummert
 *
 *	Redistribution and use of this software, modifcation and inclusion
 *	into other forms of software are permitted provided that the following
 *	conditions are met:
 *
 *	1. Redistributions of this software must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. If this software is redistributed in a modified condition
 *	   it must reveal clearly that it has been modified.
 *	
 *	THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 *	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *	TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
 *	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *	PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *	USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 *	DAMAGE.
 *
 */
				/* NO #include "osdep.h" ALLOWDED HERE  */
				/* to stay SysV386 idinstall compatible	*/
#ifndef linux			/* SysV386:				*/
#include <sys/msndio.h>		/*   ioctl-defines			*/
#include "config.h"		/*   access to sdevice-defines		*/
#else				/* Linux:				*/
#include "msndio.h"		/*   ioctl-defines			*/
#endif

/*
 *  CHECK THE FOLLOWING PARAMETERS ...
 *  ----------------------------------
 *
 *	IF YOU ARE NOT LINUX YOU HAVE TO adjust m_lpsms below
 *	depending on processor speed and kernel compiler
 *	during driver installation you can run 'make lpsms'
 *	to determine the proper value. 
 *
 *	YOU MAY WANT TO increase m_recbuffs[],m_playbuffs[] below
 *	depending on disk i/o-performance to avoid drop outs under
 *	a loaded system. On the other hand you may want to decrease
 *      them in order to save memory during device operation or 
 *	to avoid some latency when killing a process using the device.
 *	In general higher sampling rates need more buffs than
 *	lower and recording needs more buffs than playback. 
 *	The default setting (62,8,3 18,8,3) is noncritical.
 *
 *	The other tunable paramters affect default behaviour on
 *	system initialisation only an can by altered any time
 *	when the system is running.
 */


int
#ifdef MSND_LPSMS		/* PROCESSOR AND COMPILER DEPENDENCY:	*/
    m_lpspms = MSND_LPSMS,	/*   empty for-loops/msec as the code	*/
#else				/*   `for(i=m_lpsms*1000;i>0;i--);'	*/
    m_lpspms = 12000,		/*   should result in a delay of 1sec;	*/
#endif				/*   (486DX266,AT&T-cc -O: 12000	*/
				/*    486DX33,AT&T-cc -O: 6000		*/
				/*    only relevant upon boot-init, ev.	*/
				/*    determined and passed via make)	*/

				/* DISK-I/O PERFORMANCE DEPENDENCIES:	*/
    m_buffed_banks_rec[] = 	/*   number of 16KByte buffs rec/play	*/
    		{64, 8, 3},	/*   corrsponding to 44.1, 22.05 and	*/
    m_buffed_banks_play[] =	/*   11.025kHz; must be >=3 and <= 64	*/
    		{18, 8, 3},	/*   (Quantum 210AT: 64,8,3 18,8,3)	*/
			
				/* default presets (see msnd.h):	*/ 
    m_monitor = M_SILENT,   	/*   monitor function			*/
    m_mode = M_MONO,		/*   mono or stereo			*/
    m_rate = M_CLKDIV4,		/*   sample rate clock divider		*/
    m_smpfmt = M_SWAP,		/*   swap bytes in word sample or don't	*/
    m_recbytes = 0x100000,	/*   limit of bytes to be recorded	*/
    m_playbytes = M_NOLIMIT,	/*   or to by played (M_NOLIMIT=0)	*/
    m_MSNDinptval = 0x4040,	/*   input and aux. pot preset		*/
    m_MSNDauxptval = 0x0	/*   (highbyte/lowbyte: left/right)	*/
;

/*
 *  NO TUNABLE PARAMETERS BELOW
 *  ---------------------------
 */
				/* hardware paramters via config.h on 	*/
int				/* on SysV386 or via cc-flags on Linux	*/
    m_MSNDiobase = MSND_0_SIOA,	/*   I/O-base (field 7 in sdevice)	*/
    m_MSNDseg = MSND_0_SCMA,	/*   memory start (field 9 in sdevice)	*/
    m_MSNDint = MSND_0_VECT,	/*   IRQ line (field 6 in sdevice)	*/
    m_driver_state = 0		/* remains zero, if driver doesn't init	*/
;
	
#ifndef linux			/* advanced stuff on SysV386:		*/
extern int spl3();		/*   priority level for critical driver	*/
int (*m_spldev)()=spl3; 	/*   section, digit must match IPL	*/
				/*   (field 4 in sdevice)		*/
#endif

/*
 *	EOT
 */

