Name:           tuxedo-drivers
Version:        4.16.0
Release:        1%{?dist}
Summary:        Kernel modules for TUXEDO devices

License:        GPLv2+
Url:            https://www.tuxedocomputers.com
Source0:        %{name}-%{version}.tar.xz

Requires:       dkms >= 2.1
Recommends:     udev-hid-bpf

BuildArch:      noarch

Provides:       tuxedo-cc-wmi = 4.0.0-1
Provides:       tuxedo-keyboard = 4.0.0-1
Provides:       tuxedo-keyboard-dkms = 4.0.0-1
Provides:       tuxedo-keyboard-ite = 4.0.0-1
Provides:       tuxedo-touchpad-fix = 4.0.0-1
Provides:       tuxedo-wmi-dkms = 4.0.0-1
Provides:       tuxedo-xp-xc-airplane-mode-fix = 4.0.0-1
Provides:       tuxedo-xp-xc-touchpad-key-fix = 4.0.0-1
Obsoletes:      tuxedo-cc-wmi < 4.0.0-1
Obsoletes:      tuxedo-keyboard < 4.0.0-1
Obsoletes:      tuxedo-keyboard-dkms < 4.0.0-1
Obsoletes:      tuxedo-keyboard-ite < 4.0.0-1
Obsoletes:      tuxedo-touchpad-fix < 4.0.0-1
Obsoletes:      tuxedo-wmi-dkms < 4.0.0-1
Obsoletes:      tuxedo-xp-xc-airplane-mode-fix < 4.0.0-1
Obsoletes:      tuxedo-xp-xc-touchpad-key-fix < 4.0.0-1

Group:          Hardware/Other
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>

%description
Drivers for several platform devices for TUXEDO notebooks meant for DKMS.

%prep
%setup -q

%install
cp -r %{_builddir}/%{name}-%{version}/usr %{buildroot}

%files
%{_usrsrc}/%{name}-%{version}
%license LICENSE
/usr/lib/modprobe.d/tuxedo-drivers-backlist-upstream-conflicts.conf
/usr/lib/udev/hwdb.d/61-keyboard-tuxedo.hwdb
/usr/lib/udev/hwdb.d/61-sensor-tuxedo.hwdb
/usr/lib/udev/rules.d/99-tuxedo-fix-huawei-lte-modules-correct-drivers.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-infinity-flex-touchpanel-toggle.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-intel-gen13-sleep-state.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-nb02-touchpad-mouse.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-pulse-gen2-wakeup-through-nvme-controller.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-realtek-rts522a-idle-behaviour.rules
/usr/lib/udev/rules.d/99-tuxedo-fix-systemd-led-bootdelay.rules

%post
dkms add -m %{name} -v %{version} --rpm_safe_upgrade
dkms build -m %{name} -v %{version}
dkms install -m %{name} -v %{version}

%preun
dkms remove -m %{name} -v %{version} --all --rpm_safe_upgrade

%changelog
* Wed Oct 01 2025 Werner Sembach <tux@tuxedocomputers.com 4.16.0-1
- Fix min TDP for Stellaris Gen7 AMD
- Add fix for Huawei LTE modules
- Remove amdgpu-firmware package from recommended
- Add debian 13 and fedora 42 to build tests
- Remove undocumented config file
- Fix backlight control on some NB02 devices
- Blacklist Uniwill upstream driver
* Fri Aug 29 2025 Werner Sembach <tux@tuxedocomputers.com 4.15.4-1
- Fix fan control unresponsive on older NB02 devices
* Mon Aug 25 2025 Werner Sembach <tux@tuxedocomputers.com 4.15.3-1
- Fix pulsating fan on NB02 devices by making TD full fan mode aware
- Readd and fix `make all` and `make install` targets as they are required for
  unofficial packaging scripts
- Add .editorconfig for developer convenience
* Mon Aug 18 2025 Tim Guttzeit <tux@tuxedocomputers.com 4.15.2-1
- change tuxedo-linux-firmware-amdgpu to Recommends
* Thu Aug 14 2025 Maximilian Arnold <tux@tuxedocomputers.com 4.15.1-1
- add tuxedo-linux-firmware-amdgpu as Depends 
* Wed Aug 06 2025 Tim Guttzeit <tux@tuxedocomputers.com 4.15.0-1
- Stellaris Gen7 AMD: Fix keyboard color, TGP, TDP;
- Stellaris Gen7 AMD: Remove unsupported USB-C Charging Prios
- Stellaris Gen7 AMD: Add AC Autoboot and USB Powershare features
- IBP Gen10: Fix ID changes
- IBP Gen10: Add IDs to power profiles and five step keyboard backlight  
* Wed Jul 30 2025 Tim Guttzeit <tux@tuxedocomputers.com 4.14.4-1
- Move udev rules from tuxedo-fix-config-files into tuxedo-drivers
* Tue Jul 15 2025 Werner Sembach <tux@tuxedocomputers.com 4.14.3-1
- Fix Stellaris Gen7 leaving custom profile upon power event
* Tue Jul 01 2025 Werner Sembach <tux@tuxedocomputers.com 4.14.2-1
- More small fixes for Stellaris Gen7 support
- Small fix for IBP Gen10 support
* Tue Jun 17 2025 Werner Sembach <tux@tuxedocomputers.com 4.14.1-1
- Cleanup Makefile
- Update Readme
- Fix NB02 devices have bogus mouse device
- Harmonize config file names
* Wed Jun 11 2025 Werner Sembach <tux@tuxedocomputers.com 4.14.0-1
- Several small fixes for Stellaris Gen7 support
- Add wake on power setting for supported devices
- Add power share setting for supported devices
* Thu May 15 2025 Werner Sembach <tux@tuxedocomputers.com 4.13.1-1
- InfinityFlex: Make FN-key no longer disable touchpad
- NB02: Make FN-key no longer spam dmesg
* Wed May 07 2025 Werner Sembach <tux@tuxedocomputers.com 4.13.0-1
- Fix touchpad toggle key on NB02 on wayland
- Fix Aura 14/15 Gen4 Webcam switch not disapearing when deactivated in BIOS
- Add udev-hid-bpf recommendation for Sirius 16 Gen1/2 keyboard fix
- Fix build errors with Kernel 6.14 and 6.15
* Tue Feb 18 2025 Werner Sembach <tux@tuxedocomputers.com 4.12.2-1
- Fix IBP Gen9 keyboard backlight not controllable after cold boot until first
  FN + space press
- This will be the last version officially supported on Ubuntu 22.04.
  Exceptions might get made for critical bug fixes.
* Mon Jan 27 2025 Werner Sembach <tux@tuxedocomputers.com 4.12.1-1
- Change device check for fixed 5 color kbl on NB02 devices from EC-ID to DMI
  string
- Cleanup changelog and order chronologically
- Generate rpm changelog from deb changelog
* Wed Jan 15 2025 Werner Sembach <tux@tuxedocomputers.com 4.12.0-1
- Add keyboard backlight support for IBP Gen9
- Add automatic compile tests
- Fix low fan speed rounding issue between off and 25%
* Wed Dec 11 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.7-1
- Avoid floating point to be more widely compatible
* Thu Dec 05 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.6-1
- Fix build against kernel 5.15
* Thu Dec 05 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.5-1
- Block 1%-24% fanspeeds and round to 0% or 25% respectifly to avoid irregular
  fan movements
* Tue Nov 26 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.4-1
- Remove buggy autoreload on install
- Fix CPU power handling on Stellaris 16 Gen6
- Fix instant wakeup on Stellaris Slim 15 Gen6 AMD
* Mon Nov 18 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.3-1
- Fix crashes on package install
* Wed Nov 13 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.2-1
- Fix missing module reload handling in install scripts
* Wed Nov 13 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.1-1
- Fix build with different kernels
* Tue Nov 12 2024 Werner Sembach <tux@tuxedocomputers.com 4.11.0-1
- Add TUXI (TUXEDO Interface) acpi driver
- Fix InfinityBook Pro v3 keyboard backlight levels
* Wed Nov 06 2024 Werner Sembach <tux@tuxedocomputers.com 4.10.2-1
- Fix color scaling for Stellaris 16 Gen6 Intel
* Tue Nov 05 2024 Werner Sembach <tux@tuxedocomputers.com 4.10.1-1
- Fix compile errors with linux 6.12
- Fix compile warnings
* Thu Oct 24 2024 Werner Sembach <tux@tuxedocomputers.com 4.10.0-1
- Fix IBP Gen9 fan control hickups
- Add basic lightbar support for new devices
* Tue Oct 15 2024 Werner Sembach <tux@tuxedocomputers.com 4.9.0-1
- Add power profiles support for IBP Gen9
- Add Stellaris Slim Gen6 TDP support
- Fix TDP set for Stellaris Gen6 devices
* Mon Sep 30 2024 Werner Sembach <tux@tuxedocomputers.com 4.8.0-1
- Add support for InfinityFlex toggle touchscreen button
- Update ReadMe
* Mon Sep 16 2024 Werner Sembach <tux@tuxedocomputers.com 4.7.0-1
- Add Support for the TUXEDO InfinityFlex Gen1
* Mon Sep 02 2024 Werner Sembach <tux@tuxedocomputers.com 4.6.3-1
- Fix compile for kernel 6.11
* Tue Aug 13 2024 Werner Sembach <tux@tuxedocomputers.com 4.6.2-1
- Fix compile for kernel 6.10
* Wed Jul 24 2024 Werner Sembach <tux@tuxedocomputers.com 4.6.1-1
- Fix compiler warnings with `Wstrict-prototypes`
- Fix compile error on openSUSE
* Thu Jul 11 2024 Werner Sembach <tux@tuxedocomputers.com 4.6.0-1
- Enable fn_lock on Aura Gen3 refresh
* Wed Jul 10 2024 Werner Sembach <tux@tuxedocomputers.com 4.5.4-1
- Fix keyboard backlight quirk list error for Stellaris Gen5 and Gen6
* Thu Jun 27 2024 Werner Sembach <tux@tuxedocomputers.com 4.5.3-1
- Fix touchpad toggle key sometimes not working
- Fix fans having realy slow ramp up speed
- Fix fans sometimes shutting off under sustained load
* Wed Jun 19 2024 Christoffer Sandberg <tux@tuxedocomputers.com 4.5.2-1
- Rename Stellaris Slim Gen1 => Gen6 for the release
* Fri Jun 07 2024 Werner Sembach <tux@tuxedocomputers.com 4.5.1-1
- Improve Pulse Gen3 and Gen4 fan control for newer firmware
- Add keyboard backlight color sclaing for Stellaris Lite Gen1
* Sat May 25 2024 Werner Sembach <tux@tuxedocomputers.com 4.5.0-1
- Fix dynamic boost being stuck at 5W
- Add Pulse Gen4 support
- Add Sirius Gen2 support
- Add Pulse Gen3 and Gen4 fan control support
* Wed May 08 2024 Werner Sembach <tux@tuxedocomputers.com 4.4.3-1
- Stop generating transitional packages
* Fri Apr 26 2024 Werner Sembach <tux@tuxedocomputers.com 4.4.2-1
- Fix Dynamic Boost default
- Dev/Debug: Pass through make arguments to sub makes
* Wed Apr 17 2024 Werner Sembach <tux@tuxedocomputers.com 4.4.1-1
- Fix tint in keyboard backlight for Stellaris 17 Gen6
* Mon Apr 08 2024 Werner Sembach <tux@tuxedocomputers.com 4.4.0-1
- Split IBPG7 TDP definitions for mk1/mk2 and update values
- Initial Stellaris Gen6 support
* Thu Mar 07 2024 Werner Sembach <tux@tuxedocomputers.com 4.3.2-1
- Restart UPower upon instal and remove because it does not handle
  (dis-)appearing leds devices well
- Add troubleshooting section to ReadMe
- Touchups on package and make scripts
* Tue Mar 05 2024 Werner Sembach <tux@tuxedocomputers.com 4.3.1-1
- Clarify transitional packages and obsoletes
- Add systemd boot delay fix
* Thu Feb 29 2024 Werner Sembach <tux@tuxedocomputers.com 4.3.0-1
- Implement nb05 (Pulse Gen3) gauge key (opens TCC)
* Mon Feb 19 2024 Werner Sembach <tux@tuxedocomputers.com 4.2.2-1
- Fix compiler error for older kernels by naming unused variables
* Wed Feb 07 2024 Werner Sembach <tux@tuxedocomputers.com 4.2.1-1
- Fix compile issue on Linux 5.15
* Tue Feb 06 2024 Werner Sembach <tux@tuxedocomputers.com 4.2.0-1
- Add basic nb05 keyboard backlight driver
- Remove unsupported IBS Gen6 from flexicharger settings
- Clean build and runtime error/warning log
- Update README
- Add capability to control NVIDIA cTGP on nb02 devices
* Thu Jan 25 2024 Werner Sembach <tux@tuxedocomputers.com 4.1.2-1
- Fix high cpu load caused by profile write logic bug
* Tue Jan 23 2024 Werner Sembach <tux@tuxedocomputers.com 4.1.1-1
- Fix keyboard backlight detection for Stellaris Gen5 AMD
* Wed Jan 17 2024 Werner Sembach <tux@tuxedocomputers.com 4.1.0-1
- Add nb04 driver collection (so far used by Sirius 16 Gen1)
* Thu Dec 28 2023 Werner Sembach <tux@tuxedocomputers.com 4.0.3-1
- Fix modprobe conf file not applying
* Thu Dec 21 2023 Werner Sembach <tux@tuxedocomputers.com 4.0.2-1
- nb01: Charging thresholds fixes
* Fri Dec 15 2023 Werner Sembach <tux@tuxedocomputers.com 4.0.1-1
- Fix build on Ubuntu 22.04 5.15 kernel
* Tue Dec 12 2023 Werner Sembach <tux@tuxedocomputers.com 4.0.0-1
- Merge tuxedo-keyboard and tuxedo-keyboard-ite
- Rename package to tuxedo-drivers
- Rework packaging process
- Fn-lock sysfs interface for nb02 and nb01 (newer models with CCC from v4.0)
- Flexicharger sysfs interface for nb01 (new plus legacy which works on some
  older models)
- Various backlight bugfixes and rework
- nb05 driver collection (so far used by Pulse Gen3)
* Thu Nov 16 2023 Christoffer Sandberg <tux@tuxedocomputers.com 0.4.4-1
- Add color scaling for Stellaris Gen5 AMD devices
* Thu Nov 16 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.14-1
- Tweak IBPG8 TDP limits
* Fri Nov 10 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.13-1
- Add missing IBPG8 TDP definitions
* Tue Oct 24 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.12-1
- Polaris/Stellaris AMD Gen5 support
* Thu Sep 21 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.11-1
- Aura Gen3 support
* Thu Aug 10 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.10-1
- Fix build on certain systems
* Thu Aug 03 2023 Christoffer Sandberg <tux@tuxedocomputers.com 0.4.3-1
- Adjusted lightbar USB product exclusion (prevents driver binding to unused
  devices) for Stellaris Gen5 and allows proper binding of relevant ones.
- Lightbar color scaling for Stellaris 17 Gen5
* Tue Aug 01 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.9-1
- Quirks for setting missing IBP16Gen8 keyboard layouts
- Fix IBP 16 Gen8 mk1 layout set to 14inch variant layout
* Fri Jul 21 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.8-1
- Keyboard backlight support for IBS17Gen8 (white-only)
- Fn backlight key support for IBS17Gen8
* Wed Jun 28 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.7-1
- Fix for certain white kbd bl identification on boot (XA15)
- General white-only kbd bl rework to use firmware set on Fn+brightness
  switch
- Kernel 6.4 build compatibility fix
* Tue Jun 13 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.6-1
- Fallback ROM ID set quirk support
* Fri May 19 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.5-1
- IBP Gen8 keyboard backlight support
- IBP Gen8 TDP support
- Color scaling for certain one-zone RGB keyboards
- Fix for certain white kbd bl devices (like Pulse) not setting brightness
  to zero on init
* Thu May 04 2023 Christoffer Sandberg <tux@tuxedocomputers.com 0.4.1-1
- Four zone backlight support for Stellaris Gen5
- Experimental buffered writes for Stellaris/Fusion per-key variants
* Thu Apr 20 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.3-1
- Fix missing state write on resume for some devices which woke up with
  "default blue" keyboard backlight
- Add TDP device definitions for Stellaris Intel Gen5
- Add device check on newer cpu gens
* Mon Apr 17 2023 Christoffer Sandberg <tux@tuxedocomputers.com 0.4.0-1
- Color scaling for Stellaris Intel Gen5
- Lightbar impl. for Stellaris Gen4/5
* Mon Mar 27 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.1-1
- Fix "lost fan control" in some circumstances (on eg. IBPGen7)
* Wed Mar 22 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.2.0-1
- KBD BL: Interface rewrite, now generally exported through
  /sys/class/leds :kbd_backlight
- KBD BL: New interface impl. for white backlight keyboards (also
  :kbd_backlight)
- Note: Old interface is hereby deprecated (and removed)
* Thu Feb 23 2023 Christoffer Sandberg <tux@tuxedocomputers.com 0.3.0-1
- Leds interface support (/sys/class/leds)
* Fri Feb 17 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.1.4-1
- Fix upcoming 6.2 kernel build issue (from github Buddy-Matt)
- Re-write last set charging priority on barrel plug connect
- UW interface performance tweaks (should help with lagging keyboard issues
  on certain devices)
* Wed Jan 11 2023 Christoffer Sandberg <tux@tuxedocomputers.com 3.1.3-1
- Fix IBP14Gen6 second fan not spinning (alternative fan ctl approach)
- Fix some error-lookalike messages in kernel log (aka prevent uw feature
  id when interface not available)
* Mon Dec 19 2022 Christoffer Sandberg <tux@tuxedocomputers.com 3.1.2-1
- Enables dynamic boost (max offset) for certain devices needing sw ctl
- Adds charging profile interface for devices supporting charging profiles
- Adds charging priority interface for devices supporting USB-C PD charging
  priority setting
* Wed Dec 07 2022 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.5-1
- Add per-device color scaling to ite_8291 driver
- Add additional scaling setting for Stellaris 17 AMD Gen 4
* Wed Nov 30 2022 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.4-1
- Add USB ID for Stellaris 17 Gen 4 keyboard backlight
* Mon Oct 17 2022 Christoffer Sandberg <tux@tuxedocomputers.com 3.1.1-1
- Reenable fans-off for some devices that got it turned of as a temporary
  workaround
- Fix default fan curve not being reenabled when tccd is stopped
* Mon Oct 10 2022 Christoffer Sandberg <tux@tuxedocomputers.com 3.1.0-1
- Add power profiles and tdp functionality (uw)
* Thu Oct 06 2022 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.11-1
- Introduce alternative fan control (uw)
- Fan control parameters from driver "has fan off" and "min fan speed"
- Fixes missing/broken fan control on newer devices
* Thu Apr 28 2022 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.10-1
- Add Stellaris Intel gen 4 lightbar support
- Default lightbar to off
* Mon Oct 18 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.9-1
- Add IBS15v6 & IBS17v6 new module name to perf. prof workaround
- Interface modularization (uw)
- Fix Pulse14/15 gen 1 keyboard backlight ctrl dissapearing
* Fri Jul 09 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.8-1
- Add IBS14v6 to perf. prof workaround
* Thu Jun 24 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.7-1
- Add new Polaris devices gen 2 & gen 3 keyb bl support
- Add Stellaris (gen3) lightbar support
- Fix kernel 5.13 build issue (from github BlackIkeEagle)
- Add another Fusion lightbar ID (from github ArlindoFNeto)
* Mon Jun 07 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.6-1
- Add tuxedo-io perf. prof. set (cl)
* Fri Apr 23 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.5-1
- Add NS50MU to perf. profile workaround
- Add EDUBOOK1502 to perf. profile workaround
- Add XP gen 11 & 12 to perf. profile workaround
- Clean-up cl driver state init (should fix some init color issues)
* Fri Mar 19 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.4-1
- Fixed various possible race conditions on driver init
- Added IBS14v5 to perf. profile workaround
- Added new Aura board name to perf. profile workaround
- Fixed non-initialized firmware fan curve for silent mode (UW)
- Changed default perf. profile to balanced (UW)
* Fri Mar 5 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.3-1
- Added XP14 to perf. profile workaround
* Mon Feb 22 2021 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.3-1
- Fix broken brightness key reaction for ite_829x
* Tue Feb 16 2021 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.2-1
- Attempt to fix ite_829x instability sometimes locking up kernel on
  keypress
* Fri Jan 29 2021 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.2-1
- Fixed clevo keyboard init order
- Added Aura perf. profile workaround
* Mon Dec 21 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.1-1
- Added device 048d:6004 to ite_8291
* Mon Dec 21 2020 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.1-1
- Added device support (Trinity)
- Fixed uw fan ramp up issues to some extent (workaround)
* Wed Dec 9 2020 Christoffer Sandberg <tux@tuxedocomputers.com 3.0.0-1
- Changed structure of clevo interfaces
- Added separate clevo-wmi module with existing functionality
- Added clevo-acpi module with implementation of the "new" clevo ACPI
  interface
- Added tuxedo-io module (former tuxedo-cc-wmi) into package
* Fri Nov 13 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.2.0-1
- Added initial support for ITE Device(8291) ->  048d:ce00
* Fri Nov 13 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.1.0-1
- Added device support (XMG Fusion)
- Added uniwill lightbar driver (with led_classdev interface)
- Added uniwill keymapping brightness up/down
- Fixed uniwill touchpad toggle (some platforms)
- Fixed module cleanup crash
* Fri Oct 16 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.1.0-1
- Added initial (very basic) support for 048d:8297 LED controller
* Mon Oct 12 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.0.3-1
- Fixed key mapping toggle <=> switch mode
- Default color to white
* Tue Sep 29 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.0.2-1
- Initial experimental release
* Fri Sep 25 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.6-1
- Added uw kbd color backlight support
* Thu Jun 18 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.5-1
- Restructure to allow for more devices
- Added device support
- Added rudimentary device detection
* Tue May 26 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.4-1
- Added rfkill key event
- Fix volume button events, ignore
* Tue May 19 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.3-1
- General key event mapping support
- Events added for backlight and touchpad
* Tue Apr 14 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.2-1
- Fix not restoring state on resume
- Fix module autoload issues
- Add standard config tuxedo_keyboard.conf to package
* Fri Mar 27 2020 Christoffer Sandberg <tux@tuxedocomputers.com 0.0.1-1
- First version of the ITE keyboard backlight driver
- Has support for ITE Device(829x) ->  0x048d:0x8910
* Tue Mar 17 2020 Christoffer Sandberg <tux@tuxedocomputers.com 2.0.1-1
- New packaging
