#include "rmixnumspin.h"
#include "mixerhandle.h"

rmixNumSpin::rmixNumSpin(snd_hctl_elem_t *elem, ushort ch, bool writable, rmixNumSpin *prev) {
	m_elem= elem;
	m_channel= ch;
	m_prev= prev;
	snd_ctl_elem_value_malloc(&m_val);
	if(writable)
	{
		snd_ctl_elem_info_alloca(&m_info);
		snd_hctl_elem_info(elem, m_info);
		setMinimum(snd_ctl_elem_info_get_min(m_info));
		setMaximum(snd_ctl_elem_info_get_max(m_info));
		connect(this, SIGNAL(valueChanged(int)), this, SLOT(changeVal(int)));
	} else
		setDisabled(1);
	snd_hctl_elem_set_callback_private(elem, new mixerHandle::callbackData{ mixerHandle::NS, this });
	snd_hctl_elem_set_callback(elem, callback);
	updat();
}

rmixNumSpin::~rmixNumSpin() {
	snd_ctl_elem_value_free(m_val);
	snd_hctl_elem_set_callback(m_elem, nullptr);
	snd_hctl_elem_set_callback_private(m_elem, nullptr);
}

void rmixNumSpin::changeVal(int val) {
	snd_hctl_elem_read(m_elem, m_val);
	snd_ctl_elem_value_set_integer(m_val, m_channel, val);
	snd_hctl_elem_write(m_elem, m_val);
}

void rmixNumSpin::updat() {
	if(m_prev != nullptr)
		m_prev->updat();
	snd_hctl_elem_read(m_elem, m_val);
	blockSignals(1);
	setValue(snd_ctl_elem_value_get_integer(m_val, m_channel));
	blockSignals(0);
}
