/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.file.FileSourceXML;

public class FileSourceGPX
extends FileSourceXML {
    protected GPXParser parser;

    @Override
    protected void afterStartDocument() throws IOException, XMLStreamException {
        this.parser = new GPXParser();
        this.parser.__gpx();
    }

    @Override
    protected void beforeEndDocument() throws IOException, XMLStreamException {
        this.parser = null;
    }

    @Override
    public boolean nextEvents() throws IOException {
        return false;
    }

    public static interface GPXConstants {

        public static enum BOUNDSAttribute {
            MINLAT,
            MAXLAT,
            MINLON,
            MAXLON;

        }

        public static enum Balise {
            GPX,
            METADATA,
            WPT,
            RTE,
            TRK,
            EXTENSIONS,
            NAME,
            DESC,
            AUTHOR,
            COPYRIGHT,
            LINK,
            TIME,
            KEYWORDS,
            BOUNDS,
            ELE,
            MAGVAR,
            GEOIDHEIGHT,
            CMT,
            SRC,
            SYM,
            TYPE,
            FIX,
            SAT,
            HDOP,
            VDOP,
            PDOP,
            AGEOFDGPSDATA,
            DGPSID,
            NUMBER,
            RTEPT,
            TRKSEG,
            TRKPT,
            YEAR,
            LICENCE,
            TEXT,
            EMAIL,
            PT;

        }

        public static enum COPYRIGHTAttribute {
            AUTHOR;

        }

        public static enum EMAILAttribute {
            ID,
            DOMAIN;

        }

        public static enum FixType {
            T_NONE,
            T_2D,
            T_3D,
            T_DGPS,
            T_PPS;

        }

        public static enum GPXAttribute {
            CREATOR,
            VERSION;

        }

        public static enum LINKAttribute {
            HREF;

        }

        public static enum PTAttribute {
            LAT,
            LON;

        }

        public static enum WPTAttribute {
            LAT,
            LON;

        }
    }

    protected class GPXParser
    extends FileSourceXML.Parser
    implements GPXConstants {
        int automaticPointId = 0;
        int automaticRouteId = 0;
        int automaticEdgeId = 0;

        GPXParser() {
        }

        private WayPoint waypoint(String elementName) throws IOException, XMLStreamException {
            WayPoint wp = new WayPoint();
            LinkedList<String> links = new LinkedList<String>();
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, elementName);
            EnumMap<GPXConstants.WPTAttribute, String> attributes = this.getAttributes(GPXConstants.WPTAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.WPTAttribute.LAT)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'lat' is required", new Object[0]);
            }
            if (!attributes.containsKey((Object)GPXConstants.WPTAttribute.LON)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'lon' is required", new Object[0]);
            }
            wp.lat = Double.parseDouble(attributes.get((Object)GPXConstants.WPTAttribute.LAT));
            wp.lon = Double.parseDouble(attributes.get((Object)GPXConstants.WPTAttribute.LON));
            wp.ele = 0.0;
            wp.attributes.put("lat", wp.lat);
            wp.attributes.put("lon", wp.lon);
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "ele")) {
                FileSourceGPX.this.pushback(e);
                wp.ele = this.__ele();
                wp.attributes.put("ele", wp.ele);
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "time")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("time", this.__time());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "magvar")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("magvar", this.__magvar());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "geoidheight")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("geoidheight", this.__geoidheight());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "name")) {
                FileSourceGPX.this.pushback(e);
                wp.name = this.__name();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "cmt")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("cmt", this.__cmt());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "desc")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("desc", this.__desc());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "src")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("src", this.__src());
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "link")) {
                FileSourceGPX.this.pushback(e);
                links.add(this.__link());
                e = FileSourceGPX.this.getNextEvent();
            }
            wp.attributes.put("link", links.toArray(new String[links.size()]));
            if (FileSourceGPX.this.isEvent(e, 1, "sym")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("sym", this.__sym());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "type")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("type", this.__type());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "fix")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("fix", this.__fix());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "sat")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("sat", this.__sat());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "hdop")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("hdop", this.__hdop());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "vdop")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("vdop", this.__vdop());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "pdop")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("pdop", this.__pdop());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "ageofdgpsdata")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("ageofdgpsdata", this.__ageofdgpsdata());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "dgpsid")) {
                FileSourceGPX.this.pushback(e);
                wp.attributes.put("dgpsid", this.__dgpsid());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, elementName);
            if (wp.name == null) {
                wp.name = String.format("wp#%08x", this.automaticPointId++);
            }
            return wp;
        }

        private void __gpx() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "gpx");
            EnumMap<GPXConstants.GPXAttribute, String> attributes = this.getAttributes(GPXConstants.GPXAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.GPXAttribute.VERSION)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'version' is required", new Object[0]);
            } else {
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.version", attributes.get((Object)GPXConstants.GPXAttribute.VERSION));
            }
            if (!attributes.containsKey((Object)GPXConstants.GPXAttribute.CREATOR)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'creator' is required", new Object[0]);
            } else {
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.creator", attributes.get((Object)GPXConstants.GPXAttribute.CREATOR));
            }
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "metadata")) {
                FileSourceGPX.this.pushback(e);
                this.__metadata();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "wpt")) {
                FileSourceGPX.this.pushback(e);
                this.__wpt();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "rte")) {
                FileSourceGPX.this.pushback(e);
                this.__rte();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "trk")) {
                FileSourceGPX.this.pushback(e);
                this.__trk();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "gpx");
        }

        private void __metadata() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "metadata");
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "name")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.name", this.__name());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "desc")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.desc", this.__desc());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "author")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.author", this.__author());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "copyright")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.copyright", this.__copyright());
                e = FileSourceGPX.this.getNextEvent();
            }
            LinkedList<String> links = new LinkedList<String>();
            while (FileSourceGPX.this.isEvent(e, 1, "link")) {
                FileSourceGPX.this.pushback(e);
                links.add(this.__link());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (links.size() > 0) {
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.links", links.toArray(new String[links.size()]));
            }
            if (FileSourceGPX.this.isEvent(e, 1, "time")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.time", this.__time());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "keywords")) {
                FileSourceGPX.this.pushback(e);
                FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.metadata.keywords", this.__keywords());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "bounds")) {
                FileSourceGPX.this.pushback(e);
                this.__bounds();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "metadata");
        }

        private void __wpt() throws IOException, XMLStreamException {
            WayPoint wp = this.waypoint("wpt");
            wp.deploy();
        }

        private void __rte() throws IOException, XMLStreamException {
            LinkedList<String> links = new LinkedList<String>();
            LinkedList<WayPoint> points = new LinkedList<WayPoint>();
            String time = null;
            String type = null;
            String src = null;
            String desc = null;
            String cmt = null;
            String name = null;
            int number = -1;
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "rte");
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "name")) {
                FileSourceGPX.this.pushback(e);
                name = this.__name();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "time")) {
                FileSourceGPX.this.pushback(e);
                time = this.__time();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "cmt")) {
                FileSourceGPX.this.pushback(e);
                cmt = this.__cmt();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "desc")) {
                FileSourceGPX.this.pushback(e);
                desc = this.__desc();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "src")) {
                FileSourceGPX.this.pushback(e);
                src = this.__src();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "link")) {
                FileSourceGPX.this.pushback(e);
                links.add(this.__link());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "number")) {
                FileSourceGPX.this.pushback(e);
                number = this.__number();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "type")) {
                FileSourceGPX.this.pushback(e);
                type = this.__type();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "rtept")) {
                FileSourceGPX.this.pushback(e);
                points.addLast(this.__rtept());
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "rte");
            if (name == null) {
                name = String.format("route#%08x", this.automaticRouteId++);
            }
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name, Boolean.TRUE);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".desc", desc);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".cmt", cmt);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".src", src);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".type", type);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".time", time);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "routes." + name + ".number", number);
            int i = 0;
            while (i < points.size()) {
                ((WayPoint)points.get(i)).deploy();
                if (i > 0) {
                    String eid = String.format("seg#%08x", this.automaticEdgeId++);
                    FileSourceGPX.this.sendEdgeAdded(FileSourceGPX.this.sourceId, eid, ((WayPoint)points.get((int)(i - 1))).name, ((WayPoint)points.get((int)i)).name, true);
                    FileSourceGPX.this.sendEdgeAttributeAdded(FileSourceGPX.this.sourceId, eid, "route", name);
                }
                ++i;
            }
        }

        private void __trk() throws IOException, XMLStreamException {
            LinkedList<String> links = new LinkedList<String>();
            String time = null;
            String type = null;
            String src = null;
            String desc = null;
            String cmt = null;
            String name = null;
            int number = -1;
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "trk");
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "name")) {
                FileSourceGPX.this.pushback(e);
                name = this.__name();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "time")) {
                FileSourceGPX.this.pushback(e);
                time = this.__time();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "cmt")) {
                FileSourceGPX.this.pushback(e);
                cmt = this.__cmt();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "desc")) {
                FileSourceGPX.this.pushback(e);
                desc = this.__desc();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "src")) {
                FileSourceGPX.this.pushback(e);
                src = this.__src();
                e = FileSourceGPX.this.getNextEvent();
            }
            while (FileSourceGPX.this.isEvent(e, 1, "link")) {
                FileSourceGPX.this.pushback(e);
                links.add(this.__link());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "number")) {
                FileSourceGPX.this.pushback(e);
                number = this.__number();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "type")) {
                FileSourceGPX.this.pushback(e);
                type = this.__type();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (name == null) {
                name = String.format("route#%08x", this.automaticRouteId++);
            }
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name, Boolean.TRUE);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".desc", desc);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".cmt", cmt);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".src", src);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".type", type);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".time", time);
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "tracks." + name + ".number", number);
            while (FileSourceGPX.this.isEvent(e, 1, "trkseg")) {
                FileSourceGPX.this.pushback(e);
                List<WayPoint> wps = this.__trkseg();
                int i = 0;
                while (i < wps.size()) {
                    wps.get(i).deploy();
                    if (i > 0) {
                        String eid = String.format("seg#%08x", this.automaticEdgeId++);
                        FileSourceGPX.this.sendEdgeAdded(FileSourceGPX.this.sourceId, eid, wps.get((int)(i - 1)).name, wps.get((int)i).name, true);
                        FileSourceGPX.this.sendEdgeAttributeAdded(FileSourceGPX.this.sourceId, eid, "route", name);
                    }
                    ++i;
                }
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "trk");
        }

        private void __extensions() throws IOException, XMLStreamException {
            int stack = 0;
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "extensions");
            e = FileSourceGPX.this.getNextEvent();
            while (!FileSourceGPX.this.isEvent(e, 2, "extensions") || stack != 0) {
                if (FileSourceGPX.this.isEvent(e, 2, "extensions")) {
                    --stack;
                } else if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                    ++stack;
                }
                e = FileSourceGPX.this.getNextEvent();
            }
        }

        private String __name() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "name");
            String name = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "name");
            return name;
        }

        private String __desc() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "desc");
            String desc = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "desc");
            return desc;
        }

        private String __author() throws IOException, XMLStreamException {
            String author = "";
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "author");
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "name")) {
                FileSourceGPX.this.pushback(e);
                author = String.valueOf(author) + this.__name();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "email")) {
                FileSourceGPX.this.pushback(e);
                author = String.valueOf(author) + " <" + this.__email() + ">";
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "link")) {
                FileSourceGPX.this.pushback(e);
                author = String.valueOf(author) + " (" + this.__link() + ")";
                e = FileSourceGPX.this.getNextEvent();
            }
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "author");
            return author;
        }

        private String __copyright() throws IOException, XMLStreamException {
            String copyright;
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "copyright");
            EnumMap<GPXConstants.COPYRIGHTAttribute, String> attributes = this.getAttributes(GPXConstants.COPYRIGHTAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.COPYRIGHTAttribute.AUTHOR)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'author' is required", new Object[0]);
                copyright = "unknown";
            } else {
                copyright = attributes.get((Object)GPXConstants.COPYRIGHTAttribute.AUTHOR);
            }
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "year")) {
                FileSourceGPX.this.pushback(e);
                copyright = String.valueOf(copyright) + " " + this.__year();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "license")) {
                FileSourceGPX.this.pushback(e);
                copyright = String.valueOf(copyright) + " " + this.__license();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "copyright");
            return copyright;
        }

        private String __link() throws IOException, XMLStreamException {
            String link;
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "link");
            EnumMap<GPXConstants.LINKAttribute, String> attributes = this.getAttributes(GPXConstants.LINKAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.LINKAttribute.HREF)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'href' is required", new Object[0]);
                link = "unknown";
            } else {
                link = attributes.get((Object)GPXConstants.LINKAttribute.HREF);
            }
            e = FileSourceGPX.this.getNextEvent();
            if (FileSourceGPX.this.isEvent(e, 1, "text")) {
                FileSourceGPX.this.pushback(e);
                this.__text();
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "type")) {
                FileSourceGPX.this.pushback(e);
                this.__type();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "link");
            return link;
        }

        private String __time() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "time");
            String time = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "time");
            return time;
        }

        private String __keywords() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "keywords");
            String keywords = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "keywords");
            return keywords;
        }

        private void __bounds() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "bounds");
            EnumMap<GPXConstants.BOUNDSAttribute, String> attributes = this.getAttributes(GPXConstants.BOUNDSAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.BOUNDSAttribute.MINLAT)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'minlat' is required", new Object[0]);
            }
            if (!attributes.containsKey((Object)GPXConstants.BOUNDSAttribute.MAXLAT)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'maxlat' is required", new Object[0]);
            }
            if (!attributes.containsKey((Object)GPXConstants.BOUNDSAttribute.MINLON)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'minlon' is required", new Object[0]);
            }
            if (!attributes.containsKey((Object)GPXConstants.BOUNDSAttribute.MAXLON)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'maxlon' is required", new Object[0]);
            }
            double minlat = Double.parseDouble(attributes.get((Object)GPXConstants.BOUNDSAttribute.MINLAT));
            double maxlat = Double.parseDouble(attributes.get((Object)GPXConstants.BOUNDSAttribute.MAXLAT));
            double minlon = Double.parseDouble(attributes.get((Object)GPXConstants.BOUNDSAttribute.MINLON));
            double maxlon = Double.parseDouble(attributes.get((Object)GPXConstants.BOUNDSAttribute.MAXLON));
            FileSourceGPX.this.sendGraphAttributeAdded(FileSourceGPX.this.sourceId, "gpx.bounds", new double[]{minlat, minlon, maxlat, maxlon});
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "bounds");
        }

        private double __ele() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "ele");
            String ele = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "ele");
            return Double.parseDouble(ele);
        }

        private double __magvar() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "magvar");
            String magvar = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "magvar");
            return Double.parseDouble(magvar);
        }

        private double __geoidheight() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "geoidheight");
            String geoidheight = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "geoidheight");
            return Double.parseDouble(geoidheight);
        }

        private String __cmt() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "cmt");
            String cmt = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "cmt");
            return cmt;
        }

        private String __src() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "src");
            String src = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "src");
            return src;
        }

        private String __sym() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "sym");
            String sym = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "sym");
            return sym;
        }

        private String __text() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "text");
            String text = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "text");
            return text;
        }

        private String __type() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "type");
            String type = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "type");
            return type;
        }

        private String __fix() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "fix");
            String fix = this.__characters();
            if (!fix.toLowerCase().matches("^(none|2d|3d|dgps|pps)$")) {
                FileSourceGPX.this.newParseError(e, true, "invalid fix type, expecting one of 'none', '2d', '3d', 'dgps', 'pps'", new Object[0]);
            }
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "fix");
            return fix;
        }

        private int __sat() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "sat");
            String sat = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "sat");
            return Integer.parseInt(sat);
        }

        private double __hdop() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "hdop");
            String hdop = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "hdop");
            return Double.parseDouble(hdop);
        }

        private double __vdop() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "vdop");
            String vdop = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "vdop");
            return Double.parseDouble(vdop);
        }

        private double __pdop() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "pdop");
            String pdop = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "pdop");
            return Double.parseDouble(pdop);
        }

        private double __ageofdgpsdata() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "ageofdgpsdata");
            String ageofdgpsdata = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "ageofdgpsdata");
            return Double.parseDouble(ageofdgpsdata);
        }

        private int __dgpsid() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "dgpsid");
            String dgpsid = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "dgpsid");
            return Integer.parseInt(dgpsid);
        }

        private int __number() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "number");
            String number = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "number");
            return Integer.parseInt(number);
        }

        private WayPoint __rtept() throws IOException, XMLStreamException {
            return this.waypoint("rtept");
        }

        private WayPoint __trkpt() throws IOException, XMLStreamException {
            return this.waypoint("trkpt");
        }

        private List<WayPoint> __trkseg() throws IOException, XMLStreamException {
            LinkedList<WayPoint> points = new LinkedList<WayPoint>();
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "trkseg");
            e = FileSourceGPX.this.getNextEvent();
            while (FileSourceGPX.this.isEvent(e, 1, "trkpt")) {
                FileSourceGPX.this.pushback(e);
                points.addLast(this.__trkpt());
                e = FileSourceGPX.this.getNextEvent();
            }
            if (FileSourceGPX.this.isEvent(e, 1, "extensions")) {
                FileSourceGPX.this.pushback(e);
                this.__extensions();
                e = FileSourceGPX.this.getNextEvent();
            }
            FileSourceGPX.this.checkValid(e, 2, "trkseg");
            return points;
        }

        private String __email() throws IOException, XMLStreamException {
            String email = "";
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "email");
            EnumMap<GPXConstants.EMAILAttribute, String> attributes = this.getAttributes(GPXConstants.EMAILAttribute.class, e.asStartElement());
            if (!attributes.containsKey((Object)GPXConstants.EMAILAttribute.ID)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'version' is required", new Object[0]);
            } else {
                email = String.valueOf(email) + attributes.get((Object)GPXConstants.EMAILAttribute.ID);
            }
            email = String.valueOf(email) + "@";
            if (!attributes.containsKey((Object)GPXConstants.EMAILAttribute.DOMAIN)) {
                FileSourceGPX.this.newParseError(e, false, "attribute 'version' is required", new Object[0]);
            } else {
                email = String.valueOf(email) + attributes.get((Object)GPXConstants.EMAILAttribute.DOMAIN);
            }
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "email");
            return email;
        }

        private String __year() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "year");
            String year = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "year");
            return year;
        }

        private String __license() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 1, "license");
            String license = this.__characters();
            e = FileSourceGPX.this.getNextEvent();
            FileSourceGPX.this.checkValid(e, 2, "license");
            return license;
        }
    }

    protected class WayPoint {
        String name = null;
        double lat = 0.0;
        double lon = 0.0;
        double ele = 0.0;
        HashMap<String, Object> attributes = new HashMap();

        WayPoint() {
        }

        void deploy() {
            FileSourceGPX.this.sendNodeAdded(FileSourceGPX.this.sourceId, this.name);
            FileSourceGPX.this.sendNodeAttributeAdded(FileSourceGPX.this.sourceId, this.name, "xyz", new double[]{this.lon, this.lat, this.ele});
            for (String key : this.attributes.keySet()) {
                FileSourceGPX.this.sendNodeAttributeAdded(FileSourceGPX.this.sourceId, this.name, key, this.attributes.get(key));
            }
        }
    }
}

