/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.graph.implementations.AdjacencyListNode;

public class AdjacencyListGraph
extends AbstractGraph {
    public static final double GROW_FACTOR = 1.1;
    public static final int DEFAULT_NODE_CAPACITY = 128;
    public static final int DEFAULT_EDGE_CAPACITY = 1024;
    protected HashMap<String, AbstractNode> nodeMap;
    protected HashMap<String, AbstractEdge> edgeMap;
    protected AbstractNode[] nodeArray;
    protected AbstractEdge[] edgeArray;
    protected int nodeCount;
    protected int edgeCount;

    public AdjacencyListGraph(String id, boolean strictChecking, boolean autoCreate, int initialNodeCapacity, int initialEdgeCapacity) {
        super(id, strictChecking, autoCreate);
        this.setNodeFactory((NodeFactory<? extends Node>)new NodeFactory<AdjacencyListNode>(){

            @Override
            public AdjacencyListNode newInstance(String id, Graph graph) {
                return new AdjacencyListNode((AbstractGraph)graph, id);
            }
        });
        this.setEdgeFactory((EdgeFactory<? extends Edge>)new EdgeFactory<AbstractEdge>(){

            @Override
            public AbstractEdge newInstance(String id, Node src, Node dst, boolean directed) {
                return new AbstractEdge(id, (AbstractNode)src, (AbstractNode)dst, directed);
            }
        });
        if (initialNodeCapacity < 128) {
            initialNodeCapacity = 128;
        }
        if (initialEdgeCapacity < 1024) {
            initialEdgeCapacity = 1024;
        }
        this.nodeMap = new HashMap(4 * initialNodeCapacity / 3 + 1);
        this.edgeMap = new HashMap(4 * initialEdgeCapacity / 3 + 1);
        this.nodeArray = new AbstractNode[initialNodeCapacity];
        this.edgeArray = new AbstractEdge[initialEdgeCapacity];
        this.edgeCount = 0;
        this.nodeCount = 0;
    }

    public AdjacencyListGraph(String id, boolean strictChecking, boolean autoCreate) {
        this(id, strictChecking, autoCreate, 128, 1024);
    }

    public AdjacencyListGraph(String id) {
        this(id, true, false);
    }

    @Override
    protected void addEdgeCallback(AbstractEdge edge) {
        this.edgeMap.put(edge.getId(), edge);
        if (this.edgeCount == this.edgeArray.length) {
            AbstractEdge[] tmp = new AbstractEdge[(int)((double)this.edgeArray.length * 1.1) + 1];
            System.arraycopy(this.edgeArray, 0, tmp, 0, this.edgeArray.length);
            Arrays.fill(this.edgeArray, null);
            this.edgeArray = tmp;
        }
        this.edgeArray[this.edgeCount] = edge;
        edge.setIndex(this.edgeCount++);
    }

    @Override
    protected void addNodeCallback(AbstractNode node) {
        this.nodeMap.put(node.getId(), node);
        if (this.nodeCount == this.nodeArray.length) {
            AbstractNode[] tmp = new AbstractNode[(int)((double)this.nodeArray.length * 1.1) + 1];
            System.arraycopy(this.nodeArray, 0, tmp, 0, this.nodeArray.length);
            Arrays.fill(this.nodeArray, null);
            this.nodeArray = tmp;
        }
        this.nodeArray[this.nodeCount] = node;
        node.setIndex(this.nodeCount++);
    }

    @Override
    protected void removeEdgeCallback(AbstractEdge edge) {
        this.edgeMap.remove(edge.getId());
        int i = edge.getIndex();
        this.edgeArray[i] = this.edgeArray[--this.edgeCount];
        this.edgeArray[i].setIndex(i);
        this.edgeArray[this.edgeCount] = null;
    }

    @Override
    protected void removeNodeCallback(AbstractNode node) {
        this.nodeMap.remove(node.getId());
        int i = node.getIndex();
        this.nodeArray[i] = this.nodeArray[--this.nodeCount];
        this.nodeArray[i].setIndex(i);
        this.nodeArray[this.nodeCount] = null;
    }

    @Override
    protected void clearCallback() {
        this.nodeMap.clear();
        this.edgeMap.clear();
        Arrays.fill(this.nodeArray, 0, this.nodeCount, null);
        Arrays.fill(this.edgeArray, 0, this.edgeCount, null);
        this.edgeCount = 0;
        this.nodeCount = 0;
    }

    @Override
    public Stream<Node> nodes() {
        return Arrays.stream(this.nodeArray, 0, this.nodeCount);
    }

    @Override
    public Stream<Edge> edges() {
        return Arrays.stream(this.edgeArray, 0, this.edgeCount);
    }

    @Override
    public Edge getEdge(String id) {
        return this.edgeMap.get(id);
    }

    @Override
    public Edge getEdge(int index) {
        if (index < 0 || index >= this.edgeCount) {
            throw new IndexOutOfBoundsException("Edge " + index + " does not exist");
        }
        return this.edgeArray[index];
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }

    @Override
    public Node getNode(String id) {
        return this.nodeMap.get(id);
    }

    @Override
    public Node getNode(int index) {
        if (index < 0 || index > this.nodeCount) {
            throw new IndexOutOfBoundsException("Node " + index + " does not exist");
        }
        return this.nodeArray[index];
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    protected class EdgeIterator<T extends Edge>
    implements Iterator<T> {
        int iNext = 0;
        int iPrev = -1;

        protected EdgeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iNext < AdjacencyListGraph.this.edgeCount;
        }

        @Override
        public T next() {
            if (this.iNext >= AdjacencyListGraph.this.edgeCount) {
                throw new NoSuchElementException();
            }
            this.iPrev = this.iNext++;
            return (T)AdjacencyListGraph.this.edgeArray[this.iPrev];
        }

        @Override
        public void remove() {
            if (this.iPrev == -1) {
                throw new IllegalStateException();
            }
            AdjacencyListGraph.this.removeEdge(AdjacencyListGraph.this.edgeArray[this.iPrev], true, true, true);
            this.iNext = this.iPrev;
            this.iPrev = -1;
        }
    }

    protected class NodeIterator<T extends Node>
    implements Iterator<T> {
        int iNext = 0;
        int iPrev = -1;

        protected NodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iNext < AdjacencyListGraph.this.nodeCount;
        }

        @Override
        public T next() {
            if (this.iNext >= AdjacencyListGraph.this.nodeCount) {
                throw new NoSuchElementException();
            }
            this.iPrev = this.iNext++;
            return (T)AdjacencyListGraph.this.nodeArray[this.iPrev];
        }

        @Override
        public void remove() {
            if (this.iPrev == -1) {
                throw new IllegalStateException();
            }
            AdjacencyListGraph.this.removeNode(AdjacencyListGraph.this.nodeArray[this.iPrev], true);
            this.iNext = this.iPrev;
            this.iPrev = -1;
        }
    }
}

