/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.modules.releve.editor.BeanPlace;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordInfoPlace;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class RelevePlaceEditor
extends JPanel {
    static String DEFAULT_PLACE = "defaultPlace";
    private final DataManager dataManager;
    private final String defaultPlaceKey;
    private final BeanPlace beanPlace;
    private final String oldValue;
    private boolean isBusy = false;
    private JTextField cityCodeEntry;
    private JLabel cityCodeLabel;
    private JTextField cityNameEntry;
    private JLabel cityNameLabel;
    private JTextField countryEntry;
    private JLabel countryLabel;
    private JTextField countyNameEntry;
    private JLabel countyNameLabel;
    private JButton jButton1;
    private JCheckBox makeDefaultCheckBox;
    private JLabel placeLabel;
    private JPanel placePanel;
    private JTextField stateEntry;
    private JLabel stateLabel;

    public RelevePlaceEditor(DataManager dataManager, AbstractRecord record, RecordInfoPlace place) {
        this.dataManager = dataManager;
        this.defaultPlaceKey = DEFAULT_PLACE + "." + (dataManager.getCurrentFile() == null ? "none" : dataManager.getCurrentFile().getName());
        this.initComponents();
        boolean set = DataManager.getGecomCompletionEnabled();
        this.beanPlace = new BeanPlace(dataManager.getCompletionProvider().getPlaces());
        this.beanPlace.setContext(record, AbstractRecord.FieldType.place);
        this.beanPlace.setName(AbstractRecord.FieldType.place.name());
        this.placePanel.setLayout(new BorderLayout());
        this.placePanel.add(this.beanPlace);
        this.oldValue = place.getValue();
        String defaultPlace = this.getDefaultPlace();
        boolean isDefaultPlace = !defaultPlace.isBlank() && (this.oldValue.equals(RecordInfoPlace.EMPTY) || this.oldValue.equals(defaultPlace));
        this.beanPlace.setText(isDefaultPlace ? defaultPlace : this.oldValue);
        this.makeDefaultCheckBox.setSelected(isDefaultPlace);
        this.cityNameEntry.setText(place.getCityName());
        this.cityCodeEntry.setText(place.getCityCode());
        this.countyNameEntry.setText(place.getCountyName());
        this.stateEntry.setText(place.getStateName());
        this.countryEntry.setText(place.getCountryName());
        this.beanPlace.addDocumentListener(new PlaceStringListener());
        this.cityNameEntry.getDocument().addDocumentListener(new PlaceFieldListener());
        this.cityCodeEntry.getDocument().addDocumentListener(new PlaceFieldListener());
        this.countyNameEntry.getDocument().addDocumentListener(new PlaceFieldListener());
        this.stateEntry.getDocument().addDocumentListener(new PlaceFieldListener());
        this.countryEntry.getDocument().addDocumentListener(new PlaceFieldListener());
    }

    public RecordInfoPlace getPlace() {
        RecordInfoPlace place = new RecordInfoPlace();
        place.setValue(this.cityNameEntry.getText(), this.cityCodeEntry.getText(), this.countyNameEntry.getText(), this.stateEntry.getText(), this.countryEntry.getText());
        return place;
    }

    public void update() {
        this.dataManager.getCompletionProvider().updatePlaces(this.beanPlace.getFieldValue(), this.oldValue);
    }

    private String getDefaultPlace() {
        return NbPreferences.forModule(RelevePlaceEditor.class).get(this.defaultPlaceKey, "");
    }

    public static String getDefaultPlace(DataManager dataManager) {
        String key = DEFAULT_PLACE + "." + (dataManager.getCurrentFile() == null ? "none" : dataManager.getCurrentFile().getName());
        return NbPreferences.forModule(RelevePlaceEditor.class).get(key, "");
    }

    public void setDefaultPlace() {
        String newPlace;
        String defaultPlace = this.getDefaultPlace();
        boolean isSame = defaultPlace.equals(newPlace = this.beanPlace.getText());
        if (isSame && !this.makeDefaultCheckBox.isSelected()) {
            NbPreferences.forModule(RelevePlaceEditor.class).put(this.defaultPlaceKey, "");
        } else if (!isSame && this.makeDefaultCheckBox.isSelected()) {
            NbPreferences.forModule(RelevePlaceEditor.class).put(this.defaultPlaceKey, newPlace);
        }
    }

    private void initComponents() {
        this.placeLabel = new JLabel();
        this.placePanel = new JPanel();
        this.makeDefaultCheckBox = new JCheckBox();
        this.cityNameLabel = new JLabel();
        this.cityNameEntry = new JTextField();
        this.cityCodeLabel = new JLabel();
        this.cityCodeEntry = new JTextField();
        this.countyNameLabel = new JLabel();
        this.countyNameEntry = new JTextField();
        this.stateLabel = new JLabel();
        this.stateEntry = new JTextField();
        this.countryLabel = new JLabel();
        this.countryEntry = new JTextField();
        this.jButton1 = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.placeLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.Title"));
        GroupLayout placePanelLayout = new GroupLayout(this.placePanel);
        this.placePanel.setLayout(placePanelLayout);
        placePanelLayout.setHorizontalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        placePanelLayout.setVerticalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.makeDefaultCheckBox, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.makeDefaultCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.cityNameLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.cityNameLabel.text"));
        this.cityNameLabel.setFocusable(false);
        this.cityNameLabel.setPreferredSize(null);
        this.cityNameLabel.setVerticalTextPosition(1);
        this.cityNameEntry.setName("cityNameEntry");
        this.cityNameEntry.setPreferredSize(null);
        Mnemonics.setLocalizedText((JLabel)this.cityCodeLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.cityCodeLabel.text"));
        this.cityCodeLabel.setFocusable(false);
        this.cityCodeLabel.setPreferredSize(null);
        this.cityCodeEntry.setPreferredSize(null);
        Mnemonics.setLocalizedText((JLabel)this.countyNameLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.countyNameLabel.text"));
        this.countyNameLabel.setFocusable(false);
        this.countyNameLabel.setPreferredSize(null);
        this.countyNameEntry.setPreferredSize(null);
        this.stateLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.stateLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.stateLabel.text"));
        this.stateLabel.setFocusable(false);
        this.stateLabel.setHorizontalTextPosition(2);
        this.stateLabel.setPreferredSize(null);
        this.stateLabel.setRequestFocusEnabled(false);
        this.stateEntry.setPreferredSize(null);
        Mnemonics.setLocalizedText((JLabel)this.countryLabel, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.countryLabel.text"));
        this.countryLabel.setFocusable(false);
        this.countryLabel.setPreferredSize(null);
        this.countryLabel.setRequestFocusEnabled(false);
        this.countryEntry.setPreferredSize(null);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Settings.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePlaceEditor.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.placeLabel).addGap(2, 2, 2).addComponent(this.placePanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stateLabel, -2, -1, -2).addComponent(this.cityCodeLabel, -2, -1, -2).addComponent(this.cityNameLabel, -2, -1, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.makeDefaultCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cityCodeEntry, -1, 202, Short.MAX_VALUE).addComponent(this.stateEntry, -1, 202, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.countryLabel, -2, -1, -2).addGap(2, 2, 2).addComponent(this.countryEntry, -1, 203, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.countyNameLabel, -2, -1, -2).addGap(7, 7, 7).addComponent(this.countyNameEntry, -1, 203, Short.MAX_VALUE)))).addComponent(this.cityNameEntry, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.placePanel, -2, -1, -2).addComponent(this.placeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.makeDefaultCheckBox).addComponent(this.jButton1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cityNameLabel, -2, -1, -2).addComponent(this.cityNameEntry, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.countyNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 42, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cityCodeLabel, -2, -1, -2).addComponent(this.cityCodeEntry, -2, -1, -2).addComponent(this.countyNameEntry, -2, 31, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.stateLabel, -2, -1, -2).addComponent(this.stateEntry, -2, -1, -2).addComponent(this.countryLabel, -2, -1, -2).addComponent(this.countryEntry, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Extensions/Releve");
    }

    private class PlaceStringListener
    implements DocumentListener {
        private PlaceStringListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updatePlaceFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updatePlaceFields();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updatePlaceFields();
        }

        public void updatePlaceFields() {
            if (!RelevePlaceEditor.this.isBusy) {
                RelevePlaceEditor.this.isBusy = true;
                String[] bits = RelevePlaceEditor.this.beanPlace.getText().split(",");
                if (bits.length > 0) {
                    RelevePlaceEditor.this.cityNameEntry.setText(bits[0].trim());
                }
                if (bits.length > 1) {
                    RelevePlaceEditor.this.cityCodeEntry.setText(bits[1].trim());
                }
                if (bits.length > 2) {
                    RelevePlaceEditor.this.countyNameEntry.setText(bits[2].trim());
                }
                if (bits.length > 3) {
                    RelevePlaceEditor.this.stateEntry.setText(bits[3].trim());
                }
                if (bits.length > 4) {
                    RelevePlaceEditor.this.countryEntry.setText(bits[4].trim());
                }
                RelevePlaceEditor.this.makeDefaultCheckBox.setSelected(RelevePlaceEditor.this.getDefaultPlace().equals(RelevePlaceEditor.this.beanPlace.getText()));
                RelevePlaceEditor.this.isBusy = false;
            }
        }
    }

    private class PlaceFieldListener
    implements DocumentListener {
        private PlaceFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updatePlaceField();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updatePlaceField();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updatePlaceField();
        }

        private void updatePlaceField() {
            if (!RelevePlaceEditor.this.isBusy) {
                RelevePlaceEditor.this.isBusy = true;
                StringBuilder value = new StringBuilder();
                value.append(RelevePlaceEditor.this.cityNameEntry.getText());
                value.append(", ");
                value.append(RelevePlaceEditor.this.cityCodeEntry.getText());
                value.append(", ");
                value.append(RelevePlaceEditor.this.countyNameEntry.getText());
                value.append(", ");
                value.append(RelevePlaceEditor.this.stateEntry.getText());
                value.append(", ");
                value.append(RelevePlaceEditor.this.countryEntry.getText());
                RelevePlaceEditor.this.beanPlace.setText(value.toString());
                RelevePlaceEditor.this.isBusy = false;
            }
        }
    }
}

