/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.paramtable;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.paramtable.addins.ParamAddinInterface;

public abstract class HttpPanelParamTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8714941615215038148L;
    private static final Logger LOGGER = LogManager.getLogger(HttpPanelParamTableModel.class);
    private static final String[] columnNames = new String[]{Constant.messages.getString("http.panel.view.tableparam.type"), Constant.messages.getString("http.panel.view.table.paramName"), Constant.messages.getString("http.panel.view.table.paramValue"), Constant.messages.getString("http.panel.view.tableparam.functions")};
    protected HttpMessage httpMessage;
    protected LinkedList<HtmlParameter> allParams = new LinkedList();
    private boolean isEditable;
    private boolean hasChanged;

    @Override
    public int getColumnCount() {
        if (this.isEditable) {
            return 4;
        }
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.allParams.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.allParams.size() || rowIndex < 0) {
            return null;
        }
        HtmlParameter htmlParameter = this.allParams.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return htmlParameter.getType();
            }
            case 1: {
                return htmlParameter.getName();
            }
            case 2: {
                return htmlParameter.getValue();
            }
        }
        return "";
    }

    public Class<String> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        boolean changed = false;
        HtmlParameter htmlParameter = this.allParams.get(row);
        if (col == 0) {
            htmlParameter.setType((HtmlParameter.Type)((Object)value));
            changed = true;
        } else if (col == 1) {
            htmlParameter.setName((String)value);
            changed = true;
        } else if (col == 2) {
            htmlParameter.setValue((String)value);
            changed = true;
        } else if (col == 3 && value instanceof ParamAddinInterface) {
            try {
                htmlParameter.setValue(((ParamAddinInterface)value).convertData(htmlParameter.getValue()));
                changed = true;
                col = 2;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (changed) {
            this.hasChanged = true;
            this.fireTableCellUpdated(row, col);
        }
        if (!(row != this.allParams.size() - 1 || (htmlParameter = this.allParams.getLast()).getName().isEmpty() && htmlParameter.getValue().isEmpty())) {
            this.allParams.add(this.getDefaultHtmlParameter());
            this.fireTableRowsInserted(row + 1, row + 1);
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public void setHttpMessage(HttpMessage ahttpMessage) {
        this.httpMessage = ahttpMessage;
        this.hasChanged = false;
        this.allParams.clear();
        if (this.httpMessage == null) {
            this.fireTableDataChanged();
            return;
        }
        this.loadAllParams();
        if (this.isEditable) {
            this.allParams.add(this.getDefaultHtmlParameter());
        }
        this.fireTableDataChanged();
    }

    public HttpMessage getHttpMessage() {
        return this.httpMessage;
    }

    public void save() {
        if (!this.hasChanged) {
            return;
        }
        this.saveAllParams();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    protected abstract void loadAllParams();

    public abstract void saveAllParams();

    protected abstract HtmlParameter getDefaultHtmlParameter();
}

