/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.opensearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public class NonPruningSortedSetOrdinalsIndexFieldData
extends SortedSetOrdinalsIndexFieldData {
    public NonPruningSortedSetOrdinalsIndexFieldData(IndexFieldDataCache cache, String fieldName, ValuesSourceType valuesSourceType, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(cache, fieldName, valuesSourceType, breakerService, scriptFunction);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        source.disableSkipping();
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || !source.sortMissingLast(missingValue) && !source.sortMissingFirst(missingValue)) {
            return new NonPruningSortField(this, new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse));
        }
        NonPruningSortField sortField = new NonPruningSortField(this, (SortField)new SortedSetSortField(this.getFieldName(), reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN));
        sortField.setMissingValue(source.sortMissingLast(missingValue) ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
        return sortField;
    }

    public final class NonPruningSortField
    extends FilteredSortField {
        private NonPruningSortField(NonPruningSortedSetOrdinalsIndexFieldData this$0, SortField sortField) {
            super(this$0, sortField);
        }

        public static SortField.Type readType(DataInput in) throws IOException {
            return SortField.readType((DataInput)in);
        }

        @Override
        public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
            return this.delegate.getComparator(numHits, Pruning.NONE);
        }

        public SortField getDelegate() {
            return this.delegate;
        }
    }

    public abstract class FilteredSortField
    extends SortField {
        protected final SortField delegate;

        protected FilteredSortField(NonPruningSortedSetOrdinalsIndexFieldData this$0, SortField sortField) {
            super(sortField.getField(), sortField.getType());
            this.delegate = sortField;
        }

        public Object getMissingValue() {
            return this.delegate.getMissingValue();
        }

        public void setMissingValue(Object missingValue) {
            this.delegate.setMissingValue(missingValue);
        }

        public String getField() {
            return this.delegate.getField();
        }

        public SortField.Type getType() {
            return this.delegate.getType();
        }

        public boolean getReverse() {
            return this.delegate.getReverse();
        }

        public FieldComparatorSource getComparatorSource() {
            return this.delegate.getComparatorSource();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void setBytesComparator(Comparator<BytesRef> b) {
            this.delegate.setBytesComparator(b);
        }

        public Comparator<BytesRef> getBytesComparator() {
            return this.delegate.getBytesComparator();
        }

        public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
            return this.delegate.getComparator(numHits, pruning);
        }

        public SortField rewrite(IndexSearcher searcher) throws IOException {
            return this.delegate.rewrite(searcher);
        }

        public boolean needsScores() {
            return this.delegate.needsScores();
        }

        public IndexSorter getIndexSorter() {
            return this.delegate.getIndexSorter();
        }

        @Deprecated
        public void setOptimizeSortWithIndexedData(boolean optimizeSortWithIndexedData) {
            this.delegate.setOptimizeSortWithIndexedData(optimizeSortWithIndexedData);
        }

        @Deprecated
        public boolean getOptimizeSortWithIndexedData() {
            return this.delegate.getOptimizeSortWithIndexedData();
        }

        @Deprecated
        public void setOptimizeSortWithPoints(boolean optimizeSortWithPoints) {
            this.delegate.setOptimizeSortWithPoints(optimizeSortWithPoints);
        }

        @Deprecated
        public boolean getOptimizeSortWithPoints() {
            return this.delegate.getOptimizeSortWithPoints();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this(name, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION, valuesSourceType);
        }

        public Builder(String name, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.scriptFunction = scriptFunction;
            this.valuesSourceType = valuesSourceType;
        }

        public NonPruningSortedSetOrdinalsIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new NonPruningSortedSetOrdinalsIndexFieldData(cache, this.name, this.valuesSourceType, breakerService, this.scriptFunction);
        }
    }
}

