/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

public class PackedInteger {
    public static final int MAX_LENGTH = 5;
    public static final int MAX_LONG_LENGTH = 9;

    public static int readInt(byte[] buf2, int off) {
        int byteLen;
        boolean negative;
        byte b1;
        if ((b1 = buf2[off++]) < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        int value = buf2[off++] & 0xFF;
        if (byteLen > 1) {
            value |= (buf2[off++] & 0xFF) << 8;
            if (byteLen > 2) {
                value |= (buf2[off++] & 0xFF) << 16;
                if (byteLen > 3) {
                    value |= (buf2[off++] & 0xFF) << 24;
                }
            }
        }
        return negative ? -value - 119 : value + 119;
    }

    public static long readLong(byte[] buf2, int off) {
        int byteLen;
        boolean negative;
        byte b1;
        if ((b1 = buf2[off++]) < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        long value = (long)buf2[off++] & 0xFFL;
        if (byteLen > 1) {
            value |= ((long)buf2[off++] & 0xFFL) << 8;
            if (byteLen > 2) {
                value |= ((long)buf2[off++] & 0xFFL) << 16;
                if (byteLen > 3) {
                    value |= ((long)buf2[off++] & 0xFFL) << 24;
                    if (byteLen > 4) {
                        value |= ((long)buf2[off++] & 0xFFL) << 32;
                        if (byteLen > 5) {
                            value |= ((long)buf2[off++] & 0xFFL) << 40;
                            if (byteLen > 6) {
                                value |= ((long)buf2[off++] & 0xFFL) << 48;
                                if (byteLen > 7) {
                                    value |= ((long)buf2[off++] & 0xFFL) << 56;
                                }
                            }
                        }
                    }
                }
            }
        }
        return negative ? -value - 119L : value + 119L;
    }

    public static int getReadIntLength(byte[] buf2, int off) {
        byte b1 = buf2[off];
        if (b1 < -119) {
            return -b1 - 119 + 1;
        }
        if (b1 > 119) {
            return b1 - 119 + 1;
        }
        return 1;
    }

    public static int getReadLongLength(byte[] buf2, int off) {
        return PackedInteger.getReadIntLength(buf2, off);
    }

    public static int writeInt(byte[] buf2, int offset, int value) {
        boolean negative;
        int byte1Off = offset;
        if (value < -119) {
            negative = true;
            value = -value - 119;
        } else if (value > 119) {
            negative = false;
            value -= 119;
        } else {
            buf2[offset++] = (byte)value;
            return offset;
        }
        int n = ++offset;
        ++offset;
        buf2[n] = (byte)value;
        if ((value & 0xFFFFFF00) == 0) {
            buf2[byte1Off] = negative ? -120 : 120;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 8);
        if ((value & 0xFFFF0000) == 0) {
            buf2[byte1Off] = negative ? -121 : 121;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 16);
        if ((value & 0xFF000000) == 0) {
            buf2[byte1Off] = negative ? -122 : 122;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 24);
        buf2[byte1Off] = negative ? -123 : 123;
        return offset;
    }

    public static int writeLong(byte[] buf2, int offset, long value) {
        boolean negative;
        int byte1Off = offset;
        if (value < -119L) {
            negative = true;
            value = -value - 119L;
        } else if (value > 119L) {
            negative = false;
            value -= 119L;
        } else {
            buf2[offset++] = (byte)value;
            return offset;
        }
        int n = ++offset;
        ++offset;
        buf2[n] = (byte)value;
        if ((value & 0xFFFFFFFFFFFFFF00L) == 0L) {
            buf2[byte1Off] = negative ? -120 : 120;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 8);
        if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
            buf2[byte1Off] = negative ? -121 : 121;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 16);
        if ((value & 0xFFFFFFFFFF000000L) == 0L) {
            buf2[byte1Off] = negative ? -122 : 122;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 24);
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            buf2[byte1Off] = negative ? -123 : 123;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 32);
        if ((value & 0xFFFFFF0000000000L) == 0L) {
            buf2[byte1Off] = negative ? -124 : 124;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 40);
        if ((value & 0xFFFF000000000000L) == 0L) {
            buf2[byte1Off] = negative ? -125 : 125;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 48);
        if ((value & 0xFF00000000000000L) == 0L) {
            buf2[byte1Off] = negative ? -126 : 126;
            return offset;
        }
        buf2[offset++] = (byte)(value >>> 56);
        buf2[byte1Off] = negative ? -127 : 127;
        return offset;
    }

    public static int getWriteIntLength(int value) {
        if (value < -119) {
            value = -value - 119;
        } else if (value > 119) {
            value -= 119;
        } else {
            return 1;
        }
        if ((value & 0xFFFFFF00) == 0) {
            return 2;
        }
        if ((value & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((value & 0xFF000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int getWriteLongLength(long value) {
        if (value < -119L) {
            value = -value - 119L;
        } else if (value > 119L) {
            value -= 119L;
        } else {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFFF00L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFFF000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFF0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFF000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        return 9;
    }

    public static int readSortedInt(byte[] buf2, int off) {
        boolean negative;
        int byteLen;
        int b1;
        if ((b1 = buf2[off++] & 0xFF) < 8) {
            byteLen = 8 - b1;
            negative = true;
        } else if (b1 > 247) {
            byteLen = b1 - 247;
            negative = false;
        } else {
            return b1 - 127;
        }
        int value = negative ? -1 : 0;
        if (byteLen > 3) {
            value = value << 8 | buf2[off++] & 0xFF;
        }
        if (byteLen > 2) {
            value = value << 8 | buf2[off++] & 0xFF;
        }
        if (byteLen > 1) {
            value = value << 8 | buf2[off++] & 0xFF;
        }
        value = value << 8 | buf2[off++] & 0xFF;
        value = negative ? (value -= 119) : (value += 121);
        return value;
    }

    public static long readSortedLong(byte[] buf2, int off) {
        boolean negative;
        int byteLen;
        int b1;
        if ((b1 = buf2[off++] & 0xFF) < 8) {
            byteLen = 8 - b1;
            negative = true;
        } else if (b1 > 247) {
            byteLen = b1 - 247;
            negative = false;
        } else {
            return b1 - 127;
        }
        long value = negative ? -1L : 0L;
        if (byteLen > 7) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 6) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 5) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 4) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 3) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 2) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        if (byteLen > 1) {
            value = value << 8 | (long)(buf2[off++] & 0xFF);
        }
        value = value << 8 | (long)(buf2[off++] & 0xFF);
        value = negative ? (value -= 119L) : (value += 121L);
        return value;
    }

    public static int getReadSortedIntLength(byte[] buf2, int off) {
        int b1 = buf2[off] & 0xFF;
        if (b1 < 8) {
            return 9 - b1;
        }
        if (b1 > 247) {
            return 1 + b1 - 247;
        }
        return 1;
    }

    public static int getReadSortedLongLength(byte[] buf2, int off) {
        return PackedInteger.getReadSortedIntLength(buf2, off);
    }

    public static int writeSortedInt(byte[] buf2, int offset, int value) {
        int byte1Off = offset++;
        if (value < -119) {
            if (((value += 119) | 0xFFFFFF) != -1) {
                buf2[offset++] = (byte)(value >> 24);
            }
            if ((value | 0xFFFF) != -1) {
                buf2[offset++] = (byte)(value >> 16);
            }
            if ((value | 0xFF) != -1) {
                buf2[offset++] = (byte)(value >> 8);
            }
            buf2[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf2[byte1Off] = (byte)(8 - valueLen);
        } else if (value > 120) {
            if (((value -= 121) & 0xFF000000) != 0) {
                buf2[offset++] = (byte)(value >> 24);
            }
            if ((value & 0xFFFF0000) != 0) {
                buf2[offset++] = (byte)(value >> 16);
            }
            if ((value & 0xFFFFFF00) != 0) {
                buf2[offset++] = (byte)(value >> 8);
            }
            buf2[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf2[byte1Off] = (byte)(247 + valueLen);
        } else {
            buf2[byte1Off] = (byte)(value + 127);
        }
        return offset;
    }

    public static int writeSortedLong(byte[] buf2, int offset, long value) {
        int byte1Off = offset++;
        if (value < -119L) {
            if (((value += 119L) | 0xFFFFFFFFFFFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 56);
            }
            if ((value | 0xFFFFFFFFFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 48);
            }
            if ((value | 0xFFFFFFFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 40);
            }
            if ((value | 0xFFFFFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 32);
            }
            if ((value | 0xFFFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 24);
            }
            if ((value | 0xFFFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 16);
            }
            if ((value | 0xFFL) != -1L) {
                buf2[offset++] = (byte)(value >> 8);
            }
            buf2[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf2[byte1Off] = (byte)(8 - valueLen);
        } else if (value > 120L) {
            if (((value -= 121L) & 0xFF00000000000000L) != 0L) {
                buf2[offset++] = (byte)(value >> 56);
            }
            if ((value & 0xFFFF000000000000L) != 0L) {
                buf2[offset++] = (byte)(value >> 48);
            }
            if ((value & 0xFFFFFF0000000000L) != 0L) {
                buf2[offset++] = (byte)(value >> 40);
            }
            if ((value & 0xFFFFFFFF00000000L) != 0L) {
                buf2[offset++] = (byte)(value >> 32);
            }
            if ((value & 0xFFFFFFFFFF000000L) != 0L) {
                buf2[offset++] = (byte)(value >> 24);
            }
            if ((value & 0xFFFFFFFFFFFF0000L) != 0L) {
                buf2[offset++] = (byte)(value >> 16);
            }
            if ((value & 0xFFFFFFFFFFFFFF00L) != 0L) {
                buf2[offset++] = (byte)(value >> 8);
            }
            buf2[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf2[byte1Off] = (byte)(247 + valueLen);
        } else {
            buf2[byte1Off] = (byte)(value + 127L);
        }
        return offset;
    }

    public static int getWriteSortedIntLength(int value) {
        if (value < -119) {
            if (((value += 119) | 0xFF) == -1) {
                return 2;
            }
            if ((value | 0xFFFF) == -1) {
                return 3;
            }
            if ((value | 0xFFFFFF) == -1) {
                return 4;
            }
        } else if (value > 120) {
            if (((value -= 121) & 0xFFFFFF00) == 0) {
                return 2;
            }
            if ((value & 0xFFFF0000) == 0) {
                return 3;
            }
            if ((value & 0xFF000000) == 0) {
                return 4;
            }
        } else {
            return 1;
        }
        return 5;
    }

    public static int getWriteSortedLongLength(long value) {
        if (value < -119L) {
            if (((value += 119L) | 0xFFL) == -1L) {
                return 2;
            }
            if ((value | 0xFFFFL) == -1L) {
                return 3;
            }
            if ((value | 0xFFFFFFL) == -1L) {
                return 4;
            }
            if ((value | 0xFFFFFFFFL) == -1L) {
                return 5;
            }
            if ((value | 0xFFFFFFFFFFL) == -1L) {
                return 6;
            }
            if ((value | 0xFFFFFFFFFFFFL) == -1L) {
                return 7;
            }
            if ((value | 0xFFFFFFFFFFFFFFL) == -1L) {
                return 8;
            }
        } else if (value > 120L) {
            if (((value -= 121L) & 0xFFFFFFFFFFFFFF00L) == 0L) {
                return 2;
            }
            if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
                return 3;
            }
            if ((value & 0xFFFFFFFFFF000000L) == 0L) {
                return 4;
            }
            if ((value & 0xFFFFFFFF00000000L) == 0L) {
                return 5;
            }
            if ((value & 0xFFFFFF0000000000L) == 0L) {
                return 6;
            }
            if ((value & 0xFFFF000000000000L) == 0L) {
                return 7;
            }
            if ((value & 0xFF00000000000000L) == 0L) {
                return 8;
            }
        } else {
            return 1;
        }
        return 9;
    }

    public static int readReverseInt(byte[] buf2, int off) {
        int byteLen;
        boolean negative;
        byte b1 = buf2[off];
        if (b1 < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        int value = buf2[--off] & 0xFF;
        if (byteLen > 1) {
            value |= (buf2[--off] & 0xFF) << 8;
            if (byteLen > 2) {
                value |= (buf2[--off] & 0xFF) << 16;
                if (byteLen > 3) {
                    value |= (buf2[--off] & 0xFF) << 24;
                }
            }
        }
        return negative ? -value - 119 : value + 119;
    }

    public static int writeReverseInt(byte[] buf2, int off, int value) {
        int byte1Off;
        boolean negative;
        int nextOff = off + PackedInteger.getWriteIntLength(value);
        if (value < -119) {
            negative = true;
            value = -value - 119;
        } else if (value > 119) {
            negative = false;
            value -= 119;
        } else {
            buf2[off] = (byte)value;
            return off + 1;
        }
        off = byte1Off = nextOff - 1;
        buf2[--off] = (byte)value;
        if ((value & 0xFFFFFF00) == 0) {
            buf2[byte1Off] = negative ? -120 : 120;
            return nextOff;
        }
        buf2[--off] = (byte)(value >>> 8);
        if ((value & 0xFFFF0000) == 0) {
            buf2[byte1Off] = negative ? -121 : 121;
            return nextOff;
        }
        buf2[--off] = (byte)(value >>> 16);
        if ((value & 0xFF000000) == 0) {
            buf2[byte1Off] = negative ? -122 : 122;
            return nextOff;
        }
        buf2[--off] = (byte)(value >>> 24);
        buf2[byte1Off] = negative ? -123 : 123;
        return nextOff;
    }
}

