/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.raw;

import com.sleepycat.persist.raw.RawType;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

public class RawObject {
    private static final String INDENT = "  ";
    private RawType type;
    private Map<String, Object> values;
    private Object[] elements;
    private String enumConstant;
    private RawObject superObject;

    public RawObject(RawType type, Map<String, Object> values2, RawObject superObject) {
        if (type == null || values2 == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.values = values2;
        this.superObject = superObject;
    }

    public RawObject(RawType type, Object[] elements) {
        if (type == null || elements == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.elements = elements;
    }

    public RawObject(RawType type, String enumConstant) {
        if (type == null || enumConstant == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.enumConstant = enumConstant;
    }

    public RawType getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public String getEnum() {
        return this.enumConstant;
    }

    public RawObject getSuper() {
        return this.superObject;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RawObject)) {
            return false;
        }
        RawObject o = (RawObject)other;
        if (this.type != o.type) {
            return false;
        }
        if (!Arrays.deepEquals(this.elements, o.elements)) {
            return false;
        }
        if (this.enumConstant != null ? !this.enumConstant.equals(o.enumConstant) : o.enumConstant != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(o.values) : o.values != null) {
            return false;
        }
        return !(this.superObject != null ? !this.superObject.equals(o.superObject) : o.superObject != null);
    }

    public int hashCode() {
        return System.identityHashCode(this.type) + Arrays.deepHashCode(this.elements) + (this.enumConstant != null ? this.enumConstant.hashCode() : 0) + (this.values != null ? this.values.hashCode() : 0) + (this.superObject != null ? this.superObject.hashCode() : 0);
    }

    public String toString() {
        StringBuilder buf2 = new StringBuilder(500);
        this.formatRawObject(buf2, "", null, false);
        return buf2.toString();
    }

    private void formatRawObject(StringBuilder buf2, String indent, String id, boolean isSuper) {
        if (this.type.isEnum()) {
            buf2.append(indent);
            buf2.append("<Enum");
            RawObject.formatId(buf2, id);
            buf2.append(" class=\"");
            buf2.append(this.type.getClassName());
            buf2.append("\" typeId=\"");
            buf2.append(this.type.getId());
            buf2.append("\">");
            buf2.append(this.enumConstant);
            buf2.append("</Enum>\n");
        } else {
            String endTag;
            String indent2 = indent + INDENT;
            buf2.append(indent);
            if (this.type.isArray()) {
                buf2.append("<Array");
                endTag = "</Array>";
            } else if (isSuper) {
                buf2.append("<Super");
                endTag = "</Super>";
            } else {
                buf2.append("<Object");
                endTag = "</Object>";
            }
            RawObject.formatId(buf2, id);
            if (this.type.isArray()) {
                buf2.append(" length=\"");
                buf2.append(this.elements.length);
                buf2.append('\"');
            }
            buf2.append(" class=\"");
            buf2.append(this.type.getClassName());
            buf2.append("\" typeId=\"");
            buf2.append(this.type.getId());
            buf2.append("\">\n");
            if (this.superObject != null) {
                this.superObject.formatRawObject(buf2, indent2, null, true);
            }
            if (this.type.isArray()) {
                for (int i = 0; i < this.elements.length; ++i) {
                    RawObject.formatValue(buf2, indent2, String.valueOf(i), this.elements[i]);
                }
            } else {
                TreeSet<String> keys = new TreeSet<String>(this.values.keySet());
                for (String name : keys) {
                    RawObject.formatValue(buf2, indent2, name, this.values.get(name));
                }
            }
            buf2.append(indent);
            buf2.append(endTag);
            buf2.append("\n");
        }
    }

    private static void formatValue(StringBuilder buf2, String indent, String id, Object val) {
        if (val == null) {
            buf2.append(indent);
            buf2.append("<Null");
            RawObject.formatId(buf2, id);
            buf2.append("/>\n");
        } else if (val instanceof RawObject) {
            ((RawObject)val).formatRawObject(buf2, indent, id, false);
        } else {
            buf2.append(indent);
            buf2.append("<Value");
            RawObject.formatId(buf2, id);
            buf2.append(" class=\"");
            buf2.append(val.getClass().getName());
            buf2.append("\">");
            buf2.append(val.toString());
            buf2.append("</Value>\n");
        }
    }

    private static void formatId(StringBuilder buf2, String id) {
        if (id != null) {
            if (Character.isDigit(id.charAt(0))) {
                buf2.append(" index=\"");
            } else {
                buf2.append(" field=\"");
            }
            buf2.append(id);
            buf2.append('\"');
        }
    }
}

