/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.EntityResult;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.KeysIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SubIndex;
import java.util.Map;
import java.util.SortedMap;

public class SecondaryIndex<SK, PK, E>
extends BasicIndex<SK, E> {
    private SecondaryDatabase secDb;
    private Database keysDb;
    private PrimaryIndex<PK, E> priIndex;
    private EntityBinding<E> entityBinding;
    private EntityIndex<SK, PK> keysIndex;
    private SortedMap<SK, E> map;

    public SecondaryIndex(SecondaryDatabase database, Database keysDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> secondaryKeyClass, EntryBinding<SK> secondaryKeyBinding) throws DatabaseException {
        super(database, secondaryKeyClass, secondaryKeyBinding, new EntityValueAdapter<E>(primaryIndex.getEntityClass(), primaryIndex.getEntityBinding(), true));
        this.secDb = database;
        this.keysDb = keysDatabase;
        this.priIndex = primaryIndex;
        this.entityBinding = primaryIndex.getEntityBinding();
    }

    @Override
    public SecondaryDatabase getDatabase() {
        return this.secDb;
    }

    public Database getKeysDatabase() {
        return this.keysDb;
    }

    public PrimaryIndex<PK, E> getPrimaryIndex() {
        return this.priIndex;
    }

    public Class<SK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<SK> getKeyBinding() {
        return this.keyBinding;
    }

    public synchronized EntityIndex<SK, PK> keysIndex() throws DatabaseException {
        if (this.keysIndex == null) {
            if (this.keysDb == null) {
                SecondaryConfig config = this.secDb.getConfig();
                config.setReadOnly(true);
                config.setAllowCreate(false);
                config.setExclusiveCreate(false);
                this.keysDb = DbCompat.openDatabase(this.db.getEnvironment(), null, DbCompat.getDatabaseFile(this.secDb), this.secDb.getDatabaseName(), config);
                if (this.keysDb == null) {
                    throw new IllegalStateException("Could not open existing DB, file: " + DbCompat.getDatabaseFile(this.secDb) + " name: " + this.secDb.getDatabaseName());
                }
            }
            this.keysIndex = new KeysIndex(this.keysDb, this.keyClass, this.keyBinding, this.priIndex.getKeyClass(), this.priIndex.getKeyBinding());
        }
        return this.keysIndex;
    }

    public EntityIndex<PK, E> subIndex(SK key) throws DatabaseException {
        return new SubIndex(this, this.entityBinding, key);
    }

    @Override
    public E get(SK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, SK key, LockMode lockMode) throws DatabaseException {
        EntityResult<E> result2 = this.get(txn, key, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result2 != null ? (E)result2.value() : null;
    }

    @Override
    public EntityResult<E> get(Transaction txn, SK key, Get getType, ReadOptions options) throws DatabaseException {
        SecondaryIndex.checkGetType(getType);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationResult result2 = this.secDb.get(txn, keyEntry, pkeyEntry, dataEntry, getType, options);
        if (result2 != null) {
            return new EntityResult<E>(this.entityBinding.entryToObject(pkeyEntry, dataEntry), result2);
        }
        return null;
    }

    @Override
    public Map<SK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<SK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    protected TransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

