/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.util.ConsoleHandler;
import com.sleepycat.je.utilint.ConfiguredRedirectHandler;
import com.sleepycat.je.utilint.ConsoleRedirectHandler;
import com.sleepycat.je.utilint.FileRedirectHandler;
import com.sleepycat.je.utilint.FormatterRedirectHandler;
import com.sleepycat.je.utilint.TracerFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggerUtils {
    static final Map<Thread, EnvironmentImpl> envMap = new ConcurrentHashMap<Thread, EnvironmentImpl>();
    static final Map<Thread, Formatter> formatterMap = new ConcurrentHashMap<Thread, Formatter>();
    public static final String NO_ENV = ".noEnv";
    public static final String FIXED_PREFIX = ".fixedPrefix";
    private static final String PUSH_LEVEL = ".push.level";
    private static final Object fullThreadDumpMutex = new Object();

    public static Logger getLogger(Class<?> cl) {
        Logger logger = LoggerUtils.createLogger(cl.getName());
        boolean hasConsoleHandler = false;
        boolean hasFileHandler = false;
        boolean hasConfiguredHandler = false;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                if (h instanceof java.util.logging.ConsoleHandler) {
                    hasConsoleHandler = true;
                }
                if (h instanceof FileRedirectHandler) {
                    hasFileHandler = true;
                }
                if (!(h instanceof ConfiguredRedirectHandler)) continue;
                hasConfiguredHandler = true;
            }
        }
        if (!hasConsoleHandler) {
            logger.addHandler(new ConsoleRedirectHandler());
        }
        if (!hasFileHandler) {
            logger.addHandler(new FileRedirectHandler());
        }
        if (!hasConfiguredHandler) {
            logger.addHandler(new ConfiguredRedirectHandler());
        }
        return logger;
    }

    public static Logger getLoggerFormatterNeeded(Class<?> cl) {
        Logger logger = LoggerUtils.createLogger(cl.getName() + NO_ENV);
        if (!LoggerUtils.hasConsoleHandler(logger)) {
            logger.addHandler(new FormatterRedirectHandler());
        }
        return logger;
    }

    public static Logger getLoggerFixedPrefix(Class<?> cl, String prefix) {
        return LoggerUtils.getLoggerFixedPrefix(cl, prefix, null);
    }

    public static Logger getLoggerFixedPrefix(Class<?> cl, String prefix, EnvironmentImpl envImpl) {
        Logger logger = LoggerUtils.createLogger(cl.getName() + FIXED_PREFIX);
        if (!LoggerUtils.hasConsoleHandler(logger)) {
            logger.addHandler(new ConsoleHandler(new TracerFormatter(prefix), envImpl));
        }
        return logger;
    }

    private static boolean hasConsoleHandler(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        if (handlers == null) {
            return false;
        }
        for (Handler h : handlers) {
            if (!(h instanceof java.util.logging.ConsoleHandler)) continue;
            return true;
        }
        return false;
    }

    private static Logger createLogger(String className) {
        Logger logger = Logger.getLogger(className);
        logger.setUseParentHandlers(false);
        return logger;
    }

    public static String getLoggerProperty(String property) {
        LogManager mgr = LogManager.getLogManager();
        return mgr.getProperty(property);
    }

    public static Level getPushLevel(String name) {
        String propertyValue = LoggerUtils.getLoggerProperty(name + PUSH_LEVEL);
        Level level = Level.OFF;
        if (propertyValue != null) {
            level = Level.parse(propertyValue);
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(Logger useLogger, EnvironmentImpl envImpl, Level logLevel, String msg) {
        if (envImpl != null) {
            envMap.put(Thread.currentThread(), envImpl);
        }
        try {
            useLogger.log(logLevel, msg);
        }
        finally {
            envMap.remove(Thread.currentThread());
        }
    }

    public static void envLogMsg(Level logLevel, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(envImpl.getLogger(), envImpl, logLevel, msg);
    }

    public static void logMsg(Logger useLogger, EnvironmentImpl envImpl, Formatter formatter, Level logLevel, String msg) {
        if (envImpl != null) {
            LoggerUtils.logMsg(useLogger, envImpl, logLevel, msg);
        } else {
            LoggerUtils.logMsg(useLogger, formatter, logLevel, msg);
        }
    }

    public static void severe(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.SEVERE, msg);
    }

    public static void warning(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.WARNING, msg);
    }

    public static void info(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.INFO, msg);
    }

    public static void fine(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.FINE, msg);
    }

    public static void finer(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.FINER, msg);
    }

    public static void finest(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(Logger useLogger, Formatter formatter, Level logLevel, String msg) {
        if (formatter != null) {
            formatterMap.put(Thread.currentThread(), formatter);
        }
        try {
            useLogger.log(logLevel, msg);
        }
        finally {
            formatterMap.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceAndLogException(EnvironmentImpl envImpl, String sourceClass, String sourceMethod, String msg, Throwable t) {
        String traceMsg = msg + "\n" + LoggerUtils.getStackTrace(t);
        envMap.put(Thread.currentThread(), envImpl);
        try {
            envImpl.getLogger().logp(Level.SEVERE, sourceClass, sourceMethod, traceMsg);
        }
        finally {
            envMap.remove(Thread.currentThread());
        }
        Trace.trace(envImpl, traceMsg);
    }

    public static void traceAndLog(Logger logger, EnvironmentImpl envImpl, Level logLevel, String msg) {
        LoggerUtils.logMsg(logger, envImpl, logLevel, msg);
        Trace.trace(envImpl, msg);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        stackTrace = stackTrace.replaceAll("&lt", "<");
        stackTrace = stackTrace.replaceAll("&gt", ">");
        return stackTrace;
    }

    public static String getStackTrace() {
        Exception e = new Exception();
        return LoggerUtils.getStackTrace(e);
    }

    public static Level getHandlerLevel(DbConfigManager configManager, ConfigParam param2, String levelName) {
        boolean changed = false;
        String level = configManager.get(param2);
        if (!param2.getDefault().equals(level)) {
            changed = true;
        }
        String propertyLevel = LoggerUtils.getLoggerProperty(levelName);
        if (!changed && propertyLevel != null) {
            level = propertyLevel;
        }
        return Level.parse(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullThreadDump(Logger logger, EnvironmentImpl envImpl, Level level) {
        if (!logger.isLoggable(level)) {
            return;
        }
        Object object = fullThreadDumpMutex;
        synchronized (object) {
            if (envImpl != null) {
                if (envImpl.getDidFullThreadDump()) {
                    return;
                }
                envImpl.setDidFullThreadDump(true);
            }
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> stme : stackTraces.entrySet()) {
                LoggerUtils.logMsg(logger, envImpl, level, stme.getKey().toString());
                for (StackTraceElement ste : stme.getValue()) {
                    LoggerUtils.logMsg(logger, envImpl, level, "     " + ste);
                }
            }
        }
    }

    public static String exceptionTypeAndMsg(Exception e) {
        return e.getClass() + " : " + e.getMessage();
    }
}

