/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util.verify;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.util.DbVerifyLog;
import com.sleepycat.je.util.verify.BtreeVerifier;
import com.sleepycat.je.utilint.CronScheduleParser;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.PollCondition;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class DataVerifier {
    private final EnvironmentImpl envImpl;
    private final Timer timer;
    private VerifyTask verifyTask;
    private boolean verifyLog;
    private boolean verifyBtree;
    private final DbVerifyLog dbLogVerifier;
    private final BtreeVerifier dbTreeVerifier;
    private long verifyDelay;
    private long verifyInterval;
    private String cronSchedule;
    private boolean shutdownRequest = false;
    private final String VERIFIER_SCHEDULE = "test.je.env.verifierSchedule";

    public DataVerifier(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.timer = new Timer(envImpl.makeDaemonThreadName("DataCorruptionVerifier"), true);
        this.dbLogVerifier = new DbVerifyLog(envImpl, 0);
        this.dbTreeVerifier = new BtreeVerifier(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configVerifyTask(DbConfigManager configMgr) {
        if (!this.updateConfig(configMgr)) {
            return;
        }
        DataVerifier dataVerifier = this;
        synchronized (dataVerifier) {
            if (!this.shutdownRequest) {
                this.cancel();
                if (this.cronSchedule != null) {
                    this.verifyTask = new VerifyTask(this.envImpl);
                    this.timer.scheduleAtFixedRate((TimerTask)this.verifyTask, this.verifyDelay, this.verifyInterval);
                }
            }
        }
    }

    private void cancel() {
        if (this.verifyTask != null) {
            this.verifyTask.cancel();
        }
        this.dbLogVerifier.setStopVerifyFlag(true);
        this.dbTreeVerifier.setStopVerifyFlag(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShutdown() {
        DataVerifier dataVerifier = this;
        synchronized (dataVerifier) {
            this.shutdownRequest = true;
            this.cancel();
            this.timer.cancel();
        }
    }

    public void shutdown() {
        this.requestShutdown();
        int timeoutMs = 30000;
        PollCondition cond = new PollCondition(2L, 30000L){

            @Override
            protected boolean condition() {
                VerifyTask task = DataVerifier.this.verifyTask;
                return task == null || !task.isRunning;
            }
        };
        if (!cond.await()) {
            LoggerUtils.warning(this.envImpl.getLogger(), this.envImpl, "Unable to shutdown data verifier after 30000ms");
        }
    }

    public long getVerifyDelay() {
        return this.verifyDelay;
    }

    public long getVerifyInterval() {
        return this.verifyInterval;
    }

    public VerifyTask getVerifyTask() {
        return this.verifyTask;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    private boolean updateConfig(DbConfigManager configMgr) {
        if (!configMgr.getBoolean(EnvironmentParams.ENV_RUN_VERIFIER)) {
            if (this.cronSchedule == null) {
                return false;
            }
            this.cronSchedule = null;
            this.verifyDelay = 0L;
            this.verifyInterval = 0L;
            return true;
        }
        String newCronSchedule = configMgr.get(EnvironmentParams.VERIFY_SCHEDULE);
        String sysPropVerifySchedule = System.getProperty("test.je.env.verifierSchedule");
        if (sysPropVerifySchedule != null && !configMgr.isSpecified(EnvironmentParams.VERIFY_SCHEDULE)) {
            newCronSchedule = sysPropVerifySchedule;
        }
        if (CronScheduleParser.checkSame(this.cronSchedule, newCronSchedule)) {
            return false;
        }
        CronScheduleParser csp = new CronScheduleParser(newCronSchedule);
        this.verifyDelay = csp.getDelayTime();
        this.verifyInterval = csp.getInterval();
        this.cronSchedule = newCronSchedule;
        return true;
    }

    class VerifyTask
    extends TimerTask {
        private final EnvironmentImpl envImpl;
        private volatile boolean isRunning;

        VerifyTask(EnvironmentImpl envImpl) {
            this.envImpl = envImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfig() {
            DbConfigManager configMgr = this.envImpl.getConfigManager();
            DataVerifier.this.verifyLog = configMgr.getBoolean(EnvironmentParams.VERIFY_LOG);
            DataVerifier.this.verifyBtree = configMgr.getBoolean(EnvironmentParams.VERIFY_BTREE);
            DataVerifier.this.dbLogVerifier.setReadDelay(configMgr.getDuration(EnvironmentParams.VERIFY_LOG_READ_DELAY), TimeUnit.MILLISECONDS);
            VerifyConfig btreeVerifyConfig = new VerifyConfig();
            btreeVerifyConfig.setVerifySecondaries(configMgr.getBoolean(EnvironmentParams.VERIFY_SECONDARIES));
            btreeVerifyConfig.setVerifyDataRecords(configMgr.getBoolean(EnvironmentParams.VERIFY_DATA_RECORDS));
            btreeVerifyConfig.setVerifyObsoleteRecords(configMgr.getBoolean(EnvironmentParams.VERIFY_OBSOLETE_RECORDS));
            btreeVerifyConfig.setBatchSize(configMgr.getInt(EnvironmentParams.VERIFY_BTREE_BATCH_SIZE));
            btreeVerifyConfig.setBatchDelay(configMgr.getDuration(EnvironmentParams.VERIFY_BTREE_BATCH_DELAY), TimeUnit.MILLISECONDS);
            DataVerifier.this.dbTreeVerifier.setBtreeVerifyConfig(btreeVerifyConfig);
            DataVerifier dataVerifier = DataVerifier.this;
            synchronized (dataVerifier) {
                if (!DataVerifier.this.shutdownRequest) {
                    DataVerifier.this.dbLogVerifier.setStopVerifyFlag(false);
                    DataVerifier.this.dbTreeVerifier.setStopVerifyFlag(false);
                }
            }
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - this.scheduledExecutionTime() >= (long)this.envImpl.getConfigManager().getDuration(EnvironmentParams.VERIFY_MAX_TARDINESS)) {
                return;
            }
            this.isRunning = true;
            boolean success = false;
            this.updateConfig();
            try {
                if (DataVerifier.this.verifyLog) {
                    DataVerifier.this.dbLogVerifier.verifyAll();
                }
                if (DataVerifier.this.verifyBtree) {
                    DataVerifier.this.dbTreeVerifier.verifyAll();
                }
                success = true;
            }
            catch (EnvironmentFailureException environmentFailureException) {
            }
            catch (Throwable e) {
                if (this.envImpl.isValid()) {
                    StoppableThread.handleUncaughtException(this.envImpl.getLogger(), this.envImpl, Thread.currentThread(), e);
                }
            }
            finally {
                if (!success) {
                    DataVerifier.this.requestShutdown();
                }
                this.isRunning = false;
            }
        }
    }
}

