/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util.verify;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryIntegrityException;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.util.verify.VerifierUtils;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatsAccumulator;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.utilint.StringUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BtreeVerifier {
    private static final LockType LOCKTYPE_NOLOCK = LockType.NONE;
    private static final ReadOptions NOLOCK_UNCHANGED = new ReadOptions();
    private static final ReadOptions READLOCK_UNCHANGED = new ReadOptions();
    private final EnvironmentImpl envImpl;
    private final FileManager fileManager;
    private final LogManager logManager;
    private final DbConfigManager configMgr;
    private final Logger logger;
    private final UtilizationProfile up;
    private final FileSizeCache fsCache;
    private final ObsoleteOffsetsCache ooCache;
    private volatile boolean stopVerify = false;
    private VerifyConfig btreeVerifyConfig = new VerifyConfig();
    public static TestHook<Database> databaseOperBeforeBatchCheckHook;
    public static TestHook<Database> databaseOperDuringBatchCheckHook;

    public BtreeVerifier(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.fileManager = envImpl.getFileManager();
        this.configMgr = envImpl.getConfigManager();
        this.logManager = envImpl.getLogManager();
        this.logger = envImpl.getLogger();
        this.up = envImpl.getUtilizationProfile();
        this.fsCache = this.createFileSizeCache();
        this.ooCache = new ObsoleteOffsetsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyAll() throws DatabaseException {
        if (this.stopVerify) {
            return;
        }
        DbTree dbTree = this.envImpl.getDbTree();
        final PrintStream out = this.btreeVerifyConfig.getShowProgressStream() != null ? this.btreeVerifyConfig.getShowProgressStream() : System.err;
        String startMsg = "Start verify all databases";
        String stopMsg = "End verify all databases";
        if (this.btreeVerifyConfig.getPrintInfo()) {
            out.println("Start verify all databases");
        }
        LoggerUtils.envLogMsg(Level.INFO, this.envImpl, "Start verify all databases");
        try {
            this.verifyOneDb(DbType.ID.getInternalName(), DbTree.ID_DB_ID, out, true);
            this.verifyOneDb(DbType.NAME.getInternalName(), DbTree.NAME_DB_ID, out, true);
            class Traversal
            implements CursorImpl.WithCursor {
                Traversal() {
                }

                @Override
                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    if (BtreeVerifier.this.stopVerify) {
                        return false;
                    }
                    NameLN nameLN = (NameLN)cursor.lockAndGetCurrentLN(LOCKTYPE_NOLOCK);
                    if (nameLN != null && !nameLN.isDeleted()) {
                        DatabaseId dbId = nameLN.getId();
                        String dbName = StringUtils.fromUTF8(key.getData());
                        BtreeVerifier.this.verifyOneDb(dbName, dbId, out, true);
                    }
                    return true;
                }
            }
            Traversal traversal = new Traversal();
            CursorImpl.traverseDbWithCursor(dbTree.getNameDatabaseImpl(), LOCKTYPE_NOLOCK, true, traversal);
        }
        finally {
            if (this.btreeVerifyConfig.getPrintInfo()) {
                out.println("End verify all databases");
            }
            LoggerUtils.envLogMsg(Level.INFO, this.envImpl, "End verify all databases");
        }
    }

    public BtreeStats verifyDatabase(String dbName, DatabaseId dbId) {
        PrintStream out = this.btreeVerifyConfig.getShowProgressStream();
        if (out == null) {
            out = System.err;
        }
        return this.verifyOneDb(dbName, dbId, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BtreeStats verifyOneDb(String dbName, DatabaseId dbId, PrintStream out, boolean verifyAll) {
        String startMsg = "Start verify database: " + dbName;
        String stopMsg = "End verify database: " + dbName;
        if (this.btreeVerifyConfig.getPrintInfo()) {
            out.println(startMsg);
        }
        if (!verifyAll) {
            LoggerUtils.envLogMsg(Level.INFO, this.envImpl, startMsg);
        }
        try {
            int batchSize = this.btreeVerifyConfig.getBatchSize();
            long batchDelay = this.btreeVerifyConfig.getBatchDelay(TimeUnit.MILLISECONDS);
            VerifierStatsAccumulator statsAcc = new VerifierStatsAccumulator(out, this.btreeVerifyConfig.getShowProgressInterval());
            this.envImpl.checkOpen();
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl dbImpl = dbTree.getDb(dbId);
            boolean isSecondaryDb = false;
            SecondaryDatabase secDb = null;
            Database priDb = null;
            try {
                if (dbImpl == null || dbImpl.isDeleted()) {
                    BtreeStats btreeStats = new BtreeStats();
                    return btreeStats;
                }
                Set<Database> referringHandles = dbImpl.getReferringHandles();
                Iterator<Database> iterator = referringHandles.iterator();
                while (iterator.hasNext()) {
                    Database db;
                    priDb = db = iterator.next();
                    if (!(db instanceof SecondaryDatabase)) continue;
                    isSecondaryDb = true;
                    secDb = (SecondaryDatabase)db;
                    priDb = null;
                    break;
                }
            }
            finally {
                dbTree.releaseDb(dbImpl);
            }
            DatabaseEntry lastKey = null;
            DatabaseEntry lastData = null;
            while (true) {
                this.envImpl.checkOpen();
                dbTree = this.envImpl.getDbTree();
                dbImpl = dbTree.getDb(dbId);
                try {
                    if (this.stopVerify || dbImpl == null || dbImpl.isDeleted()) break;
                    if (databaseOperBeforeBatchCheckHook != null) {
                        if (priDb != null) {
                            databaseOperBeforeBatchCheckHook.doHook(priDb);
                        } else {
                            databaseOperBeforeBatchCheckHook.doHook(secDb);
                        }
                    }
                    WalkDatabaseTreeResult result2 = this.walkDatabaseTree(dbImpl, isSecondaryDb, priDb, secDb, statsAcc, lastKey, lastData, batchSize);
                    if (result2.noMoreRecords) break;
                    lastKey = result2.lastKey;
                    lastData = result2.lastData;
                }
                finally {
                    dbTree.releaseDb(dbImpl);
                }
                if (batchDelay <= 0L) continue;
                try {
                    Thread.sleep(batchDelay);
                }
                catch (InterruptedException e) {
                    throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
                }
            }
            BtreeStats stats = new BtreeStats();
            stats.setDbImplStats(statsAcc.getStats());
            if (this.btreeVerifyConfig.getPrintInfo()) {
                out.print(stats);
            }
            BtreeStats btreeStats = stats;
            return btreeStats;
        }
        catch (BtreeVerificationException bve) {
            if (bve.getCause() instanceof ChecksumException) {
                throw VerifierUtils.createMarkerFileFromException(RestoreRequired.FailureType.LOG_CHECKSUM, bve.getCause(), this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM);
            }
            throw VerifierUtils.createMarkerFileFromException(RestoreRequired.FailureType.BTREE_CORRUPTION, bve, this.envImpl, EnvironmentFailureReason.BTREE_CORRUPTION);
        }
        finally {
            if (this.btreeVerifyConfig.getPrintInfo()) {
                out.println(stopMsg);
            }
            if (!verifyAll) {
                LoggerUtils.envLogMsg(Level.INFO, this.envImpl, stopMsg);
            }
        }
    }

    private void basicBtreeVerify(Node node) {
        if (node.isUpperIN()) {
            this.verifyDanglingLSNAndObsoleteRecordsAllSlots(node);
        }
        this.verifyCommonStructure(node);
    }

    private void verifyCommonStructure(Node node) {
        assert (node.isIN());
        IN in = (IN)node;
        this.verifyOrderedKeys(in);
        this.verifyIdentifierKey(in);
    }

    private int verifyOrderedKeysInternal(IN in, DatabaseImpl dbImpl) {
        Comparator<byte[]> userCompareToFcn = dbImpl.getKeyComparator();
        for (int i = 1; i < in.getNEntries(); ++i) {
            byte[] key2;
            byte[] key1 = in.getKey(i);
            int s = Key.compareKeys(key1, key2 = in.getKey(i - 1), userCompareToFcn);
            if (s > 0) continue;
            return i;
        }
        return 0;
    }

    private void verifyOrderedKeys(IN in) {
        DatabaseImpl dbImpl = in.getDatabase();
        int corruptIndex = this.verifyOrderedKeysInternal(in, dbImpl);
        if (corruptIndex == 0) {
            return;
        }
        Pair<Long, Long> targetLsns = this.getTargetLsns(in);
        String label = "IN keys are out of order. ";
        String msg1 = "IN keys are out of order. " + in.toSafeString(corruptIndex - 1, corruptIndex);
        IN inFromFile = this.getINFromFile(targetLsns, dbImpl, msg1);
        try {
            int newCorruptIndex = this.verifyOrderedKeysInternal(inFromFile, dbImpl);
            if (newCorruptIndex == 0) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, this.transientMsg(msg1));
            }
            String msg2 = "IN keys are out of order. " + inFromFile.toSafeString(newCorruptIndex - 1, newCorruptIndex);
            throw new BtreeVerificationException(this.persistentMsg(msg2));
        }
        catch (Throwable throwable) {
            inFromFile.releaseLatchIfOwner();
            throw throwable;
        }
    }

    private void verifyIdentifierKey(IN in) {
        DatabaseImpl dbImpl = in.getDatabase();
        if (this.verifyIdentifierKeyInternal(in, dbImpl)) {
            return;
        }
        Pair<Long, Long> targetLsns = this.getTargetLsns(in);
        String label = "IdentifierKey not present in any slot. ";
        String msg1 = "IdentifierKey not present in any slot. " + in.toSafeString(null);
        IN inFromFile = this.getINFromFile(targetLsns, dbImpl, msg1);
        try {
            if (this.verifyIdentifierKeyInternal(inFromFile, dbImpl)) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, this.transientMsg(msg1));
            }
            String msg2 = "IdentifierKey not present in any slot. " + inFromFile.toSafeString(null);
            throw new BtreeVerificationException(this.persistentMsg(msg2));
        }
        catch (Throwable throwable) {
            inFromFile.releaseLatchIfOwner();
            throw throwable;
        }
    }

    private boolean verifyIdentifierKeyInternal(IN in, DatabaseImpl dbImpl) {
        if (in.isUpperIN() || in.isBINDelta() || in.getNEntries() == 0) {
            return true;
        }
        byte[] identifierKey = in.getIdentifierKey();
        if (identifierKey == null) {
            return false;
        }
        if (this.envImpl.getDbTree().getInitialLogVersion() < 15) {
            return true;
        }
        Comparator<byte[]> userCompareToFcn = dbImpl.getKeyComparator();
        for (int i = 0; i < in.getNEntries(); ++i) {
            byte[] key = in.getKey(i);
            if (Key.compareKeys(identifierKey, key, userCompareToFcn) != 0) continue;
            return true;
        }
        return false;
    }

    private void verifyDanglingLSNAndObsoleteRecordsAllSlots(Node node) {
        assert (node.isUpperIN());
        IN in = (IN)node;
        for (int i = 0; i < in.getNEntries(); ++i) {
            this.verifyDanglingLSNAndObsoleteRecordsOneSlot(i, in, false);
        }
    }

    private void verifyDanglingLSNAndObsoleteRecordsOneSlot(int index, IN in, boolean isBin) {
        if (isBin && ((BIN)in).isDefunct(index)) {
            return;
        }
        this.verifyDanglingLSN(index, in, isBin);
        this.verifyObsoleteRecords(index, in, isBin);
    }

    private void verifyDanglingLSN(int index, IN in, boolean isBin) {
        if (this.envImpl.isMemOnly()) {
            return;
        }
        DatabaseImpl dbImpl = in.getDatabase();
        DanglingLSNCheckResult result2 = this.verifyDanglingLSNInternal(index, in, isBin, dbImpl);
        if (result2.problematicIndex < 0) {
            return;
        }
        Pair<Long, Long> targetLsns = this.getTargetLsns(in);
        String label = "LSN is invalid. ";
        String msg1 = "LSN is invalid. " + result2.getReason() + in.toSafeString(result2.problematicIndex);
        IN inFromFile = this.getINFromFile(targetLsns, dbImpl, msg1);
        try {
            boolean findAgain = false;
            for (int i = 0; i < inFromFile.getNEntries(); ++i) {
                result2 = this.verifyDanglingLSNInternal(i, inFromFile, isBin, dbImpl);
                if (result2.problematicIndex < 0) continue;
                findAgain = true;
                break;
            }
            if (!findAgain) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, this.transientMsg(msg1));
            }
            String msg2 = "LSN is invalid. " + result2.getReason() + inFromFile.toSafeString(result2.problematicIndex);
            throw new BtreeVerificationException(this.persistentMsg(msg2));
        }
        catch (Throwable throwable) {
            inFromFile.releaseLatchIfOwner();
            throw throwable;
        }
    }

    private DanglingLSNCheckResult verifyDanglingLSNInternal(int index, IN in, boolean isBin, DatabaseImpl databaseImpl) {
        if (isBin && (in.isEmbeddedLN(index) || databaseImpl.getSortedDuplicates() || databaseImpl.isLNImmediatelyObsolete() || ((BIN)in).isDefunct(index))) {
            return DanglingLSNCheckResult.NO_DANGLING_LSN;
        }
        long curLsn = in.getLsn(index);
        if (DbLsn.isTransientOrNull(curLsn)) {
            return DanglingLSNCheckResult.NO_DANGLING_LSN;
        }
        long fileNum = DbLsn.getFileNumber(curLsn);
        long fileOffset = DbLsn.getFileOffset(curLsn);
        int lastLoggedSize = in.getLastLoggedSize(index);
        FileSizeInfo fsInfo = this.getFileSize(fileNum);
        if (fileOffset + (long)lastLoggedSize > (long)fsInfo.size) {
            if (fsInfo.size == -1) {
                return new DanglingLSNCheckResult(index, true, fsInfo);
            }
            return new DanglingLSNCheckResult(index, false, fsInfo);
        }
        return DanglingLSNCheckResult.NO_DANGLING_LSN;
    }

    private FileSizeInfo getFileSize(long fileNum) {
        long nextLsn = this.fileManager.getNextLsn();
        if (fileNum == DbLsn.getFileNumber(nextLsn)) {
            return new FileSizeInfo(true, false, (int)DbLsn.getFileOffset(nextLsn));
        }
        Pair<Boolean, Integer> result2 = this.fsCache.getFileSize(fileNum);
        return new FileSizeInfo(false, result2.first(), result2.second());
    }

    private FileSizeCache createFileSizeCache() {
        boolean USE_UP = false;
        return new DirectFileSizeCache();
    }

    private void verifyObsoleteRecords(int index, IN in, boolean isBin) {
        if (!this.btreeVerifyConfig.getVerifyObsoleteRecords()) {
            return;
        }
        DatabaseImpl databaseImpl = in.getDatabase();
        if (isBin && (in.isEmbeddedLN(index) || databaseImpl.getSortedDuplicates() || databaseImpl.isLNImmediatelyObsolete())) {
            return;
        }
        long curLsn = in.getLsn(index);
        long fileNum = DbLsn.getFileNumber(curLsn);
        long[] offsets = this.ooCache.getOffsets(fileNum);
        if (Arrays.binarySearch(offsets, DbLsn.getFileOffset(curLsn)) >= 0) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION_FATAL, "Active lsn is obsolete: " + DbLsn.getNoFormatString(curLsn) + in.toSafeString(index));
        }
    }

    private String persistentMsg(String msg) {
        return "Btree corruption was detected and is persistent. Re-opening the Environment is not possible without restoring from backup  or from another node. " + msg;
    }

    private String transientMsg(String msg) {
        return "Btree corruption was detected in memory, but does not appearto be persistent. Re-opening the Environment may be possible. " + msg;
    }

    private Pair<Long, Long> getTargetLsns(IN in) {
        long targetLsn1;
        long targetLsn2 = -1L;
        if (in.isUpperIN()) {
            targetLsn1 = in.getLastFullLsn();
            targetLsn2 = -1L;
        } else {
            BIN bin = (BIN)in;
            long lastDeltaVersion = bin.getLastDeltaLsn();
            if (lastDeltaVersion == -1L) {
                targetLsn1 = bin.getLastFullLsn();
            } else {
                targetLsn1 = lastDeltaVersion;
                targetLsn2 = bin.getLastFullLsn();
            }
        }
        return new Pair<Long, Long>(targetLsn1, targetLsn2);
    }

    private IN getINFromFile(Pair<Long, Long> targetLsns, DatabaseImpl dbImpl, String msg) {
        WholeEntry entry;
        WholeEntry optionalFullBinEntry = null;
        try {
            entry = this.logManager.getLogEntryDirectFromFile(targetLsns.first());
            if (targetLsns.second() != -1L) {
                optionalFullBinEntry = this.logManager.getLogEntryDirectFromFile(targetLsns.second());
            }
            if (entry == null && optionalFullBinEntry == null) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, this.transientMsg(msg));
            }
        }
        catch (ChecksumException ce) {
            throw new BtreeVerificationException(null, ce);
        }
        IN inFromFile = null;
        if (entry != null) {
            inFromFile = (IN)entry.getEntry().getMainItem();
        }
        if (optionalFullBinEntry != null) {
            BIN optionalFullBin = (BIN)optionalFullBinEntry.getEntry().getMainItem();
            if (inFromFile != null) {
                ((BIN)inFromFile).reconstituteBIN(dbImpl, optionalFullBin, false);
            }
            inFromFile = optionalFullBin;
        }
        inFromFile.latchNoUpdateLRU(dbImpl);
        return inFromFile;
    }

    private boolean findFirstRecord(DatabaseImpl dbImpl, Cursor cursor, DatabaseEntry lastKey, DatabaseEntry lastData) {
        DatabaseEntry usedKey = new DatabaseEntry();
        DatabaseEntry usedData = new DatabaseEntry();
        if (lastKey == null) {
            return cursor.get(usedKey, usedData, Get.FIRST, NOLOCK_UNCHANGED) != null;
        }
        usedKey = new DatabaseEntry(lastKey.getData(), lastKey.getOffset(), lastKey.getSize());
        usedData = new DatabaseEntry(lastData.getData(), lastData.getOffset(), lastData.getSize());
        boolean isDuplicated = dbImpl.getSortedDuplicates();
        OperationResult result2 = null;
        if (isDuplicated) {
            result2 = cursor.get(usedKey, usedData, Get.SEARCH_BOTH_GTE, NOLOCK_UNCHANGED);
            if (result2 != null) {
                if (!usedData.equals(lastData)) {
                    return true;
                }
                return cursor.get(usedKey, usedData, Get.NEXT, NOLOCK_UNCHANGED) != null;
            }
            result2 = cursor.get(usedKey, usedData, Get.SEARCH_GTE, NOLOCK_UNCHANGED);
            if (result2 == null) {
                return false;
            }
            if (!usedKey.equals(lastKey)) {
                return true;
            }
            return cursor.get(usedKey, usedData, Get.NEXT_NO_DUP, NOLOCK_UNCHANGED) != null;
        }
        result2 = cursor.get(usedKey, usedData, Get.SEARCH_GTE, NOLOCK_UNCHANGED);
        if (result2 == null) {
            return false;
        }
        if (!usedKey.equals(lastKey)) {
            return true;
        }
        return cursor.get(usedKey, usedData, Get.NEXT, NOLOCK_UNCHANGED) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WalkDatabaseTreeResult walkDatabaseTree(DatabaseImpl dbImpl, boolean isSecondaryDb, Database priDb, SecondaryDatabase secDb, TreeWalkerStatsAccumulator statsAcc, DatabaseEntry lastKey, DatabaseEntry lastData, int batchSize) {
        Tree tree = dbImpl.getTree();
        EnvironmentImpl.incThreadLocalReferenceCount();
        Locker locker = LockerFactory.getInternalReadOperationLocker(this.envImpl);
        Cursor cursor = DbInternal.makeCursor(dbImpl, locker, null, false);
        CursorImpl cursorImpl = DbInternal.getCursorImpl(cursor);
        cursorImpl.setTreeStatsAccumulator(statsAcc);
        tree.setTreeStatsAccumulator(statsAcc);
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        try {
            WalkDatabaseTreeResult walkDatabaseTreeResult;
            boolean verifyPrimaryDataRecords = priDb != null && this.btreeVerifyConfig.getVerifySecondaries() && this.btreeVerifyConfig.getVerifyDataRecords();
            boolean verifySecondary = isSecondaryDb && this.btreeVerifyConfig.getVerifySecondaries();
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            if (!(verifySecondary || priDb != null && this.btreeVerifyConfig.getVerifyDataRecords())) {
                foundData.setPartial(0, 0, true);
            }
            if (!this.findFirstRecord(dbImpl, cursor, lastKey, lastData)) {
                WalkDatabaseTreeResult walkDatabaseTreeResult2 = WalkDatabaseTreeResult.NO_MORE_RECORDS;
                return walkDatabaseTreeResult2;
            }
            int recordCount = 0;
            while (++recordCount <= batchSize) {
                if (this.stopVerify) {
                    walkDatabaseTreeResult = WalkDatabaseTreeResult.NO_MORE_RECORDS;
                    return walkDatabaseTreeResult;
                }
                if (!isSecondaryDb || !verifySecondary) {
                    if (recordCount == 1) {
                        cursor.get(foundKey, foundData, Get.CURRENT, NOLOCK_UNCHANGED);
                    }
                } else {
                    OperationResult result2 = cursor.get(foundKey, foundData, Get.CURRENT, READLOCK_UNCHANGED);
                    if (result2 == null) {
                        throw new MoveToNextRecordException();
                    }
                }
                cursorImpl.latchBIN();
                BIN bin = cursorImpl.getBIN();
                try {
                    this.verifyDanglingLSNAndObsoleteRecordsOneSlot(cursorImpl.getIndex(), bin, true);
                }
                finally {
                    cursorImpl.releaseBIN();
                }
                if (databaseOperDuringBatchCheckHook != null) {
                    if (priDb != null) {
                        databaseOperDuringBatchCheckHook.doHook(priDb);
                    } else {
                        databaseOperDuringBatchCheckHook.doHook(secDb);
                    }
                }
                if (verifySecondary) {
                    if (DbInternal.isCorrupted(secDb)) {
                        WalkDatabaseTreeResult walkDatabaseTreeResult3 = WalkDatabaseTreeResult.NO_MORE_RECORDS;
                        return walkDatabaseTreeResult3;
                    }
                    this.verifyIndex(dbImpl, secDb, cursor, foundKey, foundData);
                    this.verifyForeignConstraint(secDb, cursor, foundKey, dbCache);
                }
                if (verifyPrimaryDataRecords) {
                    this.verifyPrimaryData(dbImpl, priDb, cursor, dbCache);
                }
                if (recordCount == batchSize - 1) {
                    foundData = new DatabaseEntry();
                }
                if (recordCount == batchSize) break;
                if (cursor.get(foundKey, foundData, Get.NEXT, NOLOCK_UNCHANGED) != null) continue;
                WalkDatabaseTreeResult walkDatabaseTreeResult4 = WalkDatabaseTreeResult.NO_MORE_RECORDS;
                return walkDatabaseTreeResult4;
            }
            walkDatabaseTreeResult = new WalkDatabaseTreeResult(foundKey, foundData, false);
            return walkDatabaseTreeResult;
        }
        finally {
            cursorImpl.setTreeStatsAccumulator(null);
            tree.setTreeStatsAccumulator(null);
            EnvironmentImpl.decThreadLocalReferenceCount();
            cursor.close();
            locker.operationEnd();
            this.envImpl.getDbTree().releaseDbs(dbCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyIndex(DatabaseImpl dbImpl, SecondaryDatabase secDb, Cursor cursor, DatabaseEntry key, DatabaseEntry priKey) throws StopDbVerificationException {
        assert (secDb != null);
        try {
            dbImpl.getEnv().getSecondaryAssociationLock().readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(dbImpl.getEnv(), (Throwable)e);
        }
        try {
            SecondaryAssociation secAssoc = DbInternal.getSecondaryAssociation(secDb);
            if (secAssoc.isEmpty()) {
                return;
            }
            Database priDb = secAssoc.getPrimary(priKey);
            if (priDb == null) {
                return;
            }
            DatabaseEntry priData = new DatabaseEntry();
            priData.setPartial(0, 0, true);
            Locker locker = LockerFactory.getInternalReadOperationLocker(this.envImpl);
            locker.setDefaultNoWait(true);
            try {
                DbInternal.readPrimaryAfterGet(cursor, priDb, key, priKey, priData, LockMode.DEFAULT, false, false, true, locker, secDb, secAssoc);
                return;
            }
            catch (LockNotAvailableException lockNotAvailableException) {
                return;
            }
            finally {
                locker.operationEnd();
            }
        }
        catch (SecondaryIntegrityException sie) {
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.WARNING, "Secondary corruption is detected during btree verification. " + sie);
            throw new StopDbVerificationException();
        }
        catch (IllegalStateException ise) {
            throw new StopDbVerificationException();
        }
        finally {
            dbImpl.getEnv().getSecondaryAssociationLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void verifyForeignConstraint(SecondaryDatabase secDb, Cursor cursor, DatabaseEntry secKey, Map<DatabaseId, DatabaseImpl> dbCache) throws StopDbVerificationException {
        block27: {
            DatabaseId foreignDbId;
            assert (secDb != null);
            Database foreignDb = DbInternal.getPrivateSecondaryConfig(secDb).getForeignKeyDatabase();
            if (foreignDb == null) {
                return;
            }
            try {
                foreignDbId = DbInternal.getDbImpl(foreignDb).getId();
            }
            catch (OperationFailureException | IllegalStateException e) {
                throw new StopDbVerificationException();
            }
            this.envImpl.checkOpen();
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl foreignDbImpl = dbTree.getDb(foreignDbId, -1L, dbCache);
            if (foreignDbImpl == null || foreignDbImpl.isDeleted()) {
                throw new StopDbVerificationException();
            }
            DatabaseEntry tmpData = new DatabaseEntry();
            tmpData.setPartial(0, 0, true);
            Locker locker = LockerFactory.getInternalReadOperationLocker(this.envImpl);
            locker.setDefaultNoWait(true);
            try (Cursor foreignCursor = DbInternal.makeCursor(foreignDbImpl, locker, null, true);){
                OperationResult result22;
                try {
                    result22 = foreignCursor.get(secKey, tmpData, Get.SEARCH, READLOCK_UNCHANGED);
                }
                catch (LockNotAvailableException lnae) {
                    locker.operationEnd();
                    if (foreignCursor != null) {
                        if (var12_13 != null) {
                            try {
                                foreignCursor.close();
                            }
                            catch (Throwable throwable) {
                                var12_13.addSuppressed(throwable);
                            }
                        } else {
                            foreignCursor.close();
                        }
                    }
                    return;
                    catch (Throwable throwable) {
                        locker.operationEnd();
                        throw throwable;
                    }
                }
                locker.operationEnd();
                if (result22 != null) break block27;
                this.setSecondaryDbCorrupt(secDb, DbInternal.getCursorImpl(cursor).getLocker(), "Secondary key does not exist in foreign database " + DbInternal.getDbDebugName(foreignDb), secKey, null, DbInternal.getCursorImpl(cursor).getExpirationTime());
            }
            throw new StopDbVerificationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyPrimaryData(DatabaseImpl dbImpl, Database priDb, Cursor cursor, Map<DatabaseId, DatabaseImpl> dbCache) {
        assert (priDb != null);
        try {
            dbImpl.getEnv().getSecondaryAssociationLock().readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(dbImpl.getEnv(), (Throwable)e);
        }
        try {
            SecondaryAssociation secAssoc = DbInternal.getSecondaryAssociation(priDb);
            if (secAssoc.isEmpty()) {
                return;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            try {
                if (cursor.get(key, data, Get.CURRENT, READLOCK_UNCHANGED) == null) {
                    return;
                }
            }
            catch (LockConflictException e) {
                return;
            }
            for (SecondaryDatabase secDb : secAssoc.getSecondaries(key)) {
                try {
                    if (secAssoc.getPrimary(key) != priDb) {
                        return;
                    }
                }
                catch (Exception e) {
                    return;
                }
                if (secDb.isIncrementalPopulationEnabled()) continue;
                this.checkSecondaryKeysExist(priDb, secDb, key, data, dbCache, secAssoc, DbInternal.getCursorImpl(cursor).getExpirationTime());
            }
        }
        finally {
            dbImpl.getEnv().getSecondaryAssociationLock().readLock().unlock();
        }
    }

    private void checkSecondaryKeysExist(Database priDb, SecondaryDatabase secDb, DatabaseEntry priKey, DatabaseEntry priData, Map<DatabaseId, DatabaseImpl> dbCache, SecondaryAssociation secAssoc, long expirationTime) {
        DatabaseId secDbId;
        if (DbInternal.isCorrupted(secDb)) {
            return;
        }
        SecondaryConfig secondaryConfig = DbInternal.getPrivateSecondaryConfig(secDb);
        SecondaryKeyCreator keyCreator = secondaryConfig.getKeyCreator();
        SecondaryMultiKeyCreator multiKeyCreator = secondaryConfig.getMultiKeyCreator();
        if (keyCreator == null && multiKeyCreator == null) {
            assert (priDb.getConfig().getReadOnly());
            return;
        }
        try {
            secDbId = DbInternal.getDbImpl(secDb).getId();
        }
        catch (OperationFailureException | IllegalStateException e) {
            return;
        }
        this.envImpl.checkOpen();
        DbTree dbTree = this.envImpl.getDbTree();
        DatabaseImpl secDbImpl = dbTree.getDb(secDbId, -1L, dbCache);
        if (secDbImpl == null || secDbImpl.isDeleted()) {
            return;
        }
        String errMsg = "Secondary is corrupt: the primary record contains a key that is not present in this secondary database.";
        if (keyCreator != null) {
            assert (multiKeyCreator == null);
            DatabaseEntry secKey = new DatabaseEntry();
            if (!keyCreator.createSecondaryKey(secDb, priKey, priData, secKey)) {
                return;
            }
            this.checkOneSecondaryKeyExists(secDb, secDbImpl, priKey, secKey, expirationTime, "Secondary is corrupt: the primary record contains a key that is not present in this secondary database.", priDb, secAssoc);
            return;
        }
        HashSet<DatabaseEntry> secKeys = new HashSet<DatabaseEntry>();
        multiKeyCreator.createSecondaryKeys(secDb, priKey, priData, secKeys);
        if (secKeys.isEmpty()) {
            return;
        }
        for (DatabaseEntry secKey : secKeys) {
            if (this.checkOneSecondaryKeyExists(secDb, secDbImpl, priKey, secKey, expirationTime, "Secondary is corrupt: the primary record contains a key that is not present in this secondary database.", priDb, secAssoc)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOneSecondaryKeyExists(SecondaryDatabase secDb, DatabaseImpl secDbImpl, DatabaseEntry priKey, DatabaseEntry secKey, long expirationTime, String errMsg, Database priDb, SecondaryAssociation secAssoc) {
        block29: {
            Locker locker = LockerFactory.getInternalReadOperationLocker(this.envImpl);
            try {
                boolean bl;
                try (Cursor checkCursor = DbInternal.makeCursor(secDbImpl, locker, null, false);){
                    if (checkCursor.get(secKey, priKey, Get.SEARCH_BOTH, NOLOCK_UNCHANGED) != null) break block29;
                    try {
                        if (secAssoc.getPrimary(priKey) != priDb || secDb.isIncrementalPopulationEnabled()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    catch (Exception e) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    this.setSecondaryDbCorrupt(secDb, locker, errMsg, secKey, priKey, expirationTime);
                    bl = false;
                }
                return bl;
            }
            finally {
                locker.operationEnd();
            }
        }
        return true;
    }

    private void setSecondaryDbCorrupt(SecondaryDatabase secDb, Locker locker, String errMsg, DatabaseEntry secKey, DatabaseEntry priKey, long expirationTime) {
        if (!DbInternal.isCorrupted(secDb)) {
            SecondaryIntegrityException sie = new SecondaryIntegrityException(secDb, locker, errMsg, DbInternal.getDbDebugName(secDb), secKey, priKey, expirationTime);
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.WARNING, "Secondary corruption is detected during btree verification. " + sie);
        }
    }

    void setStopVerifyFlag(boolean val) {
        this.stopVerify = val;
    }

    public void setBtreeVerifyConfig(VerifyConfig btreeVerifyConfig) {
        this.btreeVerifyConfig = btreeVerifyConfig;
    }

    static {
        NOLOCK_UNCHANGED.setCacheMode(CacheMode.UNCHANGED);
        NOLOCK_UNCHANGED.setLockMode(LockMode.READ_UNCOMMITTED);
        READLOCK_UNCHANGED.setCacheMode(CacheMode.UNCHANGED);
        READLOCK_UNCHANGED.setLockMode(LockMode.DEFAULT);
    }

    private static class BtreeVerificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BtreeVerificationException(String message) {
            super(message);
        }

        public BtreeVerificationException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }
    }

    private static class MoveToNextRecordException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private MoveToNextRecordException() {
        }
    }

    private static class StopDbVerificationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private StopDbVerificationException() {
        }
    }

    private class VerifierStatsAccumulator
    extends StatsAccumulator {
        VerifierStatsAccumulator(PrintStream progressStream, int progressInterval) {
            super(progressStream, progressInterval);
        }

        @Override
        public void verifyNode(Node node) {
            BtreeVerifier.this.basicBtreeVerify(node);
        }
    }

    private static class WalkDatabaseTreeResult {
        DatabaseEntry lastKey;
        DatabaseEntry lastData;
        boolean noMoreRecords;
        private static final WalkDatabaseTreeResult NO_MORE_RECORDS = new WalkDatabaseTreeResult(null, null, true);

        WalkDatabaseTreeResult(DatabaseEntry lastKey, DatabaseEntry lastData, boolean noMoreRecords) {
            this.lastKey = lastKey;
            this.lastData = lastData;
            this.noMoreRecords = noMoreRecords;
        }
    }

    private class ObsoleteOffsetsCache {
        final SortedMap<Long, long[]> obsoleteOffsetsMap = new TreeMap<Long, long[]>();

        ObsoleteOffsetsCache() {
        }

        long[] getOffsets(long fileNum) {
            if (this.obsoleteOffsetsMap.containsKey(fileNum)) {
                return (long[])this.obsoleteOffsetsMap.get(fileNum);
            }
            long[] offsets = BtreeVerifier.this.up.getObsoleteDetailSorted(fileNum);
            this.obsoleteOffsetsMap.put(fileNum, offsets);
            return offsets;
        }
    }

    private class UPFileSizeCache
    implements FileSizeCache {
        final SortedMap<Long, Integer> fileSizeSummaryMap;

        UPFileSizeCache() {
            this.fileSizeSummaryMap = BtreeVerifier.this.up.getFileSizeSummaryMap();
        }

        @Override
        public Pair<Boolean, Integer> getFileSize(long fileNum) {
            if (this.fileSizeSummaryMap.containsKey(fileNum)) {
                return new Pair<Boolean, Integer>(true, (Integer)this.fileSizeSummaryMap.get(fileNum));
            }
            int size = BtreeVerifier.this.up.getFileSize(fileNum);
            if (size != -1) {
                this.fileSizeSummaryMap.put(fileNum, size);
            }
            return new Pair<Boolean, Integer>(false, size);
        }
    }

    private class DirectFileSizeCache
    implements FileSizeCache {
        private final Map<Long, Integer> cache = new HashMap<Long, Integer>();

        DirectFileSizeCache() {
        }

        @Override
        public Pair<Boolean, Integer> getFileSize(long fileNum) {
            Integer size = this.cache.get(fileNum);
            if (size != null) {
                return new Pair<Boolean, Integer>(true, size);
            }
            File file = new File(BtreeVerifier.this.fileManager.getFullFileName(fileNum));
            size = (int)file.length();
            this.cache.put(fileNum, size);
            return new Pair<Boolean, Integer>(false, size);
        }
    }

    private static interface FileSizeCache {
        public Pair<Boolean, Integer> getFileSize(long var1);
    }

    private static class FileSizeInfo {
        boolean sizeFromLastFile;
        boolean sizeFromCache;
        int size;

        FileSizeInfo(boolean sizeFromLastFile, boolean sizeFromCache, int size) {
            this.sizeFromLastFile = sizeFromLastFile;
            this.sizeFromCache = sizeFromCache;
            this.size = size;
        }

        String getReason() {
            return (this.sizeFromLastFile ? "File size from last file" : (this.sizeFromCache ? "File size previously cached" : "File size added to cache")) + ". ";
        }
    }

    private static class DanglingLSNCheckResult {
        private static final DanglingLSNCheckResult NO_DANGLING_LSN = new DanglingLSNCheckResult(-1, true, null);
        int problematicIndex;
        boolean fileNotExist;
        FileSizeInfo fsInfo;

        DanglingLSNCheckResult(int problematicIndex, boolean fileNotExist, FileSizeInfo fsInfo) {
            this.problematicIndex = problematicIndex;
            this.fileNotExist = fileNotExist;
            this.fsInfo = fsInfo;
        }

        String getReason() {
            return (this.fileNotExist ? "File does not exist. " : "Offset[+lastLoggerSize] exceeds the end of the file. ") + "fileSize=" + this.fsInfo.size + ". " + this.fsInfo.getReason();
        }
    }
}

