/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionTimeoutException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockImpl;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThinLockImpl;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TinyHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LockManager
implements EnvConfigObserver {
    private static final long TOTAL_LOCKIMPL_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    static final long TOTAL_THINLOCKIMPL_OVERHEAD = MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    private static final long REMOVE_TOTAL_LOCKIMPL_OVERHEAD = 0L - TOTAL_LOCKIMPL_OVERHEAD;
    private static final long REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD = 0L - TOTAL_THINLOCKIMPL_OVERHEAD;
    private static final long THINLOCK_MUTATE_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD - MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.LOCKINFO_OVERHEAD;
    private static final List<ThreadLocker> EMPTY_THREAD_LOCKERS = Collections.emptyList();
    public static TestHook<Void> afterLockHook;
    static TestHook<Void> simulatePartialDeadlockHook;
    final int nLockTables;
    final Latch[] lockTableLatches;
    private final Map<Long, Lock>[] lockTables;
    private final EnvironmentImpl envImpl;
    private final MemoryBudget memoryBudget;
    private final StatGroup stats;
    private final LongStat nRequests;
    private final LongStat nWaits;
    private static RangeRestartException rangeRestartException;
    private static boolean lockTableDump;
    private final Map<Thread, TinyHashSet<ThreadLocker>> threadLockers;

    public LockManager(EnvironmentImpl envImpl) {
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.nLockTables = configMgr.getInt(EnvironmentParams.N_LOCK_TABLES);
        this.lockTables = new Map[this.nLockTables];
        this.lockTableLatches = new Latch[this.nLockTables];
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTables[i] = new HashMap<Long, Lock>();
            this.lockTableLatches[i] = LatchFactory.createExclusiveLatch(envImpl, "Lock Table " + i, true);
        }
        this.envImpl = envImpl;
        this.memoryBudget = envImpl.getMemoryBudget();
        this.stats = new StatGroup("Locks", "Record locking is used to provide transactional capabilities.");
        this.nRequests = new LongStat(this.stats, LockStatDefinition.LOCK_REQUESTS);
        this.nWaits = new LongStat(this.stats, LockStatDefinition.LOCK_WAITS);
        this.envConfigUpdate(configMgr, null);
        envImpl.addConfigObserver(this);
        this.threadLockers = envImpl.isReplicated() ? new ConcurrentHashMap<Thread, TinyHashSet<ThreadLocker>>() : null;
    }

    @Override
    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig ignore2) {
        LockInfo.setDeadlockStackTrace(configMgr.getBoolean(EnvironmentParams.TXN_DEADLOCK_STACK_TRACE));
        LockManager.setLockTableDump(configMgr.getBoolean(EnvironmentParams.TXN_DUMPLOCKS));
    }

    private static void setLockTableDump(boolean enable) {
        lockTableDump = enable;
    }

    int getLockTableIndex(Long lsn) {
        return ((int)lsn.longValue() & Integer.MAX_VALUE) % this.nLockTables;
    }

    int getLockTableIndex(long lsn) {
        return ((int)lsn & Integer.MAX_VALUE) % this.nLockTables;
    }

    private static long timeRemain(long timeout, long startTime) {
        return timeout - (System.currentTimeMillis() - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long lsn, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, boolean jumpAheadOfWaiters, DatabaseImpl database) throws LockConflictException, DatabaseException {
        long startTime;
        LockGrantType grant;
        LockAttemptResult result2;
        assert (timeout >= 0L);
        if (type == LockType.NONE) {
            return LockGrantType.NONE_NEEDED;
        }
        Locker locker2 = locker;
        synchronized (locker2) {
            result2 = this.attemptLock(lsn, locker, type, nonBlockingRequest, jumpAheadOfWaiters);
            grant = result2.lockGrant;
            if (result2.success || grant == LockGrantType.DENIED) {
                assert (nonBlockingRequest || result2.success);
                if (afterLockHook != null) {
                    afterLockHook.doHook();
                }
                return grant;
            }
            if (LatchSupport.TRACK_LATCHES && !nonBlockingRequest) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
            assert (!nonBlockingRequest);
            locker.setWaitingFor(lsn, type);
            startTime = System.currentTimeMillis();
            long txnTimeout = locker.getTxnTimeout();
            if (txnTimeout > 0L) {
                long txnTimeRemaining = LockManager.timeRemain(txnTimeout, locker.getTxnStartMillis());
                if (timeout == 0L || txnTimeRemaining < timeout) {
                    timeout = Math.max(1L, txnTimeRemaining);
                }
            }
            if (this.performDeadlockDetectionDelay(lsn, locker, type, grant, timeout, startTime)) {
                return grant;
            }
        }
        DeadlockChecker lastDC = null;
        while (true) {
            WaitForLockResult waitResult;
            Locker locker3 = locker;
            synchronized (locker3) {
                waitResult = this.waitForLock(result2, lsn, locker, type, lastDC, timeout, startTime, database);
            }
            result2 = waitResult.getResult();
            grant = result2.lockGrant;
            lastDC = waitResult.getDeadLockChecker();
            Locker victim = waitResult.getVictim();
            if (victim == null) {
                return grant;
            }
            Pair<Boolean, DeadlockChecker> nvResult = this.notifyVictim(victim, locker, lsn, type, lastDC, timeout, startTime, database);
            if (nvResult.first().booleanValue()) {
                Locker locker4 = locker;
                synchronized (locker4) {
                    this.finishLock(locker, lsn, type, grant);
                }
                return grant;
            }
            lastDC = nvResult.second();
        }
    }

    private WaitForLockResult waitForLock(LockAttemptResult result2, Long lsn, Locker locker, LockType type, DeadlockChecker lastDC, long timeout, long startTime, DatabaseImpl database) {
        Locker victim;
        block18: {
            ArrayList<LockInfo> waiters;
            HashSet<LockInfo> owners;
            long now;
            boolean lockerTimedOut;
            boolean isImportunate = locker.getImportunate();
            boolean waitForever = timeout == 0L;
            victim = null;
            if (simulatePartialDeadlockHook != null) {
                simulatePartialDeadlockHook.doHook();
            }
            while (true) {
                boolean flushFromWaiters;
                if (this.envImpl.getDeadlockDetection() && !isImportunate) {
                    DeadlockResult dlr = this.checkAndHandleDeadlock(locker, lsn, type, timeout, database);
                    if (dlr.isOwner) break block18;
                    if (dlr.trueDeadlock) {
                        victim = dlr.victim;
                        lastDC = dlr.dc;
                        break block18;
                    }
                } else if (this.isOwner(lsn, locker, type)) break block18;
                try {
                    if (waitForever) {
                        locker.wait(0L);
                    } else {
                        locker.wait(Math.max(1L, LockManager.timeRemain(timeout, startTime)));
                    }
                }
                catch (InterruptedException IE) {
                    throw new ThreadInterruptedException(this.envImpl, (Throwable)IE);
                }
                lockerTimedOut = locker.isTimedOut();
                now = System.currentTimeMillis();
                boolean thisLockTimedOut = !waitForever && now - startTime >= timeout;
                boolean isRestart = result2.lockGrant == LockGrantType.WAIT_RESTART;
                owners = new HashSet<LockInfo>();
                waiters = new ArrayList<LockInfo>();
                boolean getOwnersAndWaiters = (lockerTimedOut || thisLockTimedOut) && !isImportunate;
                boolean bl = flushFromWaiters = isRestart && !isImportunate;
                if (this.validateOwnership(lsn, locker, type, getOwnersAndWaiters, flushFromWaiters, owners, waiters)) break block18;
                if (isImportunate) {
                    result2 = this.stealLock(lsn, locker, type);
                    if (!result2.success) continue;
                    break block18;
                }
                if (isRestart) {
                    throw rangeRestartException;
                }
                if (thisLockTimedOut || lockerTimedOut) break;
            }
            DeadlockResult dlr = this.checkAndHandleDeadlock(locker, lsn, type, timeout, database);
            if (!dlr.isOwner) {
                if (dlr.trueDeadlock) {
                    lastDC = dlr.dc;
                }
                if (!this.validateOwnership(lsn, locker, type, false, true, null, null)) {
                    if (lastDC != null) {
                        throw this.makeDeadlockException(lastDC, locker, timeout, false, database);
                    }
                    if (lockerTimedOut) {
                        throw this.makeTimeoutException(false, locker, lsn, type, result2.lockGrant, result2.useLock, locker.getTxnTimeout(), locker.getTxnStartMillis(), now, database, owners, waiters);
                    }
                    throw this.makeTimeoutException(true, locker, lsn, type, result2.lockGrant, result2.useLock, timeout, startTime, now, database, owners, waiters);
                }
            }
        }
        if (victim == null) {
            assert (this.isOwner(lsn, locker, type));
            this.finishLock(locker, lsn, type, result2.lockGrant);
        }
        return new WaitForLockResult(victim, lastDC, result2);
    }

    private void finishLock(Locker locker, Long nid, LockType type, LockGrantType grant) {
        locker.clearWaitingFor();
        assert (EnvironmentImpl.maybeForceYield());
        locker.addLock(nid, type, grant);
        if (afterLockHook != null) {
            afterLockHook.doHook();
        }
    }

    public abstract Set<LockInfo> getOwners(Long var1);

    Set<LockInfo> getOwnersInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            return null;
        }
        return useLock.getOwnersClone();
    }

    public abstract List<LockInfo> getWaiters(Long var1);

    List<LockInfo> getWaitersInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            return null;
        }
        return useLock.getWaitersListClone();
    }

    public abstract LockType getOwnedLockType(Long var1, Locker var2);

    LockType getOwnedLockTypeInternal(Long lsn, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            return null;
        }
        return useLock.getOwnedLockType(locker);
    }

    public abstract boolean isLockUncontended(Long var1);

    boolean isLockUncontendedInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            return true;
        }
        return useLock.nWaiters() == 0 && useLock.nOwners() == 0;
    }

    public abstract boolean ownsOrSharesLock(Locker var1, Long var2);

    boolean ownsOrSharesLockInternal(Locker locker, Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            return false;
        }
        for (LockInfo info : this.getOwnersInternal(lsn, lockTableIndex)) {
            Locker owner = info.getLocker();
            if (owner != locker && !owner.sharesLocksWith(locker) && !locker.sharesLocksWith(owner)) continue;
            return true;
        }
        return false;
    }

    abstract Lock lookupLock(Long var1) throws DatabaseException;

    Lock lookupLockInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        return lockTable.get(lsn);
    }

    abstract LockAttemptResult attemptLock(Long var1, Locker var2, LockType var3, boolean var4, boolean var5) throws DatabaseException;

    LockAttemptResult attemptLockInternal(Long lsn, Locker locker, LockType type, boolean nonBlockingRequest, boolean jumpAheadOfWaiters, int lockTableIndex) throws DatabaseException {
        this.nRequests.increment();
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock == null) {
            useLock = new ThinLockImpl();
            lockTable.put(lsn, useLock);
            this.memoryBudget.updateLockMemoryUsage(TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
        }
        LockAttemptResult lar = useLock.lock(type, locker, nonBlockingRequest, jumpAheadOfWaiters, this.memoryBudget, lockTableIndex);
        if (lar.useLock != useLock) {
            useLock = lar.useLock;
            lockTable.put(lsn, useLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        LockGrantType lockGrant = lar.lockGrant;
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(lsn, type, lockGrant);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else if (lockGrant != LockGrantType.DENIED) {
            this.nWaits.increment();
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    private boolean performDeadlockDetectionDelay(Long lsn, Locker locker, LockType type, LockGrantType grant, long timeout, long startTime) {
        boolean waitForever;
        long ddDelay = this.envImpl.getDeadlockDetectionDelay();
        if (!this.envImpl.getDeadlockDetection() || locker.getImportunate() || ddDelay == 0L) {
            return false;
        }
        boolean bl = waitForever = timeout == 0L;
        if (!waitForever) {
            ddDelay = Math.min(ddDelay, LockManager.timeRemain(timeout, startTime));
        }
        try {
            locker.wait(Math.max(1L, ddDelay));
        }
        catch (InterruptedException IE) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)IE);
        }
        if (this.isOwner(lsn, locker, type)) {
            this.finishLock(locker, lsn, type, grant);
            return true;
        }
        return false;
    }

    private DeadlockResult checkAndHandleDeadlock(Locker locker, Long lsn, LockType type, long timeout, DatabaseImpl database) {
        DeadlockChecker dc;
        boolean isOwner = false;
        boolean hasTrueDeadlock = false;
        Locker targetedVictim = null;
        int round = 0;
        while (true) {
            if ((dc = new DeadlockChecker(locker, lsn, type)).hasCycle()) {
                if (dc.hasTrueDeadlock()) {
                    targetedVictim = dc.chooseTargetedLocker();
                    if (targetedVictim != locker) {
                        if (this.isOwner(lsn, locker, type)) {
                            isOwner = true;
                            targetedVictim = null;
                            break;
                        }
                        hasTrueDeadlock = true;
                        break;
                    }
                    if (this.validateOwnership(lsn, locker, type, false, true, null, null)) {
                        isOwner = true;
                        targetedVictim = null;
                        break;
                    }
                    throw this.makeDeadlockException(dc, locker, timeout, true, database);
                }
                if (this.isOwner(lsn, locker, type)) {
                    isOwner = true;
                    break;
                }
                if (round >= 10) {
                    break;
                }
            } else {
                if (!this.isOwner(lsn, locker, type)) break;
                isOwner = true;
                break;
            }
            ++round;
        }
        return new DeadlockResult(isOwner, hasTrueDeadlock, targetedVictim, dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Boolean, DeadlockChecker> notifyVictim(Locker targetedVictim, Locker currentLocker, Long lsn, LockType type, DeadlockChecker lastDC, long timeout, long startTime, DatabaseImpl database) {
        DeadlockChecker dc;
        boolean waitForever;
        boolean bl = waitForever = timeout == 0L;
        do {
            if (!waitForever && LockManager.timeRemain(timeout, startTime) <= 0L) {
                if (this.validateOwnership(lsn, currentLocker, type, false, true, null, null)) {
                    return new Pair<Boolean, DeadlockChecker>(true, lastDC);
                }
                throw this.makeDeadlockException(lastDC, currentLocker, timeout, false, database);
            }
            Locker locker = targetedVictim;
            synchronized (locker) {
                targetedVictim.notify();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
            }
            if (this.isOwner(lsn, currentLocker, type)) {
                return new Pair<Boolean, DeadlockChecker>(true, lastDC);
            }
            dc = new DeadlockChecker(currentLocker, lsn, type);
            if (!dc.hasCycle() || !dc.hasTrueDeadlock()) {
                return new Pair<Boolean, DeadlockChecker>(false, lastDC);
            }
            lastDC = dc;
        } while (dc.chooseTargetedLocker() == targetedVictim);
        return new Pair<Boolean, DeadlockChecker>(false, lastDC);
    }

    private LockConflictException makeDeadlockException(DeadlockChecker dc, Locker locker, long timeout, boolean isVictim, DatabaseImpl database) {
        StringBuilder msg = new StringBuilder();
        msg.append("Deadlock was detected. ");
        if (isVictim) {
            msg.append("Locker: \"").append(locker);
            msg.append("\" was chosen randomly as the victim.\n");
        } else {
            msg.append("Unable to break deadlock using random victim ");
            msg.append("selection within the timeout interval. ");
            msg.append("Current locker: \"").append(locker);
            msg.append("\" must be aborted.\n");
        }
        if (database != null) {
            msg.append("DB: ").append(database.getDebugName()).append(". ");
        }
        msg.append("Timeout: ");
        if (timeout == 0L) {
            msg.append("none.\n");
        } else {
            msg.append(timeout).append("ms.\n");
        }
        msg.append(dc);
        DeadlockException ex = new DeadlockException(locker, msg.toString());
        ex.setOwnerTxnIds(this.getTxnIds(dc.getOwnersForRootLock()));
        ex.setWaiterTxnIds(this.getTxnIds(dc.getWaitersForRootLock()));
        ex.setTimeoutMillis(timeout);
        return ex;
    }

    private LockConflictException makeTimeoutException(boolean isLockNotTxnTimeout, Locker locker, long lsn, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start2, long now, DatabaseImpl database, Set<LockInfo> owners, List<LockInfo> waiters) {
        TimeoutInfo info = this.getTimeoutInfo(isLockNotTxnTimeout, locker, lsn, type, grantType, useLock, timeout, start2, now, database, owners, waiters);
        LockConflictException ex = isLockNotTxnTimeout ? new LockTimeoutException(locker, info.message) : new TransactionTimeoutException(locker, info.message);
        ex.setOwnerTxnIds(this.getTxnIds(info.owners));
        ex.setWaiterTxnIds(this.getTxnIds(info.waiters));
        ex.setTimeoutMillis(timeout);
        return ex;
    }

    abstract TimeoutInfo getTimeoutInfo(boolean var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12, DatabaseImpl var14, Set<LockInfo> var15, List<LockInfo> var16);

    TimeoutInfo getTimeoutInfoInternal(boolean isLockNotTxnTimeout, Locker locker, long lsn, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start2, long now, DatabaseImpl database, Set<LockInfo> owners, List<LockInfo> waiters) {
        if (lockTableDump) {
            System.out.println("++++++++++ begin lock table dump ++++++++++");
            for (int i = 0; i < this.nLockTables; ++i) {
                boolean success = false;
                for (int j = 0; j < 3; ++j) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        this.dumpToStringNoLatch(sb, i);
                        System.out.println(sb.toString());
                        success = true;
                        break;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                }
                if (success) continue;
                System.out.println("Couldn't dump locktable " + i);
            }
            System.out.println("++++++++++ end lock table dump ++++++++++");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(isLockNotTxnTimeout ? "Lock" : "Transaction");
        sb.append(" expired. Locker ").append(locker);
        sb.append(": waited for lock");
        if (database != null) {
            sb.append(" on database=").append(database.getDebugName());
        }
        sb.append(" LockAddr:").append(System.identityHashCode(useLock));
        sb.append(" LSN=").append(DbLsn.getNoFormatString(lsn));
        sb.append(" type=").append(type);
        sb.append(" grant=").append((Object)grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start2);
        sb.append(" endTime=").append(now);
        sb.append("\nOwners: ").append(owners);
        sb.append("\nWaiters: ").append(waiters).append("\n");
        return new TimeoutInfo(sb.toString(), owners, waiters);
    }

    private long[] getTxnIds(Collection<LockInfo> c) {
        long[] ret = new long[c.size()];
        Iterator<LockInfo> iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LockInfo info = iter.next();
            ret[i++] = info.getLocker().getId();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(long lsn, Locker locker) throws DatabaseException {
        Set<Locker> newOwners = this.releaseAndFindNotifyTargets(lsn, locker);
        if (newOwners == null) {
            return false;
        }
        if (newOwners.size() > 0) {
            Iterator<Locker> iterator = newOwners.iterator();
            while (iterator.hasNext()) {
                Locker newOwner;
                Locker locker2 = newOwner = iterator.next();
                synchronized (locker2) {
                    newOwner.notifyAll();
                }
                assert (EnvironmentImpl.maybeForceYield());
            }
        }
        return true;
    }

    abstract Set<Locker> releaseAndFindNotifyTargets(long var1, Locker var3) throws DatabaseException;

    Set<Locker> releaseAndFindNotifyTargetsInternal(long lsn, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock lock = lockTable.get(lsn);
        if (lock == null) {
            lock = lockTable.get(lsn);
        }
        if (lock == null) {
            return null;
        }
        Set<Locker> newOwners = lock.release(locker, this.memoryBudget, lockTableIndex);
        if (newOwners == null) {
            return null;
        }
        if (lock.nWaiters() == 0 && lock.nOwners() == 0) {
            lockTable.remove(lsn);
            if (lock.isThin()) {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
            } else {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_LOCKIMPL_OVERHEAD, lockTableIndex);
            }
        } else {
            lock = lock.isThin() ? new ThinLockImpl((ThinLockImpl)lock) : new LockImpl((LockImpl)lock);
            lockTable.put(lsn, lock);
        }
        return newOwners;
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    void demoteInternal(long lsn, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(lsn);
        if (useLock != null) {
            useLock.demote(locker);
            locker.moveWriteToReadLock(lsn, useLock);
        }
    }

    abstract boolean isLocked(Long var1) throws DatabaseException;

    boolean isLockedInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(lsn);
        return entry != null && entry.nOwners() != 0;
    }

    abstract boolean isOwner(Long var1, Locker var2, LockType var3) throws DatabaseException;

    boolean isOwnerInternal(Long lsn, Locker locker, LockType type, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(lsn);
        return entry != null && entry.isOwner(locker, type);
    }

    abstract boolean isWaiter(Long var1, Locker var2) throws DatabaseException;

    boolean isWaiterInternal(Long lsn, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(lsn);
        return entry != null && entry.isWaiter(locker);
    }

    abstract int nWaiters(Long var1) throws DatabaseException;

    int nWaitersInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(lsn);
        return entry == null ? -1 : entry.nWaiters();
    }

    abstract int nOwners(Long var1) throws DatabaseException;

    int nOwnersInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(lsn);
        return entry == null ? -1 : entry.nOwners();
    }

    abstract Locker getWriteOwnerLocker(Long var1) throws DatabaseException;

    Locker getWriteOwnerLockerInternal(Long lsn, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock lock = lockTable.get(lsn);
        if (lock == null) {
            return null;
        }
        if (lock.nOwners() > 1) {
            return null;
        }
        return lock.getWriteOwnerLocker();
    }

    abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4, boolean var5, Set<LockInfo> var6, List<LockInfo> var7) throws DatabaseException;

    boolean validateOwnershipInternal(Long lsn, Locker locker, LockType type, boolean getOwnersAndWaiters, boolean flushFromWaiters, int lockTableIndex, Set<LockInfo> owners, List<LockInfo> waiters) {
        Lock entry;
        if (this.isOwnerInternal(lsn, locker, type, lockTableIndex)) {
            return true;
        }
        if (getOwnersAndWaiters) {
            List<LockInfo> localWaiters;
            Set<LockInfo> localOwners;
            if (owners != null && (localOwners = this.getOwnersInternal(lsn, lockTableIndex)) != null) {
                owners.addAll(localOwners);
            }
            if (waiters != null && (localWaiters = this.getWaitersInternal(lsn, lockTableIndex)) != null) {
                waiters.addAll(localWaiters);
            }
        }
        if (flushFromWaiters && (entry = this.lockTables[lockTableIndex].get(lsn)) != null) {
            entry.flushWaiter(locker, this.memoryBudget, lockTableIndex);
        }
        return false;
    }

    public abstract LockAttemptResult stealLock(Long var1, Locker var2, LockType var3) throws DatabaseException;

    LockAttemptResult stealLockInternal(Long lsn, Locker locker, LockType lockType, int lockTableIndex) throws DatabaseException {
        Lock entry = this.lockTables[lockTableIndex].get(lsn);
        assert (entry != null) : "Lock " + DbLsn.getNoFormatString(lsn) + " for txn " + locker.getId() + " does not exist";
        entry.flushWaiter(locker, this.memoryBudget, lockTableIndex);
        entry.stealLock(locker, this.memoryBudget, lockTableIndex);
        return this.attemptLockInternal(lsn, locker, lockType, false, false, lockTableIndex);
    }

    void registerThreadLocker(ThreadLocker locker) {
        if (this.threadLockers == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        if (set != null) {
            boolean added = set.add(locker);
            assert (added);
        } else {
            this.threadLockers.put(thread, new TinyHashSet<ThreadLocker>(locker));
        }
    }

    void unregisterThreadLocker(ThreadLocker locker) {
        if (this.threadLockers == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        assert (set != null);
        boolean removed = set.remove(locker);
        assert (removed);
        if (this.threadLockers.size() == 0) {
            this.threadLockers.remove(thread);
        }
    }

    Iterator<ThreadLocker> getThreadLockers(Thread thread) {
        if (this.threadLockers == null) {
            return EMPTY_THREAD_LOCKERS.iterator();
        }
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        if (set == null) {
            return EMPTY_THREAD_LOCKERS.iterator();
        }
        return set.iterator();
    }

    LockStats lockStat(StatsConfig config) throws DatabaseException {
        StatGroup latchStats = new StatGroup("Locktable latches", "Shows lock table contention");
        for (int i = 0; i < this.nLockTables; ++i) {
            latchStats.addAll(this.lockTableLatches[i].getStats());
        }
        StatGroup tableStats = new StatGroup("Locktable", "The types of locks held in the lock table");
        if (!config.getFast()) {
            this.dumpLockTable(tableStats, false);
        }
        return new LockStats(this.stats.cloneGroup(config.getClear()), latchStats.cloneGroup(config.getClear()), tableStats.cloneGroup(config.getClear()));
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        StatGroup latchStats = new StatGroup("Locktable latches", "Shows lock table contention");
        for (int i = 0; i < this.nLockTables; ++i) {
            latchStats.addAll(this.lockTableLatches[i].getStats());
            if (!config.getClear()) continue;
            this.lockTableLatches[i].clearStats();
        }
        copyStats.addAll(latchStats);
        StatGroup tableStats = new StatGroup("Locktable", "The types of locks held in the lock table");
        if (!config.getFast()) {
            this.dumpLockTable(tableStats, config.getClear());
        }
        copyStats.addAll(tableStats);
        return copyStats;
    }

    abstract void dumpLockTable(StatGroup var1, boolean var2) throws DatabaseException;

    void dumpLockTableInternal(StatGroup tableStats, int i, boolean clear) {
        StatGroup oneTable = new StatGroup("Single lock table", "Temporary stat group");
        IntStat totalLocks = new IntStat(oneTable, LockStatDefinition.LOCK_TOTAL);
        IntStat waiters = new IntStat(oneTable, LockStatDefinition.LOCK_WAITERS);
        IntStat owners = new IntStat(oneTable, LockStatDefinition.LOCK_OWNERS);
        IntStat readLocks = new IntStat(oneTable, LockStatDefinition.LOCK_READ_LOCKS);
        IntStat writeLocks = new IntStat(oneTable, LockStatDefinition.LOCK_WRITE_LOCKS);
        Map<Long, Lock> lockTable = this.lockTables[i];
        totalLocks.add(lockTable.size());
        for (Lock lock : lockTable.values()) {
            waiters.add(lock.nWaiters());
            owners.add(lock.nOwners());
            for (LockInfo info : lock.getOwnersClone()) {
                if (info.getLockType().isWriteLock()) {
                    writeLocks.increment();
                    continue;
                }
                readLocks.increment();
            }
        }
        tableStats.addAll(oneTable);
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    private String dumpToString() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTableLatches[i].acquireExclusive();
            try {
                this.dumpToStringNoLatch(sb, i);
                continue;
            }
            finally {
                this.lockTableLatches[i].release();
            }
        }
        return sb.toString();
    }

    private void dumpToStringNoLatch(StringBuilder sb, int whichTable) {
        Map<Long, Lock> lockTable = this.lockTables[whichTable];
        for (Map.Entry<Long, Lock> entry : lockTable.entrySet()) {
            Long lsn = entry.getKey();
            Lock lock = entry.getValue();
            sb.append("---- LSN: ").append(DbLsn.getNoFormatString(lsn)).append("----\n");
            sb.append(lock);
            sb.append('\n');
        }
    }

    static {
        rangeRestartException = new RangeRestartException();
        lockTableDump = false;
    }

    private static class DeadlockResult {
        private final boolean isOwner;
        private final boolean trueDeadlock;
        private final Locker victim;
        private final DeadlockChecker dc;

        DeadlockResult(boolean isOwner, boolean trueDeadlock, Locker victim, DeadlockChecker dc) {
            this.isOwner = isOwner;
            this.trueDeadlock = trueDeadlock;
            this.victim = victim;
            this.dc = dc;
        }
    }

    private static class WaitForLockResult {
        private final Locker targetVictim;
        private final DeadlockChecker dc;
        private final LockAttemptResult result;

        WaitForLockResult(Locker targetVictim, DeadlockChecker dc, LockAttemptResult result2) {
            this.targetVictim = targetVictim;
            this.dc = dc;
            this.result = result2;
        }

        Locker getVictim() {
            return this.targetVictim;
        }

        DeadlockChecker getDeadLockChecker() {
            return this.dc;
        }

        LockAttemptResult getResult() {
            return this.result;
        }
    }

    private class DeadlockChecker {
        private final Locker rootLocker;
        private final Long lsn;
        private final LockType rootLocktype;
        private Set<LockInfo> ownersForRootLock;
        private List<LockInfo> waitersForRootLock;
        private List<CycleNode> cycle = new ArrayList<CycleNode>();

        DeadlockChecker(Locker locker, Long lsn, LockType locktype) {
            this.rootLocker = locker;
            this.lsn = lsn;
            this.rootLocktype = locktype;
        }

        Locker chooseTargetedLocker() {
            CycleNode[] cycleNodeArray = this.cycle.toArray(new CycleNode[0]);
            CycleNodeComparator cnc = new CycleNodeComparator();
            Arrays.sort(cycleNodeArray, cnc);
            return cycleNodeArray[this.getTargetedLockerIndex()].getLocker();
        }

        int getTargetedLockerIndex() {
            long sum = 0L;
            int nLockers = 0;
            for (CycleNode cn : this.cycle) {
                sum += (long)System.identityHashCode(cn.getLock());
                ++nLockers;
            }
            return (int)(Math.abs(sum) % (long)nLockers);
        }

        boolean hasCycle() {
            this.getOwnerAndWaitersForRootLocker();
            return this.hasCycleInternal(this.rootLocker, this.lsn, this.rootLocktype, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasCycleInternal(Locker checkedLocker, Long lsn, LockType requestLocktype, LockType ownLockType) {
            Set<LockInfo> ownersForCheckedLock;
            Lock checkedLock;
            int lockTableIndex = LockManager.this.getLockTableIndex(lsn);
            Latch latch = LockManager.this.lockTableLatches[lockTableIndex];
            synchronized (latch) {
                if (LockManager.this.isOwnerInternal(lsn, checkedLocker, requestLocktype, lockTableIndex)) {
                    return false;
                }
                Map lockTable = LockManager.this.lockTables[lockTableIndex];
                checkedLock = (Lock)lockTable.get(lsn);
                ownersForCheckedLock = LockManager.this.getOwnersInternal(lsn, lockTableIndex);
            }
            if (ownersForCheckedLock == null) {
                return false;
            }
            CycleNode cn = new CycleNode(checkedLocker, lsn, checkedLock, requestLocktype, ownLockType);
            this.cycle.add(cn);
            for (LockInfo info : ownersForCheckedLock) {
                Locker locker = info.getLocker();
                LockType ownType = info.getLockType();
                Long waitsFor = locker.getWaitingFor();
                LockType requestType = locker.getWaitingForType();
                if (locker == checkedLocker) continue;
                if (locker == this.rootLocker) {
                    return true;
                }
                for (int index = 0; index < this.cycle.size(); ++index) {
                    if (this.cycle.get(index).getLocker() != locker) continue;
                    this.cycle.subList(0, index).clear();
                    return true;
                }
                if (waitsFor == null || requestType == null || ownType == null || !this.hasCycleInternal(locker, waitsFor, requestType, ownType)) continue;
                return true;
            }
            this.cycle.remove(cn);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTrueDeadlock() {
            for (CycleNode cn : this.cycle) {
                Lock realtimeLock;
                Lock lock = cn.getLock();
                Long lsn = cn.getLsn();
                int lockTableIndex = LockManager.this.getLockTableIndex(lsn);
                Latch latch = LockManager.this.lockTableLatches[lockTableIndex];
                synchronized (latch) {
                    Map lockTable = LockManager.this.lockTables[lockTableIndex];
                    realtimeLock = (Lock)lockTable.get(lsn);
                }
                if (realtimeLock == lock) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getOwnerAndWaitersForRootLocker() {
            int lockTableIndex = LockManager.this.getLockTableIndex(this.lsn);
            Latch latch = LockManager.this.lockTableLatches[lockTableIndex];
            synchronized (latch) {
                List<LockInfo> localWaiters;
                Set<LockInfo> localOwners = LockManager.this.getOwnersInternal(this.lsn, lockTableIndex);
                if (localOwners != null) {
                    this.ownersForRootLock = localOwners;
                }
                if ((localWaiters = LockManager.this.getWaitersInternal(this.lsn, lockTableIndex)) != null) {
                    this.waitersForRootLock = localWaiters;
                }
            }
        }

        Set<LockInfo> getOwnersForRootLock() {
            return this.ownersForRootLock;
        }

        List<LockInfo> getWaitersForRootLock() {
            return this.waitersForRootLock;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Lock preLock = null;
            Long preLsn = null;
            for (CycleNode cn : this.cycle) {
                Locker locker = cn.getLocker();
                Lock lock = cn.getLock();
                Long lsn = cn.getLsn();
                LockType requestType = cn.getRequestLockType();
                LockType ownType = cn.getOwnLockType();
                if (preLock != null) {
                    sb.append("Locker: \"");
                    sb.append(locker).append("\" owns lock: ");
                    sb.append(System.identityHashCode(preLock));
                    sb.append("(LSN: ");
                    sb.append(DbLsn.getNoFormatString(preLsn));
                    sb.append(", ownedType: ").append(ownType).append("). ");
                }
                sb.append("Locker: \"");
                sb.append(locker).append("\" waits for lock: ");
                sb.append(System.identityHashCode(lock)).append("(LSN: ");
                sb.append(DbLsn.getNoFormatString(lsn));
                sb.append(", requestType: ").append(requestType).append(").");
                sb.append("\n");
                preLock = lock;
                preLsn = lsn;
            }
            return sb.toString();
        }

        class CycleNode {
            private final Locker locker;
            private final Long lsn;
            private final Lock lock;
            private LockType requestLockType;
            private LockType ownLockType;

            CycleNode(Locker locker, Long lsn, Lock lock, LockType requestLockType, LockType ownLockType) {
                this.locker = locker;
                this.lsn = lsn;
                this.lock = lock;
                this.requestLockType = requestLockType;
                this.ownLockType = ownLockType;
            }

            private Locker getLocker() {
                return this.locker;
            }

            private Long getLsn() {
                return this.lsn;
            }

            private Lock getLock() {
                return this.lock;
            }

            private LockType getRequestLockType() {
                return this.requestLockType;
            }

            private LockType getOwnLockType() {
                return this.ownLockType;
            }
        }

        class CycleNodeComparator
        implements Comparator {
            CycleNodeComparator() {
            }

            public int compare(Object obj1, Object obj2) {
                CycleNode nc1 = (CycleNode)obj1;
                CycleNode nc2 = (CycleNode)obj2;
                return (int)(nc1.getLocker().getWaiterThreadId() - nc2.getLocker().getWaiterThreadId());
            }
        }
    }

    static class TimeoutInfo {
        final String message;
        final Set<LockInfo> owners;
        final List<LockInfo> waiters;

        TimeoutInfo(String message, Set<LockInfo> owners, List<LockInfo> waiters) {
            this.message = message;
            this.owners = owners;
            this.waiters = waiters;
        }
    }
}

