/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class LockInfo
implements Cloneable {
    protected Locker locker;
    protected LockType lockType;
    private static boolean deadlockStackTrace = false;
    private static Map<LockInfo, StackTraceAtLockTime> traceExceptionMap = Collections.synchronizedMap(new WeakHashMap());

    static void setDeadlockStackTrace(boolean enable) {
        deadlockStackTrace = enable;
    }

    public static boolean getDeadlockStackTrace() {
        return deadlockStackTrace;
    }

    public LockInfo(Locker locker, LockType lockType) {
        this.locker = locker;
        this.lockType = lockType;
        if (deadlockStackTrace) {
            traceExceptionMap.put(this, new StackTraceAtLockTime());
        }
    }

    LockInfo(LockInfo other) {
        this.locker = other.locker;
        this.lockType = other.lockType;
        if (deadlockStackTrace) {
            traceExceptionMap.put(this, traceExceptionMap.get(other));
        }
    }

    void setLocker(Locker locker) {
        this.locker = locker;
    }

    public Locker getLocker() {
        return this.locker;
    }

    void setLockType(LockType lockType) {
        this.lockType = lockType;
    }

    LockType getLockType() {
        return this.lockType;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dump() {
        System.out.println(this);
    }

    public String toString() {
        Exception traceException;
        StringBuilder buf2 = new StringBuilder(500);
        buf2.append("<LockInfo locker=\"");
        buf2.append(this.locker);
        buf2.append("\" type=\"");
        buf2.append(this.lockType);
        buf2.append("\"/>");
        if (deadlockStackTrace && (traceException = (Exception)traceExceptionMap.get(this)) != null) {
            buf2.append(" lock taken at: ");
            buf2.append(LoggerUtils.getStackTrace(traceException));
        }
        return buf2.toString();
    }

    private static class StackTraceAtLockTime
    extends Exception {
        private StackTraceAtLockTime() {
        }
    }
}

