/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.CustomStats;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.statcap.JvmStats;
import com.sleepycat.je.statcap.StatManager;
import com.sleepycat.je.statcap.StatUtils;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.utilint.StatLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Logger;

public class StatCapture
extends DaemonThread
implements EnvConfigObserver {
    public static final String STATFILENAME = "je.stat";
    public static final String STATFILEEXT = "csv";
    private static final String CUSTOMGROUPNAME = "Custom";
    private static final String DELIMITER = ",";
    private static final String DELIMITERANDSPACE = ", ";
    private final StatManager statMgr;
    private final SortedSet<String> statProjection;
    private final StatsConfig statsConfig;
    private final Integer statKey;
    private volatile StatLogger stlog = null;
    private final StringBuffer values = new StringBuffer();
    private String currentHeader = null;
    private final JvmStats jvmstats = new JvmStats();
    private final CustomStats customStats;
    private final String[] customStatHeader;
    private final Logger logger = LoggerUtils.getLogger(this.getClass());
    private Exception lastCallException = null;

    public StatCapture(EnvironmentImpl environment, String name, long waitTime, CustomStats customStats, SortedSet<String> statProjection, StatManager statMgr) {
        super(waitTime, name, environment);
        environment.addConfigObserver(this);
        this.statMgr = statMgr;
        this.statKey = statMgr.registerStatContext();
        this.customStats = customStats;
        this.statProjection = statProjection;
        this.statsConfig = new StatsConfig();
        this.statsConfig.setClear(true);
        this.jvmstats.addVMStatDefs(statProjection);
        if (customStats != null) {
            String[] customFldNames = customStats.getFieldNames();
            this.customStatHeader = new String[customFldNames.length];
            for (int i = 0; i < customFldNames.length; ++i) {
                this.customStatHeader[i] = "Custom:" + customFldNames[i];
                statProjection.add(this.customStatHeader[i]);
            }
        } else {
            this.customStatHeader = null;
        }
        this.envConfigUpdate(this.envImpl.getConfigManager(), null);
    }

    private boolean collectStats() {
        return this.stlog != null;
    }

    @Override
    protected void onWakeup() {
        if (!this.envImpl.isValid() || !this.collectStats()) {
            return;
        }
        this.outputStats();
    }

    @Override
    public void requestShutdown() {
        super.requestShutdown();
        if (!this.collectStats() || !this.envImpl.isValid()) {
            return;
        }
        this.outputStats();
    }

    private synchronized void outputStats() {
        if (!this.collectStats() || !this.envImpl.isValid()) {
            return;
        }
        try {
            SortedMap<String, String> stats = this.getStats();
            if (stats != null) {
                if (this.currentHeader == null) {
                    this.values.setLength(0);
                    this.values.append("time");
                    for (String statname : this.statProjection) {
                        this.values.append(DELIMITER + statname);
                    }
                    this.stlog.setHeader(this.values.toString());
                    this.currentHeader = this.values.toString();
                }
                this.values.setLength(0);
                this.values.append(StatUtils.getDate(System.currentTimeMillis()));
                for (String statname : this.statProjection) {
                    String val = (String)stats.get(statname);
                    if (val != null) {
                        this.values.append(DELIMITER + val);
                        continue;
                    }
                    this.values.append(DELIMITERANDSPACE);
                }
                this.stlog.log(this.values.toString());
                this.values.setLength(0);
                this.lastCallException = null;
            }
        }
        catch (IOException e) {
            if (this.lastCallException == null) {
                LoggerUtils.warning(this.logger, this.envImpl, "Error accessing statistics capture file je.stat.csv IO Exception: " + e.getMessage());
            }
            this.lastCallException = e;
        }
        catch (Exception e) {
            if (this.lastCallException == null) {
                LoggerUtils.warning(this.logger, this.envImpl, "Error accessing or writing statistics capture file  je.stat.csv" + e + "\n" + LoggerUtils.getStackTrace(e));
            }
            this.lastCallException = e;
        }
    }

    private SortedMap<String, String> getStats() {
        Collection<StatGroup> rsg;
        ArrayList<StatGroup> envStats = new ArrayList<StatGroup>(this.statMgr.loadStats(this.statsConfig, this.statKey).getStatGroups());
        if (this.envImpl.isReplicated() && (rsg = this.envImpl.getRepStatGroups(this.statsConfig, this.statKey)) != null) {
            envStats.addAll(rsg);
        }
        envStats.add(this.jvmstats.loadStats(this.statsConfig));
        TreeMap<String, String> statsMap = new TreeMap<String, String>();
        for (StatGroup sg : envStats) {
            for (Map.Entry<StatDefinition, Stat<?>> e : sg.getStats().entrySet()) {
                String mapName = (sg.getName() + ":" + e.getKey().getName()).intern();
                Stat<?> stat = e.getValue();
                if (stat.isNotSet()) {
                    statsMap.put(mapName, " ");
                    continue;
                }
                Object val = stat.get();
                String str = val instanceof Float || val instanceof Double ? String.format("%.2f", val) : (val instanceof Number ? Long.toString(((Number)val).longValue()) : (val != null ? String.valueOf(val) : " "));
                statsMap.put(mapName, str);
            }
        }
        if (this.customStats != null) {
            String[] vals = this.customStats.getFieldValues();
            for (int i = 0; i < vals.length; ++i) {
                statsMap.put(this.customStatHeader[i], vals[i]);
            }
        }
        return statsMap;
    }

    @Override
    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig unused2) throws DatabaseException {
        this.setWaitTime(configMgr.getDuration(EnvironmentParams.STATS_COLLECT_INTERVAL));
        if (this.envImpl.isReadOnly() || this.envImpl.isMemOnly() || !configMgr.getBoolean(EnvironmentParams.STATS_COLLECT)) {
            this.stlog = null;
            return;
        }
        int maxFiles = configMgr.getInt(EnvironmentParams.STATS_MAX_FILES);
        int fileRowCount = configMgr.getInt(EnvironmentParams.STATS_FILE_ROW_COUNT);
        if (this.stlog == null) {
            File statDir;
            String statdir = configMgr.get(EnvironmentParams.STATS_FILE_DIRECTORY);
            if (statdir == null || statdir.equals("")) {
                statDir = this.envImpl.getEnvironmentHome();
            } else {
                statDir = new File(statdir);
                if (!statDir.exists()) {
                    statDir.mkdirs();
                } else if (!statDir.isDirectory()) {
                    throw new IllegalArgumentException("Specified statistic log directory " + statDir.getAbsolutePath() + " is not a directory.");
                }
            }
            try {
                this.stlog = new StatLogger(statDir, STATFILENAME, STATFILEEXT, maxFiles, fileRowCount);
            }
            catch (IOException e) {
                throw new IllegalStateException(" Error accessing statistics capture file je.stat.csv IO Exception: " + e.getMessage());
            }
        } else {
            this.stlog.setFileCount(maxFiles);
            this.stlog.setRowCount(fileRowCount);
        }
    }
}

