/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.JoinGroupEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.Monitor;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.IOException;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorService
extends ServiceDispatcher.ExecutingService {
    public static volatile TestHook<GroupChangeEvent> processGroupChangeHook;
    public static volatile TestHook<JoinGroupEvent> processJoinGroupHook;
    public static volatile TestHook<LeaveGroupEvent> processLeaveGroupHook;
    private final Monitor monitor;
    private final Protocol protocol;
    private final Logger logger;
    private final Formatter formatter;
    public static final String SERVICE_NAME = "Monitor";

    public MonitorService(Monitor monitor2, ServiceDispatcher dispatcher) {
        super(SERVICE_NAME, dispatcher);
        this.monitor = monitor2;
        this.protocol = new Protocol(monitor2.getGroupName(), monitor2.getMonitorNameIdPair(), null, dispatcher.getChannelFactory());
        this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(monitor2.getMonitorNameIdPair());
    }

    public TextProtocol.ResponseMessage process(Protocol.GroupChange groupChange) {
        GroupChangeEvent event = new GroupChangeEvent(new ReplicationGroup(groupChange.getGroup()), groupChange.getNodeName(), groupChange.getOpType());
        try {
            assert (TestHookExecute.doHookIfSet(processGroupChangeHook, event));
        }
        catch (IllegalStateException e) {
            return null;
        }
        this.monitor.notifyGroupChange(event);
        return null;
    }

    public TextProtocol.ResponseMessage process(Protocol.JoinGroup joinGroup) {
        JoinGroupEvent event = new JoinGroupEvent(joinGroup.getNodeName(), joinGroup.getMasterName(), joinGroup.getJoinTime());
        try {
            assert (TestHookExecute.doHookIfSet(processJoinGroupHook, event));
        }
        catch (IllegalStateException e) {
            return null;
        }
        this.monitor.notifyJoin(event);
        return null;
    }

    public TextProtocol.ResponseMessage process(Protocol.LeaveGroup leaveGroup) {
        LeaveGroupEvent event = new LeaveGroupEvent(leaveGroup.getNodeName(), leaveGroup.getMasterName(), leaveGroup.getLeaveReason(), leaveGroup.getJoinTime(), leaveGroup.getLeaveTime());
        try {
            assert (TestHookExecute.doHookIfSet(processLeaveGroupHook, event));
        }
        catch (IllegalStateException e) {
            return null;
        }
        this.monitor.notifyLeave(event);
        return null;
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new MonitorServiceRunnable(dataChannel, this.protocol);
    }

    class MonitorServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        MonitorServiceRunnable(DataChannel dataChannel, Protocol protocol) {
            super(dataChannel, protocol, false);
        }

        @Override
        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            return this.protocol.process(MonitorService.this, request);
        }

        @Override
        protected void logMessage(String message) {
            LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, message);
        }
    }
}

