/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.impl.MinJEVersionUnsupportedException;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class RepGroupImpl {
    public static final int MAX_FORMAT_VERSION = 3;
    public static final int FORMAT_VERSION_3 = 3;
    public static final int FORMAT_VERSION_2 = 2;
    public static final int INITIAL_FORMAT_VERSION = 3;
    static final int MIN_FORMAT_VERSION = 2;
    public static final JEVersion FORMAT_VERSION_3_JE_VERSION = new JEVersion("6.0.1");
    public static final JEVersion MIN_FORMAT_VERSION_JE_VERSION = new JEVersion("5.0.0");
    private static final int CHANGE_VERSION_START = 0;
    private static final UUID UNKNOWN_UUID = new UUID(0L, 0L);
    public static final int MAX_NODES_WITH_TRANSIENT_ID = 1024;
    private static final int NODE_SEQUENCE_START = 0;
    private static final int NODE_SEQUENCE_MAX = 0x7FFFFBFF;
    private static final Predicate ELECTABLE_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isElectable();
        }
    };
    private static final Predicate MONITOR_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isMonitor();
        }
    };
    private static final Predicate SECONDARY_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isSecondary();
        }
    };
    private static final Predicate EXTERNAL_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isExternal();
        }
    };
    private static final Predicate ACK_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isElectable() && !n.getType().isArbiter();
        }
    };
    private static final Predicate ARBITER_PREDICATE = new Predicate(){

        @Override
        boolean include(RepNodeImpl n) {
            return n.getType().isArbiter();
        }
    };
    private final String groupName;
    private UUID uuid;
    private volatile int formatVersion;
    private int changeVersion = 0;
    private int nodeIdSequence;
    private final Map<Integer, RepNodeImpl> nodesById = new HashMap<Integer, RepNodeImpl>();
    private final Map<String, RepNodeImpl> nodesByName = new HashMap<String, RepNodeImpl>();
    private volatile JEVersion minJEVersion = MIN_FORMAT_VERSION_JE_VERSION;

    public RepGroupImpl(String groupName, JEVersion currentJEVersion) {
        this(groupName, false, currentJEVersion);
    }

    public RepGroupImpl(String groupName, boolean unknownUUID, JEVersion currentJEVersion) {
        this(groupName, unknownUUID ? UNKNOWN_UUID : UUID.randomUUID(), RepGroupImpl.getCurrentFormatVersion(currentJEVersion));
    }

    private static int getCurrentFormatVersion(JEVersion currentJEVersion) {
        return currentJEVersion == null ? 3 : RepGroupImpl.getMaxFormatVersion(currentJEVersion);
    }

    public RepGroupImpl(String groupName, UUID uuid, int formatVersion) {
        this(groupName, uuid, formatVersion, 0, 0, formatVersion < 3 ? MIN_FORMAT_VERSION_JE_VERSION : FORMAT_VERSION_3_JE_VERSION);
    }

    public RepGroupImpl(String groupName, UUID uuid, int formatVersion, int changeVersion, int nodeIdSequence, JEVersion minJEVersion) {
        this.groupName = groupName;
        this.uuid = uuid;
        this.formatVersion = formatVersion;
        this.changeVersion = changeVersion;
        this.setNodeIdSequence(nodeIdSequence);
        this.minJEVersion = minJEVersion;
        if (formatVersion < 2 || formatVersion > 3) {
            throw new IllegalStateException("Expected membership database format version between: 2 and 3, encountered unsupported version: " + formatVersion);
        }
        if (minJEVersion == null) {
            throw new IllegalArgumentException("The minJEVersion must not be null");
        }
    }

    public boolean hasUnknownUUID() {
        return UNKNOWN_UUID.equals(this.uuid);
    }

    public static boolean isUnknownUUID(UUID uuid) {
        return UNKNOWN_UUID.equals(uuid);
    }

    public void setUUID(UUID uuid) {
        if (!this.hasUnknownUUID()) {
            throw EnvironmentFailureException.unexpectedState("Expected placeholder UUID, not " + uuid);
        }
        this.uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeImpl removeMember(String nodeName, boolean delete) {
        RepNodeImpl node = this.getMember(nodeName);
        if (node == null) {
            throw EnvironmentFailureException.unexpectedState("Node:" + nodeName + " is not a member of the group.");
        }
        if (node.getType().hasTransientId()) {
            throw EnvironmentFailureException.unexpectedState("Cannot remove node with transient id: " + nodeName);
        }
        if (delete) {
            Map<Integer, RepNodeImpl> map = this.nodesById;
            synchronized (map) {
                this.nodesById.remove(node.getNodeId());
                this.nodesByName.remove(nodeName);
            }
        }
        node.setRemoved(true);
        return node;
    }

    public void checkForConflicts(RepNodeImpl node) throws DatabaseException, NodeConflictException {
        for (RepNodeImpl n : this.getAllMembers(null)) {
            if (n.getNameIdPair().equals(node.getNameIdPair()) || !n.getSocketAddress().equals(node.getSocketAddress())) continue;
            throw new NodeConflictException("New or moved node:" + node.getName() + ", is configured with the socket address: " + node.getSocketAddress() + ".  It conflicts with the socket already used by the member: " + n.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.changeVersion;
        result2 = 31 * result2 + (this.groupName == null ? 0 : this.groupName.hashCode());
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            result2 = 31 * result2 + this.nodesById.hashCode();
        }
        result2 = 31 * result2 + (this.uuid == null ? 0 : this.uuid.hashCode());
        result2 = 31 * result2 + this.formatVersion;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        HashMap<Integer, RepNodeImpl> otherNodesById;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepGroupImpl)) {
            return false;
        }
        RepGroupImpl other = (RepGroupImpl)obj;
        if (this.changeVersion != other.changeVersion) {
            return false;
        }
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.formatVersion != other.formatVersion) {
            return false;
        }
        if (!this.minJEVersion.equals(other.minJEVersion)) {
            return false;
        }
        Map<Integer, RepNodeImpl> map = other.nodesById;
        synchronized (map) {
            otherNodesById = new HashMap<Integer, RepNodeImpl>(other.nodesById);
        }
        map = this.nodesById;
        synchronized (map) {
            if (!this.nodesById.equals(otherNodesById)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(Map<Integer, RepNodeImpl> nodes) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            Iterator<RepNodeImpl> iter = this.nodesById.values().iterator();
            while (iter.hasNext()) {
                RepNodeImpl node = iter.next();
                if (node.getType().hasTransientId()) continue;
                iter.remove();
                this.nodesByName.remove(node.getName());
            }
            if (nodes != null) {
                for (RepNodeImpl node : nodes.values()) {
                    RepNodeImpl prevById = this.nodesById.put(node.getNodeId(), node);
                    RepNodeImpl prevByName = this.nodesByName.put(node.getName(), node);
                    if (prevById != null && !node.getName().equals(prevById.getName())) {
                        this.nodesByName.remove(prevById.getName());
                    }
                    if (prevByName == null || node.getNodeId() == prevByName.getNodeId()) continue;
                    this.nodesById.remove(prevByName.getNodeId());
                }
            }
            assert (new HashSet<RepNodeImpl>(this.nodesById.values()).equals(new HashSet<RepNodeImpl>(this.nodesByName.values()))) : "Node maps indexed by ID and name differ: IDs: " + this.nodesById + ", Names: " + this.nodesByName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientIdNode(RepNodeImpl node) {
        if (!node.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call addTransientIdNode on a node without transient id: " + node);
        }
        if (node.getNameIdPair().hasNullId()) {
            throw new IllegalArgumentException("Attempt to call addTransientIdNode on node without ID: " + node);
        }
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            RepNodeImpl prevById = this.nodesById.get(node.getNodeId());
            assert (prevById == null || prevById.getType().hasTransientId()) : "Same node ID for nodes with transient and persistent ID: " + node + ", " + prevById;
            RepNodeImpl prevByName = this.nodesByName.get(node.getName());
            if (prevByName != null && !prevByName.getType().hasTransientId()) {
                throw new NodeConflictException("New node with transient ID " + node.getName() + " conflicts with an existing node with persistent ID with the same name: " + prevByName);
            }
            RepNodeImpl prevById2 = this.nodesById.put(node.getNodeId(), node);
            assert (prevById == prevById2);
            RepNodeImpl prevByName2 = this.nodesByName.put(node.getName(), node);
            assert (prevByName == prevByName2);
            if (prevById != null && !node.getName().equals(prevById.getName())) {
                this.nodesByName.remove(prevById.getName());
            }
            if (prevByName != null && node.getNodeId() != prevByName.getNodeId()) {
                this.nodesById.remove(prevByName.getNodeId());
            }
            assert (new HashSet<RepNodeImpl>(this.nodesById.values()).equals(new HashSet<RepNodeImpl>(this.nodesByName.values()))) : "Node maps indexed by ID and name differ: IDs: " + this.nodesById + ", Names: " + this.nodesByName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientNode(RepNodeImpl node) {
        if (!node.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call removeTransientNode on a node without transient ID: " + node);
        }
        if (node.getNameIdPair().hasNullId()) {
            throw new IllegalArgumentException("Attempt to call removeTransientNode on a node with no ID: " + node);
        }
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            this.nodesById.remove(node.getNodeId());
            this.nodesByName.remove(node.getName());
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public static int getMaxFormatVersion(JEVersion jeVersion) {
        if (jeVersion.compareTo(FORMAT_VERSION_3_JE_VERSION) < 0) {
            return 2;
        }
        return 3;
    }

    public int getChangeVersion() {
        return this.changeVersion;
    }

    public int incrementChangeVersion() {
        return ++this.changeVersion;
    }

    public int getNodeIdSequence() {
        return this.nodeIdSequence;
    }

    public void setNodeIdSequence(int nodeIdSequence) {
        if (nodeIdSequence < 0 || nodeIdSequence > 0x7FFFFBFF) {
            throw new IllegalArgumentException("Bad nodeIdSequence: " + nodeIdSequence);
        }
        this.nodeIdSequence = nodeIdSequence;
    }

    public int getNextNodeId() {
        if (this.nodeIdSequence >= 0x7FFFFBFF) {
            throw new IllegalStateException("Reached maximum node ID");
        }
        return ++this.nodeIdSequence;
    }

    public static int getFirstNodeId() {
        return 1;
    }

    public JEVersion getMinJEVersion() {
        return this.minJEVersion;
    }

    public void setMinJEVersion(JEVersion newMinJEVersion) throws MinJEVersionUnsupportedException {
        if (newMinJEVersion == null) {
            throw new IllegalArgumentException("The newMinJEVersion argument must not be null");
        }
        if (newMinJEVersion.compareTo(this.minJEVersion) <= 0) {
            return;
        }
        int newFormatVersion = RepGroupImpl.getMaxFormatVersion(newMinJEVersion);
        if (newFormatVersion < 3) {
            return;
        }
        for (RepNodeImpl node : this.getElectableMembers()) {
            JEVersion nodeJEVersion = node.getJEVersion();
            if (nodeJEVersion == null || nodeJEVersion.compareTo(newMinJEVersion) >= 0) continue;
            throw new MinJEVersionUnsupportedException(newMinJEVersion, node.getName(), nodeJEVersion);
        }
        this.minJEVersion = newMinJEVersion;
        this.formatVersion = newFormatVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConsistent() {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            if (this.nodesById.isEmpty()) {
                return;
            }
            int computedNodeId = -1;
            int computedChangeVersion = -1;
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (computedNodeId < mi.getNodeId()) {
                    computedNodeId = mi.getNodeId();
                }
                if (computedChangeVersion >= mi.getChangeVersion()) continue;
                computedChangeVersion = mi.getChangeVersion();
            }
            this.setNodeIdSequence(computedNodeId);
            this.changeVersion = computedChangeVersion;
        }
    }

    static <T> String objectToHex(TupleBinding<T> binding, T object) {
        StringBuilder buffer = new StringBuilder();
        TupleOutput tuple = new TupleOutput(new byte[100]);
        binding.objectToEntry(object, tuple);
        byte[] bytes = tuple.getBufferBytes();
        int size = tuple.getBufferLength();
        for (int i = 0; i < size; ++i) {
            int lowNibble = bytes[i] & 0xF;
            int highNibble = bytes[i] >> 4 & 0xF;
            buffer.append(Character.forDigit(lowNibble, 16));
            buffer.append(Character.forDigit(highNibble, 16));
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeHex(int groupFormatVersion) {
        RepGroupDB.GroupBinding groupBinding = new RepGroupDB.GroupBinding(groupFormatVersion);
        StringBuilder buffer = new StringBuilder();
        buffer.append(RepGroupImpl.objectToHex(groupBinding, this));
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (!RepGroupDB.NodeBinding.supportsObjectToEntry(mi, groupFormatVersion)) continue;
                buffer.append("|");
                buffer.append(RepGroupImpl.serializeHex(mi, groupFormatVersion));
            }
        }
        return buffer.toString();
    }

    public static String serializeHex(RepNodeImpl node, int formatVersion) {
        RepGroupDB.NodeBinding nodeBinding = new RepGroupDB.NodeBinding(formatVersion);
        return RepGroupImpl.objectToHex(nodeBinding, node);
    }

    public static byte[] serializeBytes(RepNodeImpl node, int formatVersion) {
        RepGroupDB.NodeBinding binding = new RepGroupDB.NodeBinding(formatVersion);
        TupleOutput tuple = new TupleOutput(new byte[122]);
        binding.objectToEntry(node, tuple);
        return tuple.getBufferBytes();
    }

    public static RepNodeImpl hexDeserializeNode(String hex, int formatVersion) {
        RepGroupDB.NodeBinding nodeBinding = new RepGroupDB.NodeBinding(formatVersion);
        return RepGroupImpl.hexToObject(nodeBinding, hex);
    }

    public static RepNodeImpl deserializeNode(byte[] bytes, int formatVersion) {
        RepGroupDB.NodeBinding binding = new RepGroupDB.NodeBinding(formatVersion);
        TupleInput tuple = new TupleInput(bytes);
        return binding.entryToObject(tuple);
    }

    private static <T> T hexToObject(TupleBinding<T> binding, String hex) {
        byte[] buffer = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            int value = Character.digit(hex.charAt(i), 16);
            buffer[i >> 1] = (byte)(value |= Character.digit(hex.charAt(i + 1), 16) << 4);
        }
        TupleInput tuple = new TupleInput(buffer);
        return binding.entryToObject(tuple);
    }

    public static RepGroupImpl deserializeHex(String[] tokens, int start2) {
        RepGroupDB.GroupBinding groupBinding = new RepGroupDB.GroupBinding();
        RepGroupImpl group = RepGroupImpl.hexToObject(groupBinding, tokens[start2++]);
        HashMap<Integer, RepNodeImpl> nodeMap = new HashMap<Integer, RepNodeImpl>();
        while (start2 < tokens.length) {
            RepNodeImpl n = RepGroupImpl.hexDeserializeNode(tokens[start2++], group.getFormatVersion());
            RepNodeImpl old = nodeMap.put(n.getNameIdPair().getId(), n);
            assert (old == null);
        }
        group.setNodes(nodeMap);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getAllElectionMemberIds() {
        HashSet<Integer> ret = new HashSet<Integer>();
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (mi.isRemoved() || mi.getType().hasTransientId()) continue;
                ret.add(mi.getNodeId());
            }
        }
        return ret;
    }

    public Set<RepNodeImpl> getAllMembers(Predicate p) {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeMembers(p, result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeAllMembers(Predicate p, Set<? super RepNodeImpl> set) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (mi.isRemoved() || p != null && !p.include(mi)) continue;
                set.add(mi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAllMembers(Predicate p) {
        int count = 0;
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (mi.isRemoved() || p != null && !p.include(mi)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeMembers(Predicate p, Set<? super RepNodeImpl> set) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl n : this.nodesById.values()) {
                if (n.isRemoved() || !n.isQuorumAck() || p != null && !p.include(n)) continue;
                set.add(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeImpl getMember(InetSocketAddress socket) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl n : this.nodesById.values()) {
                if (!socket.equals(n.getSocketAddress()) || n.isRemoved()) continue;
                return n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RepNodeImpl> getRemovedNodes() {
        HashSet<RepNodeImpl> ret = new HashSet<RepNodeImpl>();
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if (!mi.isRemoved() || !mi.isQuorumAck()) continue;
                ret.add(mi);
            }
        }
        return ret;
    }

    public Set<RepNodeImpl> getAllElectableMembers() {
        return this.getAllMembers(ELECTABLE_PREDICATE);
    }

    public Set<RepNodeImpl> getElectableMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeElectableMembers(result2);
        return result2;
    }

    public void includeElectableMembers(Set<? super RepNodeImpl> set) {
        this.includeAllMembers(new Predicate(){

            @Override
            boolean include(RepNodeImpl n) {
                return n.getType().isElectable() && n.isQuorumAck();
            }
        }, set);
    }

    public Set<RepNodeImpl> getDataMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeDataMembers(result2);
        return result2;
    }

    public void includeDataMembers(Set<? super RepNodeImpl> set) {
        this.includeAllMembers(new Predicate(){

            @Override
            boolean include(RepNodeImpl n) {
                return n.getType().isDataNode() && n.isQuorumAck();
            }
        }, set);
    }

    public Set<RepNodeImpl> getMonitorMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeMonitorMembers(result2);
        return result2;
    }

    public void includeMonitorMembers(Set<? super RepNodeImpl> set) {
        this.includeMembers(MONITOR_PREDICATE, set);
    }

    public Set<RepNodeImpl> getAllLearnerMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeAllMembers(new Predicate(){

            @Override
            boolean include(RepNodeImpl n) {
                return n.getType().isElectable() || n.getType().isMonitor();
            }
        }, result2);
        return result2;
    }

    public Set<RepNodeImpl> getSecondaryMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeSecondaryMembers(result2);
        return result2;
    }

    public Set<RepNodeImpl> getExternalMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeExternalMembers(result2);
        return result2;
    }

    public void includeSecondaryMembers(Set<? super RepNodeImpl> set) {
        this.includeAllMembers(SECONDARY_PREDICATE, set);
    }

    public void includeExternalMembers(Set<? super RepNodeImpl> set) {
        this.includeAllMembers(EXTERNAL_PREDICATE, set);
    }

    public Set<RepNodeImpl> getArbiterMembers() {
        HashSet<RepNodeImpl> result2 = new HashSet<RepNodeImpl>();
        this.includeArbiterMembers(result2);
        return result2;
    }

    public void includeArbiterMembers(Set<? super RepNodeImpl> set) {
        this.includeMembers(ARBITER_PREDICATE, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<InetSocketAddress> getAllMemberSockets(Predicate p) {
        HashSet<InetSocketAddress> sockets = new HashSet<InetSocketAddress>();
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl mi : this.nodesById.values()) {
                if ((!mi.getType().isElectable() && !mi.getType().isMonitor() || mi.isRemoved()) && !mi.getType().hasTransientId() || p != null && !p.include(mi)) continue;
                sockets.add(mi.getSocketAddress());
            }
        }
        return sockets;
    }

    public Set<InetSocketAddress> getAllLearnerSockets() {
        return this.getAllMemberSockets(new Predicate(){

            @Override
            boolean include(RepNodeImpl n) {
                return !n.getType().isSecondary() && !n.getType().isExternal();
            }
        });
    }

    public Set<InetSocketAddress> getAllHelperSockets() {
        return this.getAllMemberSockets(null);
    }

    public Set<InetSocketAddress> getAllMonitorSockets() {
        return this.getAllMemberSockets(MONITOR_PREDICATE);
    }

    public Set<InetSocketAddress> getAllAcceptorSockets() {
        return this.getAllMemberSockets(ELECTABLE_PREDICATE);
    }

    public RepNodeImpl getMember(int nodeId) {
        RepNodeImpl node = this.getNode(nodeId);
        if (node == null) {
            return null;
        }
        if (node.isRemoved()) {
            throw EnvironmentFailureException.unexpectedState("No longer a member:" + nodeId);
        }
        return node;
    }

    public RepNodeImpl getMember(String name) throws MemberNotFoundException {
        RepNodeImpl node = this.getNode(name);
        if (node == null) {
            return null;
        }
        if (node.isRemoved()) {
            throw new MemberNotFoundException("Node no longer a member:" + name);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeImpl getNode(int nodeId) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            return this.nodesById.get(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepNodeImpl getNode(String name) {
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            return this.nodesByName.get(name);
        }
    }

    public int getElectableGroupSize() {
        return this.countAllMembers(ELECTABLE_PREDICATE);
    }

    public int getAckGroupSize() {
        return this.countAllMembers(ACK_PREDICATE);
    }

    public String getName() {
        return this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group info [").append(this.groupName).append("] ");
        sb.append(this.getUUID()).append("\n Format version: ").append(this.getFormatVersion()).append("\n Change version: ").append(this.getChangeVersion()).append("\n Max persist rep node ID: ").append(this.getNodeIdSequence()).append("\n Min JE version: ").append(this.minJEVersion).append("\n");
        Map<Integer, RepNodeImpl> map = this.nodesById;
        synchronized (map) {
            for (RepNodeImpl node : this.nodesById.values()) {
                sb.append(" ").append(node);
            }
        }
        return sb.toString();
    }

    public static class NodeConflictException
    extends DatabaseException {
        public NodeConflictException(String message) {
            super(message);
        }
    }

    static abstract class Predicate {
        Predicate() {
        }

        abstract boolean include(RepNodeImpl var1);
    }
}

