/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.ProposerStatDefinition;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Proposer {
    protected final Elections elections;
    private final StatGroup statistics;
    private final IntStat phase1NoQuorum;
    protected final IntStat phase1NoNonZeroPrio;
    protected final IntStat phase1Arbiter;
    private final IntStat phase1HigherProposal;
    private final IntStat phase2NoQuorum;
    private final IntStat phase2HigherProposal;
    private final IntStat promiseCount;
    private volatile boolean shutdown;
    protected final Logger logger;
    protected final Formatter formatter;

    public Proposer(Elections elections, NameIdPair nameIdPair) {
        this.elections = elections;
        this.logger = elections.getRepImpl() != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(nameIdPair);
        this.statistics = new StatGroup("Election Proposer", "Proposals are the first stage of a replication group election.");
        this.phase1NoQuorum = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_NO_QUORUM);
        this.phase1NoNonZeroPrio = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_NO_NON_ZERO_PRIO);
        this.phase1Arbiter = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_ARBITER);
        this.phase1HigherProposal = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_HIGHER_PROPOSAL);
        this.phase2NoQuorum = new IntStat(this.statistics, ProposerStatDefinition.PHASE2_NO_QUORUM);
        this.phase2HigherProposal = new IntStat(this.statistics, ProposerStatDefinition.PHASE2_HIGHER_PROPOSAL);
        this.promiseCount = new IntStat(this.statistics, ProposerStatDefinition.PROMISE_COUNT);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public StatGroup getProposerStats() {
        return this.statistics;
    }

    private boolean haveQuorum(QuorumPolicy quorumPolicy, int votes) {
        return this.elections.getElectionQuorum().haveQuorum(quorumPolicy, votes);
    }

    private Phase1Result phase1(QuorumPolicy quorumPolicy, Proposal proposal) throws HigherNumberedProposal {
        LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.FINE, "Phase 1 proposal: " + proposal);
        Set<InetSocketAddress> acceptorSockets = this.elections.getAcceptorSockets();
        Protocol protocol = this.elections.getProtocol();
        protocol.getClass();
        Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(acceptorSockets, "Acceptor", new Protocol.Propose(protocol, proposal), this.elections.getThreadPool());
        Phase1Result result2 = this.tallyPhase1Results(proposal, compService);
        if (this.haveQuorum(quorumPolicy, result2.promisories.size())) {
            return result2;
        }
        this.phase1NoQuorum.increment();
        return null;
    }

    private Phase1Result tallyPhase1Results(Proposal currentProposal, final Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService) throws HigherNumberedProposal {
        final Phase1Result result2 = new Phase1Result();
        new Utils.WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, (long)(2 * this.elections.getProtocol().getReadTimeout()), TimeUnit.MILLISECONDS, this.logger, this.elections.getRepImpl(), null){

            @Override
            protected void processResponse(TextProtocol.MessageExchange me) {
                TextProtocol.MessageOp op = me.getResponseMessage().getOp();
                if (op == Proposer.this.elections.getProtocol().REJECT) {
                    compService.cancelFutures(true);
                    Proposer.this.phase1HigherProposal.increment();
                    throw new HigherNumberedProposal(me.target);
                }
                if (op == Proposer.this.elections.getProtocol().PROMISE) {
                    result2.promisories.add(me.target);
                    result2.promisoryMessages.add(me);
                    Protocol.Promise accept = (Protocol.Promise)me.getResponseMessage();
                    Proposal acceptProposal = accept.getHighestProposal();
                    if (result2.acceptProposal == null || acceptProposal != null && acceptProposal.compareTo(result2.acceptProposal) > 0) {
                        result2.acceptProposal = acceptProposal;
                        result2.acceptedValue = accept.getAcceptedValue();
                    }
                } else {
                    if (op == Proposer.this.elections.getProtocol().PROTOCOL_ERROR) {
                        TextProtocol.ProtocolError protocolError = (TextProtocol.ProtocolError)me.getResponseMessage();
                        LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "Proposer phase 1 protocol error: " + protocolError.getMessage());
                        return;
                    }
                    LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "Proposer phase 1 unknown response: " + op);
                    return;
                }
            }

            @Override
            protected boolean isShutdown() {
                return Proposer.this.shutdown;
            }
        }.execute();
        if (result2.promisories.size() > 0 && result2.acceptProposal == null) {
            result2.acceptProposal = currentProposal;
        }
        this.promiseCount.set(result2.promisories.size());
        return result2;
    }

    private Phase2Result phase2(QuorumPolicy quorumPolicy, Proposal proposal, Protocol.Value phase2Value, Set<InetSocketAddress> promisories) throws HigherNumberedProposal {
        LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.FINE, "Phase 2 proposal: " + proposal + " Value: " + phase2Value);
        Protocol protocol = this.elections.getProtocol();
        protocol.getClass();
        Protocol.Accept accept = new Protocol.Accept(protocol, proposal, phase2Value);
        Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(promisories, "Acceptor", accept, this.elections.getThreadPool());
        Phase2Result result2 = this.tallyPhase2Results(quorumPolicy, compService);
        if (this.haveQuorum(quorumPolicy, result2.accepts.size())) {
            return result2;
        }
        this.phase2NoQuorum.increment();
        return null;
    }

    private Phase2Result tallyPhase2Results(final QuorumPolicy quorumPolicy, final Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService) throws HigherNumberedProposal {
        final Phase2Result result2 = new Phase2Result();
        try {
            new Utils.WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, (long)(2 * this.elections.getProtocol().getReadTimeout()), TimeUnit.MILLISECONDS, this.logger, this.elections.getRepImpl(), null){

                @Override
                protected void processResponse(TextProtocol.MessageExchange me) {
                    TextProtocol.ResponseMessage responseMessage = me.getResponseMessage();
                    Protocol protocol = Proposer.this.elections.getProtocol();
                    TextProtocol.MessageOp op = responseMessage.getOp();
                    if (op == protocol.REJECT) {
                        compService.cancelFutures(true);
                        Proposer.this.phase2HigherProposal.increment();
                        throw new HigherNumberedProposal(me.target);
                    }
                    if (op == protocol.ACCEPTED) {
                        result2.accepts.add(me.target);
                        if (Proposer.this.haveQuorum(quorumPolicy, result2.accepts.size())) {
                            compService.cancelFutures(true);
                            throw new HaveQuorum();
                        }
                    } else if (op == protocol.PROTOCOL_ERROR) {
                        TextProtocol.ProtocolError errorMessage = (TextProtocol.ProtocolError)responseMessage;
                        LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "Proposer phase 2 protocol error:" + errorMessage.getMessage());
                    } else {
                        LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "Proposer Phase 2 unknown response: " + op);
                    }
                }

                @Override
                protected boolean isShutdown() {
                    return Proposer.this.shutdown;
                }
            }.execute();
        }
        catch (HaveQuorum haveQuorum) {
            // empty catch block
        }
        return result2;
    }

    protected abstract Protocol.Value choosePhase2Value(Set<TextProtocol.MessageExchange> var1);

    protected abstract Proposal nextProposal();

    public WinningProposal issueProposal(QuorumPolicy quorumPolicy, RetryPredicate retryPredicate) throws MaxRetriesException, InterruptedException {
        this.statistics.clear();
        while (retryPredicate.retry()) {
            try {
                Phase2Result result2;
                Protocol.Value phase2Value;
                Proposal proposal = this.nextProposal();
                Phase1Result result1 = this.phase1(quorumPolicy, proposal);
                if (result1 == null || (phase2Value = this.choosePhase2Value(result1.promisoryMessages)) == null || (result2 = this.phase2(quorumPolicy, proposal, phase2Value, result1.promisories)) == null) continue;
                LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.INFO, "Winning proposal: " + proposal + " Value: " + phase2Value);
                return new WinningProposal(proposal, phase2Value, this.statistics);
            }
            catch (HigherNumberedProposal eip) {
            }
        }
        throw new MaxRetriesException(this.statistics);
    }

    public static interface RetryPredicate {
        public boolean retry() throws InterruptedException;

        public int retries();
    }

    public static interface ProposalParser {
        public Proposal parse(String var1);
    }

    public static interface Proposal
    extends Comparable<Proposal> {
        public String wireFormat();
    }

    private static class HaveQuorum
    extends RuntimeException {
        HaveQuorum() {
        }
    }

    public static class MaxRetriesException
    extends Exception {
        final StatGroup proposerStats;

        MaxRetriesException(StatGroup proposerStats) {
            this.proposerStats = proposerStats;
        }
    }

    private static class HigherNumberedProposal
    extends RuntimeException {
        final InetSocketAddress acceptor;

        HigherNumberedProposal(InetSocketAddress acceptor) {
            this.acceptor = acceptor;
        }

        @Override
        public String getMessage() {
            return "More recent proposal at: " + this.acceptor.getHostName();
        }
    }

    public static class WinningProposal {
        final Proposal proposal;
        final Protocol.Value chosenValue;
        final StatGroup proposerStats;

        public WinningProposal(Proposal proposal, Protocol.Value value, StatGroup proposerStats) {
            this.proposal = proposal;
            this.chosenValue = value;
            this.proposerStats = proposerStats;
        }
    }

    private static class Phase2Result {
        Set<InetSocketAddress> accepts = new HashSet<InetSocketAddress>();

        private Phase2Result() {
        }
    }

    private static class Phase1Result {
        Set<InetSocketAddress> promisories = new HashSet<InetSocketAddress>();
        Set<TextProtocol.MessageExchange> promisoryMessages = new HashSet<TextProtocol.MessageExchange>();
        Proposal acceptProposal;
        Protocol.Value acceptedValue;

        private Phase1Result() {
        }
    }
}

