/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.arbiter.ArbiterConfig;
import com.sleepycat.je.rep.arbiter.ArbiterMutableConfig;
import com.sleepycat.je.rep.arbiter.ArbiterStats;
import com.sleepycat.je.rep.arbiter.impl.ArbiterImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class Arbiter {
    private ArbiterImpl ai;
    private final ReplicatedEnvironment repEnv;
    private final ArbiterConfig ac;
    private final String ARB_CONFIG = "ArbiterConfig";
    private final String ARB_HOME = "ArbiterHome";

    public Arbiter(ArbiterConfig arbiterConfig) throws EnvironmentNotFoundException, EnvironmentLockedException, DatabaseException, IllegalArgumentException {
        this.ac = arbiterConfig.clone();
        this.verifyParameters(this.ac);
        File envHome = new File(this.ac.getArbiterHome());
        if (!envHome.exists()) {
            throw new IllegalArgumentException("The specified environment directory " + envHome.getAbsolutePath() + " does not exist.");
        }
        Properties allProps = this.ac.getProps();
        EnvironmentConfig envConfig = new EnvironmentConfig(this.getEnvProps(allProps));
        envConfig.setReadOnly(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        envConfig.setConfigParam(EnvironmentParams.ENV_SETUP_LOGGER.getName(), "true");
        envConfig.setConfigParam(EnvironmentParams.LOG_USE_WRITE_QUEUE.getName(), "false");
        envConfig.setConfigParam(EnvironmentParams.LOG_WRITE_QUEUE_SIZE.getName(), "4096");
        if (this.ac.getLoggingHandler() != null) {
            envConfig.setLoggingHandler(this.ac.getLoggingHandler());
        }
        ReplicationConfig repConfig = new ReplicationConfig(this.getRepEnvProps(allProps));
        repConfig.setConfigParam(RepParams.ARBITER_USE.getName(), "true");
        repConfig.setRepNetConfig(this.ac.getRepNetConfig());
        this.repEnv = RepInternal.createInternalEnvHandle(envHome, repConfig, envConfig);
        try {
            this.ai = new ArbiterImpl(envHome, RepInternal.getNonNullRepImpl(this.repEnv));
            this.ai.runArbiter();
        }
        catch (Throwable t) {
            this.shutdown();
            throw t;
        }
    }

    public ArbiterMutableConfig getArbiterMutableConfig() {
        return this.ac.getArbiterMutableConfig();
    }

    public void setArbiterMutableConfig(ArbiterMutableConfig config) throws DatabaseException {
        ReplicationMutableConfig rmc = this.repEnv.getRepMutableConfig();
        Properties newProps = config.getProps();
        this.copyMutablePropsTo(newProps, rmc);
        this.repEnv.setRepMutableConfig(rmc);
        this.ai.refreshHelperHosts();
        EnvironmentMutableConfig emc = this.repEnv.getMutableConfig();
        this.copyMutablePropsTo(newProps, emc);
        this.repEnv.setMutableConfig(emc);
    }

    public ReplicatedEnvironment.State getState() {
        return this.ai.getArbState();
    }

    public ArbiterStats getStats(StatsConfig config) throws DatabaseException {
        if (this.ai == null) {
            return null;
        }
        StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
        return new ArbiterStats(this.ai.loadStats(useConfig));
    }

    public void shutdown() throws DatabaseException {
        if (this.ai != null) {
            this.ai.shutdown();
            try {
                this.ai.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.repEnv != null) {
            this.repEnv.close();
        }
    }

    private void verifyParameters(ArbiterConfig ac) throws IllegalArgumentException {
        DatabaseUtil.checkForNullParam(ac, "ArbiterConfig");
        DatabaseUtil.checkForNullParam(ac.getArbiterHome(), "ArbiterHome");
        DatabaseUtil.checkForNullParam(ac.getGroupName(), "je.rep.groupName");
        DatabaseUtil.checkForNullParam(ac.getNodeHostPort(), "je.rep.nodeHostPort");
        DatabaseUtil.checkForNullParam(ac.getHelperHosts(), "je.rep.helperHosts");
    }

    private Properties getEnvProps(Properties props) {
        Properties envProps = new Properties();
        for (Map.Entry<Object, Object> m : props.entrySet()) {
            String key = (String)m.getKey();
            if (key.startsWith("je.rep.")) continue;
            envProps.put(key, m.getValue());
        }
        return envProps;
    }

    private Properties getRepEnvProps(Properties props) {
        Properties repEnvProps = new Properties();
        for (Map.Entry<Object, Object> m : props.entrySet()) {
            String key = (String)m.getKey();
            if (!key.startsWith("je.rep.")) continue;
            repEnvProps.put(key, m.getValue());
        }
        return repEnvProps;
    }

    private void copyMutablePropsTo(Properties from, ReplicationMutableConfig toConfig) {
        Enumeration<?> propNames = from.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param2 = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (param2 == null || !param2.isForReplication() || !param2.isMutable()) continue;
            toConfig.setConfigParam(paramName, from.getProperty(paramName));
        }
    }

    private void copyMutablePropsTo(Properties from, EnvironmentMutableConfig toConfig) {
        Enumeration<?> propNames = from.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param2 = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (param2 == null || param2.isForReplication() || !param2.isMutable()) continue;
            toConfig.setConfigParam(paramName, from.getProperty(paramName));
        }
    }
}

