/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashMap;
import java.util.Map;

public class RecoveryInfo {
    public long lastUsedLsn = -1L;
    public long nextAvailableLsn = -1L;
    public long firstActiveLsn = -1L;
    public long checkpointStartLsn = -1L;
    public long checkpointEndLsn = -1L;
    public long useRootLsn = -1L;
    public long partialCheckpointStartLsn = -1L;
    public CheckpointEnd checkpointEnd;
    public long useMinReplicatedNodeId;
    public long useMaxNodeId;
    public long useMinReplicatedDbId;
    public long useMaxDbId;
    public long useMinReplicatedTxnId;
    public long useMaxTxnId;
    public VLSNRecoveryProxy vlsnProxy;
    public long lastMissingFileNumber = -1L;
    public VLSN lastMissingFileVLSN = VLSN.NULL_VLSN;
    public final Map<Long, Txn> replayTxns = new HashMap<Long, Txn>();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Recovery Info ");
        this.appendLsn(sb, " firstActive=", this.firstActiveLsn);
        this.appendLsn(sb, " ckptStart=", this.checkpointStartLsn);
        this.appendLsn(sb, " ckptEnd=", this.checkpointEndLsn);
        this.appendLsn(sb, " lastUsed=", this.lastUsedLsn);
        this.appendLsn(sb, " nextAvail=", this.nextAvailableLsn);
        this.appendLsn(sb, " useRoot=", this.useRootLsn);
        sb.append(this.checkpointEnd);
        sb.append(" useMinReplicatedNodeId=").append(this.useMinReplicatedNodeId);
        sb.append(" useMaxNodeId=").append(this.useMaxNodeId);
        sb.append(" useMinReplicatedDbId=").append(this.useMinReplicatedDbId);
        sb.append(" useMaxDbId=").append(this.useMaxDbId);
        sb.append(" useMinReplicatedTxnId=").append(this.useMinReplicatedTxnId);
        sb.append(" useMaxTxnId=").append(this.useMaxTxnId);
        return sb.toString();
    }

    private void appendLsn(StringBuilder sb, String name, long lsn) {
        if (lsn != -1L) {
            sb.append(name).append(DbLsn.getNoFormatString(lsn));
        }
    }
}

