/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.entry.AbortLogEntry;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.CommitLogEntry;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.EmptyLogEntry;
import com.sleepycat.je.log.entry.FileHeaderEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.MatchpointLogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.log.entry.OldBINDeltaLogEntry;
import com.sleepycat.je.log.entry.ReplicableLogEntry;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.log.entry.TraceLogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.OldBINDelta;
import com.sleepycat.je.tree.dupConvert.DBIN;
import com.sleepycat.je.tree.dupConvert.DIN;
import com.sleepycat.je.tree.dupConvert.DupCountLN;
import com.sleepycat.je.tree.dupConvert.INDeleteInfo;
import com.sleepycat.je.tree.dupConvert.INDupDeleteInfo;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.TxnPrepare;
import java.util.HashSet;
import java.util.Set;

public class LogEntryType {
    public static final int LOG_VERSION = 15;
    public static final int LOG_VERSION_HIGHEST_REPLICABLE = 13;
    public static final int FIRST_LOG_VERSION = 1;
    public static final int LOG_VERSION_REPLICATE_OLDER = 9;
    public static final int LOG_VERSION_EXPIRE_INFO = 12;
    public static final int LOG_VERSION_DURABLE_VLSN = 13;
    public static final int UNKNOWN_FILE_HEADER_VERSION = -1;
    private static final int MAX_TYPE_NUM = 40;
    private static LogEntryType[] LOG_TYPES = new LogEntryType[40];
    public static final LogEntryType LOG_OLD_LN_TRANSACTIONAL = LogEntryType.createReplicableLogEntryType((byte)1, "LN_TX", LNLogEntry.create(LN.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_USER);
    public static final LogEntryType LOG_OLD_LN = LogEntryType.createReplicableLogEntryType((byte)2, "LN", LNLogEntry.create(LN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_USER);
    public static final LogEntryType LOG_MAPLN_TRANSACTIONAL = new LogEntryType(3, "MapLN_TX", LNLogEntry.create(MapLN.class), Txnal.TXNAL, Marshall.INSIDE_LATCH, NodeType.LN_INTERNAL);
    public static final LogEntryType LOG_MAPLN = new LogEntryType(4, "MapLN", LNLogEntry.create(MapLN.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, NodeType.LN_INTERNAL);
    public static final LogEntryType LOG_NAMELN_TRANSACTIONAL = LogEntryType.createReplicableLogEntryType((byte)5, "NameLN_TX", new NameLNLogEntry(), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_INTERNAL);
    public static final LogEntryType LOG_NAMELN = LogEntryType.createReplicableLogEntryType((byte)6, "NameLN", new NameLNLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_INTERNAL);
    public static final LogEntryType LOG_DEL_DUPLN_TRANSACTIONAL = LogEntryType.createReplicableLogEntryType((byte)7, "DelDupLN_TX", new DeletedDupLNLogEntry(), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_USER);
    public static final LogEntryType LOG_DEL_DUPLN = LogEntryType.createReplicableLogEntryType((byte)8, "DelDupLN", new DeletedDupLNLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_USER);
    public static final LogEntryType LOG_DUPCOUNTLN_TRANSACTIONAL = new LogEntryType(9, "DupCountLN_TX", LNLogEntry.create(DupCountLN.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, NodeType.OLD_DUP);
    public static final LogEntryType LOG_DUPCOUNTLN = new LogEntryType(10, "DupCountLN", LNLogEntry.create(DupCountLN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.OLD_DUP);
    public static final LogEntryType LOG_FILESUMMARYLN = new LogEntryType(11, "FileSummaryLN", LNLogEntry.create(FileSummaryLN.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, NodeType.LN_INTERNAL);
    public static final LogEntryType LOG_IN = new LogEntryType(12, "IN", INLogEntry.create(IN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.IN);
    public static final LogEntryType LOG_BIN = new LogEntryType(13, "BIN", INLogEntry.create(BIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.IN);
    public static final LogEntryType LOG_DIN = new LogEntryType(14, "DIN", INLogEntry.create(DIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.OLD_DUP);
    public static final LogEntryType LOG_DBIN = new LogEntryType(15, "DBIN", INLogEntry.create(DBIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.OLD_DUP);
    public static final LogEntryType LOG_DBTREE = new LogEntryType(16, "DbTree", SingleItemEntry.create(DbTree.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_TXN_COMMIT = LogEntryType.createReplicableLogEntryType((byte)17, "Commit", new CommitLogEntry(), Txnal.TXNAL, Marshall.INSIDE_LATCH, Replicable.REPLICABLE_MATCH, NodeType.NONE);
    public static final LogEntryType LOG_TXN_ABORT = LogEntryType.createReplicableLogEntryType((byte)18, "Abort", new AbortLogEntry(), Txnal.TXNAL, Marshall.INSIDE_LATCH, Replicable.REPLICABLE_MATCH, NodeType.NONE);
    public static final LogEntryType LOG_CKPT_START = new LogEntryType(19, "CkptStart", SingleItemEntry.create(CheckpointStart.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_CKPT_END = new LogEntryType(20, "CkptEnd", SingleItemEntry.create(CheckpointEnd.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_IN_DELETE_INFO = new LogEntryType(21, "INDelete", SingleItemEntry.create(INDeleteInfo.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_OLD_BIN_DELTA = new LogEntryType(22, "BINDelta", new OldBINDeltaLogEntry(OldBINDelta.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_OLD_DUP_BIN_DELTA = new LogEntryType(23, "DupBINDelta", new OldBINDeltaLogEntry(OldBINDelta.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_TRACE = LogEntryType.createReplicableLogEntryType((byte)24, "Trace", new TraceLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.NONE);
    public static final LogEntryType LOG_FILE_HEADER = new LogEntryType(25, "FileHeader", new FileHeaderEntry(FileHeader.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_IN_DUPDELETE_INFO = new LogEntryType(26, "INDupDelete", SingleItemEntry.create(INDupDeleteInfo.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_TXN_PREPARE = new LogEntryType(27, "Prepare", SingleItemEntry.create(TxnPrepare.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_ROLLBACK_START = new LogEntryType(28, "RollbackStart", SingleItemEntry.create(RollbackStart.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_ROLLBACK_END = new LogEntryType(29, "RollbackEnd", SingleItemEntry.create(RollbackEnd.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_MATCHPOINT = LogEntryType.createReplicableLogEntryType((byte)30, "Matchpoint", new MatchpointLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_MATCH, NodeType.NONE);
    public static final LogEntryType LOG_DEL_LN_TRANSACTIONAL = new UserLNLogEntryType(31, "DEL_LN_TX", Txnal.TXNAL);
    public static final LogEntryType LOG_DEL_LN = new UserLNLogEntryType(32, "DEL_LN", Txnal.NON_TXNAL);
    public static final LogEntryType LOG_INS_LN_TRANSACTIONAL = new UserLNLogEntryType(33, "INS_LN_TX", Txnal.TXNAL);
    public static final LogEntryType LOG_INS_LN = new UserLNLogEntryType(34, "INS_LN", Txnal.NON_TXNAL);
    public static final LogEntryType LOG_UPD_LN_TRANSACTIONAL = new UserLNLogEntryType(35, "UPD_LN_TX", Txnal.TXNAL);
    public static final LogEntryType LOG_UPD_LN = new UserLNLogEntryType(36, "UPD_LN", Txnal.NON_TXNAL);
    public static final LogEntryType LOG_BIN_DELTA = new LogEntryType(37, "NewBINDelta", new BINDeltaLogEntry(BIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.IN);
    public static final LogEntryType LOG_IMMUTABLE_FILE = new LogEntryType(38, "ImmutableFile", SingleItemEntry.create(EmptyLogEntry.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_RESTORE_REQUIRED = new LogEntryType(39, "RestoreRequired", SingleItemEntry.create(RestoreRequired.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.NONE);
    public static final LogEntryType LOG_RESERVED_FILE_LN = new LogEntryType(40, "ReservedFileLN", LNLogEntry.create(LN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, NodeType.LN_INTERNAL);
    private final byte typeNum;
    private final String displayName;
    private final LogEntry logEntry;
    private Txnal isTransactional;
    private Marshall marshallBehavior;
    private Replicable replicationPossible;
    private NodeType nodeType;

    LogEntryType(byte typeNum) {
        this.typeNum = typeNum;
        this.displayName = null;
        this.logEntry = null;
    }

    LogEntryType(byte typeNum, String displayName) {
        assert (typeNum > 40);
        this.typeNum = typeNum;
        this.displayName = displayName;
        this.logEntry = null;
    }

    private LogEntryType(byte typeNum, String displayName, LogEntry logEntry, Txnal isTransactional, Marshall marshallBehavior, NodeType nodeType) {
        this(typeNum, displayName, logEntry, isTransactional, marshallBehavior, Replicable.LOCAL, nodeType);
    }

    private static LogEntryType createReplicableLogEntryType(byte typeNum, String displayName, ReplicableLogEntry logEntry, Txnal isTransactional, Marshall marshallBehavior, Replicable replicationPossible, NodeType nodeType) {
        return new LogEntryType(typeNum, displayName, logEntry, isTransactional, marshallBehavior, replicationPossible, nodeType);
    }

    private LogEntryType(byte typeNum, String displayName, LogEntry logEntry, Txnal isTransactional, Marshall marshallBehavior, Replicable replicationPossible, NodeType nodeType) {
        this.typeNum = typeNum;
        this.displayName = displayName;
        this.logEntry = logEntry;
        this.isTransactional = isTransactional;
        this.marshallBehavior = marshallBehavior;
        this.replicationPossible = replicationPossible;
        this.nodeType = nodeType;
        logEntry.setLogType(this);
        LogEntryType.LOG_TYPES[typeNum - 1] = this;
        assert (logEntry != null && replicationPossible != null);
        assert (!replicationPossible.isReplicable() || logEntry instanceof ReplicableLogEntry) : "Replicable log types must have replicable log entries";
    }

    public static LogEntryType findType(byte typeNum) {
        if (typeNum <= 0 || typeNum > 40) {
            return null;
        }
        return LOG_TYPES[typeNum - 1];
    }

    public static Set<LogEntryType> getAllTypes() {
        HashSet<LogEntryType> ret = new HashSet<LogEntryType>();
        for (int i = 0; i < 40; ++i) {
            ret.add(LOG_TYPES[i]);
        }
        return ret;
    }

    public LogEntry getSharedLogEntry() {
        return this.logEntry;
    }

    public LogEntry getNewLogEntry() throws DatabaseException {
        return this.logEntry.clone();
    }

    public byte getTypeNum() {
        return this.typeNum;
    }

    static boolean isValidType(byte typeNum) {
        return typeNum > 0 && typeNum <= 40;
    }

    public String toStringNoVersion() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean equalsType(byte type) {
        return this.typeNum == type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogEntryType)) {
            return false;
        }
        return this.typeNum == ((LogEntryType)obj).typeNum;
    }

    public int hashCode() {
        return this.typeNum;
    }

    public boolean isTransactional() {
        return this.isTransactional.isTransactional();
    }

    public boolean marshallOutsideLatch() {
        return this.marshallBehavior.marshallOutsideLatch();
    }

    public boolean compareTypeAndVersion(int versionA, int versionB, byte typeB) {
        return this.typeNum == typeB;
    }

    public boolean isReplicationPossible() {
        return this.replicationPossible.isReplicable();
    }

    public boolean isSyncPoint() {
        return this.replicationPossible.isMatchable();
    }

    public static boolean isSyncPoint(byte entryType) {
        return LogEntryType.findType(entryType).isSyncPoint();
    }

    public boolean isNodeType() {
        return this.nodeType != NodeType.NONE;
    }

    public boolean isUserLNType() {
        return this.nodeType == NodeType.LN_USER;
    }

    public boolean isLNType() {
        return this.nodeType == NodeType.LN_INTERNAL || this.isUserLNType();
    }

    public boolean isINType() {
        return this.nodeType == NodeType.IN;
    }

    public boolean isOldDupType() {
        return this.nodeType == NodeType.OLD_DUP;
    }

    public static boolean compareTypeAndVersion(int versionA, byte typeA, int versionB, byte typeB) {
        LogEntryType entryA = LogEntryType.findType(typeA);
        return entryA.compareTypeAndVersion(versionA, versionB, typeB);
    }

    private static class UserLNLogEntryType
    extends LogEntryType {
        public UserLNLogEntryType(byte typeNum, String displayName, Txnal txnal) {
            super(typeNum, displayName, LNLogEntry.create(LN.class), txnal, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH, NodeType.LN_USER);
        }

        @Override
        public boolean compareTypeAndVersion(int versionA, int versionB, byte typeB) {
            if (versionA <= versionB && this.getTypeNum() == typeB) {
                return true;
            }
            return versionA > versionB && this.isEquivalentOldType(typeB);
        }

        private boolean isEquivalentOldType(byte typeB) {
            return !this.isTransactional() && typeB == LOG_OLD_LN.getTypeNum() || this.isTransactional() && typeB == LOG_OLD_LN_TRANSACTIONAL.getTypeNum();
        }
    }

    static enum NodeType {
        NONE,
        IN,
        OLD_DUP,
        LN_INTERNAL,
        LN_USER;

    }

    static enum Replicable {
        REPLICABLE_MATCH(true, true),
        REPLICABLE_NO_MATCH(true, false),
        LOCAL(false, false);

        private final boolean isReplicable;
        private final boolean isMatchable;

        private Replicable(boolean isReplicable, boolean isMatchable) {
            this.isReplicable = isReplicable;
            this.isMatchable = isMatchable;
        }

        boolean isReplicable() {
            return this.isReplicable;
        }

        boolean isMatchable() {
            return this.isMatchable;
        }
    }

    static enum Marshall {
        OUTSIDE_LATCH(true),
        INSIDE_LATCH(false);

        private final boolean marshallOutsideLatch;

        private Marshall(boolean marshallOutsideLatch) {
            this.marshallOutsideLatch = marshallOutsideLatch;
        }

        boolean marshallOutsideLatch() {
            return this.marshallOutsideLatch;
        }
    }

    static enum Txnal {
        TXNAL(true),
        NON_TXNAL(false);

        private final boolean isTxnal;

        private Txnal(boolean isTxnal) {
            this.isTxnal = isTxnal;
        }

        boolean isTransactional() {
            return this.isTxnal;
        }
    }
}

