/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.StoppableThread;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class FileDeletionDetector {
    private final EnvironmentImpl envImpl;
    private final Set<String> filesDeletedByJE;
    private final WatchService fileDeletionWatcher;
    private final Timer fileDeletionTimer;
    private final FileDeleteDetectTask fileDeletionTask;
    private Map<WatchKey, File> fileDeletionWatchKeys;

    FileDeletionDetector(File dbEnvHome, File[] dbEnvDataDirs, EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.filesDeletedByJE = new HashSet<String>();
        this.fileDeletionWatchKeys = new HashMap<WatchKey, File>();
        try {
            this.fileDeletionWatcher = FileSystems.getDefault().newWatchService();
            if (dbEnvDataDirs != null) {
                for (File f : dbEnvDataDirs) {
                    WatchKey key = f.toPath().register(this.fileDeletionWatcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                    this.fileDeletionWatchKeys.put(key, f);
                }
            } else {
                WatchKey key = dbEnvHome.toPath().register(this.fileDeletionWatcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                this.fileDeletionWatchKeys.put(key, dbEnvHome);
            }
        }
        catch (IOException ie) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION, "Can not register " + dbEnvHome.toString() + " or its sub-directories to WatchService.", ie);
        }
        DbConfigManager configManager = envImpl.getConfigManager();
        int interval = configManager.getDuration(EnvironmentParams.LOG_DETECT_FILE_DELETE_INTERVAL);
        this.fileDeletionTimer = new Timer(envImpl.makeDaemonThreadName("FileDeletionDetector"), true);
        this.fileDeletionTask = new FileDeleteDetectTask();
        this.fileDeletionTimer.schedule((TimerTask)this.fileDeletionTask, 0L, (long)interval);
    }

    private void handleUnexpectedThrowable(Thread t, Throwable e) {
        StoppableThread.handleUncaughtException(this.envImpl.getLogger(), this.envImpl, t, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogFileDeleteEvents() throws Exception {
        block8: {
            WatchKey key;
            do {
                if ((key = this.fileDeletionWatcher.poll()) == null) {
                    for (File file : this.fileDeletionWatchKeys.values()) {
                        if (file.exists()) continue;
                        String dir = file.getCanonicalPath();
                        throw new IOException("Directory " + dir + " does not exist now. Something abnormal may happen.");
                    }
                    break block8;
                }
                for (WatchEvent watchEvent : key.pollEvents()) {
                    WatchEvent ev;
                    String fileName;
                    WatchEvent.Kind kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !(fileName = ((Path)(ev = this.cast(watchEvent)).context()).toString()).endsWith(".jdb")) continue;
                    Set<String> set = this.filesDeletedByJE;
                    synchronized (set) {
                        if (!this.filesDeletedByJE.contains(fileName)) {
                            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_UNEXPECTED_FILE_DELETION, "Log file " + fileName + " was deleted unexpectedly.");
                        }
                        this.filesDeletedByJE.remove(fileName);
                    }
                }
            } while (key.reset());
            String dir = this.fileDeletionWatchKeys.get(key).getCanonicalPath();
            throw new IOException("Watch Key corresponding to " + dir + " return false when reset. Something abnormal may happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeletedFile(String fileName) {
        Set<String> set = this.filesDeletedByJE;
        synchronized (set) {
            this.filesDeletedByJE.add(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.fileDeletionTask.cancel();
        this.fileDeletionTimer.cancel();
        WatchService watchService = this.fileDeletionWatcher;
        synchronized (watchService) {
            this.fileDeletionWatcher.close();
        }
    }

    <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private class FileDeleteDetectTask
    extends TimerTask {
        private FileDeleteDetectTask() {
        }

        @Override
        public void run() {
            boolean success = false;
            try {
                FileDeletionDetector.this.processLogFileDeleteEvents();
                success = true;
            }
            catch (EnvironmentFailureException ie) {
            }
            catch (Exception e) {
                if (FileDeletionDetector.this.envImpl.isValid() && !FileDeletionDetector.this.envImpl.isClosing()) {
                    FileDeletionDetector.this.handleUnexpectedThrowable(Thread.currentThread(), e);
                }
            }
            catch (Error e) {
                FileDeletionDetector.this.handleUnexpectedThrowable(Thread.currentThread(), e);
            }
            finally {
                if (!success) {
                    try {
                        FileDeletionDetector.this.close();
                    }
                    catch (IOException ie) {
                        FileDeletionDetector.this.handleUnexpectedThrowable(Thread.currentThread(), ie);
                    }
                }
            }
        }
    }
}

