/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.ConfigParam;

public class ShortConfigParam
extends ConfigParam {
    private static final String DEBUG_NAME = ShortConfigParam.class.getName();
    private Short min;
    private Short max;

    public ShortConfigParam(String configName, Short minVal, Short maxVal, Short defaultValue2, boolean mutable, boolean forReplication) {
        super(configName, defaultValue2.toString(), mutable, forReplication);
        this.min = minVal;
        this.max = maxVal;
    }

    private void validate(Short value) throws IllegalArgumentException {
        if (value != null) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ": param " + this.name + " doesn't validate, " + value + " is less than min of " + this.min);
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ": param " + this.name + " doesn't validate, " + value + " is greater than max of " + this.max);
            }
        }
    }

    @Override
    public void validateValue(String value) throws IllegalArgumentException {
        try {
            this.validate(new Short(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(DEBUG_NAME + ": " + value + " not valid value for " + this.name);
        }
    }

    public Short getMin() {
        return this.min;
    }
}

