/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class FileSummary
implements Loggable,
Cloneable {
    public int totalCount;
    public int totalSize;
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int maxLNSize;
    public int obsoleteINCount;
    public int obsoleteLNCount;
    public int obsoleteLNSize;
    public int obsoleteLNSizeCounted;

    public FileSummary clone() {
        try {
            return (FileSummary)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.totalCount == 0 && this.totalSize == 0 && this.obsoleteINCount == 0 && this.obsoleteLNCount == 0;
    }

    public int getObsoleteLNSize() {
        float avgLNSizeNotCounted;
        if (this.totalLNCount == 0) {
            return 0;
        }
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        long obsSize = obsLNSize;
        int obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted > 0 && !Float.isNaN(avgLNSizeNotCounted = this.getAvgObsoleteLNSizeNotCounted())) {
            obsSize += (long)((int)((float)obsCountNotCounted * avgLNSizeNotCounted));
        }
        return obsSize > (long)this.totalLNSize ? this.totalLNSize : (int)obsSize;
    }

    public float getAvgObsoleteLNSizeNotCounted() {
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        int obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted <= 0) {
            return Float.NaN;
        }
        int totalSizeNotCounted = this.totalLNSize - obsLNSize;
        int totalCountNotCounted = this.totalLNCount - obsLNSizeCounted;
        if (totalSizeNotCounted <= 0 || totalCountNotCounted <= 0) {
            return Float.NaN;
        }
        return (float)totalSizeNotCounted / (float)totalCountNotCounted;
    }

    public int getMaxObsoleteLNSize() {
        if (this.maxLNSize == 0) {
            return this.getObsoleteLNSize();
        }
        if (this.totalLNCount == 0) {
            return 0;
        }
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        long obsSize = obsLNSize;
        long obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted > 0L) {
            long maxLNSizeNotCounted = obsCountNotCounted * (long)this.maxLNSize;
            long maxObsSizeNotCounted = this.totalLNSize - obsLNSize - (this.totalLNCount - obsLNCount) * 17;
            obsSize += Math.min(maxLNSizeNotCounted, maxObsSizeNotCounted);
        }
        return obsSize > (long)this.totalLNSize ? this.totalLNSize : (int)obsSize;
    }

    public int getObsoleteINSize() {
        if (this.totalINCount == 0) {
            return 0;
        }
        int obsINCount = Math.min(this.obsoleteINCount, this.totalINCount);
        float size = this.totalINSize;
        float avgSizePerIN = size / (float)this.totalINCount;
        return (int)((float)obsINCount * avgSizePerIN);
    }

    public int getObsoleteSize() {
        return this.calculateObsoleteSize(this.getObsoleteLNSize());
    }

    public int getMaxObsoleteSize() {
        return this.calculateObsoleteSize(this.getMaxObsoleteLNSize());
    }

    private int calculateObsoleteSize(int lnObsoleteSize) {
        if (this.totalSize <= 0) {
            return 0;
        }
        int leftoverSize = this.totalSize - (this.totalINSize + this.totalLNSize);
        int obsoleteSize = lnObsoleteSize + this.getObsoleteINSize() + leftoverSize;
        if (obsoleteSize > this.totalSize) {
            obsoleteSize = this.totalSize;
        }
        return obsoleteSize;
    }

    int getEntriesCounted() {
        return this.totalCount + this.obsoleteLNCount + this.obsoleteINCount;
    }

    public int utilization() {
        return FileSummary.utilization(this.getObsoleteSize(), this.totalSize);
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize == 0L) {
            return 0;
        }
        return Math.round(100.0f * (float)(totalSize - obsoleteSize) / (float)totalSize);
    }

    public void reset() {
        this.totalCount = 0;
        this.totalSize = 0;
        this.totalINCount = 0;
        this.totalINSize = 0;
        this.totalLNCount = 0;
        this.totalLNSize = 0;
        this.maxLNSize = 0;
        this.obsoleteINCount = 0;
        this.obsoleteLNCount = 0;
        this.obsoleteLNSize = 0;
        this.obsoleteLNSizeCounted = 0;
    }

    public void add(FileSummary o) {
        this.totalCount += o.totalCount;
        this.totalSize += o.totalSize;
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        if (this.maxLNSize < o.maxLNSize) {
            this.maxLNSize = o.maxLNSize;
        }
        this.obsoleteINCount += o.obsoleteINCount;
        this.obsoleteLNCount += o.obsoleteLNCount;
        this.obsoleteLNSize += o.obsoleteLNSize;
        this.obsoleteLNSizeCounted += o.obsoleteLNSizeCounted;
    }

    @Override
    public int getLogSize() {
        return 11 * LogUtils.getIntLogSize();
    }

    @Override
    public void writeToLog(ByteBuffer buf2) {
        LogUtils.writeInt(buf2, this.totalCount);
        LogUtils.writeInt(buf2, this.totalSize);
        LogUtils.writeInt(buf2, this.totalINCount);
        LogUtils.writeInt(buf2, this.totalINSize);
        LogUtils.writeInt(buf2, this.totalLNCount);
        LogUtils.writeInt(buf2, this.totalLNSize);
        LogUtils.writeInt(buf2, this.maxLNSize);
        LogUtils.writeInt(buf2, this.obsoleteINCount);
        LogUtils.writeInt(buf2, this.obsoleteLNCount);
        LogUtils.writeInt(buf2, this.obsoleteLNSize);
        LogUtils.writeInt(buf2, this.obsoleteLNSizeCounted);
    }

    @Override
    public void readFromLog(ByteBuffer buf2, int entryVersion) {
        this.totalCount = LogUtils.readInt(buf2);
        this.totalSize = LogUtils.readInt(buf2);
        this.totalINCount = LogUtils.readInt(buf2);
        this.totalINSize = LogUtils.readInt(buf2);
        this.totalLNCount = LogUtils.readInt(buf2);
        this.totalLNSize = LogUtils.readInt(buf2);
        if (entryVersion >= 8) {
            this.maxLNSize = LogUtils.readInt(buf2);
        }
        this.obsoleteINCount = LogUtils.readInt(buf2);
        if (this.obsoleteINCount == -1) {
            this.obsoleteINCount = this.totalINCount;
        }
        this.obsoleteLNCount = LogUtils.readInt(buf2);
        if (entryVersion >= 3) {
            this.obsoleteLNSize = LogUtils.readInt(buf2);
            this.obsoleteLNSizeCounted = LogUtils.readInt(buf2);
        } else {
            this.obsoleteLNSize = 0;
            this.obsoleteLNSizeCounted = 0;
        }
    }

    @Override
    public void dumpLog(StringBuilder buf2, boolean verbose) {
        buf2.append("<summary totalCount=\"");
        buf2.append(this.totalCount);
        buf2.append("\" totalSize=\"");
        buf2.append(this.totalSize);
        buf2.append("\" totalINCount=\"");
        buf2.append(this.totalINCount);
        buf2.append("\" totalINSize=\"");
        buf2.append(this.totalINSize);
        buf2.append("\" totalLNCount=\"");
        buf2.append(this.totalLNCount);
        buf2.append("\" totalLNSize=\"");
        buf2.append(this.totalLNSize);
        buf2.append("\" maxLNSize=\"");
        buf2.append(this.maxLNSize);
        buf2.append("\" obsoleteINCount=\"");
        buf2.append(this.obsoleteINCount);
        buf2.append("\" obsoleteLNCount=\"");
        buf2.append(this.obsoleteLNCount);
        buf2.append("\" obsoleteLNSize=\"");
        buf2.append(this.obsoleteLNSize);
        buf2.append("\" obsoleteLNSizeCounted=\"");
        buf2.append(this.obsoleteLNSizeCounted);
        buf2.append("\" getObsoleteSize=\"");
        buf2.append(this.getObsoleteSize());
        buf2.append("\" getObsoleteINSize=\"");
        buf2.append(this.getObsoleteINSize());
        buf2.append("\" getObsoleteLNSize=\"");
        buf2.append(this.getObsoleteLNSize());
        buf2.append("\" getMaxObsoleteSize=\"");
        buf2.append(this.getMaxObsoleteSize());
        buf2.append("\" getMaxObsoleteLNSize=\"");
        buf2.append(this.getMaxObsoleteLNSize());
        buf2.append("\" getAvgObsoleteLNSizeNotCounted=\"");
        buf2.append(this.getAvgObsoleteLNSizeNotCounted());
        buf2.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuilder buf2 = new StringBuilder();
        this.dumpLog(buf2, true);
        return buf2.toString();
    }
}

