/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.SortedPackedLongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.Put;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.cleaner.ExpirationTracker;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpirationProfile {
    private static Pair<Integer, Integer> PAIR_OF_ZEROS = new Pair<Integer, Integer>(0, 0);
    private final EnvironmentImpl env;
    private final Map<Long, ExpInfo> map;
    private int lastRefreshHour = -1;
    private int lastRefreshDay = -1;
    private boolean anyExpirationInHours;
    private final Map<Long, ExpirationTracker> completedTrackers;
    private DatabaseImpl db;

    public ExpirationProfile(EnvironmentImpl env) {
        this.env = env;
        this.map = new HashMap<Long, ExpInfo>();
        this.completedTrackers = new HashMap<Long, ExpirationTracker>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpirationProfile(ExpirationProfile other) {
        this.env = other.env;
        this.db = other.db;
        Map<Long, ExpInfo> map = other.map;
        synchronized (map) {
            this.map = new HashMap<Long, ExpInfo>(other.map);
        }
        this.completedTrackers = Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCache(StartupTracker.Counter counter, ProgressListener<RecoveryProgress> listener) {
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            assert (this.db == null);
            assert (this.completedTrackers.isEmpty());
            this.db = this.env.getDbTree().openNonRepInternalDB(DbType.EXPIRATION);
            if (this.db == null) {
                return;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
            boolean[] filesHaveRecords = new boolean[existingFiles.length];
            FileProcessor processor = this.env.getCleaner().createProcessor();
            long lastFileNum = this.env.getFileManager().getCurrentFileNum();
            if (!this.env.isReadOnly()) {
                if (existingFiles.length > 0) {
                    this.env.flushLog(false);
                    ExpirationTracker tracker = processor.countExpiration(lastFileNum);
                    this.env.getLogManager().initExpirationTracker(tracker);
                } else {
                    this.env.getLogManager().initExpirationTracker(new ExpirationTracker(0L));
                }
            }
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            try (Cursor cursor = DbInternal.makeCursor(this.db, (Locker)locker, null);){
                while (cursor.get(key, data, Get.NEXT, null) != null) {
                    counter.incNumRead();
                    long fileNum = SortedPackedLongBinding.entryToLong(key);
                    int i = Arrays.binarySearch(existingFiles, (Object)fileNum);
                    if (i >= 0 && (Long)existingFiles[i] < lastFileNum) {
                        filesHaveRecords[i] = true;
                        byte[] serializedForm = data.getData();
                        if (serializedForm.length <= 0) continue;
                        counter.incNumProcessed();
                        this.map.put(fileNum, new ExpInfo(serializedForm, 0));
                        continue;
                    }
                    if (this.env.isReadOnly()) continue;
                    counter.incNumDeleted();
                    cursor.delete();
                }
            }
            finally {
                locker.operationEnd();
            }
            for (int i = 0; i < existingFiles.length && (Long)existingFiles[i] < lastFileNum; ++i) {
                if (filesHaveRecords[i]) continue;
                long fileNum = (Long)existingFiles[i];
                counter.incNumAux();
                if (listener != null) {
                    listener.progress(RecoveryProgress.POPULATE_EXPIRATION_PROFILE, 1L, -1L);
                }
                ExpirationTracker tracker = processor.countExpiration(fileNum);
                this.putFile(tracker, 0);
                LoggerUtils.info(this.env.getLogger(), this.env, "Loaded missing expiration data from file 0x" + Long.toHexString(fileNum));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFile(ExpirationTracker tracker, int expiredSize) {
        long fileNum = tracker.getFileNum();
        byte[] serializedForm = tracker.serialize();
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            if (this.db != null && !this.env.isReadOnly()) {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                SortedPackedLongBinding.longToEntry(fileNum, key);
                data.setData(serializedForm);
                BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
                try (Cursor cursor = DbInternal.makeCursor(this.db, (Locker)locker, null);){
                    cursor.put(key, data, Put.OVERWRITE, null);
                }
                finally {
                    locker.operationEnd();
                }
            }
            if (serializedForm.length > 0) {
                this.map.put(fileNum, new ExpInfo(serializedForm, expiredSize));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFile(long fileNum) {
        if (this.db == null || this.env.isReadOnly()) {
            return;
        }
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            this.map.remove(fileNum);
            DatabaseEntry key = new DatabaseEntry();
            SortedPackedLongBinding.longToEntry(fileNum, key);
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            try (Cursor cursor = DbInternal.makeCursor(this.db, (Locker)locker, null);){
                if (cursor.get(key, null, Get.SEARCH, LockMode.RMW.toReadOptions()) != null) {
                    cursor.delete(null);
                }
            }
            finally {
                locker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedTracker(ExpirationTracker tracker) {
        if (this.db == null) {
            return;
        }
        long fileNum = tracker.getFileNum();
        Map<Long, ExpirationTracker> map = this.completedTrackers;
        synchronized (map) {
            assert (!this.completedTrackers.containsKey(fileNum));
            this.completedTrackers.put(fileNum, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompletedTrackers() {
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            ArrayList<ExpirationTracker> trackers;
            Map<Long, ExpirationTracker> map2 = this.completedTrackers;
            synchronized (map2) {
                trackers = new ArrayList<ExpirationTracker>(this.completedTrackers.values());
            }
            for (ExpirationTracker tracker : trackers) {
                if (tracker.hasPendingTrackCalls()) continue;
                this.putFile(tracker, 0);
                Map<Long, ExpirationTracker> map3 = this.completedTrackers;
                synchronized (map3) {
                    this.completedTrackers.remove(tracker.getFileNum());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(long time) {
        if (this.db == null) {
            return;
        }
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            int hourLimit = (int)(time / 3600000L);
            if (hourLimit == this.lastRefreshHour) {
                return;
            }
            int dayLimit = hourLimit / 24;
            boolean newDayLimit = dayLimit != this.lastRefreshDay;
            this.processCompletedTrackers();
            this.lastRefreshHour = hourLimit;
            this.lastRefreshDay = dayLimit;
            this.anyExpirationInHours = false;
            for (ExpInfo info : this.map.values()) {
                if (!ExpirationTracker.isExpirationInHours(info.serializedForm)) continue;
                this.anyExpirationInHours = true;
                break;
            }
            if (!newDayLimit && !this.anyExpirationInHours) {
                return;
            }
            for (ExpInfo info : this.map.values()) {
                info.previousExpiredBytes = info.currentExpiredBytes;
                info.currentExpiredBytes = ExpirationTracker.getExpiredBytes(info.serializedForm, dayLimit, hourLimit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpiredBytes(long fileNum) {
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            ExpInfo info = this.map.get(fileNum);
            return info != null ? info.currentExpiredBytes : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Integer> getExpiredBytes(long fileNum, long time) {
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            ExpInfo info = this.map.get(fileNum);
            if (info == null) {
                return PAIR_OF_ZEROS;
            }
            int newlyExpiredBytes = info.currentExpiredBytes - info.previousExpiredBytes;
            if (newlyExpiredBytes == 0) {
                return new Pair<Integer, Integer>(info.currentExpiredBytes, info.currentExpiredBytes);
            }
            long intervalMs = this.anyExpirationInHours ? 3600000L : 86400000L;
            long currentMs = time % intervalMs;
            int gradualBytes = info.previousExpiredBytes + (int)((long)newlyExpiredBytes * currentMs / intervalMs);
            return new Pair<Integer, Integer>(info.currentExpiredBytes, gradualBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(long fileNum) {
        Map<Long, ExpInfo> map = this.map;
        synchronized (map) {
            ExpInfo info = this.map.get(fileNum);
            return info != null ? info.toString() : "NoExpInfo";
        }
    }

    private static class ExpInfo {
        final byte[] serializedForm;
        int currentExpiredBytes = 0;
        int previousExpiredBytes = 0;

        ExpInfo(byte[] serializedForm, int currentExpiredBytes) {
            this.serializedForm = serializedForm;
            this.currentExpiredBytes = currentExpiredBytes;
        }

        public String toString() {
            return "{ExpInfo currentBytes = " + this.currentExpiredBytes + " " + ExpirationTracker.toString(this.serializedForm) + '}';
        }
    }
}

