/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class DbFileSummary
implements Loggable,
Cloneable {
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int obsoleteINCount;
    public int obsoleteLNCount;
    public int obsoleteLNSize;
    public int obsoleteLNSizeCounted;

    public void add(DbFileSummary o) {
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        this.obsoleteINCount += o.obsoleteINCount;
        this.obsoleteLNCount += o.obsoleteLNCount;
        this.obsoleteLNSize += o.obsoleteLNSize;
        this.obsoleteLNSizeCounted += o.obsoleteLNSizeCounted;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getPackedIntLogSize(this.totalINCount) + LogUtils.getPackedIntLogSize(this.totalINSize) + LogUtils.getPackedIntLogSize(this.totalLNCount) + LogUtils.getPackedIntLogSize(this.totalLNSize) + LogUtils.getPackedIntLogSize(this.obsoleteINCount) + LogUtils.getPackedIntLogSize(this.obsoleteLNCount) + LogUtils.getPackedIntLogSize(this.obsoleteLNSize) + LogUtils.getPackedIntLogSize(this.obsoleteLNSizeCounted);
    }

    @Override
    public void writeToLog(ByteBuffer buf2) {
        LogUtils.writePackedInt(buf2, this.totalINCount);
        LogUtils.writePackedInt(buf2, this.totalINSize);
        LogUtils.writePackedInt(buf2, this.totalLNCount);
        LogUtils.writePackedInt(buf2, this.totalLNSize);
        LogUtils.writePackedInt(buf2, this.obsoleteINCount);
        LogUtils.writePackedInt(buf2, this.obsoleteLNCount);
        LogUtils.writePackedInt(buf2, this.obsoleteLNSize);
        LogUtils.writePackedInt(buf2, this.obsoleteLNSizeCounted);
    }

    @Override
    public void readFromLog(ByteBuffer buf2, int entryTypeVersion) {
        this.totalINCount = LogUtils.readPackedInt(buf2);
        this.totalINSize = LogUtils.readPackedInt(buf2);
        this.totalLNCount = LogUtils.readPackedInt(buf2);
        this.totalLNSize = LogUtils.readPackedInt(buf2);
        this.obsoleteINCount = LogUtils.readPackedInt(buf2);
        this.obsoleteLNCount = LogUtils.readPackedInt(buf2);
        this.obsoleteLNSize = LogUtils.readPackedInt(buf2);
        this.obsoleteLNSizeCounted = LogUtils.readPackedInt(buf2);
    }

    @Override
    public void dumpLog(StringBuilder buf2, boolean verbose) {
        buf2.append("<summary totalINCount=\"");
        buf2.append(this.totalINCount);
        buf2.append("\" totalINSize=\"");
        buf2.append(this.totalINSize);
        buf2.append("\" totalLNCount=\"");
        buf2.append(this.totalLNCount);
        buf2.append("\" totalLNSize=\"");
        buf2.append(this.totalLNSize);
        buf2.append("\" obsoleteINCount=\"");
        buf2.append(this.obsoleteINCount);
        buf2.append("\" obsoleteLNCount=\"");
        buf2.append(this.obsoleteLNCount);
        buf2.append("\" obsoleteLNSize=\"");
        buf2.append(this.obsoleteLNSize);
        buf2.append("\" obsoleteLNSizeCounted=\"");
        buf2.append(this.obsoleteLNSizeCounted);
        buf2.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public DbFileSummary clone() {
        try {
            return (DbFileSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        StringBuilder buf2 = new StringBuilder();
        this.dumpLog(buf2, true);
        return buf2.toString();
    }
}

