/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionEvent;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DiskOrderedCursorImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Properties;

public class DbInternal {
    public static OperationResult DEFAULT_RESULT = new OperationResult(0L, false);

    public static void invalidate(Database db) {
        db.invalidate();
    }

    public static void setPreempted(Database db, String dbName, String msg) {
        db.setPreempted(dbName, msg);
    }

    public static EnvironmentImpl getEnvironmentImpl(Environment env) {
        return env.getMaybeNullEnvImpl();
    }

    public static EnvironmentImpl getNonNullEnvImpl(Environment env) {
        return env.getNonNullEnvImpl();
    }

    public static void clearEnvImpl(Environment env) {
        env.clearEnvImpl();
    }

    public static EnvironmentImpl checkOpen(Environment env) {
        return env.checkOpen();
    }

    public static void closeInternalHandle(Environment env) {
        env.closeInternalHandle();
    }

    public static String getDbDebugName(Database dbHandle) {
        return dbHandle.getDebugName();
    }

    public static SecondaryAssociation getSecondaryAssociation(Database db) {
        return db.getSecondaryAssociation();
    }

    public static SecondaryConfig getPrivateSecondaryConfig(SecondaryDatabase secDb) {
        return secDb.getPrivateSecondaryConfig();
    }

    public static boolean readPrimaryAfterGet(Cursor cursor, Database priDb, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secDirtyRead, boolean lockPrimaryOnly, boolean allowNoData, Locker locker, SecondaryDatabase secDb, SecondaryAssociation secAssoc) {
        return cursor.readPrimaryAfterGet(priDb, key, pKey, data, lockMode, secDirtyRead, lockPrimaryOnly, allowNoData, locker, secDb, secAssoc);
    }

    public static OperationResult position(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        return cursor.position(key, data, lockMode, null, first);
    }

    public static OperationResult search(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode, boolean countOpStat) {
        return cursor.search(key, data, lockMode, cacheMode, searchMode, countOpStat);
    }

    public static OperationResult searchForReplay(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, SearchMode searchMode) {
        return cursor.searchForReplay(key, data, lockMode, null, searchMode);
    }

    public static OperationResult retrieveNext(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) throws DatabaseException {
        return cursor.retrieveNext(key, data, lockMode, null, getMode);
    }

    public static boolean advanceCursor(Cursor cursor, DatabaseEntry key, DatabaseEntry data) {
        return cursor.advanceCursor(key, data);
    }

    public static OperationResult deleteInternal(Cursor cursor, ReplicationContext repContext) {
        return cursor.deleteInternal(repContext, null);
    }

    public static OperationResult deleteForReplay(Cursor cursor, ReplicationContext repContext) {
        return cursor.deleteForReplay(repContext);
    }

    public static OperationResult putForReplay(Cursor cursor, DatabaseEntry key, DatabaseEntry data, LN ln, int expiration, boolean expirationInHours, PutMode putMode, ReplicationContext repContext) {
        return cursor.putForReplay(key, data, ln, expiration, expirationInHours, putMode, repContext);
    }

    public static OperationStatus search(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, LockMode lockMode) {
        OperationResult result2 = DbInternal.search(cursor, key, pKey, data, searchMode, DbInternal.getReadOptions(lockMode));
        return result2 != null ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
    }

    public static OperationResult search(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, ReadOptions options) {
        DbCompat.OpResult result2;
        boolean first;
        DatabaseImpl dbImpl = cursor.getDatabaseImpl();
        KeyRange range = new KeyRange(dbImpl.getBtreeComparator());
        switch (searchMode) {
            case GT: 
            case GTE: {
                range = range.subRange(key, searchMode == Search.GTE, null, false);
                first = true;
                break;
            }
            case LT: 
            case LTE: {
                range = range.subRange(null, false, key, searchMode == Search.LTE);
                first = false;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState();
            }
        }
        RangeCursor rangeCursor = new RangeCursor(range, null, dbImpl.getSortedDuplicates(), cursor);
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(options);
        DbCompat.OpResult opResult = result2 = first ? rangeCursor.getFirst(key, pKey, data, opReadOptions) : rangeCursor.getLast(key, pKey, data, opReadOptions);
        assert (cursor == rangeCursor.getCursor());
        return result2.jeResult;
    }

    public static OperationStatus searchBoth(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, LockMode lockMode) {
        OperationResult result2 = DbInternal.searchBoth(cursor, key, pKey, data, searchMode, DbInternal.getReadOptions(lockMode));
        return result2 != null ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
    }

    public static OperationResult searchBoth(Cursor cursor, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Search searchMode, ReadOptions options) {
        DbCompat.OpResult result2;
        boolean first;
        LockMode lockMode = options != null ? options.getLockMode() : null;
        DatabaseImpl dbImpl = cursor.getDatabaseImpl();
        KeyRange range = new KeyRange(dbImpl.getBtreeComparator());
        range = range.subRange(key);
        KeyRange pKeyRange = new KeyRange(dbImpl.getDuplicateComparator());
        switch (searchMode) {
            case GT: 
            case GTE: {
                pKeyRange = pKeyRange.subRange(pKey, searchMode == Search.GTE, null, false);
                first = true;
                break;
            }
            case LT: 
            case LTE: {
                pKeyRange = pKeyRange.subRange(null, false, pKey, searchMode == Search.LTE);
                first = false;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState();
            }
        }
        RangeCursor rangeCursor = new RangeCursor(range, pKeyRange, dbImpl.getSortedDuplicates(), cursor);
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(options);
        DbCompat.OpResult opResult = result2 = first ? rangeCursor.getFirst(key, pKey, data, opReadOptions) : rangeCursor.getLast(key, pKey, data, opReadOptions);
        assert (cursor == rangeCursor.getCursor());
        return result2.jeResult;
    }

    public static CursorImpl getCursorImpl(Cursor cursor) {
        return cursor.getCursorImpl();
    }

    public static Cursor makeCursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig) {
        return DbInternal.makeCursor(databaseImpl, locker, cursorConfig, true);
    }

    public static Cursor makeCursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        Cursor cursor = new Cursor(databaseImpl, locker, cursorConfig, retainNonTxnLocks);
        cursor.setNonSticky(true);
        return cursor;
    }

    public static Cursor makeCursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) {
        return DbInternal.makeCursor(dbHandle, locker, cursorConfig, false);
    }

    public static Cursor makeCursor(Database dbHandle, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        return new Cursor(dbHandle, locker, cursorConfig, retainNonTxnLocks);
    }

    public static void setNonCloning(Cursor cursor, boolean nonSticky) {
        cursor.setNonSticky(nonSticky);
    }

    public static boolean isCorrupted(Database db) {
        return db.isCorrupted();
    }

    public static DatabaseImpl getDbImpl(Database db) {
        return db.getDbImpl();
    }

    public static Cursor[] getSortedCursors(JoinCursor cursor) {
        return cursor.getSortedCursors();
    }

    public static void setLoadPropertyFile(EnvironmentConfig config, boolean loadProperties) {
        config.setLoadPropertyFile(loadProperties);
    }

    public static void setCreateUP(EnvironmentConfig config, boolean val) {
        config.setCreateUP(val);
    }

    public static boolean getCreateUP(EnvironmentConfig config) {
        return config.getCreateUP();
    }

    public static void setCreateEP(EnvironmentConfig config, boolean val) {
        config.setCreateEP(val);
    }

    public static boolean getCreateEP(EnvironmentConfig config) {
        return config.getCreateEP();
    }

    public static void setCheckpointUP(EnvironmentConfig config, boolean checkpointUP) {
        config.setCheckpointUP(checkpointUP);
    }

    public static boolean getCheckpointUP(EnvironmentConfig config) {
        return config.getCheckpointUP();
    }

    public static void setTxnReadCommitted(EnvironmentConfig config, boolean txnReadCommitted) {
        config.setTxnReadCommitted(txnReadCommitted);
    }

    public static boolean getTxnReadCommitted(EnvironmentConfig config) {
        return config.getTxnReadCommitted();
    }

    public static EnvironmentMutableConfig cloneMutableConfig(EnvironmentMutableConfig config) {
        return config.cloneMutableConfig();
    }

    public static void checkImmutablePropsForEquality(EnvironmentMutableConfig config, Properties handleConfigProps) throws IllegalArgumentException {
        config.checkImmutablePropsForEquality(handleConfigProps);
    }

    public static void copyMutablePropsTo(EnvironmentMutableConfig config, EnvironmentMutableConfig toConfig) {
        config.copyMutablePropsTo(toConfig);
    }

    public static void disableParameterValidation(EnvironmentMutableConfig config) {
        config.setValidateParams(false);
    }

    public static Properties getProps(EnvironmentMutableConfig config) {
        return config.getProps();
    }

    public static void setUseExistingConfig(DatabaseConfig config, boolean useExistingConfig) {
        config.setUseExistingConfig(useExistingConfig);
    }

    public static void validate(DatabaseConfig config1, DatabaseConfig config2) throws DatabaseException {
        config1.validate(config2);
    }

    public static Locker getLocker(Transaction txn) throws DatabaseException {
        return txn.getLocker();
    }

    public static Environment getEnvironment(Transaction txn) throws DatabaseException {
        return txn.getEnvironment();
    }

    public static TransactionConfig getDefaultTxnConfig(Environment env) {
        return env.getDefaultTxnConfig();
    }

    public static Transaction beginInternalTransaction(Environment env, TransactionConfig config) {
        return env.beginInternalTransaction(config);
    }

    public static ExceptionEvent makeExceptionEvent(Exception e, String n) {
        return new ExceptionEvent(e, n);
    }

    public static Txn getTxn(Transaction transaction) {
        return transaction.getTxn();
    }

    public static DiskOrderedCursorImpl getDiskOrderedCursorImpl(DiskOrderedCursor cursor) {
        return cursor.getCursorImpl();
    }

    public static OperationResult makeResult(long time) {
        return time == 0L ? DEFAULT_RESULT : new OperationResult(time, false);
    }

    public static OperationResult makeResult(int expiration, boolean expirationInHours) {
        return DbInternal.makeResult(TTL.expirationToSystemTime(expiration, expirationInHours));
    }

    public static OperationResult makeUpdateResult(int expiration, boolean expirationInHours) {
        return new OperationResult(TTL.expirationToSystemTime(expiration, expirationInHours), true);
    }

    public static ReadOptions getReadOptions(LockMode lockMode) {
        if (lockMode == null) {
            lockMode = LockMode.DEFAULT;
        }
        return lockMode.toReadOptions();
    }

    public static enum Search {
        GT,
        GTE,
        LT,
        LTE;

    }
}

