/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import com.pi4j.util.StringUtil;

public class Console {
    private static final int LINE_WIDTH = 60;
    public static final String CLEAR_SCREEN_ESCAPE_SEQUENCE = "\u001b[2J\u001b[1;1H";
    public static final String ERASE_LINE_ESCAPE_SEQUENCE = "\u001b[K";
    public static final char LINE_SEPARATOR_CHAR = '*';
    public static final String LINE_SEPARATOR = StringUtil.repeat('*', 60);
    protected boolean exiting = false;

    public synchronized Console println(String format, Object ... args) {
        return this.println(String.format(format, args));
    }

    public synchronized Console print(String format, Object ... args) {
        return this.print(String.format(format, args));
    }

    public synchronized Console println(String line) {
        System.out.println(line);
        return this;
    }

    public synchronized Console println(Object line) {
        System.out.println(line);
        return this;
    }

    public synchronized Console println() {
        return this.println("");
    }

    public synchronized Console print(Object data) {
        System.out.print(data);
        return this;
    }

    public synchronized Console print(String data) {
        System.out.print(data);
        return this;
    }

    public synchronized Console println(char character, int repeat) {
        return this.println(StringUtil.repeat(character, repeat));
    }

    public synchronized Console emptyLine() {
        return this.emptyLine(1);
    }

    public synchronized Console emptyLine(int number2) {
        for (int index = 0; index < number2; ++index) {
            this.println();
        }
        return this;
    }

    public synchronized Console separatorLine() {
        return this.println(LINE_SEPARATOR);
    }

    public synchronized Console separatorLine(char character) {
        return this.separatorLine(character, 60);
    }

    public synchronized Console separatorLine(char character, int length) {
        return this.println(StringUtil.repeat(character, length));
    }

    public synchronized Console title(String ... title) {
        this.clearScreen().separatorLine().separatorLine().emptyLine();
        for (String s : title) {
            this.println(StringUtil.center(s, 60));
        }
        this.emptyLine().separatorLine().separatorLine().emptyLine();
        return this;
    }

    public synchronized Console box(String ... lines) {
        return this.box(2, lines);
    }

    public synchronized Console box(int padding, String ... lines) {
        int max_length = 0;
        for (String l2 : lines) {
            if (l2.length() <= max_length) continue;
            max_length = l2.length();
        }
        this.separatorLine('-', max_length + padding * 2 + 2);
        String left = StringUtil.padRight("|", padding);
        String right = StringUtil.padLeft("|", padding);
        for (String l3 : lines) {
            this.println(StringUtil.concat(left, StringUtil.padRight(l3, max_length - l3.length()), right));
        }
        this.separatorLine('-', max_length + padding * 2 + 2);
        return this;
    }

    public synchronized Console goodbye() {
        this.emptyLine();
        this.separatorLine();
        this.println(StringUtil.center("GOODBYE", 60));
        this.separatorLine();
        this.emptyLine();
        return this;
    }

    public synchronized Console clearScreen() {
        return this.print(CLEAR_SCREEN_ESCAPE_SEQUENCE);
    }

    public synchronized Console eraseLine() {
        return this.print(ERASE_LINE_ESCAPE_SEQUENCE);
    }

    public synchronized Console promptForExit() {
        this.box(4, "PRESS CTRL-C TO EXIT");
        this.emptyLine();
        this.exiting = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Console.this.exiting = true;
                Console.this.goodbye();
            }
        });
        return this;
    }

    public void waitForExit() throws InterruptedException {
        while (!this.exiting) {
            Thread.sleep(50L);
        }
    }

    public synchronized boolean exiting() {
        return this.exiting;
    }

    public synchronized boolean isRunning() {
        return !this.exiting;
    }

    public synchronized void exit() {
        this.exiting = true;
        this.goodbye();
    }
}

