/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.serial.SerialDataWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public abstract class AbstractSerialDataWriter
implements SerialDataWriter {
    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IllegalStateException, IOException;

    @Override
    public void write(byte ... data) throws IllegalStateException, IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] ... data) throws IllegalStateException, IOException {
        for (byte[] single : data) {
            this.write(single);
        }
    }

    @Override
    public void write(ByteBuffer ... data) throws IllegalStateException, IOException {
        for (ByteBuffer single : data) {
            byte[] payload = new byte[single.remaining()];
            single.get(payload);
            this.write(payload);
        }
    }

    @Override
    public void write(InputStream input) throws IllegalStateException, IOException {
        int length;
        if (input.available() <= 0) {
            throw new IOException("No available bytes in input stream to write to serial port.");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((length = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, length);
        }
        buffer.flush();
        this.write(buffer.toByteArray());
    }

    @Override
    public void write(Charset charset2, char[] data, int offset, int length) throws IllegalStateException, IOException {
        this.write(charset2, CharBuffer.wrap(data, offset, length));
    }

    @Override
    public void write(Charset charset2, char ... data) throws IllegalStateException, IOException {
        this.write(charset2, CharBuffer.wrap(data));
    }

    @Override
    public void write(char ... data) throws IllegalStateException, IOException {
        this.write(StandardCharsets.US_ASCII, CharBuffer.wrap(data));
    }

    @Override
    public void write(Charset charset2, CharBuffer ... data) throws IllegalStateException, IOException {
        for (CharBuffer single : data) {
            this.write(charset2.encode(single));
        }
    }

    @Override
    public void write(CharBuffer ... data) throws IllegalStateException, IOException {
        this.write(StandardCharsets.US_ASCII, data);
    }

    @Override
    public void write(Charset charset2, CharSequence ... data) throws IllegalStateException, IOException {
        for (CharSequence single : data) {
            this.write(charset2.encode(CharBuffer.wrap(single)));
        }
    }

    @Override
    public void write(CharSequence ... data) throws IllegalStateException, IOException {
        this.write(StandardCharsets.US_ASCII, data);
    }

    @Override
    public void write(Charset charset2, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        for (CharSequence charSequence : data) {
            this.write(charset2.encode(CharBuffer.wrap(charSequence)));
        }
    }

    @Override
    public void write(Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        this.write(StandardCharsets.US_ASCII, data);
    }

    protected CharSequence appendNewLine(CharSequence data) {
        String separator = System.getProperty("line.separator");
        return data + separator;
    }

    @Override
    public void writeln(Charset charset2, CharSequence ... data) throws IllegalStateException, IOException {
        for (CharSequence single : data) {
            this.write(charset2.encode(CharBuffer.wrap(this.appendNewLine(single))));
        }
    }

    @Override
    public void writeln(CharSequence ... data) throws IllegalStateException, IOException {
        this.writeln(StandardCharsets.US_ASCII, data);
    }

    @Override
    public void writeln(Charset charset2, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        for (CharSequence charSequence : data) {
            this.write(charset2.encode(CharBuffer.wrap(this.appendNewLine(charSequence))));
        }
    }

    @Override
    public void writeln(Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        this.writeln(StandardCharsets.US_ASCII, data);
    }
}

