/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.file.LinuxFile;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CConstants;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.impl.I2CDeviceImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I2CBusImpl
implements I2CBus {
    private static final Logger logger = Logger.getLogger(I2CBusImpl.class.getCanonicalName());
    protected LinuxFile file = null;
    protected int lastAddress = -1;
    protected String filename;
    protected int busNumber;
    protected long lockAquireTimeout;
    protected TimeUnit lockAquireTimeoutUnit;
    private final ReentrantLock accessLock = new ReentrantLock(true);

    protected I2CBusImpl(int busNumber, String fileName, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) {
        this.filename = fileName;
        this.busNumber = busNumber;
        this.lockAquireTimeout = lockAquireTimeout < 0L ? 1000L : lockAquireTimeout;
        this.lockAquireTimeoutUnit = lockAquireTimeoutUnit == null ? I2CFactory.DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS : lockAquireTimeoutUnit;
    }

    @Override
    public I2CDevice getDevice(int address) throws IOException {
        if (address < 0 || address > 127) {
            throw new IOException("I2C device address is out of bounds; valid range=(0-127); ADDRESS=" + address);
        }
        return new I2CDeviceImpl(this, address);
    }

    protected void open() throws IOException {
        if (this.file != null) {
            return;
        }
        this.file = new LinuxFile(this.filename, "rw");
        this.lastAddress = -1;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }

    public int readByteDirect(I2CDevice device) throws IOException {
        return this.runBusLockedDeviceAction(device, () -> this.file.readUnsignedByte());
    }

    public int readBytesDirect(I2CDevice device, int size, int offset, byte[] buffer) throws IOException {
        return this.runBusLockedDeviceAction(device, () -> this.file.read(buffer, offset, size));
    }

    public int readByte(I2CDevice device, int localAddress) throws IOException {
        return this.runBusLockedDeviceAction(device, () -> {
            this.file.writeByte(localAddress);
            return this.file.readUnsignedByte();
        });
    }

    public int readBytes(I2CDevice device, int localAddress, int size, int offset, byte[] buffer) throws IOException {
        return this.runBusLockedDeviceAction(device, () -> {
            this.file.writeByte(localAddress);
            return this.file.read(buffer, offset, size);
        });
    }

    public void writeByteDirect(I2CDevice device, byte data) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            this.file.writeByte(data & 0xFF);
            return null;
        });
    }

    public void writeBytesDirect(I2CDevice device, int size, int offset, byte[] buffer) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            this.file.write(buffer, offset, size);
            return null;
        });
    }

    public void writeByte(I2CDevice device, int localAddress, byte data) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            this.file.write(new byte[]{(byte)localAddress, data});
            return null;
        });
    }

    public void writeBytes(I2CDevice device, int localAddress, int size, int offset, byte[] buffer) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            byte[] buf2 = new byte[size + 1];
            buf2[0] = (byte)localAddress;
            System.arraycopy(buffer, offset, buf2, 1, size);
            this.file.write(buf2);
            return null;
        });
    }

    public int writeAndReadBytesDirect(I2CDevice device, int writeSize, int writeOffset, byte[] writeBuffer, int readSize, int readOffset, byte[] readBuffer) throws IOException {
        return this.runBusLockedDeviceAction(device, () -> {
            this.file.write(writeBuffer, writeOffset, writeSize);
            return this.file.read(readBuffer, readOffset, readSize);
        });
    }

    public void ioctl(I2CDevice device, long command, int value) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            this.file.ioctl(command, value);
            return null;
        });
    }

    public void ioctl(I2CDevice device, long command, ByteBuffer values2, IntBuffer offsets) throws IOException {
        this.runBusLockedDeviceAction(device, () -> {
            this.file.ioctl(command, values2, offsets);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T runBusLockedDeviceAction(I2CDevice device, Callable<T> action) throws IOException {
        if (action == null) {
            throw new NullPointerException("Parameter 'action' is mandatory!");
        }
        this.testForProperOperationConditions(device);
        try {
            if (!this.accessLock.tryLock(this.lockAquireTimeout, this.lockAquireTimeoutUnit)) throw new RuntimeException("Could not obtain an access-lock!");
            try {
                this.testForProperOperationConditions(device);
                this.selectBusSlave(device);
                T t = action.call();
                return t;
            }
            finally {
                this.accessLock.unlock();
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.FINER, "Failed locking I2CBusImpl-" + this.busNumber, e);
            throw new RuntimeException("Could not obtain an access-lock!", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void selectBusSlave(I2CDevice device) throws IOException {
        int addr = device.getAddress();
        if (this.lastAddress != addr) {
            this.lastAddress = addr;
            this.file.ioctl(I2CConstants.I2C_SLAVE, addr & 0xFF);
        }
    }

    protected void testForProperOperationConditions(I2CDevice device) throws IOException {
        if (this.file == null) {
            throw new IOException(this.toString() + " has already been closed! A new bus has to be acquired.");
        }
        if (device == null) {
            throw new NullPointerException("Parameter 'device' is mandatory!");
        }
    }

    @Override
    public int getBusNumber() {
        return this.busNumber;
    }

    public String toString() {
        return "I2CBus '" + this.busNumber + "' ('" + this.filename + "')";
    }
}

