/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;

public class ResampleOp
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private float totalItems;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private AtomicInteger multipleInvocationLock = new AtomicInteger();
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOp(int destWidth, int destHeight) {
        this(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ResampleOp(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter2) {
        this.filter = filter2;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public BufferedImage doFilter(BufferedImage srcImg, BufferedImage dest, int dstWidth, int dstHeight) {
        BufferedImage out;
        byte[] outPixels;
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        if (dstWidth < 3 || dstHeight < 3) {
            throw new RuntimeException("Error doing rescale. Target size was " + dstWidth + "x" + dstHeight + " but must be at least 3x3.");
        }
        assert (this.multipleInvocationLock.incrementAndGet() == 1) : "Multiple concurrent invocations detected";
        if (srcImg.getType() == 12 || srcImg.getType() == 13 || srcImg.getType() == 0) {
            srcImg = ImageUtils.convert(srcImg, srcImg.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(srcImg);
        assert (this.nrChannels > 0);
        this.srcWidth = srcImg.getWidth();
        this.srcHeight = srcImg.getHeight();
        byte[][] workPixels = new byte[this.srcHeight][dstWidth * this.nrChannels];
        this.processedItems = 0;
        this.totalItems = this.srcHeight + dstWidth;
        this.horizontalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcWidth, dstWidth);
        this.verticalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcHeight, dstHeight);
        final BufferedImage scrImgCopy = srcImg;
        final byte[][] workPixelsCopy = workPixels;
        Thread[] threads = new Thread[this.numberOfThreads - 1];
        for (int i = 1; i < this.numberOfThreads; ++i) {
            final int finalI = i;
            threads[i - 1] = new Thread(new Runnable(){

                public void run() {
                    ResampleOp.this.horizontallyFromSrcToWork(scrImgCopy, workPixelsCopy, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i - 1].start();
        }
        this.horizontallyFromSrcToWork(scrImgCopy, workPixelsCopy, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        final byte[] outPixelsCopy = outPixels = new byte[dstWidth * dstHeight * this.nrChannels];
        for (int i = 1; i < this.numberOfThreads; ++i) {
            final int finalI = i;
            threads[i - 1] = new Thread(new Runnable(){

                public void run() {
                    ResampleOp.this.verticalFromWorkToDst(workPixelsCopy, outPixelsCopy, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i - 1].start();
        }
        this.verticalFromWorkToDst(workPixelsCopy, outPixelsCopy, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        workPixels = null;
        if (dest != null && dstWidth == dest.getWidth() && dstHeight == dest.getHeight()) {
            out = dest;
            int nrDestChannels = ImageUtils.nrChannels(dest);
            if (nrDestChannels != this.nrChannels) {
                String errorMgs = String.format("Destination image must be compatible width source image. Source image had %d channels destination image had %d channels", this.nrChannels, nrDestChannels);
                throw new RuntimeException(errorMgs);
            }
        } else {
            out = new BufferedImage(dstWidth, dstHeight, this.getResultBufferedImageType(srcImg));
        }
        ImageUtils.setBGRPixels(outPixels, out, 0, 0, dstWidth, dstHeight);
        assert (this.multipleInvocationLock.decrementAndGet() == 0) : "Multiple concurrent invocations detected";
        return out;
    }

    private void waitForAllThreads(Thread[] threads) {
        try {
            for (Thread t : threads) {
                t.join(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    static SubSamplingData createSubSampling(ResampleFilter filter2, int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = filter2.getSamplingRadius();
        float centerOffset = 0.5f / scale;
        if (scale < 1.0f) {
            float width = fwidth / scale;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * numContributors;
                float center = (float)i / scale + centerOffset;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (int j = left; j <= right; ++j) {
                    float weight = filter2.apply((center - (float)j) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k2 = arrN[i];
                    int n2 = i;
                    arrN[n2] = arrN[n2] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k2] = n;
                    arrWeight[subindex + k2] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        } else {
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * numContributors;
                float center = (float)i / scale + centerOffset;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j = left; j <= right; ++j) {
                    float weight = filter2.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k3 = arrN[i];
                    int n3 = i;
                    arrN[n3] = arrN[n3] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k3] = n;
                    arrWeight[subindex + k3] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    private void verticalFromWorkToDst(byte[][] workPixels, byte[] outPixels, int start2, int delta) {
        if (this.nrChannels == 1) {
            this.verticalFromWorkToDstGray(workPixels, outPixels, start2, this.numberOfThreads);
            return;
        }
        boolean useChannel3 = this.nrChannels > 3;
        for (int x = start2; x < this.dstWidth; x += delta) {
            int xLocation = x * this.nrChannels;
            for (int y = this.dstHeight - 1; y >= 0; --y) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y];
                int sampleLocation = (y * this.dstWidth + x) * this.nrChannels;
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                float sample3 = 0.0f;
                int index = yTimesNumContributors;
                for (int j = max - 1; j >= 0; --j) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                    float arrWeight = this.verticalSubsamplingData.arrWeight[index];
                    sample0 += (float)(workPixels[valueLocation][xLocation] & 0xFF) * arrWeight;
                    sample1 += (float)(workPixels[valueLocation][xLocation + 1] & 0xFF) * arrWeight;
                    sample2 += (float)(workPixels[valueLocation][xLocation + 2] & 0xFF) * arrWeight;
                    if (useChannel3) {
                        sample3 += (float)(workPixels[valueLocation][xLocation + 3] & 0xFF) * arrWeight;
                    }
                    ++index;
                }
                outPixels[sampleLocation] = this.toByte(sample0);
                outPixels[sampleLocation + 1] = this.toByte(sample1);
                outPixels[sampleLocation + 2] = this.toByte(sample2);
                if (!useChannel3) continue;
                outPixels[sampleLocation + 3] = this.toByte(sample3);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
    }

    private void verticalFromWorkToDstGray(byte[][] workPixels, byte[] outPixels, int start2, int delta) {
        for (int x = start2; x < this.dstWidth; x += delta) {
            int xLocation = x;
            for (int y = this.dstHeight - 1; y >= 0; --y) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y];
                int sampleLocation = y * this.dstWidth + x;
                float sample0 = 0.0f;
                int index = yTimesNumContributors;
                for (int j = max - 1; j >= 0; --j) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                    float arrWeight = this.verticalSubsamplingData.arrWeight[index];
                    sample0 += (float)(workPixels[valueLocation][xLocation] & 0xFF) * arrWeight;
                    ++index;
                }
                outPixels[sampleLocation] = this.toByte(sample0);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWork(BufferedImage srcImg, byte[][] workPixels, int start2, int delta) {
        if (this.nrChannels == 1) {
            this.horizontallyFromSrcToWorkGray(srcImg, workPixels, start2, delta);
            return;
        }
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth * this.nrChannels];
        boolean useChannel3 = this.nrChannels > 3;
        for (int k = start2; k < this.srcHeight; k += delta) {
            ImageUtils.getPixelsBGR(srcImg, k, this.srcWidth, srcPixels, tempPixels);
            for (int i = this.dstWidth - 1; i >= 0; --i) {
                int sampleLocation = i * this.nrChannels;
                int max = this.horizontalSubsamplingData.arrN[i];
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                float sample3 = 0.0f;
                int index = i * this.horizontalSubsamplingData.numContributors;
                for (int j = max - 1; j >= 0; --j) {
                    float arrWeight = this.horizontalSubsamplingData.arrWeight[index];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index] * this.nrChannels;
                    sample0 += (float)(srcPixels[pixelIndex] & 0xFF) * arrWeight;
                    sample1 += (float)(srcPixels[pixelIndex + 1] & 0xFF) * arrWeight;
                    sample2 += (float)(srcPixels[pixelIndex + 2] & 0xFF) * arrWeight;
                    if (useChannel3) {
                        sample3 += (float)(srcPixels[pixelIndex + 3] & 0xFF) * arrWeight;
                    }
                    ++index;
                }
                workPixels[k][sampleLocation] = this.toByte(sample0);
                workPixels[k][sampleLocation + 1] = this.toByte(sample1);
                workPixels[k][sampleLocation + 2] = this.toByte(sample2);
                if (!useChannel3) continue;
                workPixels[k][sampleLocation + 3] = this.toByte(sample3);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWorkGray(BufferedImage srcImg, byte[][] workPixels, int start2, int delta) {
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth];
        for (int k = start2; k < this.srcHeight; k += delta) {
            ImageUtils.getPixelsBGR(srcImg, k, this.srcWidth, srcPixels, tempPixels);
            for (int i = this.dstWidth - 1; i >= 0; --i) {
                int sampleLocation = i;
                int max = this.horizontalSubsamplingData.arrN[i];
                float sample0 = 0.0f;
                int index = i * this.horizontalSubsamplingData.numContributors;
                for (int j = max - 1; j >= 0; --j) {
                    float arrWeight = this.horizontalSubsamplingData.arrWeight[index];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index];
                    sample0 += (float)(srcPixels[pixelIndex] & 0xFF) * arrWeight;
                    ++index;
                }
                workPixels[k][sampleLocation] = this.toByte(sample0);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
    }

    private byte toByte(float f) {
        if (f < 0.0f) {
            return 0;
        }
        if (f > 255.0f) {
            return -1;
        }
        return (byte)(f + 0.5f);
    }

    private void setProgress() {
        this.fireProgressChanged((float)this.processedItems / this.totalItems);
    }

    protected int getResultBufferedImageType(BufferedImage srcImg) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (srcImg.getSampleModel().getDataType() == 1 ? 11 : 10));
    }

    static class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final float[] arrWeight;
        private final int numContributors;

        private SubSamplingData(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
        }

        public int getNumContributors() {
            return this.numContributors;
        }

        public int[] getArrN() {
            return this.arrN;
        }

        public int[] getArrPixel() {
            return this.arrPixel;
        }

        public float[] getArrWeight() {
            return this.arrWeight;
        }
    }
}

